<?php
class Work_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }


  public function select_work($columns = "*", $data = "", $in_array = "")
  {
    $this->db->select($columns . ",GROUP_CONCAT(DISTINCT u2.user_alias) as users_assigned")->from('work_contracts w');
    $this->db->join('users u', 'w.created_by=u.user_id');
    $this->db->join('clients c', 'w.client_id=c.client_id');
    $this->db->join('companies cm', 'w.company_id=cm.company_id', 'left');
    $this->db->join('work_category wc', 'w.work_type=wc.wcat_id', 'left');
    $this->db->join('project_area_locations pa', 'w.location_area=pa.area_id', 'left');
    $this->db->join('users u2', ("FIND_IN_SET(u2.user_id , w.assigned_users)"), 'left');
    $this->db->join('users u3', 'w.updated_by=u3.user_id', 'left');
    if ($this->config->item('app_module_company_branches') == 1){
      $this->db->join('branches b', 'w.branch_id=b.branch_id','left');
      $this->db->where('(w.branch_id=0 or (w.branch_id!=0 and b.delete_status=0))');
    }
    if (!empty($data)) {
      $this->db->where($data);
    }
    if (!empty($in_array)) {
      $this->db->where_in('w.work_id', $in_array);
    }
    $this->db->where('w.delete_status', 0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('w.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by('w.work_id', 'desc');
    $this->db->group_by('w.work_id');
    $query = $this->db->get();
    return $query;
  }
  public function select_work_2($columns = "*", $data = "", $in_array = "")
  {
    $this->db->select($columns)->from('work_contracts w');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where('w.delete_status', 0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('w.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by('w.work_id', 'desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_work($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('work_contracts', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function update_work($data)
  {
    $this->db->where('work_id', $data['work_id']);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id',$this->session->userdata('branch_id'));
    }
    $query = $this->db->update('work_contracts', $data);
    return $query;
  }

  //  Work Types
  public function select_work_types($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('work_types wt');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where("wt.delete_status", 0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_work_type($data)
  {
    $query = $this->db->insert('work_types', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function update_work_type($data)
  {
    $this->db->where('type_id', $data['type_id']);
    $query = $this->db->update('work_types', $data);
    return $query;
  }

  // Work Category
  public function select_work_category($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('work_category wc');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_work_category($data)
  {
    $query = $this->db->insert('work_category', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function update_work_category($data)
  {
    $this->db->where('wcat_id', $data['wcat_id']);
    $query = $this->db->update('work_category', $data);
    return $query;
  }

  // Work Assign Log
  public function create_work_assign_log($data)
  {
    $query = $this->db->insert('work_assign_log', $data);
    return $query;
  }
  public function select_work_assign_log($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('work_assign_log wp');
    $this->db->join('users u', 'wp.user_id=u.user_id');
    $this->db->join('user_roles ur', 'u.user_role=ur.role_id');
    $this->db->join('work_contracts wc', 'wp.work_id=wc.work_id');
    $this->db->join('users u2', 'wp.created_by=u2.user_id', 'left');
    if (!empty($data)) {
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wc.branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }
  public function update_work_assign_log($data)
  {
    $this->db->where('assign_log_id', $data['assign_log_id']);
    $query = $this->db->update('work_assign_log', $data);
    return $query;
  }
  public function delete_work_assign_log($data)
  {
    $this->db->where('assign_log_id', $data['assign_log_id']);
    $query = $this->db->delete('work_assign_log', $data);
    return $query;
  }

  // Work Progress Log
  public function insert_progress_log($data)
  {
    $query = $this->db->insert('project_progress_log', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function select_progress_log($columns = "*", $data = "", $query_type = "")
  {
    if ($query_type == "distinct") {
      $this->db->distinct();
    }
    $this->db->select($columns)->from('project_progress_log ppl');
    $this->db->join('users u', 'ppl.created_by=u.user_id');
    if (!empty($data)) {
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    if ($query_type == "sum") {
      $this->db->group_by('ppl.created_by');
    }
    $query = $this->db->get();
    return $query;
  }

  // Project Area
  public function select_project_area($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('project_area_locations pal');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_project_area($data)
  {
    $query = $this->db->insert('project_area_locations', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function update_project_area($data)
  {
    $this->db->where('area_id', $data['area_id']);
    $query = $this->db->update('project_area_locations', $data);
    return $query;
  }

  // Project Stage
  public function select_project_stage($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('project_stages ps');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->order_by('ps.stage_no', 'asc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_project_stage($data)
  {
    $query = $this->db->insert('project_stages', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function update_project_stage($where_data, $update_data)
  {
    if (!empty($where_data)) {
      $this->db->where($where_data);
      $query = $this->db->update('project_stages', $update_data);
      return $query;
    }
  }

  public function insert_project_stage_log($data)
  {
    $query = $this->db->insert('project_stage_active_log', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }

  // Project Sections
  public function select_project_sections($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('project_sections ps');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where('ps.delete_status', 0);
    $this->db->order_by('ps.section_id', 'asc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_project_section($data)
  {
    $query = $this->db->insert('project_sections', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function update_project_section($data)
  {
    $this->db->where('section_id', $data['section_id']);
    $query = $this->db->update('project_sections', $data);
    return $query;
  }
  // Custom Requirements
  public function create_custom_requirement($data)
  {
    $query = $this->db->insert('project_custom_requirements', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function select_custom_requirement($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('project_custom_requirements pcr');
    $this->db->join('tax_types tt','pcr.tax_percent=tt.tax_id','left');
    $this->db->join('work_contracts wc', 'pcr.project_id=wc.work_id');
    $this->db->join('users u', 'pcr.created_by=u.user_id', 'left');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where('pcr.delete_status', 0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wc.branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }
  public function update_custom_requirement($data)
  {
    $this->db->where('requirement_id', $data['requirement_id']);
    $query = $this->db->update('project_custom_requirements', $data);
    return $query;
  }


  public function create_beneficiary_account($data)
  {
    $query = $this->db->insert('project_beneficiary_accounts', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  public function select_beneficiary_accounts($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('project_beneficiary_accounts pba');
    $this->db->join('work_contracts wc', 'pba.project_id=wc.work_id');
    $this->db->join('users u1', 'pba.supervisor_id=u1.user_id', 'left');
    $this->db->join('users u2', 'pba.created_by=u2.user_id', 'left');
    $this->db->join('data_meter_makes mm', 'pba.meter_make_no=mm.meter_id','left');
    $this->db->join('sub_contracts sc','pba.subcontract_id=sc.contract_id');
      $this->db->join('sub_contractors c','c.contractor_id=sc.contractor','left');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where('pba.delete_status', 0);
    $query = $this->db->get();
    return $query;
  }
  public function update_beneficiary_accounts($where_data,$update_data)
  {
    if(!empty($where_data)){
      $this->db->where($where_data);
      $query=$this->db->update('project_beneficiary_accounts', $update_data);
      return $query;
    }
  }
}
