<?php
class Vehicle_work_slips_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }


  public function select_vehicle_work_slips($columns="*",$data="",$order_by_column="",$order_by="",$group_by="",$limit_start="",$limit="",$entry_approval=1)
  {
    $this->db->select($columns)->from('vehicle_work_slips vws');
    $this->db->join('users u','vws.created_by=u.user_id','left');
    $this->db->join('vehicles v','vws.vehicle_id=v.id');
    $this->db->join('vehicle_consignee vc','vc.consignee_id=v.consignee','left');
    $this->db->join('work_contracts wc','vws.vehicle_work_id=wc.work_id','left');
    $this->db->join('employees e','vws.driver_id=e.employee_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('vws.work_slip_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("vws.delete_status",0);
    $this->db->where("v.delete_status",0);
    // $this->db->where("wc.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("vws.entry_approval_status",$entry_approval);
    }
    $this->db->order_by("vws.worked_date",'desc');
    if($order_by_column!='' && $order_by!=''){
      $this->db->order_by($order_by_column,$order_by);
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    if($limit!=''){
      if($limit_start!=''){
        $this->db->limit($limit,$limit_start);
      }else{
        $this->db->limit($limit);
      }
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_vehicle_work_slip($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['work_slip_branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('vehicle_work_slips', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_vehicle_work_slip($data)
  {
    $this->db->where('work_slip_id', $data['work_slip_id']);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('work_slip_branch_id', $this->session->userdata('branch_id'));
    }
    $query=$this->db->update('vehicle_work_slips', $data);
    return $query;
  }

  // Work Slip Expense
  public function select_vehicle_work_slip_expense($columns="*",$data="",$order_by_column="",$order_by="",$group_by="",$limit_start="",$limit="",$entry_approval=1)
  {
    $this->db->select($columns)->from('vehicle_work_slip_expenses vwse');
    $this->db->join('vehicle_work_slips vws','vws.work_slip_id=vwse.work_slip_id');
    $this->db->join('work_contracts wc','vws.vehicle_work_id=wc.work_id','left');
    $this->db->join('users u','vws.created_by=u.user_id','left');
    $this->db->join('vehicles v','vws.vehicle_id=v.id');
    $this->db->join('vehicle_consignee vc','vc.consignee_id=v.consignee','left');
    $this->db->join('suppliers s','vwse.supplier_id=s.supplier_id','left');
    $this->db->join('stock_locations sl','vwse.supplier_id=sl.location_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('vws.work_slip_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("vwse.delete_status",0);
    $this->db->where("vws.delete_status",0);
    $this->db->where("v.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("vws.entry_approval_status",$entry_approval);
    }
    if($order_by_column!='' && $order_by!=''){
      $this->db->order_by($order_by_column,$order_by);
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    if($limit!=''){
      if($limit_start!=''){
        $this->db->limit($limit,$limit_start);
      }else{
        $this->db->limit($limit);
      }
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_vehicle_work_slip_expense($data){
    $query = $this->db->insert('vehicle_work_slip_expenses', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_vehicle_work_slip_expense($data)
  {
    $this->db->where('expense_id', $data['expense_id']);
    $query=$this->db->update('vehicle_work_slip_expenses', $data);
    return $query;
  }
  // Work Slip Files
  public function select_vehicle_work_slip_files($columns="*",$data="",$order_by_column="",$order_by="",$group_by="",$limit_start="",$limit="",$entry_approval=1)
  {
    $this->db->select($columns)->from('vehicle_work_slip_files vwsf');
    $this->db->join('vehicle_work_slips vws','vws.work_slip_id=vwsf.work_slip_id');
    $this->db->join('work_contracts wc','vws.vehicle_work_id=wc.work_id','left');
    $this->db->join('users u','vws.created_by=u.user_id','left');
    $this->db->join('vehicles v','vws.vehicle_id=v.id');
    $this->db->join('vehicle_consignee vc','vc.consignee_id=v.consignee','left');
    $this->db->join('user_activities ua','vwsf.activity_id=ua.activity_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('vws.work_slip_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("vwsf.delete_status",0);
    $this->db->where("vws.delete_status",0);
    $this->db->where("v.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("vws.entry_approval_status",$entry_approval);
    }
    if($order_by_column!='' && $order_by!=''){
      $this->db->order_by($order_by_column,$order_by);
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    if($limit!=''){
      if($limit_start!=''){
        $this->db->limit($limit,$limit_start);
      }else{
        $this->db->limit($limit);
      }
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_vehicle_work_slip_files($data){
    $query = $this->db->insert('vehicle_work_slip_files', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_vehicle_work_slip_files($data)
  {
    $this->db->where('file_id', $data['file_id']);
    $query=$this->db->update('vehicle_work_slip_files', $data);
    return $query;
  }
}
?>
