<?php
class Vehicle_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_vehicle($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('vehicles v');
    $this->db->join('users u', 'v.created_by=u.user_id', 'left');
    $this->db->join('vehicle_consignee vc', 'vc.consignee_id=v.consignee', 'left');
    $this->db->join('loan_provider lp', 'lp.loan_provider_id=v.financier', 'left');
    if ($this->config->item('app_module_vehicle_management') == 1) {
      $this->db->join('account_heads ah', 'v.emi_bank_account=ah.acc_head_id', 'left');
    }
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where("v.delete_status", 0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('v.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("v.id", 'desc');
    $query = $this->db->get();
    return $query;
  }
  public function update_vehicle($data)
  {
    $this->db->where('id', $data['id']);
    $query = $this->db->update('vehicles', $data);
    return $query;
  }
  public function create_vehicle($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('vehicles', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }

  // Vehicle Consignee
  public function select_consignee($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('vehicle_consignee vc');
    if (!empty($data)) {
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('vc.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("vc.delete_status", 0);
    $query = $this->db->get();
    return $query;
  }
  public function update_consignee($data)
  {
    $this->db->where('consignee_id', $data['consignee_id']);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->update('vehicle_consignee', $data);
    return $query;
  }
  public function create_consignee($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('vehicle_consignee', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  // Vehicle Allocation Status
  public function select_vehicle_allocations($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('vehicle_allocation_status va');
    $this->db->join('vehicles v', 'v.id=va.vehicle_id');
    $this->db->join('users u', 'va.created_by=u.user_id', 'left');
    $this->db->join('stock_locations sl', 'va.location_id=sl.location_id', 'left');
    $this->db->join('employees e', 'e.employee_id=va.driver_id', 'left');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where("va.delete_status", 0);
    $this->db->where("v.delete_status", 0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('v.branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }
  public function update_vehicle_allocation($data)
  {
    $this->db->where('allocation_id', $data['allocation_id']);
    $query = $this->db->update('vehicle_allocation_status', $data);
    return $query;
  }
  public function create_vehicle_allocation($data)
  {
    $query = $this->db->insert('vehicle_allocation_status', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  // Vehicle Documents
  public function select_vehicle_documents($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('vehicle_documents vd');
    $this->db->join('vehicles v', 'v.id=vd.vehicle_id');
    $this->db->join('users u', 'vd.created_by=u.user_id', 'left');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $this->db->where("vd.delete_status", 0);
    $this->db->where("v.delete_status", 0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('v.branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }
  public function update_vehicle_document($data)
  {
    $this->db->where('document_id', $data['document_id']);
    $query = $this->db->update('vehicle_documents', $data);
    return $query;
  }
  public function create_vehicle_document($data)
  {
    $query = $this->db->insert('vehicle_documents', $data);
    $result = array();
    $result['insert_id'] = $this->db->insert_id();
    $result['status'] = $query;
    return $result;
  }
  // Vehicle Document types
  public function select_vehicle_document_types($columns = "*", $data = "")
  {
    $this->db->select($columns)->from('vehicle_document_types');
    if (!empty($data)) {
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
}
