<?php
class User_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function is_logged_in($user_type=array())
  {
    // Return true or false based on the presence of user data
    if ($this->session->userdata('user_id') == ""){
      return false;
    }else{
      if(!empty($user_type)){
        if(in_array($this->session->userdata('user_role'), $user_type)){
          return true;
        }else {
          return false;
        }
      }else {
        return true;
      }
    }
  }


  public function select_user($columns='*',$data='',$join=false)
  {
    $this->db->select($columns)->from('users u');
    if($join==true){
      $this->db->join('employees e','e.user_id=u.user_id','left');
    }
    $this->db->join('user_roles ur','u.user_role=ur.role_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('u.delete_status',0);
    $this->db->order_by('u.user_id','desc');
    $query = $this->db->get();
    return $query;
  }
  public function select_user_2($columns='*',$data='',$join=false)
  {
    $this->db->select($columns.",GROUP_CONCAT(DISTINCT pal.area_name) as assigned_area",FALSE)->from('users u');
    if($join==true){
      $this->db->join('employees e','e.user_id=u.user_id','left');
    }
    $this->db->join('user_roles ur','u.user_role=ur.role_id');
    $this->db->join('project_area_locations pal', ("FIND_IN_SET(pal.area_id , u.project_area_location)"),'left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('u.delete_status',0);
    $this->db->group_by("u.user_id");
    $this->db->order_by('u.user_id','desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_user($data){

    if($this->session->userdata('branch_id')!=0){
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('users', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_user($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('user_id', $data['user_id']);
    $query=$this->db->update('users', $data);
    return $query;
  }
  // User Roles
  public function select_user_roles($columns='*',$data='')
  {
    $this->db->select($columns)->from('user_roles ur');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('ur.delete_status',0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_user_role($data){
    $query = $this->db->insert('user_roles', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_user_role($data)
  {
    $this->db->where('role_id', $data['role_id']);
    $query=$this->db->update('user_roles', $data);
    return $query;
  }

  public function select_activities($column='*',$data='')
  {
    $this->db->select($column)->from('user_activities ua');
    $this->db->join('users u','ua.user_id=u.user_id');
    $this->db->join('user_roles ur','u.user_role=ur.role_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('u.delete_status',0);
    $this->db->order_by('ua.activity_date','desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_activity($data){
    $query = $this->db->insert('user_activities', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function add_user_activity($activity_type,$reference_id='',$description=''){
    $data['activity_type'] = $activity_type;
    $data['reference_id'] = $reference_id;
    $data['activity_description'] = $description;
    $data['user_id'] = $this->session->userdata('user_id');
    $data['activity_date'] = date('Y-m-d H:i:s');
    $data['activity_through'] = 'webapp';
    $this->insert_activity($data);
  }

  ##Send Email
  public function send_email($data)
  {
    $settings = $this->db->select('*')->from('settings')->get()->result();
    foreach ($settings as $key => $value) {
      ${$value->settings_name} = $value->value;
    }

    $software_name = $company_name." Application ";

    $subject = $data['subject'];
    $to=$data['to'];
    $message = $data['message'];
    $message = str_replace("#software_name", $software_name, $message);
    $message = str_replace("#logo", base_url().'uploads/company/logo.png',$message);

    $this->load->library('My_PHPMailer');
    $mail = new PHPMailer();
    $mail->IsSMTP(); // we are going to use SMTP
    $mail->SMTPAuth   = true; // enabled SMTP authentication
    $mail->SMTPSecure = "ssl";  // prefix for secure protocol to connect to the server
    $mail->Host       = $smtp_host;      // setting GMail as our SMTP server
    $mail->Port       = $smtp_port;                   // SMTP port to connect to GMail
    $mail->Username   = $smtp_username;  // user email address
    $mail->Password   = $smtp_password;            // password in GMail
    $mail->SetFrom($smtp_username, $company_name);  //Who is sending the email
    $mail->Subject    = $subject;
    $mail->Body      = $message;
    $mail->AltBody    = "Plain text message";
    $destino = $to; // Who is addressed the email to
    $mail->AddAddress($destino);
    $mail=$mail->Send();  //Sending Mail
    return $mail;
  }


  public function push_firebase($data)
  {
    $this->load->library('Firebase');
    $serverObject = new Firebase();
    $jsonString = $serverObject->sendPushNotificationToFCMSever($data['token'], $data['message'], "",$data['title'] );
    $jsonObject = json_decode($jsonString);
    return $jsonObject;
  }

  public function add_notifications($data){

    $query = $this->db->insert('app_notifications', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
}
