<?php
class Supplier_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_supplier($columns="*",$data="")
  {
    $this->db->select($columns.',GROUP_CONCAT(DISTINCT sc.sup_category_name) as category_names')->from('suppliers s');
    $this->db->join('supplier_categories sc', ("FIND_IN_SET(sc.sup_category_id, s.supplier_category)"),'left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("s.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('s.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->group_by("supplier_id");
    $query = $this->db->get();
    return $query;
  }
  public function update_supplier($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('supplier_id', $data['supplier_id']);
    $query=$this->db->update('suppliers', $data);
    return $query;
  }
  public function create_supplier($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('suppliers', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_supplier_category($columns="*",$data="")
  {
    $this->db->select($columns)->from('supplier_categories sc');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("sc.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function update_supplier_category($data)
  {
    $this->db->where('sup_category_id', $data['sup_category_id']);
    $query=$this->db->update('supplier_categories', $data);
    return $query;
  }
  public function create_supplier_category($data){
    $query = $this->db->insert('supplier_categories', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_supplier_advance_return($data="")
  {
    $this->db->select('*')->from('supplier_advance_redeem art');
    $this->db->join('suppliers s','art.supplier_id=s.supplier_id');
    $this->db->join('users u','art.created_by=u.user_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("s.delete_status",0);
    $this->db->where("art.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('s.branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }
  public function update_supplier_advance_return($data)
  {
    $this->db->where('tr_id', $data['tr_id']);
    $query=$this->db->update('supplier_advance_redeem', $data);
    return $query;
  }
}
?>
