<?php
class Settings_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_settings($columns="*",$data="")
  {
    $this->db->select($columns)->from('settings s');
    if(!empty($data)){
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_settings($data)
  {
    $query=$this->db->insert('settings', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_settings($data)
  {
    $this->db->where('settings_id', $data['settings_id']);
    $query=$this->db->update('settings', $data);
    return $query;
  }
  public function update_settings_2($where_data,$update_data)
  {
    if(!empty($where_data)){
      $this->db->where($where_data);
      $query=$this->db->update('settings', $update_data);
      return $query;
    }else{
      return 0;
    }
  }
  public function check_maintenance_mode()
  {
    $query = $this->select_settings("",array("settings_name"=>"maintenance_mode"));
    if($query->num_rows()==1 && $query->row()->value == 1){
      return true;
    }else{
      return false;
    }
  }


  public function select_settings_modules($columns="*",$data="")
  {
    $this->db->select($columns)->from('settings_modules sm');
    if(!empty($data)){
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_settings_modules($data)
  {
    $query=$this->db->insert('settings_modules', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_holidays($columns="*",$data="")
  {
    $this->db->select($columns)->from('holidays h');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('delete_status',0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_holidays($data)
  {
    $query=$this->db->insert('holidays', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_holidays($data)
  {
    $this->db->where('id', $data['id']);
    $query=$this->db->update('holidays', $data);
    return $query;
  }

  public function select_billing_address($columns="*",$data="")
  {
    $this->db->select($columns)->from('billing_address');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('delete_status',0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_billing_address($data)
  {
    $query=$this->db->insert('billing_address', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_billing_address($data)
  {
    $this->db->where('id', $data['id']);
    $query=$this->db->update('billing_address', $data);
    return $query;
  }

  public function select_tax_types($columns="*",$data="",$data_select='')
  {
    $this->db->select($columns)->from('tax_types tt');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($data_select!='all'){
      $this->db->where('tt.delete_status',0);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_tax_types($data)
  {
    $query=$this->db->insert('tax_types', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_tax_types($data)
  {
    $this->db->where('tax_id', $data['tax_id']);
    $query=$this->db->update('tax_types', $data);
    return $query;
  }

  public function select_tax_state_codes($columns="*",$data="")
  {
    $this->db->select($columns)->from('tax_state_codes');
    if(!empty($data)){
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }

  public function select_terms_and_condition_templates($columns="*",$data="")
  {
    $this->db->select($columns)->from('terms_and_condition_templates');
    if(!empty($data)){
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }

  public function select_bank_account_details($columns="*",$data="",$data_select='')
  {
    $this->db->select($columns)->from('bank_account_details ba');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    if($data_select!='all'){
      $this->db->where('ba.delete_status',0);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_bank_account_detail($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query=$this->db->insert('bank_account_details', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_bank_account_detail($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('account_id', $data['account_id']);
    $query=$this->db->update('bank_account_details', $data);
    return $query;
  }


  public function select_modules($columns="*",$data="",$group_by='')
  {
    $this->db->select($columns)->from('modules m');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('m.activestatus',1);
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    $this->db->order_by('m.module_group_slno','asc');
    $this->db->order_by('m.slno','asc');
    $query = $this->db->get();
    return $query;
  }

  public function select_module_elements($columns="*",$data="",$join=false)
  {
    $this->db->select($columns)->from('module_elements me');
    if($join==true){
      $this->db->join('modules m','m.moduleno=me.moduleno');
      $this->db->where('m.activestatus',1);
    }
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('me.activestatus',1);
    // $this->db->order_by('m.slno','asc');
    $this->db->order_by('me.slno','asc');
    $query = $this->db->get();
    return $query;
  }

  public function select_user_module_elements($columns="*",$data="",$join=false)
  {
    $this->db->select($columns)->from('module_elements_user ue');
    if($join==true){
      $this->db->join('moduleelements me','me.elementno=ue.elementno');
      $this->db->join('modules m','m.moduleno=me.moduleno');
    }
    if(!empty($data)){
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_user_module_elements($data){
    // Run the query
    $query = $this->db->insert('module_elements_user', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_user_module_elements($data)
  {
    $this->db->where('user_id', $data['user_id']);
    $this->db->where('user_id_type', $data['user_id_type']);
    $this->db->where('elementno', $data['elementno']);
    $query=$this->db->update('module_elements_user', $data);
    return $query;
  }

  public function select_finyear($columns="*",$data="")
  {
    $this->db->select($columns)->from('financial_year f');
    if(!empty($data)){
      $this->db->where($data);
    }
    // $this->db->where('delete_status',0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_finyear($data){
    // Run the query
    $query = $this->db->insert('financial_year', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

}
?>
