<?php
class Sales_targets_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_targets($columns='*',$data='')
  {
    $this->db->select($columns)->from('sales_targets st');
    $this->db->join('users u','st.created_by=u.user_id','left');
    $this->db->join('users u2','st.user_id=u2.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('st.delete_status',0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u2.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("st.target_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_target($data){
    $query = $this->db->insert('sales_targets', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_target($data)
  {
    $this->db->where('target_id', $data['target_id']);
    $query=$this->db->update('sales_targets', $data);
    return $query;
  }

  public function select_target_items($columns='*',$data='',$group_by='')
  {
    $this->db->select($columns)->from('sales_target_details std');
    $this->db->join('sales_targets st','st.target_id=std.target_id','left');
    $this->db->join('users u','st.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('st.delete_status',0);
    $this->db->where('std.delete_status',0);
    if(!empty($group_by)){
      $this->db->group_by($group_by);
    }
    $query = $this->db->get();
    return $query;
  }
  public function insert_target_item($data){
    $query = $this->db->insert('sales_target_details', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_target_item($data)
  {
    $this->db->where('id', $data['id']);
    $query=$this->db->update('sales_target_details', $data);
    return $query;
  }

}
?>
