<?php
class Sales_quotation_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_quotations($columns='*',$data='')
  {
    $this->db->select($columns)->from('sales_quotations sq');
    $this->db->join('customers c','c.customer_id=sq.customer_id','left');
    $this->db->join('users u','sq.created_by=u.user_id','left');
    $this->db->join('users u1','sq.prepared_by=u1.user_id','left');
    $this->db->join('branches b','b.branch_id=sq.branch_id','left');
    $this->db->join('tax_types tt','sq.quotation_tax_percent=tt.tax_id','left');
    $this->db->join('tax_state_codes tsc','tsc.state_id=c.customer_tax_state','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sq.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('sq.delete_status',0);
    $this->db->order_by("sq.quotation_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_quotation($data){
    if($this->session->userdata('branch_id')!=0){
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('sales_quotations', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_quotation($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('quotation_id', $data['quotation_id']);
    $query=$this->db->update('sales_quotations', $data);
    return $query;
  }

  public function select_quotation_items($columns='*',$data='')
  {
    $this->db->select($columns)->from('sales_quotation_items sqi');
    $this->db->join('measure_units mu','sqi.unit=mu.unit_id','left');
    $this->db->join('sales_quotations sq','sq.quotation_id=sqi.quotation_id','left');
    $this->db->join('sales_quotation_templates sqt','sqt.template_id=sqi.template_id','left');
    $this->db->join('users u','sq.created_by=u.user_id','left');
    $this->db->join('work_types wt','sqi.work_type_id=wt.type_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('sqi.delete_status',0);
    $this->db->where('sq.delete_status',0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_quotation_item($data){
    $query = $this->db->insert('sales_quotation_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_quotation_item($data)
  {
    $this->db->where('item_id', $data['item_id']);
    $query=$this->db->update('sales_quotation_items', $data);
    return $query;
  }

  public function select_quotation_templates($columns='*',$data='')
  {
    $this->db->select($columns)->from('sales_quotation_templates sqt');
    $this->db->join('users u','sqt.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('sqt.delete_status',0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_quotation_templates($data){
    $query = $this->db->insert('sales_quotation_templates', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_quotation_templates($data)
  {
    $this->db->where('template_id', $data['template_id']);
    $query=$this->db->update('sales_quotation_templates', $data);
    return $query;
  }

}
?>
