<?php
class Sales_invoice_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function create_sale_invoice($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query=$this->db->insert('sales_invoices', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_sale_invoice($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('invoice_id', $data['invoice_id']);
    $query=$this->db->update('sales_invoices', $data);
    return $query;
  }
  public function select_invoices($columns="*",$data="")
  {
    $this->db->select($columns)->from('sales_invoices si');
    $this->db->join('financial_year fy','si.finyear=fy.finyear_id','left');
    $this->db->join('customers c','si.buyer_customer_id=c.customer_id','left');
    $this->db->join('stock_locations sl','si.location_id=sl.location_id');
    $this->db->join('tax_state_codes tsc','tsc.state_id=si.buyer_state_id','left');
    $this->db->join('users u','si.created_by=u.user_id','left');
    $this->db->join('bank_account_details ba','ba.account_id=si.bill_bank_account','left');
    $this->db->join('branches b','b.branch_id=si.branch_id','left');
    $this->db->join('branches b2','b2.branch_id=si.buyer_branch_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("si.delete_status",0);
    $this->db->where("sl.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('si.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("si.invoice_date",'desc');
    $query = $this->db->get();
    return $query;
  }

  public function create_invoice_sale_items($data){
    $query=$this->db->insert('sales_invoice_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_invoice_sale_item($columns="*",$data="",$group_by="")
  {
    $this->db->select($columns)->from('sales_invoice_items sii');
    $this->db->join('sales_invoices si','sii.invoice_id=si.invoice_id');
    $this->db->join('financial_year fy','si.finyear=fy.finyear_id','left');
    $this->db->join('tax_types tt','sii.tax_percent=tt.tax_id','left');
    $this->db->join('customers c','si.buyer_customer_id=c.customer_id','left');
    $this->db->join('stock_locations sl','si.location_id=sl.location_id');
    $this->db->join('stock_register sr','sii.stock_id=sr.stock_id');
    $this->db->join('materials m','sr.material_id=m.material_id');
    $this->db->join('measure_units mu','sr.unit = mu.unit_id','left');
    $this->db->join('users u','sii.created_by=u.user_id','left');
    $this->db->join('branches b','b.branch_id=si.branch_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("sii.delete_status",0);
    $this->db->where("si.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('si.branch_id', $this->session->userdata('branch_id'));
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    $this->db->order_by("sii.item_id",'asc');
    $query = $this->db->get();
    return $query;
  }

}
