<?php
class Salary_slips_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_salary_slips($columns="*",$data="",$order_by_column="",$order_by="",$group_by="",$limit_start="",$limit="",$entry_approval=1)
  {
    $this->db->select($columns)->from('salary_slips ss');
    $this->db->join('users u','ss.created_by=u.user_id','left');
    $this->db->join('employees e','ss.employee_id=e.employee_id');
    $this->db->join('work_contracts wc','ss.work_id=wc.work_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('e.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("ss.delete_status",0);
    $this->db->where("e.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("ss.entry_approval_status",$entry_approval);
    }
    $this->db->order_by("ss.month",'desc');
    if($order_by_column!='' && $order_by!=''){
      $this->db->order_by($order_by_column,$order_by);
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    if($limit!=''){
      if($limit_start!=''){
        $this->db->limit($limit,$limit_start);
      }else{
        $this->db->limit($limit);
      }
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_salary_slip($data){
    $query = $this->db->insert('salary_slips', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_salary_slip($data)
  {
    $this->db->where('salary_id', $data['salary_id']);
    $query=$this->db->update('salary_slips', $data);
    return $query;
  }
}
?>
