<?php
class Reminders_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }
  public function select_reminders($columns='*',$data='')
  {
    $this->db->select($columns)->from('reminders r');
    $this->db->join('users u','r.created_by=u.user_id','left');
    $this->db->join('work_contracts wc','r.reference_id=wc.work_id','left');
    $this->db->join('labours l','r.reference_id=l.labour_id','left');
    $this->db->join('employees e','r.reference_id=e.employee_id','left');
    $this->db->join('vehicles v','r.reference_id=v.id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("r.delete_status",0);
    $this->db->order_by("r.reminder_date",'asc');
    $query = $this->db->get();
    return $query;
  }
  public function create_reminder($data){
    $query = $this->db->insert('reminders', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_reminder($data)
  {
    $this->db->where('reminder_id', $data['reminder_id']);
    $query=$this->db->update('reminders', $data);
    return $query;
  }

}
?>
