<?php
class Purchase_request_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function insert_purchase_request($data)
  {
    $query=$this->db->insert('purchase_request', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_purchase_request($data)
  {
    $this->db->where('request_id', $data['request_id']);
    $query=$this->db->update('purchase_request', $data);
    return $query;
  }
  public function select_purchase_request($columns="*",$data="",$like="")
  {
    $this->db->select($columns)->from('purchase_request pr');
    $this->db->join('stock_locations sl','pr.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    $this->db->join('users u','pr.created_by=u.user_id','left');
    $this->db->join('users u1','pr.approved_by_1=u1.user_id','left');
    $this->db->join('users u2','pr.approved_by_2=u2.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sl.location_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("pr.delete_status",0);
    $this->db->where("sl.delete_status",0);
    $this->db->order_by("pr.request_date",'desc');
    $this->db->order_by("pr.request_id",'desc');
    $query = $this->db->get();
    return $query;
  }


  public function create_purchase_request_item($data)
  {
    $query=$this->db->insert('purchase_request_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_purchase_request_item($data)
  {
    $this->db->where('item_id', $data['item_id']);
    $query=$this->db->update('purchase_request_items', $data);
    return $query;
  }
  public function select_purchase_request_items($columns="*",$data="")
  {
    $this->db->select($columns)->from('purchase_request_items pri');
    $this->db->join('purchase_request pr','pri.request_id=pr.request_id');
    $this->db->join('users u','pr.created_by=u.user_id','left');
    $this->db->join('materials m','pri.material_id=m.material_id');
    $this->db->join('measure_units mu','pri.unit_id = mu.unit_id','left');
    $this->db->join('stock_locations sl','pr.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sl.location_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("pri.delete_status",0);
    $this->db->where("pr.delete_status",0);
    $this->db->where("sl.delete_status",0);
    $this->db->order_by("pr.request_date",'desc');
    $query = $this->db->get();
    return $query;
  }

}
?>
