<?php
class Purchase_order_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function insert_purchase_order($data)
  {
    $query=$this->db->insert('purchase_order', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_purchase_order($columns="*",$data="",$entry_approval=1)
  {
    $this->db->select($columns)->from('purchase_order po');
    $this->db->join('suppliers s','po.supplier_id=s.supplier_id');
    $this->db->join('stock_locations sl','po.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    $this->db->join('users u','po.created_by=u.user_id','left');
    $this->db->join('users u1','po.approved_by_1=u1.user_id','left');
    $this->db->join('users u2','po.approved_by_2=u2.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("po.delete_status",0);
    $this->db->where("sl.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("po.entry_approval_status",$entry_approval);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $branch_id = $this->session->userdata('branch_id');
      $this->db->where("sl.location_branch_id = $branch_id OR wc.branch_id = $branch_id");
    }
    // if(!empty($like)){
    //     $this->db->like('po.purchase_bill_id', $like);
    // }
    $this->db->order_by("po.order_date",'desc');
    $this->db->order_by("po.order_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function update_purchase_order($data)
  {
    $this->db->where('order_id', $data['order_id']);
    $query=$this->db->update('purchase_order', $data);
    return $query;
  }


  public function create_purchase_order_item($data)
  {
    $query=$this->db->insert('purchase_order_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_purchase_order_item($data)
  {
    $this->db->where('item_id', $data['item_id']);
    $query=$this->db->update('purchase_order_items', $data);
    return $query;
  }
  public function select_purchase_order_items($columns="*",$data="")
  {
    $this->db->select($columns)->from('purchase_order_items poi');
    $this->db->join('purchase_order po','poi.order_id=po.order_id');
    $this->db->join('users u','po.created_by=u.user_id','left');
    $this->db->join('materials m','poi.material_id=m.material_id');
    $this->db->join('measure_units mu','poi.unit_id = mu.unit_id','left');
    $this->db->join('stock_locations sl','po.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    $this->db->join('tax_types tt','poi.tax_percent=tt.tax_id','left');
    $this->db->join('suppliers s','po.supplier_id=s.supplier_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sl.location_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("poi.delete_status",0);
    $this->db->where("po.delete_status",0);
    $this->db->where("sl.delete_status",0);
    $this->db->order_by("po.order_date",'desc');
    $query = $this->db->get();
    return $query;
  }
}
?>
