<?php
class Purchase_bill_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function insert_purchase($data)
  {
    $query=$this->db->insert('purchase_bills', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_purchase($columns="*",$data="",$entry_approval=1,$order_by='',$group_by='',$entry_approval_2=1)
  {
    $this->db->select($columns)->from('purchase_bills p');
    $this->db->join('suppliers s','p.supplier_id=s.supplier_id');
    $this->db->join('stock_locations sl','p.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    $this->db->join('users u','p.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("p.delete_status",0);
    $this->db->where("sl.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("p.entry_approval_status",$entry_approval);
    }
    if($entry_approval_2!='all'){
      $this->db->where("p.entry_approval_status_2",$entry_approval_2);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sl.location_branch_id', $this->session->userdata('branch_id'));
    }
    if(!empty($group_by)){
      $this->db->group_by($group_by);
    }
    $this->db->order_by("p.purchase_date",'desc');
    $this->db->order_by("p.purchase_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function update_purchase($data)
  {
    $this->db->where('purchase_id', $data['purchase_id']);
    $query=$this->db->update('purchase_bills', $data);
    return $query;
  }


  public function create_purchase_item($data)
  {
    $query=$this->db->insert('purchase_bill_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_purchase_item($data)
  {
    $this->db->where('item_id', $data['item_id']);
    $query=$this->db->update('purchase_bill_items', $data);
    return $query;
  }
  public function select_purchase_items($columns="*",$data="",$order_by='',$group_by='',$data_type='',$entry_approval=1,$join_type='',$entry_approval_2=1)
  {
    $this->db->select($columns)->from('purchase_bill_items pi');
    $this->db->join('purchase_bills p','pi.purchase_id=p.purchase_id');
    if($join_type=='purchase_order'){
      $this->db->join('purchase_order po','p.purchase_order_id=po.order_id','left');
    }
    $this->db->join('suppliers s','p.supplier_id=s.supplier_id');
    $this->db->join('users u','p.created_by=u.user_id','left');
    $this->db->join('materials m','pi.material_id=m.material_id');
    $this->db->join('material_categories mc','m.category=mc.cat_id','left');
    $this->db->join('measure_units mu','pi.unit_id = mu.unit_id','left');
    $this->db->join('stock_locations sl','p.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    $this->db->join('tax_types tt','pi.tax_percent=tt.tax_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sl.location_branch_id', $this->session->userdata('branch_id'));
    }
    if($data_type!='all'){
      $this->db->where("pi.delete_status",0);
      $this->db->where("p.delete_status",0);
      $this->db->where("sl.delete_status",0);
    }
    if($entry_approval!='all'){
      $this->db->where("p.entry_approval_status",$entry_approval);
    }
    if($entry_approval_2!='all'){
      $this->db->where("p.entry_approval_status_2",$entry_approval_2);
    }
    if(!empty($group_by)){
      $this->db->group_by($group_by);
    }
    if(!empty($order_by)){
      $this->db->order_by($order_by[0],$order_by[1]);
    }else{
      $this->db->order_by("p.purchase_date",'desc');
    }
    $query = $this->db->get();
    return $query;
  }


  public function insert_purchase_return($data)
  {
    $query=$this->db->insert('purchase_return', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_purchase_return($columns="*",$data="",$group_by="",$entry_approval=1)
  {
    $this->db->select($columns)->from('purchase_return pr');
    $this->db->join('suppliers s','pr.supplier_id=s.supplier_id');
    $this->db->join('stock_register sr','pr.stock_id=sr.stock_id');
    $this->db->join('materials m','sr.material_id=m.material_id');
    $this->db->join('measure_units mu','sr.unit = mu.unit_id','left');
    $this->db->join('stock_locations sl','sr.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    $this->db->join('users u','pr.created_by=u.user_id','left');
    $this->db->join('tax_types tt','pr.tax_percent=tt.tax_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sl.location_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("pr.delete_status",0);
    $this->db->where("s.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("pr.entry_approval_status",$entry_approval);
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    $this->db->order_by("pr.return_date",'desc');
    $this->db->order_by("pr.return_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function update_purchase_return($data)
  {
    $this->db->where('return_id', $data['return_id']);
    $query=$this->db->update('purchase_return', $data);
    return $query;
  }


  public function insert_delivery_challan($data)
  {
    $query=$this->db->insert('purchase_delivery_challan', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_delivery_challan($columns="*",$data="",$entry_approval=1)
  {
    $this->db->select($columns)->from('purchase_delivery_challan pdc');
    $this->db->join('purchase_order po','po.order_id=pdc.order_id');
    $this->db->join('suppliers s','po.supplier_id=s.supplier_id');
    $this->db->join('stock_locations sl','po.location_id=sl.location_id');
    $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
    $this->db->join('users u','pdc.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('sl.location_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("pdc.delete_status",0);
    $this->db->where("po.delete_status",0);
    if($entry_approval!='all'){
      // $this->db->where("pdc.entry_approval_status",$entry_approval);
    }
    $this->db->order_by("pdc.challan_date",'desc');
    $this->db->order_by("pdc.challan_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function update_delivery_challan($data)
  {
    $this->db->where('challan_id ', $data['challan_id ']);
    $query=$this->db->update('purchase_delivery_challan', $data);
    return $query;
  }

  public function create_delivery_challan_item($data)
  {
    $query=$this->db->insert('purchase_delivery_challan_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_delivery_challan_item($data)
  {
    $this->db->where('item_id', $data['item_id']);
    $query=$this->db->update('purchase_delivery_challan_items', $data);
    return $query;
  }
  public function select_delivery_challan_items($columns="*",$data="")
  {
    $this->db->select($columns)->from('purchase_delivery_challan_items pdci');
    $this->db->join('purchase_order_items poi','poi.item_id=pdci.order_item_id');
    $this->db->join('materials m','poi.material_id=m.material_id');
    $this->db->join('measure_units mu','poi.unit_id = mu.unit_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
}
?>
