<?php
class Project_tasks_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }
  public function select_tasks($columns='*',$data='')
  {
    $this->db->select($columns)->from('project_tasks pt');
    $this->db->join('users u1','pt.created_by=u1.user_id','left');
    $this->db->join('users u2','pt.user_id=u2.user_id','left');
    $this->db->join('work_contracts wc','pt.work_id=wc.work_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wc.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("pt.delete_status",0);
    $this->db->order_by("pt.planned_start_date",'asc');
    $query = $this->db->get();
    return $query;
  }
  public function create_task($data){
    $query = $this->db->insert('project_tasks', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_task($data)
  {
    $this->db->where('task_id', $data['task_id']);
    $query=$this->db->update('project_tasks', $data);
    return $query;
  }

  public function select_task_activity($columns='*',$data='')
  {
    $this->db->select($columns)->from('project_task_activities pta');
    $this->db->join('project_tasks pt','pt.task_id=pta.task_id','left');
    $this->db->join('users u1','pt.created_by=u1.user_id','left');
    $this->db->join('users u2','pta.created_by=u2.user_id','left');
    $this->db->join('work_contracts wc','pt.work_id=wc.work_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wc.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("pt.delete_status",0);
    $this->db->where("pta.delete_status",0);
    $this->db->order_by("pta.created_date",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_task_activity($data){
    $query = $this->db->insert('project_task_activities', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_task_activity($data)
  {
    $this->db->where('id', $data['id']);
    $query=$this->db->update('project_task_activities', $data);
    return $query;
  }

  public function select_project_task_progress_log($columns='*',$data='')
  {
    $this->db->select($columns)->from('project_progress_log ppl');
    $this->db->join('users u1','ppl.created_by=u1.user_id','left');
    $this->db->join('project_tasks pt','ppl.reference_id=pt.task_id');
    // $this->db->join('users u2','pt.user_id=u2.user_id');
    $this->db->join('work_contracts wc','pt.work_id=wc.work_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wc.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("ppl.reference_type","project_task");
    $this->db->where("pt.delete_status",0);
    $this->db->order_by("ppl.created_date",'desc');
    $query = $this->db->get();
    return $query;
  }
}
?>
