<?php
class Production_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function insert_production($data)
  {
    $query=$this->db->insert('production', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_production($where_data,$update_data)
  {
    if(!empty($where_data)){
      $this->db->where($where_data);
      $query=$this->db->update('production', $update_data);
      return $query;
    }else{
      return 0;
    }
  }
  public function select_production($columns="*",$data="",$group_by="",$entry_approval=1)
  {
    $this->db->select($columns)->from('production p');
    $this->db->join('stock_register sr','p.stock_id=sr.stock_id');
    $this->db->join('stock_locations sl','sr.location_id=sl.location_id');
    $this->db->join('materials m','p.material_id=m.material_id');
    $this->db->join('measure_units mu','m.unit = mu.unit_id','left');
    $this->db->join('users u','p.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("p.delete_status",0);
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    $this->db->order_by("p.production_id ",'desc');
    $query = $this->db->get();
    return $query;
  }

  public function insert_production_materials_used($data)
  {
    $query=$this->db->insert('production_materials_used', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_production_materials_used($where_data,$update_data)
  {
    if(!empty($where_data)){
      $this->db->where($where_data);
      $query=$this->db->update('production_materials_used', $update_data);
      return $query;
    }else{
      return 0;
    }
  }
  public function select_production_materials_used($columns="*",$data="",$group_by="",$entry_approval=1)
  {
    $this->db->select($columns)->from('production_materials_used pmu');
    $this->db->join('production p','pmu.production_id=p.production_id');
    $this->db->join('stock_register sr','pmu.used_stock_id=sr.stock_id');
    $this->db->join('stock_locations sl','sr.location_id=sl.location_id');
    $this->db->join('materials m','sr.material_id=m.material_id');
    $this->db->join('measure_units mu','m.unit = mu.unit_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("p.delete_status",0);
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    $this->db->order_by("p.production_id ",'desc');
    $query = $this->db->get();
    return $query;
  }


}
?>
