<?php
class Material_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }


  public function select_material($columns="*",$data="")
  {
    $this->db->select($columns)->from('materials m');
    $this->db->join('measure_units mu','m.unit=mu.unit_id','left');
    $this->db->join('material_categories mc','m.category=mc.cat_id','left');
    $this->db->join('tax_types tt','m.material_tax_percent=tt.tax_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('(m.material_branch_id='.$this->session->userdata('branch_id').' or m.material_branch_id=0)');
    }else{
      $this->db->where('m.material_branch_id',0);
    }
    $this->db->where("m.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function update_material($data)
  {
    $this->db->where('material_id', $data['material_id']);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('(material_branch_id='.$this->session->userdata('branch_id').' or material_branch_id=0)');
    }
    $query=$this->db->update('materials', $data);
    return $query;
  }
  public function create_material($data){

    if($this->session->userdata('branch_id')!=0){
      $data['material_branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('materials', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  //  Measure Units
  public function select_unit($columns="*",$data="")
  {
    $this->db->select($columns)->from('measure_units mu');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("mu.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function update_unit($data)
  {
    $this->db->where('unit_id', $data['unit_id']);
    $query=$this->db->update('measure_units', $data);
    return $query;
  }
  public function create_unit($data){

    $query = $this->db->insert('measure_units', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  // Material categories
  public function select_category($columns="*",$data="")
  {
    $this->db->select($columns)->from('material_categories mc');
    if(!empty($data)){
      $this->db->where($data);
    }
    $query = $this->db->get();
    return $query;
  }
  public function update_category($data)
  {
    $this->db->where('cat_id', $data['cat_id']);
    $query=$this->db->update('material_categories', $data);
    return $query;
  }
  public function create_category($data){

    $query = $this->db->insert('material_categories', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_material_prices($columns="*",$data="")
  {
    $this->db->select($columns)->from('material_prices mp');
    $this->db->join('materials m','m.material_id=mp.material_id');
    $this->db->join('measure_units mu','m.unit=mu.unit_id','left');
    $this->db->join('material_categories mc','m.category=mc.cat_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('mp.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where("mp.delete_status",0);
    $this->db->where("m.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function update_material_prices($data)
  {
    $this->db->where('price_id', $data['price_id']);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id',$this->session->userdata('branch_id'));
    }
    $query=$this->db->update('material_prices', $data);
    return $query;
  }
  public function create_material_sale_price($data){

    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('material_prices', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

}
?>
