<?php
class Loan_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }


  public function select_loan($columns="*",$data="",$entry_approval=1,$entry_approval_2=1)
  {
    $this->db->select($columns)->from('loans l');
    $this->db->join('loan_provider lp','lp.loan_provider_id=l.provider_id','left');
    $this->db->join('users u','l.created_by=u.user_id','left');
    $this->db->join('account_heads ah1', 'l.credit_ac=ah1.acc_head_id');
    $this->db->join('work_contracts wc','l.work_id=wc.work_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($entry_approval!='all'){
      $this->db->where("l.entry_approval_status",$entry_approval);
    }
    if($entry_approval_2!='all'){
      $this->db->where("l.entry_approval_status_2",$entry_approval_2);
    }
    $this->db->where("l.delete_status",0);
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("l.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->order_by("l.loan_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_loan($data){
    if($this->session->userdata('branch_id')!=0){
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('loans', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_loan($data)
  {
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('loan_id', $data['loan_id']);
    $query=$this->db->update('loans', $data);
    return $query;
  }

  public function select_loan_provider($columns="*",$data="")
  {
    $this->db->select($columns)->from('loan_provider lp');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("lp.provider_branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where("lp.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function create_loan_provider($data){
    if($this->session->userdata('branch_id')!=0){
      $data['provider_branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('loan_provider', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_loan_provider($data)
  {
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("provider_branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('loan_provider_id', $data['loan_provider_id']);
    $query=$this->db->update('loan_provider', $data);
    return $query;
  }

}
?>
