<?php
class Labour_wages_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }


  public function select_labour_wages($columns="*",$data="",$order_by_column="",$order_by="",$group_by="",$limit_start="",$limit="",$entry_approval=1)
  {
    $this->db->select($columns)->from('labour_wages lw');
    $this->db->join('users u','lw.created_by=u.user_id','left');
    $this->db->join('labours l','lw.labour_id=l.labour_id');
    $this->db->join('work_contracts wc','lw.work_id=wc.work_id');
    $this->db->join('work_types wt','l.work_type=wt.type_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("lw.delete_status",0);
    $this->db->where("l.delete_status",0);
    $this->db->where("wc.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("lw.entry_approval_status",$entry_approval);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('l.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("lw.work_date",'desc');
    if($order_by_column!='' && $order_by!=''){
      $this->db->order_by($order_by_column,$order_by);
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    if($limit!=''){
      if($limit_start!=''){
        $this->db->limit($limit,$limit_start);
      }else{
        $this->db->limit($limit);
      }
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_labour_wage($data){
    $query = $this->db->insert('labour_wages', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_labour_wage($data)
  {
    $this->db->where('wage_id', $data['wage_id']);
    $query=$this->db->update('labour_wages', $data);
    return $query;
  }
}
?>
