<?php
class Labour_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_labours($columns="*",$data="",$order_by_1="",$order_by_2="",$group_by="",$limit_start="",$limit="",$active_status="1")
  {
    if($columns==''){
      $columns = '*';
    }
    $this->db->select($columns.",GROUP_CONCAT(DISTINCT wc.work_name) as assigned_project_names")->from('labours l');
    $this->db->join('users u','l.created_by=u.user_id','left');
    $this->db->join('work_types wt','l.work_type=wt.type_id','left');
    $this->db->join('work_contracts wc', ("FIND_IN_SET(wc.work_id , l.assigned_projects)"),'left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("l.delete_status",0);
    if($active_status!='all'){
      $this->db->where("l.active_status",$active_status);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('l.branch_id', $this->session->userdata('branch_id'));
    }
    if(!empty($order_by_1)){
      $this->db->order_by($order_by_1[0],$order_by_1[1]);
    }
    if(!empty($order_by_2)){
      $this->db->order_by($order_by_2[0],$order_by_2[1]);
    }
    $this->db->order_by('group_position','desc');
    $this->db->order_by('l.labour_name','asc');
    if($group_by!=''){
      $this->db->group_by($group_by);
    }else{
      $this->db->group_by('l.labour_id');
    }
    if($limit!=''){
      if($limit_start!=''){
        $this->db->limit($limit,$limit_start);
      }else{
        $this->db->limit($limit);
      }
    }
    $query = $this->db->get();
    return $query;
  }
  public function select_labours_2($columns="*",$data="",$active_status="1")
  {
    $this->db->select($columns)->from('labours l');
    $this->db->join('users u','l.created_by=u.user_id','left');
    $this->db->join('work_types wt','l.work_type=wt.type_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("l.delete_status",0);
    if($active_status!='all'){
      $this->db->where("l.active_status",$active_status);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('l.branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }
  public function select_labours_max($columns="*",$data="")
  {
    $this->db->select_max($columns)->from('labours l');
    $this->db->join('users u','l.created_by=u.user_id','left');
    $this->db->join('work_types wt','l.work_type=wt.type_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("l.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('l.branch_id', $this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }
  public function update_labour($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->where('labour_id', $data['labour_id']);
    $query=$this->db->update('labours', $data);
    return $query;
  }
  public function create_labour($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('labours', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }


  public function select_labour_attendance($columns="*",$data="",$order_by_column="",$order_by="",$group_by="",$limit_start="",$limit="")
  {
    $this->db->select($columns)->from('labour_attendance la');
    $this->db->join('users u','la.created_by=u.user_id','left');
    $this->db->join('labours l','la.labour_id=l.labour_id');
    $this->db->join('work_contracts wc','la.project_id=wc.work_id');
    $this->db->join('work_types wt','l.work_type=wt.type_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("la.delete_status",0);
    $this->db->where("l.delete_status",0);
    $this->db->where("wc.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('l.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("la.date",'desc');
    if($order_by_column!='' && $order_by!=''){
      $this->db->order_by($order_by_column,$order_by);
    }
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    if($limit!=''){
      if($limit_start!=''){
        $this->db->limit($limit,$limit_start);
      }else{
        $this->db->limit($limit);
      }
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_labour_attendance($data){
    $query = $this->db->insert('labour_attendance', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_labour_attendance($data)
  {
    $this->db->where('attendance_id', $data['attendance_id']);
    $query=$this->db->update('labour_attendance', $data);
    return $query;
  }

}
