<?php
class Invoices_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }
  public function select_invoices($columns='*',$data='',$entry_approval=1)
  {
    $this->db->select($columns)->from('client_invoices i');
    $this->db->join('clients c','c.client_id=i.client_id');
    $this->db->join('users u1','i.created_by=u1.user_id','left');
    $this->db->join('work_contracts wc','i.project_id=wc.work_id','left');
    $this->db->join('tax_types tt','i.invoice_tax_percent=tt.tax_id','left');
    $this->db->join('vehicles v','i.vehicle_id=v.id','left');
    $this->db->join('bank_account_details ba','ba.account_id=i.bank_account','left');
    $this->db->join('users u2','i.prepared_by=u2.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($entry_approval!='all'){
      $this->db->where("i.entry_approval_status",$entry_approval);
    }
    $this->db->where("i.delete_status",0);
    $this->db->where("((i.invoice_type='project_invoice' and wc.delete_status=0) or (i.invoice_type='proforma' and wc.delete_status=0) or (i.invoice_type='other_income' and c.delete_status=0))");
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("c.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->order_by("i.created_date",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_invoice($data){
    $query = $this->db->insert('client_invoices', $data);
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_invoice($data)
  {
    $this->db->where('invoice_id', $data['invoice_id']);
    $query=$this->db->update('client_invoices', $data);
    return $query;
  }

  public function select_invoice_items($columns='*',$data='',$order_by='',$group_by='',$data_type='',$entry_approval=1)
  {
    $this->db->select($columns)->from('client_invoice_items ii');
    $this->db->join('measure_units mu','ii.unit=mu.unit_id','left');
    $this->db->join('users u1','ii.created_by=u1.user_id','left');
    $this->db->join('client_invoices i','i.invoice_id=ii.invoice_id');
    $this->db->join('work_contracts wc','i.project_id=wc.work_id','left');
    $this->db->join('tax_types tt','ii.item_tax_percent=tt.tax_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("i.delete_status",0);
    $this->db->where("ii.delete_status",0);
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("c.branch_id",$this->session->userdata('branch_id'));
    }
    if(!empty($group_by)){
      $this->db->group_by($group_by);
    }
    if(!empty($order_by)){
      $this->db->order_by($order_by[0],$order_by[1]);
    }else{
      $this->db->order_by("i.created_date",'desc');
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_invoice_items($data)
  {
    $query=$this->db->insert('client_invoice_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_invoice_items($data)
  {
    $this->db->where('item_id', $data['item_id']);
    $query=$this->db->update('client_invoice_items', $data);
    return $query;
  }
}
