<?php
class Enquiries_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_enquiries($columns='*',$data='')
  {
    $this->db->select($columns)->from('enquiries e');
    $this->db->join('customers c','c.customer_id=e.customer_id');
    $this->db->join('tax_state_codes tsc','tsc.state_id=c.customer_tax_state','left');
    $this->db->join('service_departments s','s.service_id=e.service');
    $this->db->join('service_types st','st.stype_id=e.service_type','left');
    $this->db->join('users u1','u1.user_id=e.currently_assigned_to','left');
    $this->db->join('users u2','u2.user_id=e.created_by','left');
    $this->db->join('branches b','b.branch_id=e.branch_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('e.delete_status',0);
    $this->db->where('c.delete_status',0);
    $this->db->order_by('e.enquiry_id','desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_enquiry($data){

    if($this->session->userdata('branch_id')!=0){
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('enquiries', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_enquiry($data)
  {
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('enquiry_id', $data['enquiry_id']);
    $query=$this->db->update('enquiries', $data);
    return $query;
  }

  public function select_enquiry_responses($columns='*',$data='')
  {
    $this->db->select($columns)->from('enquiry_reponse er');
    $this->db->join('enquiries e','e.enquiry_id=er.enquiry_id');
    $this->db->join('customers c','c.customer_id=e.customer_id');
    $this->db->join('service_departments s','s.service_id=e.service');
    $this->db->join('users u','er.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('er.delete_status',0);
    $this->db->where('e.delete_status',0);
    $this->db->where('c.delete_status',0);
    $this->db->order_by('response_id','desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_enquiry_response($data){
    $query = $this->db->insert('enquiry_reponse', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_enquiry_response($data)
  {
    $this->db->where('response_id', $data['response_id']);
    $query=$this->db->update('enquiry_reponse', $data);
    return $query;
  }

  public function select_enquiry_followups($columns='*',$data='')
  {
    $this->db->select($columns)->from('enquiry_followups ef');
    $this->db->join('enquiries e','e.enquiry_id=ef.enquiry_id');
    $this->db->join('customers c','c.customer_id=e.customer_id');
    $this->db->join('service_departments s','s.service_id=e.service');
    $this->db->join('users u','ef.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('ef.delete_status',0);
    $this->db->where('e.delete_status',0);
    $this->db->where('c.delete_status',0);
    $this->db->order_by('followup_id','desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_enquiry_followup($data){
    $query = $this->db->insert('enquiry_followups', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_enquiry_followup($data)
  {
    $this->db->where('followup_id', $data['followup_id']);
    $query=$this->db->update('enquiry_followups', $data);
    return $query;
  }

  public function insert_enquiry_transfer_log($data){
    $query = $this->db->insert('enquiry_transfer_log', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_enquiry_transfer($columns='*',$data='')
  {
    $this->db->select($columns)->from('enquiry_transfer_log etl');
    $this->db->join('enquiries e','e.enquiry_id=etl.enquiry_id');
    $this->db->join('customers c','c.customer_id=e.customer_id');
    $this->db->join('service_departments s','s.service_id=e.service');
    $this->db->join('users u','etl.created_by=u.user_id','left');
    $this->db->join('branches b1','b1.branch_id=etl.transfer_from_branch','left');
    $this->db->join('branches b2','b2.branch_id=etl.transfer_to_branch','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('e.delete_status',0);
    $this->db->where('c.delete_status',0);
    $this->db->order_by('transfer_id','desc');
    $query = $this->db->get();
    return $query;
  }

  public function insert_enquiry_assign_log($data){
    $query = $this->db->insert('enquiry_assign_log', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_enquiry_assign_logs($columns='*',$data='')
  {
    $this->db->select($columns)->from('enquiry_assign_log eal');
    $this->db->join('enquiries e','e.enquiry_id=eal.enquiry_id');
    $this->db->join('users u','eal.created_by=u.user_id','left');
    $this->db->join('users u2','eal.assigned_to=u2.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('e.delete_status',0);
    $this->db->order_by('assign_id','desc');
    $query = $this->db->get();
    return $query;
  }
}
?>
