<?php
class Employees_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_employee($columns="*",$data="")
  {
    $this->db->select($columns.",GROUP_CONCAT(DISTINCT v.vehicle_no,';',v.vehicle_name,';',v.id) as assigned_vehicle_names,",FALSE)->from('employees e');
    $this->db->join('users u','e.user_id=u.user_id','left');
    $this->db->join('user_roles ur','u.user_role=ur.role_id','left');
    $this->db->join('employee_departments ed','ed.department_id=e.department','left');
    $this->db->join('vehicles v', ("FIND_IN_SET(v.id , e.assigned_vehicles)"),'left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where("e.delete_status",0);
    $this->db->group_by("e.employee_id");
    $query = $this->db->get();
    return $query;
  }
  public function update_employee($data)
  {
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('employee_id', $data['employee_id']);
    $query=$this->db->update('employees', $data);
    return $query;
  }
  public function create_employee($data){
    if($this->session->userdata('branch_id')!=0){
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('employees', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_employee_attendance($columns="*",$data="")
  {
    $this->db->select($columns)->from('employee_attendance ea');
    $this->db->join('employees e','e.employee_id=ea.employee_id','left');
    $this->db->join('employee_departments ed','ed.department_id=e.department','left');
    $this->db->join('work_contracts wc','wc.work_id=ea.project_id','left');
    $this->db->join('users u','ea.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where("ea.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function update_employee_attendance($data)
  {
    $this->db->where('attendance_id', $data['attendance_id']);
    $query=$this->db->update('employee_attendance', $data);
    return $query;
  }
  public function create_employee_attendance($data){
    $query = $this->db->insert('employee_attendance', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_employee_site_vist($columns="*",$data="")
  {
    $this->db->select($columns)->from('employee_site_visit esv');
    $this->db->join('employees e','e.employee_id=esv.employee_id','left');
    $this->db->join('employee_departments ed','ed.department_id=e.department','left');
    $this->db->join('work_contracts wc','wc.work_id=esv.project_id','left');
    $this->db->join('users u','esv.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->order_by("esv.visit_date","desc");
    $query = $this->db->get();
    return $query;
  }
  public function create_employee_site_vist($data){
    $query = $this->db->insert('employee_site_visit', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_employee_department($columns="*",$data="")
  {
    $this->db->select($columns)->from('employee_departments ed');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("ed.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function create_employee_department($data){
    $query = $this->db->insert('employee_departments', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }

  public function select_leave_types($columns="*",$data="")
  {
    $this->db->select($columns)->from('leave_types lt');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("lt.delete_status",0);
    $query = $this->db->get();
    return $query;
  }

  public function select_employee_leave_applications($columns="*",$data="",$group_by="",$order_by='',$limit='')
  {
    $this->db->select($columns)->from('leave_applications la');
    $this->db->join('employees e','e.employee_id=la.employee_id','left');
    $this->db->join('employee_departments ed','ed.department_id=e.department','left');
    $this->db->join('users u','la.created_by=u.user_id','left');
    $this->db->join('leave_types lt','la.leave_type=lt.leave_type_id','left');
    $this->db->join('users u1','la.approved_by_1=u1.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("e.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where("la.delete_status",0);
    if($group_by!=''){
      $this->db->group_by($group_by);
    }
    if(!empty($order_by)){
      $this->db->order_by($order_by[0],$order_by[1]);
    }
    if($limit!=''){
      $this->db->limit($limit);
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_employee_leave_applications($data){
    $query = $this->db->insert('leave_applications', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_employee_leave_applications($data)
  {
    $this->db->where('application_id', $data['application_id']);
    $query=$this->db->update('leave_applications', $data);
    return $query;
  }
}
?>
