<?php
class Documents_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }
  public function select_documents($columns='*',$data='')
  {
    $this->db->select($columns)->from('project_documents pd');
    $this->db->join('users u1','pd.created_by=u1.user_id','left');
    $this->db->join('work_contracts wc','pd.work_id=wc.work_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("wc.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where("pd.delete_status",0);
    $this->db->order_by("pd.created_date",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_document($data){
    $query = $this->db->insert('project_documents', $data);
    return $query;
  }
  public function update_document($data)
  {
    $this->db->where('id', $data['id']);
    $query=$this->db->update('project_documents', $data);
    return $query;
  }

  public function insert_document_revision($data)
  {
    $query=$this->db->insert('project_document_revisions', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_document_revision($data)
  {
    $this->db->where('revision_id', $data['revision_id']);
    $query=$this->db->update('project_document_revisions', $data);
    return $query;
  }
  public function select_document_revision($columns="*",$data="")
  {
    $this->db->select($columns)->from('project_document_revisions pdr');
    $this->db->join('project_documents pd','pd.id=pdr.document_id','left');
    $this->db->join('work_contracts wc','pd.work_id=wc.work_id');
    $this->db->join('users u','pdr.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("wc.branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where("pdr.delete_status",0);
    $query = $this->db->get();
    return $query;
  }
}
?>
