<?php
class Daily_reports_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  //  Task Reports
  public function select_task_report($columns="*",$data="")
  {
    $this->db->select($columns)->from('daily_task_report dr');
    $this->db->join('daily_tasks dt','dr.task_id=dt.task_id','left');
    $this->db->join('work_contracts wc','dt.work_id=wc.work_id','left');
    $this->db->join('users u','dr.created_by=u.user_id','left');
    $this->db->join('user_activities ua','dr.activity_id=ua.activity_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("dr.delete_status",0);
    $this->db->where("wc.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wc.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("dr.report_date",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_task_report($data){
    $query=$this->db->insert('daily_task_report', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_task_report($data)
  {
    $this->db->where('report_id', $data['report_id']);
    $query=$this->db->update('daily_task_report', $data);
    return $query;
  }
  //  Labour Report
  public function select_labour_report($columns="*",$data="")
  {
    $this->db->select($columns)->from('daily_labour_report dr');
    $this->db->join('labours l','dr.labour_id=l.labour_id','left');
    $this->db->join('work_types wt1','l.work_type=wt1.type_id','left');
    $this->db->join('sub_contracts sc','dr.subcontract_id=sc.contract_id','left');
    $this->db->join('sub_contractors c','c.contractor_id=sc.contractor','left');
    $this->db->join('work_types wt2','sc.work_type_id=wt2.type_id','left');
    $this->db->join('work_contracts wc','dr.work_id=wc.work_id','left');
    $this->db->join('users u','dr.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("dr.delete_status",0);
    $this->db->where("wc.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("dr.report_date",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_labour_report($data){
    $query=$this->db->insert('daily_labour_report', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_labour_report($data)
  {
    $this->db->where('report_id', $data['report_id']);
    $query=$this->db->update('daily_labour_report', $data);
    return $query;
  }

  //  Daily Notes
  public function select_daily_notes($columns="*",$data="")
  {
    $this->db->select($columns)->from('daily_notes dn');
    $this->db->join('work_contracts wc','dn.work_id=wc.work_id','left');
    $this->db->join('users u','dn.created_by=u.user_id','left');
    $this->db->join('user_activities ua','dn.activity_id=ua.activity_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("dn.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wc.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("dn.note_date",'desc');
    $this->db->order_by("dn.created_date",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_daily_note($data){
    $query=$this->db->insert('daily_notes', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_daily_note($data)
  {
    $this->db->where('note_id', $data['note_id']);
    $query=$this->db->update('daily_notes', $data);
    return $query;
  }

  public function select_daily_progress_report($columns="*",$data="")
  {
    $this->db->select($columns)->from('daily_progress_report dpr');
    $this->db->join('work_contracts wc','dpr.work_id=wc.work_id','left');
    $this->db->join('users u','dpr.created_by=u.user_id','left');
    $this->db->join('user_activities ua','dpr.activity_id=ua.activity_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("dpr.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("dpr.report_date",'desc');
    $this->db->order_by("dpr.created_date",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function create_daily_progress_report($data){

    $query=$this->db->insert('daily_progress_report', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_daily_progress_report($data)
  {
    $this->db->where('report_id', $data['report_id']);
    $query=$this->db->update('daily_progress_report', $data);
    return $query;
  }
}
?>
