<?php
class Boq_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function insert_boq($data)
  {
    $query=$this->db->insert('boq', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq($data,$id)
  {
    $where = array('boq_id' => $id);
    $query = $this->db->update('boq', $data, $where);
    return $query;
  }
  public function select_boq($columns="*",$data="",$in_array="")
  {
    $this->db->select($columns)->from('boq b');
    $this->db->join('users u','b.created_by=u.user_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('b.delete_status',0);
    if(!empty($in_array)){
      $this->db->where_in('b.boq_id',$in_array);
    }
    $this->db->group_by('b.boq_id');
    $query = $this->db->get();
    return $query;
  }

  public function insert_project_work_type($data)
  {
    $query=$this->db->insert('project_work_types', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_project_work_type($data,$where)
  {
    $query = $this->db->update('project_work_types', $data, $where);
    return $query;
  }
  public function select_project_work_type($columns="*",$data='',$order_by='asc',$limit='') {

    $this->db->select($columns)->from('project_work_types pwt');
    $this->db->join('work_types w','pwt.work_type_id=w.type_id');
    // $this->db->join('boq_tasks bt','bt.boq_id='$boq_id,'left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('pwt.delete_status',0);
    // $this->db->order_by('pwt.priority',$order_by);
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    $query = $this->db->get();
    return $query;

  }

  public function insert_boq_tasks($data)
  {
    $query=$this->db->insert('boq_tasks', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq_task($data,$where)
  {
    $query = $this->db->update('boq_tasks', $data, $where);
    return $query;
  }
  public function select_task($columns="*",$data='',$limit='',$orderby_column='',$orderby_type='') {

    $this->db->select($columns);
    $this->db->from('boq_tasks bt');
    $this->db->join('project_work_types pwt', 'bt.project_work_type_id=pwt.id');
    $this->db->join('work_types w','pwt.work_type_id=w.type_id');
    $this->db->join('measure_units mu','bt.unit=mu.unit_id','left');
    $this->db->join('tax_types tt','bt.client_tax_percent=tt.tax_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('bt.delete_status',0);
    $this->db->where('pwt.delete_status',0);
    if(!empty($orderby_column) && !empty($orderby_type)){
      $this->db->order_by($orderby_column,$orderby_type);
    }
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    // $this->db->group_by("bt.project_work_type_id");
    $query = $this->db->get();
    return $query;
  }

  public function insert_boq_task_items($data)
  {
    $query=$this->db->insert('boq_task_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq_task_items($data,$where)
  {
    $query = $this->db->update('boq_task_items', $data, $where);
    return $query;
  }
  public function select_task_items($column='*',$data='',$limit='',$orderby_column='',$orderby_type='',$group_by='') {

    $this->db->select($column);
    $this->db->from('boq_task_items bti');
    $this->db->join('boq_tasks bt', 'bti.boq_task_id=bt.task_id','left');
    $this->db->join('boq b', 'b.boq_id=bt.boq_id','left');
    $this->db->join('materials m', 'm.material_id=bti.material_id','left');
    $this->db->join('measure_units mu','bti.unit=mu.unit_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('bti.delete_status',0);
    $this->db->where('bt.delete_status',0);
    if(!empty($orderby_column) && !empty($orderby_type)){
      $this->db->order_by($orderby_column,$orderby_type);
    }
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    if(!empty($group_by)){
      $this->db->group_by($group_by);
    }
    // $this->db->group_by("bt.project_work_type_id");
    $query = $this->db->get();
    return $query;
  }

  public function insert_boq_daily_progress($data)
  {
    $query=$this->db->insert('boq_daily_progress', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq_daily_progress($data,$where)
  {
    $query = $this->db->update('boq_daily_progress', $data, $where);
    return $query;
  }
  public function select_boq_daily_progress($columns="*",$data='',$limit='',$orderby_column='',$orderby_type='',$join=false) {

    $this->db->select($columns);
    $this->db->from('boq_daily_progress bdp');
    $this->db->join('boq b', 'b.boq_id=bdp.boq_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($join==true){
      $this->db->join('boq_tasks bt', 'bt.task_id=bdp.reference_id');
      $this->db->where('bdp.type','boq_task');
      $this->db->where('bt.delete_status',0);
    }
    $this->db->where('bdp.delete_status',0);
    if(!empty($orderby_column) && !empty($orderby_type)){
      $this->db->order_by($orderby_column,$orderby_type);
    }
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    // $this->db->group_by("bt.project_work_type_id");
    $query = $this->db->get();
    return $query;
  }

  public function insert_boq_dpr($data)
  {
    $query=$this->db->insert('boq_dpr', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq_dpr($data,$where)
  {
    $query = $this->db->update('boq_dpr', $data, $where);
    return $query;
  }
  public function select_boq_dpr($columns="*",$data='',$limit='',$order_by='',$join=false) {

    $this->db->select($columns);
    $this->db->from('boq_dpr bdp');
    $this->db->join('boq b', 'b.boq_id=bdp.boq_id','left');
    $this->db->join('users u1','bdp.supervisor_id=u1.user_id','left');
    $this->db->join('sub_contracts sc','bdp.subcontract_id=sc.contract_id','left');
    $this->db->join('sub_contractors c','c.contractor_id=sc.contractor','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($join==true){

    }
    $this->db->where('bdp.delete_status',0);
    if(!empty($order_by)){
      $this->db->order_by($order_by[0],$order_by[1]);
    }
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    // $this->db->group_by("bt.project_work_type_id");
    $query = $this->db->get();
    return $query;
  }

  public function insert_boq_dpr_items($data)
  {
    $query=$this->db->insert('boq_dpr_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq_dpr_items($data,$where)
  {
    $query = $this->db->update('boq_dpr_items', $data, $where);
    return $query;
  }
  public function select_boq_dpr_items($columns="*",$data='',$limit='',$orderby_column='',$orderby_type='',$join=false) {

    $this->db->select($columns);
    $this->db->from('boq_dpr_items bdi');
    $this->db->join('boq_dpr bd', 'bd.dpr_id=bdi.dpr_id','left');
    $this->db->join('materials m', 'm.material_id=bdi.item_material_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($join==true){

    }
    $this->db->where('bd.delete_status',0);
    if(!empty($orderby_column) && !empty($orderby_type)){
      $this->db->order_by($orderby_column,$orderby_type);
    }
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    // $this->db->group_by("bt.project_work_type_id");
    $query = $this->db->get();
    return $query;
  }


  public function insert_boq_dpr_item_materials($data)
  {
    $query=$this->db->insert('boq_dpr_item_materials', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq_dpr_item_materials($data,$where)
  {
    $query = $this->db->update('boq_dpr_item_materials bdim', $data, $where);
    return $query;
  }
  public function select_boq_dpr_item_materials($columns="*",$data='',$limit='',$orderby_column='',$orderby_type='',$join=false) {

    $this->db->select($columns);
    $this->db->from('boq_dpr_item_materials bdim');
    $this->db->join('boq_dpr_items bdi', 'bdim.item_id=bdi.item_id','left');
    $this->db->join('boq_dpr bd', 'bdi.dpr_id=bd.dpr_id','left');
    // $this->db->join('boq b', 'b.boq_id=bdp.boq_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($join==true){

    }
    // $this->db->where('bdp.delete_status',0);
    if(!empty($orderby_column) && !empty($orderby_type)){
      $this->db->order_by($orderby_column,$orderby_type);
    }
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    // $this->db->group_by("bt.project_work_type_id");
    $query = $this->db->get();
    return $query;
  }


  public function insert_boq_dpr_material_consumption($data)
  {
    $query=$this->db->insert('boq_dpr_material_consumption', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_boq_dpr_material_consumption($data,$where)
  {
    $query = $this->db->update('boq_dpr_material_consumption bdmc', $data, $where);
    return $query;
  }
  public function select_boq_dpr_material_consumption($columns="*",$data='',$limit='',$orderby_column='',$orderby_type='',$join=false) {

    $this->db->select($columns);
    $this->db->from('boq_dpr_material_consumption bdmc');
    $this->db->join('boq_dpr bd', 'bd.dpr_id=bdmc.dpr_id','left');
    $this->db->join('materials m', 'm.material_id=bdmc.material_id','left');
    $this->db->join('measure_units mu','m.unit=mu.unit_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    if($join==true){

    }
    // $this->db->where('bdmc.delete_status',0);
    if(!empty($orderby_column) && !empty($orderby_type)){
      $this->db->order_by($orderby_column,$orderby_type);
    }
    if(!empty($limit)){
      $this->db->limit($limit);
    }
    // $this->db->group_by("bt.project_work_type_id");
    $query = $this->db->get();
    return $query;
  }

}
?>
