<?php
class Bills_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_bills($columns="*",$data="",$bill_type='',$group_by=true,$group_by_column='',$entry_approval=1,$entry_approval_2=1)
  {
    if($bill_type=='subcontract_bill' && $group_by==true){
      $this->db->select($columns.",GROUP_CONCAT(DISTINCT wt.type_name) as work_type_names",false)->from('bills b');
    }else{
      $this->db->select($columns)->from('bills b');
    }
    $this->db->join('tax_types tt','b.bill_tax_percent=tt.tax_id','left');
    $this->db->join('users u','b.created_by=u.user_id','left');
    $this->db->join('work_contracts wc','b.work_id=wc.work_id','left');
    $this->db->join('account_heads ah1','b.bill_credit_ac=ah1.acc_head_id','left');
    $this->db->join('sub_contracts sc','b.subcontract_id=sc.contract_id','left');
    $this->db->join('sub_contractors c','c.contractor_id=sc.contractor','left');
    $this->db->join('work_contracts wc2','sc.work_id=wc2.work_id','left');
    $this->db->join('vehicles v','v.id=b.vehicle_id','left');
    $this->db->join('vehicle_consignee vc','vc.consignee_id=v.consignee','left');
    $this->db->join('suppliers s','s.supplier_id=b.bill_supplier_id','left');
    if($bill_type=='subcontract_bill'){
      $this->db->join('work_types wt', ("FIND_IN_SET(wt.type_id , sc.work_type_id)"),'left');
    }
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("b.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("b.entry_approval_status",$entry_approval);
    }
    if($entry_approval_2!='all'){
      $this->db->where("b.entry_approval_status_2",$entry_approval_2);
    }
    $this->db->where("((b.bill_type='expense' and b.work_id!=0 and wc.delete_status=0) or (b.bill_type='expense' and b.work_id=0) or (b.bill_type='subcontract' and sc.delete_status=0 and ((b.work_id!=0 and wc.delete_status=0) or wc2.delete_status=0)) or (b.bill_type='vehicle' and b.vehicle_id!=0 and v.delete_status=0))");
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('b.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("bill_date",'desc');
    $this->db->order_by("bill_id",'desc');
    if($bill_type=='subcontract_bill'){
      $this->db->group_by("b.bill_id");
    }
    if($group_by_column!=''){
      $this->db->group_by($group_by_column);
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_bills($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query=$this->db->insert('bills', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_bills($data)
  {
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('bill_id', $data['bill_id']);
    $query=$this->db->update('bills', $data);
    return $query;
  }
  public function update_bills_2($where_data,$update_data)
  {
    if(!empty($where_data)){
      if($this->session->userdata('branch_id')!=0){
        $this->db->where("branch_id",$this->session->userdata('branch_id'));
      }
      $this->db->where($where_data);
      $query=$this->db->update('bills', $update_data);
      return $query;
    }else{
      return 0;
    }
  }

  public function select_bill_items($columns='*',$data='')
  {
    $this->db->select('*')->from('bill_items');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("delete_status",0);
    $query = $this->db->get();
    return $query;
  }
  public function create_bill_items($data){
    $query=$this->db->insert('bill_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
}
?>
