<?php
class Attendance_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function insert_attendance($data)
  {
    $query=$this->db->insert('user_attendance', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_attendance($data)
  {
    $this->db->where('attendance_id', $data['attendance_id']);
    $query=$this->db->update('user_attendance', $data);
    return $query;
  }
  public function select_attendance($columns="*",$data="",$order_by=array(),$limit='')
  {
    $this->db->select($columns)->from('user_attendance uat');
    $this->db->join('users u','uat.user_id=u.user_id','left');
    $this->db->join('users u2','uat.created_by=u2.user_id','left');
    $this->db->join('user_activities ua1','uat.sign_in_activity_id=ua1.activity_id','left');
    $this->db->join('user_activities ua2','uat.sign_off_activity_id=ua2.activity_id','left');
    $this->db->join('leave_types lt','uat.leave_type=lt.leave_type_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("uat.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    if(!empty($order_by)){
      $this->db->order_by($order_by[0],$order_by[1]);
    }
    if($limit!=''){
      $this->db->limit($limit);
    }
    $this->db->order_by("uat.signed_in_time",'asc');
    $query = $this->db->get();
    return $query;
  }


  public function insert_attendance_projectwise($data)
  {
    $query=$this->db->insert('user_attendance_project_wise', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_attendance_projectwise($data)
  {
    $this->db->where('attendance_id', $data['attendance_id']);
    $query=$this->db->update('user_attendance_project_wise', $data);
    return $query;
  }
  public function select_attendance_projectwise($columns="*",$data="",$order_by=array(),$limit='')
  {
    $this->db->select($columns)->from('user_attendance_project_wise uat');
    $this->db->join('work_contracts wc','uat.project_id=wc.work_id','left');
    $this->db->join('users u','uat.user_id=u.user_id','left');
    $this->db->join('users u2','uat.created_by=u2.user_id','left');
    $this->db->join('user_activities ua1','uat.sign_in_activity_id=ua1.activity_id','left');
    $this->db->join('user_activities ua2','uat.sign_off_activity_id=ua2.activity_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("uat.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('u.branch_id', $this->session->userdata('branch_id'));
    }
    if(!empty($order_by)){
      $this->db->order_by($order_by[0],$order_by[1]);
    }else{
      $this->db->order_by("uat.signed_in_time",'asc');
    }
    if($limit!=''){
      $this->db->limit($limit);
    }
    $query = $this->db->get();
    return $query;
  }
}
?>
