<?php
class Account_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }


  public function select_account_heads($columns="*",$data="",$type="",$order_by="desc",$all='')
  {
    $this->db->select($columns)->from('account_heads ah');
    $this->db->join('account_types at','ah.account_type=at.ac_type');
    if($type=='user'){
      $this->db->join('employees e','ah.acc_employee_id=e.employee_id');
      $this->db->join('employee_departments ed','ed.department_id=e.department','left');
      $this->db->join('users u','e.user_id=u.user_id','left');
      $this->db->join('user_roles ur','u.user_role=ur.role_id','left');
      $this->db->where("e.delete_status",0);
    }elseif($type=='supplier'){
      $this->db->join('suppliers s','ah.acc_supplier_id=s.supplier_id');
    }
    if(!empty($data)){
      $this->db->where($data);
    }
    if($all!='all'){
      $this->db->where("ah.delete_status",0);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('ah.acc_head_branch_id', $this->session->userdata('branch_id'));
    }
    if($this->config->item('Expense_local_material_purchase')!=1){
      $this->db->where("ah.acc_head_id !=",23);
    }
    $this->db->order_by("acc_head_id",$order_by);
    $query = $this->db->get();
    return $query;
  }
  public function select_account_transfer($columns="*",$data="",$order_by="desc",$entry_approval=1)
  {

    if($entry_approval==''){
      $entry_approval=1;
    }
    $this->db->select($columns)->from('account_transactions ats');
    $this->db->join('account_heads ah1','ats.tr_debit_acc=ah1.acc_head_id');
    $this->db->join('account_heads ah2','ats.tr_credit_acc=ah2.acc_head_id');
    $this->db->join('users u1','ats.created_by=u1.user_id','left');
    $this->db->join('users u2','ats.updated_by=u2.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("ats.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("ats.tr_entry_approval_status",$entry_approval);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('ah1.acc_head_branch_id', $this->session->userdata('branch_id'));
      $this->db->where('ah2.acc_head_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("transaction_id",$order_by);
    $query = $this->db->get();
    return $query;
  }
  public function create_account_head($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['acc_head_branch_id'] = $this->session->userdata('branch_id');
    }
    $query=$this->db->insert('account_heads', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_account_head($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('acc_head_branch_id',$this->session->userdata('branch_id'));
    }
    $this->db->where('acc_head_id', $data['acc_head_id']);
    $query=$this->db->update('account_heads', $data);
    return $query;
  }

  public function select_account_transaction($columns="*",$data="",$join_tables='',$group_by='',$limit='',$order_by='',$entry_approval=1,$entry_approval_2=1,$join_table_entry_approval=1)
  {
    // $this->output->enable_profiler(true);
    if($entry_approval==''){
      $entry_approval=1;
    }
    if($entry_approval_2==''){
      $entry_approval_2=1;
    }
    if($join_table_entry_approval==''){
      $join_table_entry_approval=1;
    }
    $this->db->select($columns)->from('account_transactions ats');
    $this->db->join('account_heads ah1','ats.tr_debit_acc=ah1.acc_head_id');
    $this->db->join('account_heads ah2','ats.tr_credit_acc=ah2.acc_head_id');
    $this->db->join('users u1','ats.created_by=u1.user_id','left');
    $this->db->join('users u2','ats.updated_by=u2.user_id','left');
    if($join_tables=='expense_bill' || $join_tables=='subcontract_bill' | $join_tables=='vehicle_bill'){

      $this->db->join('bills b','ats.reference_id=b.bill_id','left');
      $this->db->join('work_contracts wc','b.work_id=wc.work_id','left');
      $this->db->join('sub_contracts sc','b.subcontract_id=sc.contract_id','left');
      $this->db->join('sub_contractors c','c.contractor_id=sc.contractor','left');
      $this->db->join('vehicles v','v.id=b.vehicle_id','left');
      $this->db->join('vehicle_consignee vc','vc.consignee_id=v.consignee','left');
      if($join_tables=='expense_bill'){
        $this->db->where("((b.work_id !=0 and wc.delete_status=0) or b.work_id=0)");
        if($entry_approval!='all' && $join_table_entry_approval!='all'){
          $this->db->where("b.entry_approval_status",$entry_approval);
        }
        if($entry_approval_2!='all' && $join_table_entry_approval!='all'){
          $this->db->where("b.entry_approval_status_2",$entry_approval_2);
        }
      }
      if($join_tables=='vehicle_bill'){
        $this->db->where("v.delete_status",0);
      }
      if($join_tables=='subcontract_bill' ){
        $this->db->where("wc.delete_status",0);
        $this->db->where("sc.delete_status",0);
        if($entry_approval!='all' && $join_table_entry_approval!='all'){
          $this->db->where("b.entry_approval_status",$entry_approval);
        }
      }
      $this->db->where("b.delete_status",0);

    }elseif($join_tables=='subcontract_advance'){

      // For Subcontract Advance
      $this->db->join('sub_contracts sc2','ats.reference_id=sc2.contract_id','left');
      $this->db->join('work_contracts wc2','sc2.work_id=wc2.work_id','left');
      $this->db->join('sub_contractors c2','c2.contractor_id=sc2.contractor','left');

      $this->db->where("(ats.reference_type ='subcontract' and wc2.delete_status=0 and sc2.delete_status=0)");

    }elseif($join_tables=='subcontract_transactions'){

      // For Subcontract Bill
      $this->db->join('bills b','ats.reference_id=b.bill_id','left');
      $this->db->join('work_contracts wc','b.work_id=wc.work_id','left');
      $this->db->join('sub_contracts sc','b.subcontract_id=sc.contract_id','left');
      $this->db->join('sub_contractors c','c.contractor_id=sc.contractor','left');

      // For Subcontract Advance
      $this->db->join('sub_contracts sc2','ats.reference_id=sc2.contract_id','left');
      $this->db->join('work_contracts wc2','sc2.work_id=wc2.work_id','left');
      $this->db->join('sub_contractors c2','c2.contractor_id=sc2.contractor','left');
      if($entry_approval!='all' && $join_table_entry_approval!='all'){
        $this->db->where("((ats.reference_type ='subcontract_bill' and wc.delete_status=0 and sc.delete_status=0 and b.delete_status=0 and b.entry_approval_status='$entry_approval') or (ats.reference_type ='subcontract' and wc2.delete_status=0 and sc2.delete_status=0))");
      }else{
        $this->db->where("((ats.reference_type ='subcontract_bill' and wc.delete_status=0 and sc.delete_status=0 and b.delete_status=0) or (ats.reference_type ='subcontract' and wc2.delete_status=0 and sc2.delete_status=0))");
      }

    }elseif($join_tables=='client_payment'){

      $this->db->join('work_contracts wc','ats.reference_id=wc.work_id','left');
      $this->db->join('client_invoices ci','ats.invoice_id=ci.invoice_id','left');
      $this->db->join('clients c','wc.client_id=c.client_id','left');
      $this->db->where("wc.delete_status",0);
      $this->db->where("((ats.invoice_id!=0 and ci.delete_status=0) or (ats.invoice_id=0))");
      if($this->session->userdata('branch_id')!=0){
        $this->db->where("wc.branch_id",$this->session->userdata('branch_id'));
      }

    }elseif($join_tables=='income_receipt'){

      $this->db->join('work_contracts wc','ats.tr_work_id=wc.work_id','left');
      $this->db->join('client_invoices ci','ats.invoice_id=ci.invoice_id','left');
      $this->db->join('clients c','ci.client_id=c.client_id','left');
      $this->db->where("((ats.invoice_id!=0 and ci.delete_status=0) or (ats.invoice_id=0))");

    }elseif($join_tables=='sales_invoice'){

      $this->db->join('sales_invoices si','ats.reference_id=si.invoice_id','left');
      $this->db->join('customers c','c.customer_id=si.buyer_customer_id','left');
      $this->db->where("si.delete_status",0);

    }elseif($join_tables=='bills'){

      $this->db->join('bills b','ats.reference_id=b.bill_id','left');
      $this->db->join('work_contracts wc','b.work_id=wc.work_id','left');
      $this->db->where("b.delete_status",0);
      if($entry_approval!='all' && $join_table_entry_approval!='all'){
        $this->db->where("b.entry_approval_status",$entry_approval);
      }
      if($entry_approval_2!='all' && $join_table_entry_approval!='all'){
        $this->db->where("b.entry_approval_status_2",$entry_approval_2);
      }

    }elseif($join_tables=='purchase_bill'){

      $this->db->join('purchase_bills p','ats.reference_id=p.purchase_id','left');
      $this->db->join('suppliers s','p.supplier_id=s.supplier_id','left');
      $this->db->join('stock_locations sl','p.location_id=sl.location_id','left');
      $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
      $this->db->where("p.delete_status",0);
      // $this->db->where("wc.delete_status",0);
      $this->db->where("sl.delete_status",0);
      $this->db->where("s.delete_status",0);
      if($entry_approval!='all'  && $join_table_entry_approval!='all'){
        $this->db->where("p.entry_approval_status",$entry_approval);
      }
      if($entry_approval_2!='all'  && $join_table_entry_approval!='all'){
        $this->db->where("p.entry_approval_status_2",$entry_approval_2);
      }
      $this->db->where("((sl.location_type='work_site' and wc.delete_status=0) or (sl.location_type='ware_house'))");

    }elseif($join_tables=='purchase_order'){

      $this->db->join('purchase_order po','ats.reference_id=po.order_id','left');
      $this->db->join('suppliers s','po.supplier_id=s.supplier_id','left');
      $this->db->join('stock_locations sl','po.location_id=sl.location_id','left');
      $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
      $this->db->where("po.delete_status",0);
      // $this->db->where("wc.delete_status",0);
      $this->db->where("sl.delete_status",0);
      $this->db->where("s.delete_status",0);
      if($entry_approval!='all'  && $join_table_entry_approval!='all'){
        $this->db->where("po.entry_approval_status",$entry_approval);
      }
      $this->db->where("((sl.location_type='work_site' and wc.delete_status=0) or (sl.location_type='ware_house'))");

    }elseif($join_tables=='labour' || $join_tables=='labour_insurance_fd'){

      $this->db->join('labours l','ats.reference_id=l.labour_id','left');
      $this->db->join('work_types wt','l.work_type=wt.type_id','left');
      $this->db->where("l.delete_status",0);

    }elseif($join_tables=='loan'){

      $this->db->join('loans l','ats.reference_id=l.loan_id','left');
      $this->db->join('loan_provider lp','lp.loan_provider_id=l.provider_id','left');
      $this->db->join('work_contracts wc','l.work_id=wc.work_id','left');
      $this->db->where("l.delete_status",0);
      if($entry_approval!='all'  && $join_table_entry_approval!='all'){
        $this->db->where("l.entry_approval_status",$entry_approval);
      }
      if($entry_approval_2!='all'  && $join_table_entry_approval!='all'){
        $this->db->where("l.entry_approval_status_2",$entry_approval_2);
      }
    }elseif($join_tables=='tool'){

      $this->db->join('tool_rent tr','ats.reference_id=tr.id','left');
      $this->db->join('work_contracts wc','tr.rented_to=wc.work_id','left');
      $this->db->join('tools t','tr.tool_id=t.tool_id','left');
      $this->db->join('tools_category tc','t.category_id=tc.cat_id','left');

      $this->db->join('tools_transfers tt','ats.reference_id=tt.transfer_id','left');
      $this->db->join('work_contracts wc1','tt.transfer_from=wc1.work_id','left');
      $this->db->join('work_contracts wc2','tt.transfer_to=wc2.work_id','left');
      $this->db->join('work_contracts wc3','tr.rented_to=wc3.work_id','left');
      $this->db->join('tools t2','tt.tool_id=t2.tool_id','left');
      $this->db->join('tools_category tc2','t2.category_id=tc2.cat_id','left');
      if($entry_approval!='all'){
        $this->db->where("((ats.reference_type='tool_transfer' and tt.delete_status=0 and tt.entry_approval_status='$entry_approval' and (tt.transfer_from=0 or (tt.transfer_from!=0 and wc1.delete_status=0)) and (tt.transfer_to=0 or (tt.transfer_to!=0 and wc2.delete_status=0))) or (ats.reference_type='tool_rent' and tr.delete_status=0 and tr.entry_approval_status='$entry_approval' and wc3.delete_status=0))");
      }else{
        $this->db->where("((ats.reference_type='tool_transfer' and tt.delete_status=0  and (tt.transfer_from=0 or (tt.transfer_from!=0 and wc1.delete_status=0)) and (tt.transfer_to=0 or (tt.transfer_to!=0 and wc2.delete_status=0))) or (ats.reference_type='tool_rent' and tr.delete_status=0 and wc3.delete_status=0))");
      }

    }elseif($join_tables=='supplier'){

      $this->db->join('suppliers s','ats.reference_id=s.supplier_id','left');
      $this->db->where("s.delete_status",0);

    }elseif($join_tables=='salary_slip'){

      $this->db->join('salary_slips ss','ats.reference_id=ss.salary_id','left');
      $this->db->join('employees e','ss.employee_id=e.employee_id');
      $this->db->join('work_contracts wc','ss.work_id=wc.work_id','left');
      $this->db->where("e.delete_status",0);
      $this->db->where("ss.delete_status",0);

    }elseif($join_tables=='employee'){

      $this->db->join('salary_slips ss','ats.reference_id=ss.salary_id','left');
      $this->db->join('employees e','ss.employee_id=e.employee_id','left');
      $this->db->join('work_contracts wc','ss.work_id=wc.work_id','left');
      $this->db->join('employees e2','ats.reference_id=e2.employee_id','left');
      $this->db->join('work_contracts wc2','ats.tr_work_id=wc2.work_id','left');
      $this->db->where("((ats.reference_type='salary_slip' and ss.delete_status=0 and e.delete_status=0) or (ats.reference_type='employee' and e2.delete_status=0))");

    }elseif($join_tables=='vehicle_work_slip'){

      $this->db->join('vehicle_work_slips vws','ats.reference_id=vws.work_slip_id','left');
      $this->db->join('vehicles v','vws.vehicle_id=v.id');
      $this->db->join('vehicle_consignee vc','vc.consignee_id=v.consignee','left');
      $this->db->join('work_contracts wc','vws.vehicle_work_id=wc.work_id','left');
      $this->db->where("v.delete_status",0);
      $this->db->where("vws.delete_status",0);

    }elseif($join_tables=='vehicle_renewal' || $join_tables=='vehicle_payment'){
      $this->db->join('vehicles v','ats.reference_id=v.id');
      $this->db->join('vehicle_consignee vc','vc.consignee_id=v.consignee','left');
      $this->db->where("v.delete_status",0);

    }elseif($join_tables=='user_payment_receipt'){

      $this->db->join('employees e','ah2.acc_employee_id=e.employee_id');
      $this->db->join('employee_departments ed','ed.department_id=e.department','left');
      $this->db->join('users u3','e.user_id=u3.user_id','left');
      $this->db->join('user_roles ur','ur.role_id=u3.user_role','left');
      // $this->db->where("e.delete_status",0);

    }elseif($join_tables=='user_payment_return'){

      $this->db->join('employees e2','ah1.acc_employee_id=e2.employee_id');
      $this->db->join('employee_departments ed','ed.department_id=e2.department','left');
      $this->db->join('users u4','e2.user_id=u4.user_id','left');
      $this->db->join('user_roles ur','ur.role_id=u4.user_role','left');
      // $this->db->where("e2.delete_status",0);

    }elseif($join_tables=='user_commission'){

      $this->db->join('users u3','ah2.acc_user_id=u3.user_id','left');
      $this->db->join('user_roles ur','ur.role_id=u3.user_role');
      $this->db->join('work_contracts wc','ats.tr_work_id=wc.work_id','left');
      // $this->db->where("u.`3.delete_status",0);

    }elseif($join_tables=='tool_purchase'){

      $this->db->join('tools_purchase tp','ats.reference_id=tp.purchase_id','left');
      $this->db->join('tools t','tp.tool_id=t.tool_id','left');
      $this->db->join('tools_category tc','t.category_id=tc.cat_id','left');
      $this->db->where("tp.delete_status",0);
    }elseif($join_tables=='travel_allowance'){

      $this->db->join('travel_allowance ta','ats.reference_id=ta.ta_id');
      $this->db->join('employees e','ta.employee_id=e.employee_id');
      $this->db->where("ta.delete_status",0);
      if($entry_approval!='all'){
        $this->db->where("ta.entry_approval_status",$entry_approval);
      }
    }
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("ats.delete_status",0);
    if($entry_approval!='all'){
      $this->db->where("ats.tr_entry_approval_status",$entry_approval);
    }
    if($entry_approval_2!='all'){
      $this->db->where("ats.tr_entry_approval_status_2",$entry_approval_2);
    }
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('ats.tr_branch_id', $this->session->userdata('branch_id'));
    }
    if(!empty($order_by)){
      foreach ($order_by as $key => $value) {
        $this->db->order_by($value['column'],$value['order']);
      }
    }
    else{
      $this->db->order_by("ats.tr_date",'desc');
      $this->db->order_by("ats.transaction_id",'desc');
    }
    $query = $this->db->get();
    return $query;
  }
  public function create_account_transaction($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['tr_branch_id'] = $this->session->userdata('branch_id');
    }
    $query=$this->db->insert('account_transactions', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_account_transaction($data)
  {
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('tr_branch_id',$this->session->userdata('branch_id'));
    }
    $this->db->where('transaction_id', $data['transaction_id']);
    $query=$this->db->update('account_transactions', $data);
    return $query;
  }
  //advance return
  public function create_advance_return_transaction($data){

    $query=$this->db->insert('supplier_advance_redeem', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function select_advance_return_transaction($columns="*",$data="",$group_by='',$limit='',$type='')
  {
    $this->db->select($columns)->from('supplier_advance_redeem art');
    $this->db->join('account_heads ah','art.supplier_id=ah.acc_supplier_id');
    $this->db->join('users u','art.created_by=u.user_id','left');
    if($type=='purchase_bill'){
      $this->db->join('purchase_bills p','art.reference_id=p.purchase_id','left');
      $this->db->join('suppliers s','p.supplier_id=s.supplier_id','left');
      $this->db->join('stock_locations sl','p.location_id=sl.location_id','left');
      $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
      $this->db->where("p.delete_status",0);
      // $this->db->where("wc.delete_status",0);
      $this->db->where("sl.delete_status",0);
      $this->db->where("s.delete_status",0);
      $this->db->where("art.reference_type",'purchase_bill');
    }elseif($type=='purchase_order'){
      $this->db->join('purchase_order po','art.reference_id=po.order_id','left');
      $this->db->join('suppliers s','po.supplier_id=s.supplier_id','left');
      $this->db->join('stock_locations sl','po.location_id=sl.location_id','left');
      $this->db->join('work_contracts wc','sl.work_id=wc.work_id','left');
      $this->db->where("po.delete_status",0);
      $this->db->where("wc.delete_status",0);
      $this->db->where("sl.delete_status",0);
      $this->db->where("s.delete_status",0);
      $this->db->where("art.reference_type",'purchase_order');
    }
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("art.delete_status",0);
    $this->db->where("ah.delete_status",0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('ah.acc_head_branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("art.created_date",'desc');
    $this->db->order_by("art.tr_id",'desc');
    $query = $this->db->get();
    return $query;
  }

  public function update_advance_return_transaction($data)
  {
    $this->db->where('tr_id', $data['tr_id']);
    $query=$this->db->update('supplier_advance_redeem', $data);
    return $query;
  }

  public function create_security_deposit($data){

    $query = $this->db->insert('security_deposits', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_security_deposit($data)
  {
    $this->db->where('deposit_id', $data['deposit_id']);
    $query=$this->db->update('security_deposits', $data);
    return $query;
  }
  public function select_security_deposit($columns='*',$data='',$order_by='')
  {
    $this->db->select($columns)->from('security_deposits sd');
    $this->db->join('account_transactions ats','ats.transaction_id=sd.receipt_transaction_id','left');
    $this->db->join('users u','sd.created_by=u.user_id','left');
    $this->db->join('work_contracts wc','sd.project_id=wc.work_id');
    $this->db->join('clients c','wc.client_id=c.client_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("sd.delete_status",0);
    $this->db->where("wc.delete_status",0);
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("wc.branch_id",$this->session->userdata('branch_id'));
    }
    if($order_by!=''){
      $order_by = explode(',', $order_by);
      $this->db->order_by($order_by[0],$order_by[1]);
    }else{
      $this->db->order_by("sd.deposit_date",'desc');
    }
    $query = $this->db->get();
    return $query;
  }

  public function create_security_deposit_emd($data){
    $query = $this->db->insert('security_deposit_emd', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_security_deposit_emd($data)
  {
    $this->db->where('emd_id', $data['emd_id']);
    $query=$this->db->update('security_deposit_emd', $data);
    return $query;
  }
  public function select_security_deposit_emd($columns='*',$data='',$order_by='')
  {
    $this->db->select($columns)->from('security_deposit_emd sd');
    $this->db->join('users u','sd.created_by=u.user_id','left');
    $this->db->join('work_contracts wc','sd.project_id=wc.work_id');
    $this->db->join('clients c','wc.client_id=c.client_id');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("sd.delete_status",0);
    $this->db->where("wc.delete_status",0);
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("wc.branch_id",$this->session->userdata('branch_id'));
    }
    if($order_by!=''){
      $order_by = explode(',', $order_by);
      $this->db->order_by($order_by[0],$order_by[1]);
    }else{
      $this->db->order_by("sd.emd_date",'desc');
    }
    $query = $this->db->get();
    return $query;
  }

  public function create_asset($data){
    if($this->session->userdata('branch_id')!=0){
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('assets', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_asset($data)
  {
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("branch_id",$this->session->userdata('branch_id'));
    }
    $this->db->where('asset_id', $data['asset_id']);
    $query=$this->db->update('assets', $data);
    return $query;
  }
  public function select_assets($columns='*',$data='',$order_by='')
  {
    $this->db->select($columns)->from('assets as');
    $this->db->join('users u','as.created_by=u.user_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where("as.delete_status",0);
    if($this->session->userdata('branch_id')!=0){
      $this->db->where("as.branch_id",$this->session->userdata('branch_id'));
    }
    $query = $this->db->get();
    return $query;
  }


  ##Send Email
  public function send_email($data)
  {
    $settings = $this->db->select('*')->from('settings')->get()->result();
    foreach ($settings as $key => $value) {
      ${$value->settings_name} = $value->value;
    }

    $software_name = $company_name;

    $subject = $data['subject'];
    $to=$data['to'];
    $message = $data['message'];

    $this->load->library('My_PHPMailer');
    $mail = new PHPMailer();
    $mail->IsSMTP(); // we are going to use SMTP
    $mail->SMTPAuth   = true; // enabled SMTP authentication
    $mail->SMTPSecure = "ssl";  // prefix for secure protocol to connect to the server
    $mail->Host       = $smtp_host;      // setting GMail as our SMTP server
    $mail->Port       = $smtp_port;                   // SMTP port to connect to GMail
    $mail->Username   = $smtp_username;  // user email address
    $mail->Password   = $smtp_password;            // password in GMail
    $mail->SetFrom($smtp_username, $company_name);  //Who is sending the email
    $mail->Subject    = $subject;
    $mail->Body      = $message;
    $mail->AltBody    = "Plain text message";
    $destino = $to; // Who is addressed the email to
    $mail->AddAddress($destino);
    $mail=$mail->Send();  //Sending Mail
    return $mail;
  }
}
?>
