<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Push_notification {

  function __construct()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    

    $CI =& get_instance();
    $CI->load->model('User_model', 'User');
    $CI->load->model('Work_model', 'Work');
    $CI->load->model('Client_model', 'Client');
    $CI->load->model('Supplier_model', 'Supplier');
    $CI->load->model('Purchase_bill_model', 'Purchases');
    $CI->load->model('Purchase_order_model', 'Purchase_order');
    $CI->load->model('Material_model', 'Material');
    $CI->load->model('Stock_model', 'Stock');
  }

  public function send_notification($user_id,$message,$message_title,$reference_id){
    $CI =& get_instance();
    $user_data = $CI->User->select_user("",array("user_id"=>$user_id))->row();
    $notification_data['user_id'] = $user_id;
    $notification_data['reference_id'] = $reference_id;
    $notification_data['message'] = $message;
    $notification_data['created_date'] = date("Y-m-d H:i:s");

    $firebase_data['token'] = $user_data->firebase_token;
    $firebase_data['title'] = $message_title;
    $firebase_data['message'] = $message;
    //                          Send Push Notification
    $firebase_result = $CI->User->push_firebase($firebase_data);
    if(!empty($firebase_data) && isset($firebase_result->success)){
      $notification_data['firebase_sent_status'] = $firebase_result->success;
      $notification_data['firebase_multicast_id'] = $firebase_result->multicast_id;
      if ($notification_data['firebase_sent_status'] == 1) {
        $notification_data['firebase_message_id'] = $firebase_result->success;
      }
      //                          Insert in to Notification Table
      $notification_result = $CI->User->add_notifications($notification_data);
      if($notification_data['firebase_sent_status']==1){
        // echo "Sent Successfully for User #".$user_id."<br/>";
      }
    }

  }
}
?>
