<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Projects_management {

  function __construct()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");


    $CI =& get_instance();
    $CI->CI =& get_instance();
    $CI->CI->load->library('session');
    $CI->load->model('User_model','User');
    $CI->load->model('Work_model', 'Work');
    $CI->load->model('Client_model', 'Client');
    $CI->load->model('Supplier_model', 'Supplier');
    $CI->load->model('Purchase_bill_model', 'Purchases');
    $CI->load->model('Subcontracts_model', 'Subcontracts');
    $CI->load->model('Purchase_order_model', 'Purchase_order');
    $CI->load->model('Labour_model', 'Labour');
    $CI->load->model('Labour_wages_model', 'Labour_wages');
    $CI->load->model('Account_model', 'Account');
    $CI->load->model('Bills_model', 'Bills');
    $CI->load->model('Loan_model', 'Loan');
    $CI->load->model('Settings_model', 'Settings');
    $CI->load->model('Stock_model', 'Stock');
    $CI->load->model('Employees_model', 'Employee');
    $CI->load->model('Salary_slips_model', 'Salary_slips');
    $CI->load->model('Project_tasks_model', 'Project_tasks');
    $CI->load->model('Invoices_model', 'Invoices');
    $CI->load->model('Material_model', 'Material');
    $CI->load->model('Vehicle_model', 'Vehicle');
    $CI->load->model('Customers_model', 'Customers');
    $CI->load->model('Vehicle_work_slips_model', 'Vehicle_work_slips');
    $CI->load->model('Project_tasks_model', 'Project_tasks');
    $CI->load->model('Work_order_model','Work_order');
    $CI->load->model('Sales_quotation_model','Sales_quotation');
    $CI->load->model('Enquiries_model','Enquiries');

  }


  public function update_project_progress($project_id,$user_id=''){
    $CI =& get_instance();
    $project_data = $CI->Work->select_work("w.work_id,project_progress,w.actual_end_date",array("w.work_id"=>$project_id));
    if($project_data->num_rows()==1){
      $project_data = $project_data->row();
      $total_tasks = $CI->Project_tasks->select_tasks("pt.task_id",array("pt.work_id"=>$project_data->work_id))->num_rows();
      $total_progress = $CI->Project_tasks->select_tasks("COALESCE(SUM(pt.progress),0) as total",array("pt.work_id"=>$project_data->work_id))->row()->total;
      if($total_tasks>0){
        $project['project_progress'] = round($total_progress/$total_tasks,2);
      }else{
        $project['project_progress'] = 0;
      }
      $project['work_id'] = $project_data->work_id;
      $result = $CI->Work->update_work($project);
      if($result==1){
        // Add to Progress Update Log
        $progress_log_data['reference_id'] = $project_data->work_id;
        $progress_log_data['reference_type'] = "project";
        $progress_log_data['old_value'] = $project_data->project_progress;
        $progress_log_data['new_value'] = $project['project_progress'];
        $progress_log_data['variation'] = $project['project_progress']-$project_data->project_progress;
        $progress_log_data['created_date'] = date('Y-m-d H:i:s');
        if($user_id!=''){
          $progress_log_data['created_by'] = $user_id;
        }else{
          $progress_log_data['created_by'] = $CI->session->userdata('user_id');
        }

        $CI->Work->insert_progress_log($progress_log_data);

        return true;
      }

    }
  }


  public function get_project_stage_id($project_id){
    $CI =& get_instance();
    $data['ps.project_id'] = $project_id;
    $data['ps.stage_active_status'] = 1;
    $project_stage = $CI->Work->select_project_stage("*",$data);
    if($project_stage->num_rows()==1){
      return $project_stage->row()->stage_id;
    }else{
      return 0;
    }

  }
  public function get_project_stages($project_id){
    $CI =& get_instance();
    $data['ps.project_id'] = $project_id;
    $data['ps.stage_active_status'] = 1;
    $project_stage = $CI->Work->select_project_stage("*",$data)->row();
    return $project_stage;
  }

  public function calculate_project_stage_income($project_id){
    $CI =& get_instance();
    return 0;
  }

  public function calculate_project_stage_expense($project_id,$start_date='',$end_date=''){
    $CI =& get_instance();
    return 10;
  }

  public function get_project_summary($project_id,$start_date='',$end_date='',$project_page_type=''){
    $CI =& get_instance();

    $json_data=$json_data2=array();
    $j=$sl_no=0;
    $data=$sub_project_ids=array();
    $id = $project_id;
    $work_data = $CI->Work->select_work("*", array("work_id" => $id))->row();
    if($project_page_type=='master_summary'){
      $sub_projects = $CI->Work->select_work("*",array("parent_project_id"=>$id))->result();
      foreach ($sub_projects as $key => $value) {
        $sub_project_ids[] = $value->work_id;
      }
    }
    $sub_project_ids_1 = implode("','",$sub_project_ids);

    if($project_page_type=='master_summary'){
      $json_data['project_budget'] = 0;
      foreach ($sub_projects as $key => $value) {
        $json_data['project_budget'] += $value->total_budget_amount;
      }
    }else{
      $json_data['project_budget'] = $work_data->total_budget_amount;
    }

    $stock_consumption_where = $stock_balance_where = $stock_transfer_out_where = $stock_transfer_in_where = $labour_wage_where_data = $vehicle_work_slip_where = $custom_requirement_where = $subcontract_where = $purchase_return_where = $purchase_order_where = $subcontract_bill_where = $expense_bill_where = $salary_slip_where = $invoice_where = $tool_payment_where = $user_commission_where = $salary_payment_where = $purchase_order_payment_where = $client_payment_where = $expense_bill_payment_where = $purchase_payment_where = $purchase_bill_where= $subcontract_payment_where = $vehicle_payment_where = array();
    if($CI->config->item('user_data_access_view_all')!=1){
      $purchase_return_where['pr.created_by'] =  $purchase_order_where['po.created_by'] = $subcontract_bill_where['b.created_by'] = $salary_slip_where['ss.created_by'] = $expense_bill_where['b.created_by'] = $invoice_where['i.created_by'] = $vehicle_work_slip_where['vws.created_by'] = $supplier_advance_purchase_order_where['art.created_by'] = $supplier_advance_purchase_bill_where['art.created_by'] = $tool_payment_where['ats.created_by'] = $user_commission_where['ats.created_by'] = $vehicle_payment_where['ats.created_by'] = $salary_payment_where['ats.created_by'] = $purchase_order_payment_where['ats.created_by'] = $client_payment_where['ats.created_by'] = $expense_bill_payment_where['ats.created_by'] = $purchase_payment_where['ats.created_by'] = $purchase_bill_where['p.created_by'] = $subcontract_payment_where['ats.created_by'] = $CI->session->userdata('user_id');
    }
    if($start_date!=''){
      $client_payment_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $salary_payment_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $tool_payment_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $user_commission_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $vehicle_payment_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $vehicle_work_slip_where["vws.worked_date >="]= date('Y-m-d', strtotime($start_date));
      $purchase_payment_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $purchase_order_payment_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $stock_transfer_in_where["st.transfer_date >="]= date('Y-m-d', strtotime($start_date));
      $purchase_bill_where["p.purchase_date >="]= date('Y-m-d', strtotime($start_date));
      $purchase_return_where["pr.return_date >="]= date('Y-m-d', strtotime($start_date));
      $purchase_order_where["po.order_date >="]= date('Y-m-d', strtotime($start_date));
      $expense_bill_payment_where["b.bill_date >="]= date('Y-m-d', strtotime($start_date));
      $supplier_advance_purchase_bill_where["art.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $supplier_advance_purchase_order_where["art.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $subcontract_payment_where["ats.tr_date >="]= date('Y-m-d', strtotime($start_date));
      $labour_wage_where_data["lw.work_date >="]= date('Y-m-d', strtotime($start_date));
      $stock_transfer_out_where["st.transfer_date >="]= date('Y-m-d', strtotime($start_date));
      $stock_consumption_where["sc.consumption_date >="]= date('Y-m-d', strtotime($start_date));
      $invoice_where["i.invoice_date >="]= date('Y-m-d', strtotime($start_date));
      $expense_bill_where["b.bill_date >="]= date('Y-m-d', strtotime($start_date));
      $subcontract_bill_where["b.bill_date >="]= date('Y-m-d', strtotime($start_date));
      $salary_slip_where["STR_TO_DATE(ss.month,'%Y-%m-%d') >="] = $start_date;

    }
    if($end_date!=''){
      $client_payment_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $salary_payment_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $tool_payment_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $user_commission_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $vehicle_payment_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $vehicle_work_slip_where["vws.worked_date <="]= date('Y-m-d', strtotime($end_date));
      $purchase_payment_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $purchase_order_payment_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $stock_transfer_in_where["st.transfer_date <="]= date('Y-m-d', strtotime($end_date));
      $purchase_bill_where["p.purchase_date <="]= date('Y-m-d', strtotime($end_date));
      $purchase_return_where["pr.return_date <="]= date('Y-m-d', strtotime($end_date));
      $purchase_order_where["po.order_date <="]= date('Y-m-d', strtotime($end_date));
      $expense_bill_payment_where["b.bill_date <="]= date('Y-m-d', strtotime($end_date));
      $supplier_advance_purchase_bill_where["art.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $supplier_advance_purchase_order_where["art.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $subcontract_payment_where["ats.tr_date <="]= date('Y-m-d', strtotime($end_date));
      $labour_wage_where_data["lw.work_date <="]= date('Y-m-d', strtotime($end_date));
      $stock_transfer_out_where["st.transfer_date <="]= date('Y-m-d', strtotime($end_date));
      $stock_consumption_where["sc.consumption_date <="]= date('Y-m-d', strtotime($end_date));
      $invoice_where["i.invoice_date <="]= date('Y-m-d', strtotime($end_date));
      $expense_bill_where["b.bill_date <="]= date('Y-m-d', strtotime($end_date));
      $subcontract_bill_where["b.bill_date <="]= date('Y-m-d', strtotime($end_date));
      $salary_slip_where["STR_TO_DATE(ss.month,'%Y-%m-%d') <="] = $end_date;
    }

    if($project_page_type!='master_summary'){
      $custom_requirement_where['pcr.project_id'] = $id;
    }else{
      $CI->db->where_in('pcr.project_id',$sub_project_ids);
    }
    $json_data['total_custom_requirement_amount'] = round($CI->Work->select_custom_requirement("COALESCE(SUM(pcr.amount),0) as total",$custom_requirement_where)->row()->total,$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_project_budget'] = $json_data['project_budget']+$json_data['total_custom_requirement_amount'];

    if($project_page_type!='master_summary'){
      $invoice_where['i.project_id'] = $id;
    }else{
      $CI->db->where_in('i.project_id',$sub_project_ids);
    }
    $invoice_data = $CI->Invoices->select_invoices("COALESCE(SUM(i.invoice_tax_amount),0) as invoice_total_tax,COALESCE(SUM(i.invoice_total_amount),0) as invoice_total,COALESCE(SUM(i.total_paid),0) as invoice_total_paid,COALESCE(SUM(i.balance_amount),0) as invoice_balance",$invoice_where)->row();
    $json_data['total_client_invoice_receivable'] = round($invoice_data->invoice_total,$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_client_invoice_received'] = round($invoice_data->invoice_total_paid,$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_client_invoice_balance'] = round($invoice_data->invoice_balance,$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_client_invoice_tax_amount'] = round($invoice_data->invoice_total_tax,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $CI->db->where("((wc.work_id=$id and ats.reference_type='project' and ats.invoice_id=0) or (ci.project_id=$id and ats.reference_type='project' and ats.invoice_id!=0))");
    }else{
      $CI->db->where("((wc.work_id IN ('$sub_project_ids_1') and ats.reference_type='project' and ats.invoice_id=0) or (ci.project_id IN ('$sub_project_ids_1') and ats.reference_type='project' and ats.invoice_id!=0))");
    }
    $client_payment_where['ats.tr_type'] = 'client_payment_transaction';
    $client_payment_where['ats.reference_type'] = 'project';
    if($CI->session->userdata('user_role')=='general_manager' && $CI->config->item('User_general_manager_client_payment_view_all')==0) {
      $client_payment_where['ats.created_by'] = $CI->session->userdata('user_id');
    }
    $json_data['total_client_payments_received'] = round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$client_payment_where,'client_payment')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type!='master_summary'){
      $CI->db->where("((wc.work_id=$id and ats.reference_type='project' and ats.invoice_id=0) or (ci.project_id=$id and ats.reference_type='project' and ats.invoice_id!=0))");
    }else{
      $CI->db->where("((wc.work_id IN ('$sub_project_ids_1') and ats.reference_type='project' and ats.invoice_id=0) or (ci.project_id IN ('$sub_project_ids_1') and ats.reference_type='project' and ats.invoice_id!=0))");
    }
    $json_data['total_client_payment_tax_amount'] = round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tax_amount),0) as total_amount", $client_payment_where, 'client_payment')->row()->total_amount, $CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $expense_bill_where['b.work_id'] = $id;
    }else{
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $expense_bill_where['b.bill_type'] = 'expense';
    $json_data['total_expense_bill_amount'] = round($CI->Bills->select_bills("COALESCE(SUM(bill_payable_amount),0) as total_amount", $expense_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $json_data['total_expense_bill_tax_amount'] = round($CI->Bills->select_bills("COALESCE(SUM(bill_tax_amount),0) as total_amount", $expense_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    $expense_bill_where['b.bill_credit_ac'] = 25;
    if($project_page_type=='master_summary'){
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $json_data['total_project_management_fees'] = round($CI->Bills->select_bills("COALESCE(SUM(bill_payable_amount),0) as total_amount", $expense_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    $expense_bill_where['b.bill_credit_ac'] = 26;
    if($project_page_type=='master_summary'){
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $json_data['total_project_supervision_charge'] = round($CI->Bills->select_bills("COALESCE(SUM(bill_payable_amount),0) as total_amount", $expense_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $expense_bill_payment_where['b.work_id'] = $id;
    }else{
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $expense_bill_payment_where['ats.tr_type'] = 'expense_bill_transaction';
    $expense_bill_payment_where['ats.reference_type'] = 'expense_bill';
    $json_data['total_other_expense'] = round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$expense_bill_payment_where,'expense_bill')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $salary_slip_where['ss.work_id'] = $id;
    }else{
      $CI->db->where_in('ss.work_id',$sub_project_ids);
    }
    $salary_slip_where['ss.slip_type'] = 'Project';
    $json_data['total_salary_slip_amount'] = round($CI->Salary_slips->select_salary_slips("COALESCE(SUM(ss.net_salary_amount),0) as total", $salary_slip_where)->row()->total,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $CI->db->where("((ats.tr_type='salary_slip_transaction' and ss.work_id='".$id."') or (ats.tr_type='salary_advance_transaction' and ats.tr_work_id='".$id."'))");
    }else{
      $CI->db->where("((ats.tr_type='salary_slip_transaction' and ss.work_id IN ('$sub_project_ids_1')) or (ats.tr_type='salary_advance_transaction' and ats.tr_work_id IN ('$sub_project_ids_1')))");
    }
    $CI->db->where("(ats.tr_type='salary_slip_transaction' or ats.tr_type='salary_advance_transaction')");
    $CI->db->where("(ats.reference_type='salary_slip' or ats.reference_type='employee')");
    $json_data['total_salary_payments']	= round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$salary_payment_where,'employee')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $CI->db->where("((ats.reference_type='tool_rent' and tr.rented_to='".$id."') or (ats.reference_type='tool_transfer' and tt.transfer_to='".$id."'))");
    }else{
      $CI->db->where("((ats.reference_type='tool_rent' and tr.rented_to IN ('$sub_project_ids_1')) or (ats.reference_type='tool_transfer' and tt.transfer_to IN ('$sub_project_ids_1')))");
    }
    $tool_payment_where['ats.tr_type'] = 'tool_payment_transaction';
    $CI->db->where("(ats.reference_type='tool_rent' or ats.reference_type='tool_transfer')");
    $json_data['total_tool_payments']	= round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$tool_payment_where,'tool')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $user_commission_where['ats.tr_work_id'] = $id;
    }else{
      $CI->db->where_in('ats.tr_work_id',$sub_project_ids);
    }
    $user_commission_where['ats.tr_type'] = 'user_commission_transaction';
    $user_commission_where['ats.reference_type'] = 'user_account_head';
    $json_data['total_user_commission_payments']	= round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$user_commission_where,'user_commission')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $vehicle_payment_where['wc.work_id'] = $id;
    }else{
      $CI->db->where_in('wc.work_id',$sub_project_ids);
    }
    $vehicle_payment_where['ats.reference_type'] = 'vehicle_work_slip';
    $vehicle_payment_where['ats.tr_type'] = 'vehicle_work_slip_transaction';
    $json_data['total_vehicle_payments']	= round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount", $vehicle_payment_where,'vehicle_work_slip')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $vehicle_work_slip_where['vws.vehicle_work_id'] = $id;
    }else{
      $CI->db->where_in('vws.vehicle_work_id',$sub_project_ids);
    }
    $json_data['total_vehicle_work_slip_amount']	= round($CI->Vehicle_work_slips->select_vehicle_work_slips("COALESCE(SUM(vws.total_payable_amount),0) as total_amount", $vehicle_work_slip_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $purchase_payment_where['sl.work_id'] = $id;
    }else{
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $purchase_payment_where['ats.tr_type'] = 'purchase_bill_transaction';
    $purchase_payment_where['ats.reference_type'] = 'purchase_bill';
    $json_data['total_purchase_bill_payment'] = round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$purchase_payment_where,'purchase_bill')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $supplier_advance_purchase_bill_where['sl.work_id'] = $id;
    }else{
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $supplier_advance_purchase_bill_where['art.tr_type'] = 'purchase_bill_transaction';
    $supplier_advance_purchase_bill_where['art.reference_type'] = 'purchase_bill';
    $json_data['total_supplier_advance_purchase_bill'] = round($CI->Account->select_advance_return_transaction("COALESCE(SUM(art.tr_amount),0) as total_amount",$supplier_advance_purchase_bill_where,'','','purchase_bill')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_purchase_bill_payment'] += $json_data['total_supplier_advance_purchase_bill'];

    if($project_page_type!='master_summary'){
      $purchase_order_payment_where['sl.work_id'] = $id;
    }else{
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $purchase_order_payment_where['ats.tr_type'] = 'purchase_order_transaction';
    $purchase_order_payment_where['ats.reference_type'] = 'purchase_order';
    // $purchase_order_payment_where['po.purchase_bill_id'] = 0;
    $json_data['total_purchase_order_payment'] = round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$purchase_order_payment_where,'purchase_order')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $supplier_advance_purchase_order_where['sl.work_id'] = $id;
    }else{
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $supplier_advance_purchase_order_where['art.tr_type'] = 'purchase_order_transaction';
    $supplier_advance_purchase_order_where['art.reference_type'] = 'purchase_order';
    $json_data['total_supplier_advance_purchase_order'] = round($CI->Account->select_advance_return_transaction("COALESCE(SUM(art.tr_amount),0) as total_amount",$supplier_advance_purchase_order_where,'','','purchase_order')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_purchase_order_payment'] += $json_data['total_supplier_advance_purchase_order'];

    $json_data['total_purchase_payment'] = $json_data['total_purchase_order_payment']+$json_data['total_purchase_bill_payment'];

    if($project_page_type!='master_summary'){
      $purchase_bill_where['sl.work_id'] = $id;
      $purchase_return_where['sl.work_id'] = $id;
    }
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_bill_amount'] = round($CI->Purchases->select_purchase("COALESCE(SUM(p.bill_payable_amount),0) as grand_total",$purchase_bill_where)->row()->grand_total,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_bill_balance_amount'] = round($CI->Purchases->select_purchase("COALESCE(SUM(p.balance_amount),0) as total_purchase_balance",$purchase_bill_where)->row()->total_purchase_balance,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_bill_commission'] = round($CI->Purchases->select_purchase("COALESCE(SUM(p.bill_commission_amount),0) as total_amount",$purchase_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_bill_tax_amount'] = round($CI->Purchases->select_purchase("COALESCE(SUM(p.bill_tax_amount),0) as grand_total", $purchase_bill_where)->row()->grand_total, $CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_retrun_amount'] = round($CI->Purchases->select_purchase_return("COALESCE(SUM(pr.returned_qty*pr.unit_price),0) as grand_total", $purchase_return_where)->row()->grand_total, $CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_bill_discount_amount'] = round($CI->Purchases->select_purchase("COALESCE(SUM(p.bill_round_amount+p.bill_discount_amount),0) as grand_total", $purchase_bill_where)->row()->grand_total, $CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $purchase_order_where['sl.work_id'] = $id;
    }
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_order_amount'] = round($CI->Purchase_order->select_purchase_order("COALESCE(SUM(po.total_est_amount),0) as grand_total",$purchase_order_where)->row()->grand_total,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_purchase_order_tax_amount'] = round($CI->Purchase_order->select_purchase_order("COALESCE(SUM(po.tax_amount),0) as grand_total", $purchase_order_where)->row()->grand_total, $CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $subcontract_where['sc.work_id'] = $id;
    }else{
      $CI->db->where_in('sc.work_id',$sub_project_ids);
    }
    $json_data['total_subcontract_amount'] = round($CI->Subcontracts->select_subcontract_2("COALESCE(SUM(sc.payable_amount),0) as total",$subcontract_where)->row()->total,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $subcontract_bill_where['b.work_id'] = $id;
    }
    $subcontract_bill_where['b.bill_type'] = 'subcontract';
    if($project_page_type=='master_summary'){
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $json_data['total_subcontract_bill_amount'] = round($CI->Bills->select_bills("COALESCE(SUM(bill_payable_amount),0) as total_amount", $subcontract_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $json_data['total_subcontract_bill_balance_amount'] = round($CI->Bills->select_bills("COALESCE(SUM(bill_balance_amount),0) as total_amount", $subcontract_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));
    if($project_page_type=='master_summary'){
      $CI->db->where_in('b.work_id',$sub_project_ids);
    }
    $json_data['total_subcontract_bill_tax_amount'] = round($CI->Bills->select_bills("COALESCE(SUM(bill_tax_amount),0) as total_amount", $subcontract_bill_where)->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $CI->db->where("((ats.reference_type='subcontract_bill' and b.work_id=$id) or (ats.reference_type='subcontract' and sc2.work_id=$id))");
    }else{
      $CI->db->where("((ats.reference_type='subcontract_bill' and b.work_id IN ('$sub_project_ids_1')) or (ats.reference_type='subcontract' and sc2.work_id IN ('$sub_project_ids_1')))");
    }
    $json_data['total_subcontract_payment'] = round($CI->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$subcontract_payment_where,'subcontract_transactions')->row()->total_amount,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $labour_wage_where_data['lw.work_id'] = $id;
    }else{
      $CI->db->where_in('lw.work_id',$sub_project_ids);
    }
    $json_data['total_labour_wages'] = round($CI->Labour_wages->select_labour_wages("COALESCE(SUM(lw.total_wage),0) as total",$labour_wage_where_data)->row()->total,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $stock_transfer_in_where['sl2.work_id'] = $id;
    }else{
      $CI->db->where_in('sl2.work_id',$sub_project_ids);
    }
    $json_data['total_stock_transfer_in_amount'] = round($CI->Stock->select_stock_transfers("COALESCE(SUM(st.transferred_qty*sr1.unit_price),0) as total", $stock_transfer_in_where)->row()->total,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $stock_transfer_out_where['sl1.work_id'] = $id;
    }else{
      $CI->db->where_in('sl1.work_id',$sub_project_ids);
    }
    $json_data['total_stock_transfer_out_amount'] = round($CI->Stock->select_stock_transfers("COALESCE(SUM(st.transferred_qty*sr1.unit_price),0) as total", $stock_transfer_out_where)->row()->total,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $stock_consumption_where['sl.work_id'] = $id;
    }else{
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_stock_consumption_amount'] = round($CI->Stock->select_stock_consumption("COALESCE(SUM(sc.consumption_qty*sr.unit_price),0) as total", $stock_consumption_where)->row()->total,$CI->config->item('Currency_amount_decimals_2'));

    if($project_page_type!='master_summary'){
      $stock_balance_where['sl.work_id'] = $id;
    }else{
      $CI->db->where_in('sl.work_id',$sub_project_ids);
    }
    $json_data['total_stock_balance_amount'] = round($CI->Stock->select_stock_register("COALESCE(SUM(sr.total_balance_qty*sr.unit_price),0) as total", $stock_balance_where)->row()->total,$CI->config->item('Currency_amount_decimals_2'));

    $json_data['total_opening_expense_amount'] = $work_data->op_expense_amount;
    $json_data['total_opening_income_amount'] = $work_data->op_income_amount;
    $project_commission_percent = $work_data->project_management_commission;
    $work_type = $work_data->work_type;
    $json_data['total_expense_amount'] = $json_data['total_opening_expense_amount'] + $json_data['total_tool_payments'] + $json_data['total_user_commission_payments'] + $json_data['total_other_expense']  + $json_data['total_purchase_payment'] +  $json_data['total_subcontract_payment'] + $json_data['total_labour_wages'] + $json_data['total_salary_payments'] + $json_data['total_vehicle_payments'];
    $json_data['total_project_cost'] = $json_data['total_opening_expense_amount'] + $json_data['total_tool_payments'] + $json_data['total_user_commission_payments'] + $json_data['total_expense_bill_amount']  + $json_data['total_purchase_bill_amount'] +  $json_data['total_subcontract_payment'] + $json_data['total_labour_wages'] + $json_data['total_salary_slip_amount'] + $json_data['total_vehicle_work_slip_amount'] + $json_data['total_stock_transfer_in_amount'] - $json_data['total_stock_transfer_out_amount'] - $json_data['total_purchase_retrun_amount'];
    // $json_data['total_project_cost'] = $json_data['total_tool_payments'] + $json_data['total_user_commission_payments'] + $json_data['total_other_expense']  + $json_data['total_purchase_bill_amount'] +  $json_data['total_subcontract_payment'] + $json_data['total_labour_wages'] + $json_data['total_salary_payments'] + $json_data['total_vehicle_payments'];
    $json_data['total_committed_amount'] = $json_data['total_project_cost']+$json_data['total_purchase_order_amount']+$json_data['total_subcontract_amount']-$json_data['total_purchase_bill_amount']-$json_data['total_subcontract_payment'];
    $json_data['total_project_commission_amount'] = round((($json_data['total_project_budget'] * $project_commission_percent)/100),$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_pm_commission_exclude_tax'] = round((($work_data->est_budget_amt * $project_commission_percent)/100),$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_pm_commission_include_tax'] = round((($work_data->total_budget_amount * $project_commission_percent)/100),$CI->config->item('Currency_amount_decimals_2'));

    $json_data['total_client_payments_received'] += $json_data['total_opening_income_amount'];
    $json_data['total_profit_margin_amt'] = round((($work_data->est_budget_amt * $work_data->profit_margin_percent)/100),$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_credit_bill_amount'] = round(($json_data['total_purchase_bill_balance_amount'] + ($json_data['total_expense_bill_amount']-$json_data['total_other_expense']) + ($json_data['total_salary_slip_amount']-$json_data['total_salary_payments']) + ($json_data['total_vehicle_work_slip_amount']-$json_data['total_vehicle_payments']) + $json_data['total_subcontract_bill_balance_amount']),$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_amount_to_receive'] = $json_data['total_project_budget'];
    $json_data['balance_to_receive'] = round($json_data['total_project_budget'] - $json_data['total_client_payments_received'],$CI->config->item('Currency_amount_decimals_2'));
    $json_data['total_profit'] = round($json_data['total_client_payments_received'] - $json_data['total_project_cost'],$CI->config->item('Currency_amount_decimals_2'));
    if($work_type==1) {
      $json_data['gross_profit'] = round($json_data['total_client_payments_received'] - ($json_data['total_project_cost'] ),$CI->config->item('Currency_amount_decimals_2'));
    }else{
      $json_data['gross_profit'] = round($json_data['total_client_payments_received'] - ($json_data['total_project_cost']),$CI->config->item('Currency_amount_decimals_2'));
    }

    // foreach ($json_data as $key => $value) {
    //   $json_data[$key] = $CI->config->item('Currency_currency_format')." ".number_format($value,$CI->config->item('Currency_amount_decimals_2'));
    // }
    $json_data['total_profit_margin_percent'] = $work_data->profit_margin_percent;
    if($project_page_type=='master_summary'){
      $CI->db->where_in('lw.work_id',$sub_project_ids);
    }
    $json_data['total_labours_worked'] = $CI->Labour_wages->select_labour_wages("COALESCE(SUM(lw.no_of_labours),0) as total",$labour_wage_where_data)->row()->total;
    $json_data['total_labours_worked_distinct'] = $CI->Labour_wages->select_labour_wages("distinct(lw.labour_id)",$labour_wage_where_data)->num_rows();
    if($project_page_type=='master_summary'){
      $CI->db->where_in('lw.work_id',$sub_project_ids);
    }
    $json_data['total_labour_days'] = $CI->Labour_wages->select_labour_wages("distinct(lw.work_date)",$labour_wage_where_data)->num_rows();

    return $json_data;  // send data as json format
  }
  public function create_project($creation_type,$reference_id,$reference_type){
    $CI =& get_instance();
    $return_message = '';
    if(($creation_type=='project_creation_on_order_create' || $creation_type=='project_creation_on_order_approval') && $reference_id!='' && $reference_type=='work_order'){
      $work_order_data = $CI->Work_order->select_work_orders("wo.*,u.user_alias,b.*,sq.quotation_no,u2.user_alias as site_coordinator_name",array("order_id"=>$reference_id))->row();
      if($work_order_data->branch_id==0){
        $default_branch_data = $CI->config->item('default_branch_data');
        $work_order_data->branch_name = $default_branch_data['branch_name'];
        $work_order_data->quotation_prefix = $default_branch_data['quotation_prefix'];
        $work_order_data->workorder_prefix = $default_branch_data['workorder_prefix'];
      }

      $count2 = $CI->Work->select_work("work_id", array("w.work_order_id"=>$reference_id));
      if($count2->num_rows()==0){
        // Create Client
        if($work_order_data->customer_id!=0){
          $customer_data = $CI->Customers->select_customer("*", array("customer_id" => $work_order_data->customer_id))->row();
          $client_data['client_name'] = $customer_data->customer_name;
          $client_data['client_contact'] = $customer_data->customer_phone;
          $client_data['contact_person'] = $customer_data->contact_person;
          $client_data['client_address'] = $customer_data->customer_location;
          $client_data['client_email'] = $customer_data->customer_email;
        }else{
          $client_data['client_name'] = $work_order_data->customer_name;
          $client_data['client_contact'] = $work_order_data->customer_phone;
          $client_data['client_address'] = $work_order_data->customer_address;
          $client_data['client_email'] = $work_order_data->customer_email;
        }
        $client_data['created_date'] = date('Y-m-d H:i:s');
        $client_data['created_by'] = $CI->session->userdata('user_id');
        // Check Client exist with email/phone
        $client_contact = $client_data['client_contact'];
        $client_email = $client_data['client_email'];
        if($work_order_data->customer_id!=0){
          $client_data['customer_id'] = $work_order_data->customer_id;
          $CI->db->where("(customer_id='".$work_order_data->customer_id."')");
        }else{
          $CI->db->where("(client_contact='".$client_contact."')");
        }
        $count = $CI->Client->select_client('client_id');
        if($count->num_rows()==0){
          $client_result = $CI->Client->insert_client($client_data);
          $client_id = $client_result['insert_id'];
        }else{
          $client_id = $count->result()[0]->client_id;
        }

        if($work_order_data->quotation_id!=0){
          $quotation_data = $CI->Sales_quotation->select_quotations("sq.*,u1.user_alias as prepared_by_name,u1.phone_no as prepared_by_phone,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,b.*", array("quotation_id"=>$work_order_data->quotation_id))->row();
          if($CI->config->item('Quotation_sales_quotation_no_manual')==1){
            $project_data['reference_no_2'] = $quotation_data->quotation_no_suffix;
          }else{
            $project_data['reference_no_2'] = $quotation_data->quotation_prefix.$quotation_data->quotation_no.$quotation_data->quotation_no_suffix;
          }
        }else{
          $project_data['reference_no_2'] = $CI->config->item('workorder_prefix')."".$work_order_data->order_no;
        }

        $project_data['project_priority'] = 2;
        $project_data['work_location'] = $client_data['client_address'];
        if($work_order_data->enquiry_id!=0){
          $enquiry_data = $CI->Enquiries->select_enquiries("e.*", array("enquiry_id"=>$work_order_data->enquiry_id));
          if($enquiry_data->num_rows()==1){
            $project_data['enquiry_id'] = $enquiry_data->row()->enquiry_id;
            $project_data['project_priority'] = $enquiry_data->row()->enquiry_priority;
            $project_data['reference_no'] = $enquiry_data->row()->enquiry_reference_no;
            if($enquiry_data->row()->work_place!=''){
              $project_data['work_location'] = $enquiry_data->row()->work_place;
            }
          }
        }

        // Create Project
        $project_data['client_id'] = $client_id;
        $project_data['branch_id'] = $CI->session->userdata('branch_id');
        $project_data['work_order_id'] = $reference_id;
        $project_data['work_description'] = 'Work Order: #'.$work_order_data->workorder_prefix.'-'.$work_order_data->order_no;
        if($work_order_data->project_name!=''){
          $project_data['work_name'] = $work_order_data->project_name;
        }else{
          $project_data['work_name'] = $client_data['client_name'];
        }
        if($work_order_data->project_start_date!='0000-00-00'){
          $project_data['planned_date_of_start'] = $work_order_data->project_start_date;
        }
        $project_data['project_section'] = 'Commercial';
        $project_data['work_type'] = 1;
        $project_data['est_budget_amt'] = $work_order_data->total_order_amount;
        $project_data['lpo_no'] = $work_order_data->customer_order_ref_no;
        $project_data['lpo_date'] = $work_order_data->customer_order_ref_date;
        $project_data['total_budget_amount'] = $work_order_data->total_order_amount;
        $project_data['work_description'] = strip_tags($work_order_data->order_description);
        $project_data['created_date'] = date('Y-m-d H:i:s');
        $project_data['created_by'] = $CI->session->userdata('user_id');
        $project_data['work_status'] = 2; //In Process Default
        $project_result = $CI->Work->insert_work($project_data);

        if($project_result['status'] == 1){

          if($work_order_data->enquiry_id!=0){
            $enquiry_update_data['enquiry_id'] = $work_order_data->enquiry_id;
            $enquiry_update_data['enquiry_status'] = 'Project Created';
            $enquiry_result = $CI->Enquiries->update_enquiry($enquiry_update_data);
          }

          // Create Stock Location
          $loc_data['location_type'] = 'work_site';
          $loc_data['location_name'] = $project_data['work_name'];
          $loc_data['work_id'] = $project_result['insert_id'];
          $loc_result =  $CI->Stock->insert_stock_location($loc_data);

          $return_message .= 'Project Created Successfully!.';

          // Default Stage
          $stage_data['project_id'] = $project_result['insert_id'];
          $stage_data['stage_no'] = 1;
          $stage_data['stage_active_status'] = 1;
          $stage_data['stage_name'] = 'First Stage';
          $stage_data['stage_budget'] = $project_data['total_budget_amount'];
          // $stage_data['stage_description'] = 'First Stage ';
          $stage_data['created_date'] = date('Y-m-d H:i:s');
          $stage_data['created_by'] = $CI->session->userdata('user_id');
          $result_stage = $CI->Work->insert_project_stage($stage_data);

          $stage_log_data['stage_id'] = $result_stage['insert_id'];
          $stage_log_data['project_id'] = $project_result['insert_id'];
          $stage_log_data['active_on'] = date('Y-m-d h:i:s');
          $result_stage_log = $CI->Work->insert_project_stage_log($stage_log_data);

          if($work_order_data->site_coordinator!='' && $work_order_data->site_coordinator!=0){
            $assign_data['user_id'] = $work_order_data->site_coordinator;
            $assign_data['work_id'] = $project_result['insert_id'];
            $assign_data['created_date'] = date('Y-m-d H:i:s');
            $assign_data['created_by'] = $CI->session->userdata('user_id');
            $assign_result = $CI->Work->create_work_assign_log($assign_data);
            if($assign_result == 1){
              // Update assigned Supervisor in work
              $CI->update_work_user_assigned($project_result['insert_id']);
            }
          }
        }else{
          $return_message .= 'Project Creation Error!.';
        }
      }

    }elseif($creation_type=='project_creation_on_quotation_approval' && $reference_id!='' && $reference_type=='sales_quotation'){

      $count = $CI->Work->select_work("work_id", array("w.quotation_id"=>$reference_id));
      if($count->num_rows()==0){
        // Create Client
        $quotation_data = $CI->Sales_quotation->select_quotations("sq.*,u1.user_alias as prepared_by_name,u1.phone_no as prepared_by_phone,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,b.*", array("quotation_id"=>$reference_id))->row();

        // Create Client
        if($quotation_data->customer_id!=0){
          $customer_data = $CI->Customers->select_customer("*", array("customer_id" => $quotation_data->customer_id))->row();
          $client_data['client_name'] = $customer_data->customer_name;
          $client_data['client_contact'] = $customer_data->customer_phone;
          $client_data['contact_person'] = $customer_data->contact_person;
          $client_data['client_address'] = $customer_data->customer_location;
          $client_data['client_email'] = $customer_data->customer_email;
        }else{
          $client_data['client_name'] = $quotation_data->customer_name;
          $client_data['client_contact'] = $quotation_data->customer_phone;
          $client_data['client_address'] = $quotation_data->customer_address;
          $client_data['client_email'] = $quotation_data->customer_email;
        }
        $client_data['created_date'] = date('Y-m-d H:i:s');
        $client_data['created_by'] = $CI->session->userdata('user_id');
        // Check Client exist with email/phone
        $client_contact = $client_data['client_contact'];
        $client_email = $client_data['client_email'];
        if($quotation_data->customer_id!=0){
          $client_data['customer_id'] = $quotation_data->customer_id;
          $CI->db->where("(customer_id='".$quotation_data->customer_id."')");
        }else{
          $CI->db->where("(client_contact='".$client_contact."')");
        }
        $count = $CI->Client->select_client('client_id');
        if($count->num_rows()==0){
          $client_result = $CI->Client->insert_client($client_data);
          $client_id = $client_result['insert_id'];
        }else{
          $client_id = $count->result()[0]->client_id;
        }

        // Create Project
        $project_data['work_location'] = $client_data['client_address'];
        $project_data['project_priority'] = 2;
        if($quotation_data->enquiry_id!=0){
          $enquiry_data = $CI->Enquiries->select_enquiries("e.*", array("enquiry_id"=>$quotation_data->enquiry_id));
          if($enquiry_data->num_rows()==1){
            $project_data['enquiry_id'] = $enquiry_data->row()->enquiry_id;
            $project_data['project_priority'] = $enquiry_data->row()->enquiry_priority;
            $project_data['reference_no'] = $enquiry_data->row()->enquiry_reference_no;
            if($enquiry_data->row()->work_place!=''){
              $project_data['work_location'] = $enquiry_data->row()->work_place;
            }
          }
        }
        $project_data['client_id'] = $client_id;
        $project_data['quotation_id'] = $quotation_data->quotation_id;
        if($quotation_data->project_name!=''){
          $project_data['work_name'] = $quotation_data->project_name;
        }else{
          $project_data['work_name'] = $quotation_data->quotation_subject;
        }
        $project_data['project_section'] = 'Commercial';
        $project_data['work_type'] = 1;
        if($CI->config->item('Quotation_sales_quotation_no_manual')==1){
          $project_data['reference_no_2'] = $quotation_data->quotation_no_suffix;
        }else{
          if($quotation_data->quotation_no_prefix!=''){
            $quotation_data->quotation_prefix = $quotation_data->quotation_no_prefix;
          }
          $quotation_data->quotation_no = sprintf("%04d", $quotation_data->quotation_no);
          $project_data['reference_no_2'] = $quotation_data->quotation_prefix.$quotation_data->quotation_no.$quotation_data->quotation_no_suffix;
        }
        $project_data['est_budget_amt'] = $quotation_data->quotation_total_amount;
        $project_data['total_budget_amount'] = $quotation_data->quotation_total_amount;
        $project_data['work_description'] = strip_tags($quotation_data->quotation_description);
        $project_data['created_date'] = date('Y-m-d H:i:s');
        $project_data['created_by'] = $CI->session->userdata('user_id');
        $project_data['work_status'] = 2; //In Process Default
        $project_result = $CI->Work->insert_work($project_data);
        $flash_data['flashdata_msg'] = '';
        if($project_result['status'] == 1){

          if($quotation_data->enquiry_id!=0){
            $enquiry_update_data['enquiry_id'] = $quotation_data->enquiry_id;
            $enquiry_update_data['enquiry_status'] = 'Project Created';
            $enquiry_result = $CI->Enquiries->update_enquiry($enquiry_update_data);
          }
          // Create Stock Location
          $loc_data['location_type'] = 'work_site';
          $loc_data['location_name'] = $project_data['work_name'];
          $loc_data['work_id'] = $project_result['insert_id'];
          $loc_result =  $CI->Stock->insert_stock_location($loc_data);

          $flash_data['flashdata_msg'] .= '<br/>Project Created Successfully!.';

          // Default Stage
          $stage_data['project_id'] = $project_result['insert_id'];
          $stage_data['stage_no'] = 1;
          $stage_data['stage_active_status'] = 1;
          $stage_data['stage_name'] = 'First Stage';
          $stage_data['stage_budget'] = $project_data['total_budget_amount'];
          // $stage_data['stage_description'] = 'First Stage ';
          $stage_data['created_date'] = date('Y-m-d H:i:s');
          $stage_data['created_by'] = $CI->session->userdata('user_id');
          $result_stage = $CI->Work->insert_project_stage($stage_data);

          $stage_log_data['stage_id'] = $result_stage['insert_id'];
          $stage_log_data['project_id'] = $project_result['insert_id'];
          $stage_log_data['active_on'] = date('Y-m-d h:i:s');
          $result_stage_log = $CI->Work->insert_project_stage_log($stage_log_data);
        }else{
          $flash_data['flashdata_msg'] .= '<br/>Project Creation Error!.';
        }
      }
    }

  }
}
?>
