<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* Check whether the site is offline or not.
*
*/
class Maintenance_hook
{
  public function __construct(){
    log_message('debug','Accessing maintenance hook!');
  }

  public function offline_check(){
    if(file_exists(APPPATH.'config/config.php')){
      include(APPPATH.'config/config.php');

      $this->CI =& get_instance();
      $this->CI->load->model('Settings_model', 'Settings');
      if($this->CI->Settings->check_maintenance_mode()==true && $this->CI->session->userdata('user_login_type')!='developer'){
        $maintenance_time=$this->CI->Settings->select_settings("",array("settings_name"=>"maintenance_time"))->row()->value;
        $time = explode(":",$maintenance_time);
        $maintenance_minutes = ($time[0]*60)+$time[1]+($time[2]/60);
        $current_time = new DateTime(date('Y-m-d H:i:s'));
        $current_time->add(new DateInterval('PT' . $maintenance_minutes . 'M'));
        $end_time = $current_time->format('d F Y H:i:s');
        include(APPPATH.'views/maintenance_mode.php');
        exit;
      }
    }
  }
}
