<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Vehicles extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Employees_model', 'Employee');
    $this->load->model('Vehicle_model', 'Vehicle');
    $this->load->model('Vehicle_work_slips_model', 'Vehicle_work_slips');
    $this->load->library('Projects_management','projects_management');
  }
  public function index_get()
  {
    //     Default Method
    $this->select_assigned_get();
  }
  public function select_work_slips_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $data['vws.driver_id'] = $employee_data->row()->employee_id;
        $work_slip_data	= $this->Vehicle_work_slips->select_vehicle_work_slips("vws.work_slip_id,v.vehicle_name,v.vehicle_no,wc.work_name,DATE_FORMAT(vws.worked_date,'%d-%m-%Y') as worked_date,vws.job_status",$data,"","","","","",'all');
        if ($work_slip_data->num_rows() > 0) {
          $message = array();
          $j = 0;

          $json_data['status'] = TRUE;
          $json_data['data'] = $work_slip_data->result();
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'No Jobs Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_work_slip_details_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_slip_id')!="" && $this->get('work_slip_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $data['vws.driver_id'] = $employee_data->row()->employee_id;
        $data['vws.work_slip_id'] = $this->get('work_slip_id');
        $work_slip_data	= $this->Vehicle_work_slips->select_vehicle_work_slips("vws.work_slip_id,v.vehicle_name,v.vehicle_no,vws.work_slip_type,vws.location,wc.work_name,DATE_FORMAT(vws.worked_date,'%d-%m-%Y') as worked_date,vws.job_status,vws.start_time,vws.end_time,vws.start_km,vws.end_km,vws.worked_duration,vws.duration_type",$data,"","","","","",'all');
        if ($work_slip_data->num_rows() == 1 ) {
          $work_slip_data = $work_slip_data->row();
          $message = array();
          $j = 0;
          if($work_slip_data->job_status==0){
            $work_slip_data->end_time = '';
            $work_slip_data->end_km = '';
          }
          // Get Work Slip images
          // Get Work Slip expenses
          $expense_where_data['vwse.work_slip_id'] = $work_slip_data->work_slip_id;
          $work_slip_expenses	= $this->Vehicle_work_slips->select_vehicle_work_slip_expense("vwse.*,s.supplier_name,sl.location_name",$expense_where_data,"","","","","",'all')->result();

          // Get Work slip Bill Images

          $json_data['status'] = TRUE;
          $json_data['data'] = $work_slip_data;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'Job Details Not Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work Slip ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_work_slip_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('vehicle_id')!="" && $this->post('vehicle_id') !== NULL) {

      $user_id = $this->post('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $data2['worked_date'] = $work_slip_where['vws.worked_date'] = date('Y-m-d');
        $work_slip_where['job_status'] = 0;
        // Check Already Ongoing Job Exist Today
        $work_slip_data	= $this->Vehicle_work_slips->select_vehicle_work_slips("vws.work_slip_id,v.vehicle_name,v.vehicle_no,wc.work_name,DATE_FORMAT(vws.worked_date,'%d-%m-%Y') as worked_date,vws.job_status",$work_slip_where,"","","","","",'all');
        if($work_slip_data->num_rows()==0){
          $data2['vehicle_id'] = $this->post('vehicle_id');
          $data2['work_slip_type'] = $this->post('work_slip_type');
          if($data2['work_slip_type']=='inside_work'){
            $data2['vehicle_work_id'] = $this->post('work_id');
            $data2['project_stage_id'] = $this->projects_management->get_project_stage_id($data2['vehicle_work_id']);
          }
          if($this->post('location')){
            $data2['location'] = $this->post('location');
          }
          $data2['driver_id'] = $employee_data->row()->employee_id;
          if($this->post('start_time') && $this->post('start_time')!=''){
            $data2['start_time'] = date('H:i:s',strtotime($this->post('start_time')));
          }else{
            $data2['start_time'] = date('H:i:s');
          }
          $data2['start_km'] = $this->post('start_km');
          $data2['job_status'] = 0;
          $data2['created_date'] = date('Y-m-d H:i:s');
          $data2['created_by'] = $this->post('user_id');
          $result = $this->Vehicle_work_slips->create_vehicle_work_slip($data2);
          if($result['status'] == 1) {
            $message = [
              'status' => TRUE,
              'message' => 'Work Slip Created Successfully'
            ];
            $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
          }else {
            $message = [
              'status' => FALSE,
              'message' => 'There Has Been Some Error Occurred'
            ];
            $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
          }
        }else{
          $message = [
            'status' => FALSE,
            'message' => 'You Have Already Pending Job to Finish'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Vehicle ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_work_slip_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_slip_id')!="" && $this->post('work_slip_id') !== NULL) {

      $user_id = $this->post('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $data2['work_slip_id'] = $this->post('work_slip_id');
        if($this->post('end_time') && $this->post('end_time')!=''){
          $data2['end_time'] = date('H:i:s',strtotime($this->post('end_time')));
        }else{
          $data2['end_time'] = date('H:i:s');
        }
        $data2['end_km'] = $this->post('end_km');
        $data2['job_status'] = 1; //completed
        // Calculate Worked Duration
        // $date1 = new DateTime();
        // $date2 = new DateTime();
        // $date1->setTimestamp($startTimestamp);
        // $date2->setTimestamp($endTimestamp);
        // $interval = date_diff($date1, $date2);
        // //or $interval = $date1->diff($date2)
        // echo $interval->format('%h hours and %m minutes');

        $result = $this->Vehicle_work_slips->update_vehicle_work_slip($data2);
        if($result == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Work Slip Updated Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work Slip ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_file_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_slip_id')!="" && $this->post('work_slip_id') !== NULL) {

      $data['file_type'] = $this->post('file_type');
      $data['work_slip_id'] = $this->post('work_slip_id');
      if($this->post('title')){
        $data['file_title'] = $this->post('title');
      }
      if($this->post('description')){
        $data['remarks'] = $this->post('description');
      }
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      $work_slip_files	= $this->Vehicle_work_slips->select_vehicle_work_slip_files("vwsf.*",array("vwsf.work_slip_id"=>$data['work_slip_id'],"vwsf.file_type"=>$data['file_type']));
      if(($data['file_type']=='selfie' && $work_slip_files->num_rows()<2) || $data['file_type']=='bill'){
        if($this->post('image') && $this->post('image')!=''){
          $data['file'] = date('dmY-His') . '.png';
          $Image1_Data = $this->post('image');
          $Image1_Path = "uploads/vehicle_work_slip/".$data['file'];
          file_put_contents($Image1_Path,base64_decode($Image1_Data));
        }
        $result =  $this->Vehicle_work_slips->create_vehicle_work_slip_files($data);
        if($result['status'] == 1) {
          if($this->post('address')){
            $actvity_data['user_id'] = $this->post('user_id');
            $actvity_data['activity_type'] = 'Vehicle Work Slip';
            $actvity_data['activity_through'] = 'Mobile App';
            $actvity_data['activity_date'] = $data['created_date'];
            $actvity_data['activity_description'] = 'Vehicle Work Slip Image';
            $actvity_data['activity_location_address'] = $this->post('address');
            // $actvity_data['activity_location_landmark'] = $this->post('landmark');
            $actvity_data['activity_location_latitude'] = $this->post('latitude');
            $actvity_data['activity_location_longitude'] = $this->post('longitude');
            $actvity_data['reference_id'] = $result['insert_id'];
            $result2 = $this->User->insert_activity($actvity_data);

            $update_data['activity_id'] = $result2['insert_id'];
            $update_data['file_id'] = $result['insert_id'];
            $this->Vehicle_work_slips->update_vehicle_work_slip_files($update_data);
          }

          $message = [
            'status' => TRUE,
            'message' => 'File Added Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'Maximum 2 Images are Allowed'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work Slip ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_file_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('file_id')!="" && $this->post('file_id') !== NULL) {

      $data['file_id'] = $this->post('file_id');
      if($this->post('title')){
        $data['file_title'] = $this->post('title');
      }
      if($this->post('description')){
        $data['remarks'] = $this->post('description');
      }
      $result =  $this->Vehicle_work_slips->update_vehicle_work_slip_files($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'File Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, File ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_file_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('file_id')!="" && $this->post('file_id') !== NULL) {

      $data['file_id'] = $this->post('file_id');
      $data['delete_status'] = 1;
      $result =  $this->Vehicle_work_slips->update_vehicle_work_slip_files($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'File Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, File ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_files_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_slip_id')!="" && $this->get('work_slip_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        if($this->get('file_type') && $this->get('file_type')!=''){
          $data['file_type'] = $this->get('file_type');
        }else{
          $data['file_type'] = 'selfie';
        }
        $data['vwsf.work_slip_id'] = $this->get('work_slip_id');
        $limit='';
        if($data['file_type']=='selfie'){
          $limit=2;
        }
        $work_slip_files	= $this->Vehicle_work_slips->select_vehicle_work_slip_files("vwsf.*",$data,"","","","",$limit,'all');
        if ($work_slip_files->num_rows() > 0) {
          $message = array();
          $j = 0;
          $work_slip_files = $work_slip_files->result();
          foreach ($work_slip_files as $key => $value) {
            $value->file_path = base_url().'uploads/vehicle_work_slip/'.$value->file;
          }

          $json_data['status'] = TRUE;
          $json_data['data'] = $work_slip_files;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'No Files Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work Slip ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_assigned_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $message = array();
        $j = 0;


        $assigned_vehicles = explode(',',$employee_data->row()->assigned_vehicles);
        foreach ($assigned_vehicles as $key => $value) {
          $vehicle_data = $this->Vehicle->select_vehicle('',array("v.id"=>$value));
          if($vehicle_data->num_rows()==1){
            $vehicle_data = $vehicle_data->row();
            $message[$j]['vehicle_id'] = $vehicle_data->id;
            $message[$j]['vehicle_no'] = $vehicle_data->vehicle_no;
            $message[$j]['vehicle_name'] = $vehicle_data->vehicle_name;
            $message[$j]['vehicle_type'] = $vehicle_data->vehicle_type;
            $message[$j]['vehicle_category'] = $vehicle_data->vehicle_category;
            $message[$j]['model'] = $vehicle_data->model;
            $j++;
          }
        }
        if(!empty($message)){
          $json_data['status'] = TRUE;
          $json_data['data'] = $message;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        }else{
          $message = [
            'status' => FALSE,
            'message' => 'No Assigned Vehicles Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_details_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('vehicle_id')!="" && $this->get('vehicle_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $vehicle_data = $this->Vehicle->select_vehicle('v.vehicle_name,v.vehicle_no,v.id',array("v.id"=>$this->get('vehicle_id')));
      if($vehicle_data->num_rows()==1){
        // Check Assigned for Employee
        $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
        if ($employee_data->num_rows() == 1) {
          $assigned_vehicles = explode(',',$employee_data->row()->assigned_vehicles);
          if (in_array($this->get('vehicle_id'), $assigned_vehicles)){
            $json_data['status'] = TRUE;
            $json_data['data'] = $vehicle_data->row();
            $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
          }else{
            $message = [
              'status' => FALSE,
              'message' => 'Selected Vehicle Not Assigned To You'
            ];
            $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
          }
        }
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'Vehicle Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function create_expense_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_slip_id')!="" && $this->post('work_slip_id') !== NULL) {

      $expense_data['work_slip_id'] = $this->post('work_slip_id');
      $expense_data['expense_head'] = 'Fuel';
      $expense_data['expense_type'] = $this->post('fuel_type');
      $expense_data['supplier_id'] = $this->post('supplier');
      $expense_data['supplier_type'] = 'supplier';
      $expense_data['total_qty'] = $this->post('qty');
      $expense_data['total_amount'] = $this->post('amount');
      $expense_data['remarks'] = $this->post('reading');
      $expense_data['include_work_slip_payable'] = 1;
      if($this->post('attachment1') && $this->post('attachment1')!=''){
        $expense_data['attachment1'] = date('dmY-His') . '.png';
        $Image1_Data = $this->post('attachment1');
        $Image1_Path = "uploads/vehicle_work_slip/".$expense_data['attachment1'];
        file_put_contents($Image1_Path,base64_decode($Image1_Data));
      }
      if($this->post('attachment2') && $this->post('attachment2')!=''){
        $expense_data['attachment2'] = date('dmY-His') . '.png';
        $Image1_Data = $this->post('attachment2');
        $Image1_Path = "uploads/vehicle_work_slip/".$expense_data['attachment2'];
        file_put_contents($Image1_Path,base64_decode($Image1_Data));
      }
      $result = $this->Vehicle_work_slips->create_vehicle_work_slip_expense($expense_data);
      if($result['status']==1){
        $message = [
          'status' => TRUE,
          'message' => 'Expense Added Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }

    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work Slip ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_expense_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('expense_id')!="" && $this->post('expense_id') !== NULL) {

      $expense_data['expense_id'] = $this->post('expense_id');
      $expense_data['expense_type'] = $this->post('fuel_type');
      $expense_data['supplier_id'] = $this->post('supplier');
      $expense_data['total_qty'] = $this->post('qty');
      $expense_data['total_amount'] = $this->post('amount');
      $expense_data['remarks'] = $this->post('reading');
      $result = $this->Vehicle_work_slips->update_vehicle_work_slip_expense($expense_data);
      if($result==1){
        $message = [
          'status' => TRUE,
          'message' => 'Expense Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }

    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Expense ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_expense_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('expense_id')!="" && $this->post('expense_id') !== NULL) {

      $expense_data['expense_id'] = $this->post('expense_id');
      $expense_data['delete_status'] = 1;
      $result = $this->Vehicle_work_slips->update_vehicle_work_slip_expense($expense_data);
      if($result==1){
        $message = [
          'status' => TRUE,
          'message' => 'Expense Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }

    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Expense ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_expense_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_slip_id')!="" && $this->get('work_slip_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $expense_where_data['vwse.work_slip_id'] = $this->get('work_slip_id');
        $work_slip_expenses	= $this->Vehicle_work_slips->select_vehicle_work_slip_expense("vwse.*,s.supplier_name,sl.location_name",$expense_where_data,"","","","","",'all');
        if ($work_slip_expenses->num_rows() > 0) {
          $message = array();
          $j = 0;
          $work_slip_expenses = $work_slip_expenses->result();
          foreach ($work_slip_expenses as $key => $value) {
            $value->attachment1_path = $value->attachment2_path = "";
            if($value->attachment1!=''){
              $value->attachment1_path = base_url()."uploads/vehicle_work_slip/".$value->attachment1;
            }
            if($value->attachment2!=''){
              $value->attachment2_path = base_url()."uploads/vehicle_work_slip/".$value->attachment2;
            }
          }

          $json_data['status'] = TRUE;
          $json_data['data'] = $work_slip_expenses;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'No Entries Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Vehicle ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function create_documents_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('vehicle_id')!="" && $this->post('vehicle_id') !== NULL) {

      $data['vehicle_id'] = $this->post('vehicle_id');
      $data['document_type'] = $this->post('document_type');
      $data['file_type'] = 'file';
      $data['file_remarks'] = $this->post('description');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      if($this->post('image') && $this->post('image')!=''){
        $data['file'] = date('dmY-His') . '.png';
        $Image1_Data = $this->post('image');
        $Image1_Path = "uploads/vehicles/".$data['file'];
        file_put_contents($Image1_Path,base64_decode($Image1_Data));
      }
      $result =  $this->Vehicle->create_vehicle_document($data);
      if($result['status'] == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'File Added Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Vehicle ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_documents_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('document_id')!="" && $this->post('document_id') !== NULL) {

      $data['document_id'] = $this->post('document_id');
      $data['document_type'] = $this->post('document_type');
      $data['file_remarks'] = $this->post('description');
      $result =  $this->Vehicle->update_vehicle_document($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'File Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Document ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_documents_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('document_id')!="" && $this->post('document_id') !== NULL) {

      $data['document_id'] = $this->post('document_id');
      $data['delete_status'] = 1;
      $result =  $this->Vehicle->update_vehicle_document($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'File Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Document ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_documents_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('vehicle_id')!="" && $this->get('vehicle_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $data['vd.vehicle_id'] = $this->get('vehicle_id');
        $documents	= $this->Vehicle->select_vehicle_documents("vd.document_id,vd.document_type,vd.file,vd.file_type,vd.file_remarks,vd.created_by,u.user_alias as created_by_user",$data);
        if ($documents->num_rows() > 0) {
          $message = array();
          $j = 0;
          $documents = $documents->result();
          foreach ($documents as $key => $value) {
            $value->file_path = $value->file;
            $value->file_editable = 0;
            if($value->created_by==$user_id){
              $value->file_editable = 1;
            }
            if($value->file_type=='file'){
              $value->file_path = base_url().'uploads/vehicles/'.$value->file;
            }
          }

          $json_data['status'] = TRUE;
          $json_data['data'] = $documents;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'No Documents Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Vehicle ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_driver_report_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {
      $reports = array();
      $reports[0]['title'] = 'Total Worked Hours';
      $reports[0]['value'] = 0;

      $reports[1]['title'] = 'Total Worked KMs';
      $reports[1]['value'] = 0;
      //
      // $reports[2]['title'] = 'Total Worked KMs';
      // $reports[2]['value'] = 0;
      //
      // $reports[3]['title'] = 'Total Worked KMs';
      // $reports[3]['value'] = 0;

      $json_data['status'] = TRUE;
      $json_data['data'] = $reports;
      $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Vehicle ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

}
