<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Tools extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Tools_model', 'Tools');
    $this->load->library('Projects_management','projects_management');

  }
  public function index_get()
  {
    //     Default Method
    $this->select_get();
  }
  public function select_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $type='all';
      if($this->get('type') && $this->get('type')!="" && $this->get('type') !== NULL){
        $type=$this->get('type');
      }
      $tools	= $this->Tools->select_tools("",$data,array("t.name",'asc'));
      if ($tools->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($tools->result() as $row):

          $total_transferred_in = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$row->tool_id,"tt.transfer_to"=>$this->get('work_id')))->row()->total;
          $total_transferred_out = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$row->tool_id,"tt.transfer_from"=>$this->get('work_id')))->row()->total;
          $total_remains_transfer = $total_transferred_in-$total_transferred_out;

          $total_rented_qty = $this->Tools->select_tool_rent("COALESCE(SUM(tr.rented_qty),0) as total",array("tr.tool_id"=>$row->tool_id,"tr.rented_to"=>$this->get('work_id')))->row()->total;
          $total_returned_qty = $this->Tools->select_tool_rent("COALESCE(SUM(tr.total_returned_qty),0) as total",array("tr.tool_id"=>$row->tool_id))->row()->total;
          $total_remains_rent = $total_rented_qty - $total_returned_qty;

          $message[$j]['tool_id'] = $row->tool_id;
          $message[$j]['name'] = $row->name;
          $message[$j]['category_name'] = $row->cat_name;
          $message[$j]['category_id'] = $row->category_id;
          $message[$j]['description'] = $row->description;
          if($type=='all'){
            $message[$j]['owned_qty'] = $row->total_owned_qty;
            $message[$j]['total_transferred_in'] = $total_transferred_in;
            $message[$j]['total_transferred_out'] = $total_transferred_out;
            $message[$j]['total_rented_in'] = $total_rented_qty;
            $message[$j]['total_rented_returned'] = $total_returned_qty;
            $message[$j]['total_qty_present'] = $total_remains_transfer+$total_remains_rent;
          }
          if($type=='own'){
            $message[$j]['owned_qty'] = $row->total_owned_qty;
            $message[$j]['total_transferred_in'] = $total_transferred_in;
            $message[$j]['total_transferred_out'] = $total_transferred_out;
            $message[$j]['total_qty_present'] = $total_remains_transfer;
          }
          if($type=='rent'){
            $message[$j]['total_rented_in'] = $total_rented_qty;
            $message[$j]['total_rented_returned'] = $total_returned_qty;
            $message[$j]['total_qty_present'] = $total_remains_rent;
          }
          if($row->created_by == $this->get('user_id')){
            $message[$j]['editable'] = 1;
          }else{
            $message[$j]['editable'] = 0;
          }

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Tools Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_details_get()
  {
    if($this->get('tool_id')!="" && $this->get('tool_id') !== NULL &&$this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=$available_locations=$transfer_in_log=$transfer_out_log=$rent_log=$transfer_to_locations=array();
      $i=$j=$k=0;
      //          Select Assigned Tasks Only
      $data['tool_id'] = $this->get('tool_id');
      $user_id = $this->get('user_id');
      $tools	= $this->Tools->select_tools("",$data);
      $work_data = $this->Work->select_work("wc.wcat_name,w.work_id,w.work_type,w.work_status,w.work_name,client_name,client_contact,work_location,total_budget_amount,u.user_alias as created_user,w.created_date,u3.user_alias as updated_user,w.updated_date",array("w.work_id"=>$this->get('work_id')));
      $other_locations = $this->Work->select_work("w.work_id,w.work_name",array("w.work_id !="=>$this->get('work_id')))->result();

      $transfer_to_locations[$k]['id'] = 0;
      $transfer_to_locations[$k]['name'] = $this->config->item('Tools_transfer_default_location_name');
      $k++;
      foreach ($other_locations as $key => $value) {
        $transfer_to_locations[$k]['id'] = $value->work_id;
        $transfer_to_locations[$k]['name'] = $value->work_name;
        $k++;
      }
      if ($tools->num_rows() ==1 && $work_data->num_rows()==1) {
        $message = array();
        $row = $tools->row();

        $transfer_in_log = $this->Tools->select_tool_transfers("tt.entry_approval_status,tt.transfer_from,wc1.work_name,tt.transferred_qty,tt.transfer_date,tt.remarks",array("tt.tool_id"=>$row->tool_id,"tt.transfer_to"=>$this->get('work_id')),'','','','','','',$this->config->item('select_data_entry_approval'))->result();
        $transfer_out_log = $this->Tools->select_tool_transfers("tt.entry_approval_status,tt.transfer_to,wc2.work_name,tt.transferred_qty,tt.transfer_date,tt.remarks",array("tt.tool_id"=>$row->tool_id,"tt.transfer_from"=>$this->get('work_id')),'','','','','','',$this->config->item('select_data_entry_approval'))->result();
        $rent_log = $this->Tools->select_tool_rent("tr.entry_approval_status,tr.rent_price,tr.return_status,tr.id,tr.rented_from,tr.rented_qty,tr.rented_date,tr.total_returned_qty,tr.balance_to_return,tr.returned_log",array("t.tool_id"=>$row->tool_id,"tr.rented_to"=>$this->get('work_id')),'','','','','','',$this->config->item('select_data_entry_approval'))->result();
        foreach ($transfer_in_log as $key => $value) {
          if($value->transfer_from==0){
            $value->location = $this->config->item('Tools_transfer_default_location_name');
          }else{
            $value->location = $value->work_name;
          }
          $value->transfer_date = date('d-m-Y',strtotime($value->transfer_date));
          unset($value->transfer_from);
          unset($value->work_name);
        }

        foreach ($transfer_out_log as $key => $value) {
          if($value->transfer_to==0){
            $value->location = $this->config->item('Tools_transfer_default_location_name');
          }else{
            $value->location = $value->work_name;
          }
          $value->transfer_date = date('d-m-Y',strtotime($value->transfer_date));
          unset($value->transfer_to);
          unset($value->work_name);
        }

        foreach ($rent_log as $key => $value) {
          if($value->return_status==1){
            $value->status = 'Returned';
          }elseif($value->return_status==2){
            $value->status = 'Partially Returned';
          }else{
            $value->status = 'Not Returned';
          }
          $value->rented_date = date('d-m-Y',strtotime($value->rented_date));
          if($value->returned_log!=''){
            $value->returned_log = unserialize($value->returned_log);
            if(sizeof($value->returned_log)>0){
              foreach ($value->returned_log as $key2 => $value2) {
                $value->returned_log[$key2]['returned_date'] = date('d-m-Y',strtotime($value2['returned_date']));
              }
            }else{
              $value->returned_log = array();
            }
          }else{
            $value->returned_log = array();
          }
        }

        $total_transferred_in = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$row->tool_id,"tt.transfer_to"=>$this->get('work_id')))->row()->total;
        $total_transferred_out = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$row->tool_id,"tt.transfer_from"=>$this->get('work_id')))->row()->total;
        $total_remains_transfer = $total_transferred_in-$total_transferred_out;

        $total_rented_qty = $this->Tools->select_tool_rent("COALESCE(SUM(tr.rented_qty),0) as total",array("tr.tool_id"=>$row->tool_id,"tr.rented_to"=>$this->get('work_id')))->row()->total;
        $total_returned_qty = $this->Tools->select_tool_rent("COALESCE(SUM(tr.total_returned_qty),0) as total",array("tr.tool_id"=>$row->tool_id))->row()->total;
        $total_remains_rent = $total_rented_qty - $total_returned_qty;

        //      Select Available Locations
        $data1['tt.tool_id'] = $data3['tr.tool_id'] = $data2['t.tool_id'] = $row->tool_id;
        $data1['tt.transfer_to !='] = 0;
        // Select All Transfer where Transfer to != Office
        $transfer_data = $this->Tools->select_tool_transfers("tt.transfer_to,wc2.work_name",$data1,"","","","","","distinct");
        $total_in_office = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$data1['tt.tool_id'],"tt.transfer_to"=>0))->row()->total;
        $total_in_office+=$row->total_owned_qty;
        // Get Total Transferred Out
        $total_out_office = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$data1['tt.tool_id'],"tt.transfer_from"=>0))->row()->total;

        if($total_in_office>$total_out_office){
          $available_locations[$i]['id'] = 0;
          $available_locations[$i]['name'] = $this->config->item('Tools_transfer_default_location_name');
          $available_locations[$i]['available_qty'] = $total_in_office-$total_out_office;
          $i++;
        }

        foreach ($transfer_data->result() as $row2):
          $location_name = $row2->work_name;
          $location_id = $row2->transfer_to;
          if($location_id!=$this->get('work_id')){
            $total_in = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$data1['tt.tool_id'],"tt.transfer_to"=>$location_id))->row()->total;
            // Get Total Transferred Out
            $total_out = $this->Tools->select_tool_transfers("COALESCE(SUM(tt.transferred_qty),0) as total",array("tt.tool_id"=>$data1['tt.tool_id'],"tt.transfer_from"=>$location_id))->row()->total;

            if($total_in>$total_out){
              $available_locations[$i]['id'] = $location_id;
              $available_locations[$i]['name'] = $location_name;
              $available_locations[$i]['available_qty'] = $total_in-$total_out;
              $i++;
            }
          }
        endforeach;

        $message['tool_id'] = $row->tool_id;
        $message['name'] = $row->name;
        $message['price'] = $row->price;
        $message['category_name'] = $row->cat_name;
        $message['category_id'] = $row->category_id;
        $message['description'] = $row->description;
        $message['owned_qty'] = $row->total_owned_qty;
        $message['total_transferred_in'] = $total_transferred_in;
        $message['total_transferred_out'] = $total_transferred_out;
        $message['total_rented_in'] = $total_rented_qty;
        $message['total_rented_returned'] = $total_returned_qty;
        $message['total_remains_transfer'] = $total_remains_transfer;
        $message['total_remains_rent'] = $total_remains_rent;
        $message['total_qty_remains'] = $total_remains_transfer+$total_remains_rent;
        if($row->created_by == $this->get('user_id')){
          $message['editable'] = 1;
        }else{
          $message['editable'] = 0;
        }
        $available_locations = array_map("unserialize", array_unique(array_map("serialize", $available_locations)));
        $message['available_locations'] = $available_locations;
        $message['transfer_in_log'] = $transfer_in_log;
        $message['transfer_out_log'] = $transfer_out_log;
        $message['rent_log'] = $rent_log;
        $message['transfer_to_locations'] = $transfer_to_locations;

        $json_data['status'] = TRUE;
        $json_data['data'] = $message;

        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'Tool Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . Tool ID,User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL) {

      $data['name'] = $this->post('name');
      $data['category_id'] = $this->post('category');
      $count = $this->Tools->select_tools("tool_id",array('name' => $data['name'],'category_id' => $data['category_id']))->num_rows();
      $data['description'] = $this->post('description');
      $data['opening_owned_qty'] = $this->post('owned_qty');
      $data['price'] = $this->post('price');
      $data['tool_type'] = 'own';
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      if($count==0) {
        $result = $this->Tools->create_tools($data);
        if($result['status'] == 1) {
          $this->Tools->calculate_total_owned_qty($result['insert_id']);
          $message = [
            'status' => TRUE,
            'message' => 'Tool Item Created Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'A Tool with Same Name Already Exist in Selected Category'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('tool_id')!="" && $this->post('tool_id') !== NULL) {

      $data['tool_id'] = $this->post('tool_id');
      $data['name'] = $this->post('name');
      $data['category_id'] = $this->post('category');
      $count = $this->Tools->select_tools("tool_id",array('tool_id !=' => $data['tool_id'],'name' => $data['name'],'category_id' => $data['category_id']))->num_rows();
      $data['description'] = $this->post('description');
      $data['opening_owned_qty'] = $this->post('owned_qty');
      $data['tool_type'] = 'own';
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');
      if($count==0) {
        $result = $this->Tools->update_tools($data);
        if($result == 1) {
          $this->Tools->calculate_total_owned_qty($data['tool_id']);
          $message = [
            'status' => TRUE,
            'message' => 'Tool Details Updated Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'A Tool with Same Name Already Exist in Selected Category'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Tool ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('tool_id')!="" && $this->post('tool_id') !== NULL) {

      $data['tool_id'] = $this->post('tool_id');
      $data['delete_status'] = 1;

      $result = $this->Tools->update_tools($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Tool Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Tool ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function transfer_create_post()
  {
    if($this->post('tool_id')!="" && $this->post('tool_id') !== NULL &&$this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {
      $user_data = $this->User->select_user("",array("user_id"=>$this->post('user_id')));

      $transfer_type = $this->post('transfer_type');
      if($transfer_type=='in'){
        $data['transfer_from'] = $this->post('transfer_from');
        $data['transfer_to'] = $this->post('work_id');
      }else{
        $data['transfer_to'] = $this->post('transfer_to');
        $data['transfer_from'] = $this->post('work_id');
      }

      if($data['transfer_from']!=0){
        $work_id = $data['transfer_from'];
      }else {
        $work_id = $data['transfer_to'];
      }

      $data['project_stage_id']=$this->projects_management->get_project_stage_id($work_id);

      $data['tool_id'] = $this->post('tool_id');
      $data['transferred_qty'] = $this->post('quantity');
      $data['transfer_date'] = date('Y-m-d',strtotime($this->post('date')));
      $data['transferred_by'] = $user_data->row()->user_alias;
      $data['remarks'] = $this->post('remarks');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $data['entry_approval_status'] = 0;
      }
      $result = $this->Tools->create_tool_transfer($data);
      if($result['status'] == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Tool Transfer Created Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }

    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID,Tool ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function rent_create_post()
  {
    if($this->post('tool_id')!="" && $this->post('tool_id') !== NULL &&$this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {
      $user_data = $this->User->select_user("",array("user_id"=>$this->post('user_id')));

      $data['tool_id'] = $this->post('tool_id');
      $data['rented_from'] = $this->post('rented_from');
      $data['rented_to'] = $this->post('work_id');
      if($this->post('price')){
        $data['rent_price'] = $this->post('price');
      }
      $data['project_stage_id'] = $this->projects_management->get_project_stage_id($data['rented_to']);

      $data['rented_qty'] = $this->post('quantity');
      $data['balance_to_return'] = $data['rented_qty'];
      $data['rented_date'] = date('Y-m-d',strtotime($this->post('date')));
      $data['remarks'] = $this->post('remarks');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $data['entry_approval_status'] = 0;
      }
      $result = $this->Tools->create_rent_tools($data);
      if($result['status'] == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Tool Rent Created Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }

    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID,Tool ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function rent_return_create_post()
  {
    if($this->post('rent_id')!="" && $this->post('rent_id') !== NULL &&$this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {
      $user_data = $this->User->select_user("",array("user_id"=>$this->post('user_id')));

      $data['id'] = $this->post('rent_id');
      $rent_log = $this->Tools->select_tool_rent("tr.return_status,tr.id,tr.rented_from,tr.rented_qty,tr.rented_date,tr.total_returned_qty,tr.balance_to_return,tr.returned_log",array("tr.id"=>$this->post('rent_id')));
      if($rent_log->num_rows()==1){
        $rent_log = $rent_log->row();

        if($rent_log->returned_log!=''){
          $returned_log = unserialize($rent_log->returned_log);
          $array_index = sizeof($returned_log);
        }else{
          $array_index = 0;
        }
        $returned_log[$array_index]['returned_qty'] = $this->post('quantity');
        $returned_log[$array_index]['returned_date'] = date('Y-m-d',strtotime($this->post('date')));
        $returned_log[$array_index]['created_date'] = date('Y-m-d H:i:s');
        $returned_log[$array_index]['created_by'] = $this->post('user_id');
        $data['returned_log'] = serialize($returned_log);
        $data['total_returned_qty'] = $rent_log->total_returned_qty + $this->post('quantity');
        $data['balance_to_return'] = $rent_log->rented_qty-$data['total_returned_qty'];
        if($data['balance_to_return']==0){
          $data['return_status'] = 1;
        }elseif($data['balance_to_return']>0 && $data['balance_to_return']<$rent_log->rented_qty){
          $data['return_status'] = 2;
        }else{
          $data['return_status'] = 0;
        }
        $result = $this->Tools->update_tool_rent($data);
        if($result == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Tool Rent Return Created Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID,Tool ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
