<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Settings extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model', 'User');
    $this->load->model('Settings_model', 'Settings');

  }
  public function index_get()
  {
    //     Default Method
    $this->select_settings_get();
  }
  //  Account Heads, Payment Modes, Expense Heads
  public function select_settings_get()
  {
    $data = array();
    $this->db->where("settings_category='Mobile App' or settings_category='Labour' or settings_category='User' or settings_category='Purchase'");
    $settings	= $this->Settings->select_settings("*",$data);
    if ($settings->num_rows() > 0) {
      $json_data['status'] = TRUE;
      $json_data['data'] = $settings->result();
      $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    } else {
      $message = [
        'status' => FALSE,
        'message' => 'No Settings Found'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
    }
  }


}
