<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Projects extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");


    //      Load Models
    $this->load->model('User_model','User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->library('Projects_management','projects_management');
  }
  public function index_get()
  {
    //     Default Method
    $this->projects_get();
  }

  //  Projects
  public function projects_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Works Only
      $user_id = $this->get('user_id');
      $user_details = $this->User->select_user("",array("user_id"=>$user_id));
      if($user_details->num_rows()==1){
        if($user_details->row()->user_role==9 && $user_details->row()->project_area_location!=0 && $user_details->row()->project_area_location!=''){ //Area Manager
          $assigned_areas = $user_details->row()->project_area_location;
          $this->db->where("FIND_IN_SET(w.location_area, '$assigned_areas')");
        }elseif($user_details->row()->role_name=='supervisor'){
          $this->db->where("FIND_IN_SET($user_id, w.assigned_users)");
        }
        $data['w.delete_status'] = 0;
        $projects	= $this->Work->select_work("wc.wcat_name,w.work_id,w.work_type,w.work_status,w.work_name,client_name,client_contact,work_location,total_budget_amount,u.user_alias as created_user,w.created_date,u3.user_alias as updated_user,w.updated_date",$data);
        if ($projects->num_rows() > 0) {
          $message = array();
          $j = 0;
          foreach ($projects->result() as $row):

            if($row->work_status==1){
              $work_status="Completed";
            }elseif($row->work_status==3){
              $work_status="Freeze";
            }else{
              $work_status="In Progress";
            }

            $message[$j]['work_id'] = $row->work_id;
            $message[$j]['work_name'] = $row->work_name;
            $message[$j]['work_type'] = $row->wcat_name;
            $message[$j]['work_status'] = $work_status;
            $message[$j]['work_location'] = $row->work_location;
            $message[$j]['client_name'] = $row->client_name;
            $message[$j]['client_contact'] = $row->client_contact;
            $message[$j]['work_name_1'] = $row->work_name." - ".$row->work_location;
            $j++;
          endforeach;
          $json_data['status'] = TRUE;
          $json_data['data'] = $message;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'No Assigned Projects Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Not Found!'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function projects_client_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Projects of this client Only
      $client_id = $this->get('user_id');
      $client_details = $this->Client->select_client("",array("client_id"=>$client_id));
      if($client_details->num_rows()==1){
        $data['w.client_id'] = $client_id;
        $data['w.delete_status'] = 0;
        $projects	= $this->Work->select_work("wc.wcat_name,w.work_id,w.work_type,w.work_status,w.work_name,client_name,client_contact,work_location,total_budget_amount,u.user_alias as created_user,w.created_date,u3.user_alias as updated_user,w.updated_date",$data);
        if ($projects->num_rows() > 0) {
          $message = array();
          $j = 0;
          foreach ($projects->result() as $row):

            if($row->work_status==1){
              $work_status="Completed";
            }elseif($row->work_status==3){
              $work_status="Freeze";
            }else{
              $work_status="In Progress";
            }

            $message[$j]['work_id'] = $row->work_id;
            $message[$j]['work_name'] = $row->work_name;
            $message[$j]['work_type'] = $row->wcat_name;
            $message[$j]['work_status'] = $work_status;
            $message[$j]['work_location'] = $row->work_location;
            $message[$j]['client_name'] = $row->client_name;
            $message[$j]['client_contact'] = $row->client_contact;
            $j++;
          endforeach;
          $json_data['status'] = TRUE;
          $json_data['data'] = $message;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'No Assigned Projects Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'Client Not Found!'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function projects_profile_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Projects of this client Only
      $client_id = $this->get('user_id');
      $client_details = $this->Client->select_client("",array("client_id"=>$client_id));
      $data['w.client_id'] = $client_id;
      $data['w.work_id'] = $this->get('work_id');
      $data['w.delete_status'] = 0;
      $projects	= $this->Work->select_work("w.planned_date_of_completion,w.total_budget_amount,wc.wcat_name,w.work_id,w.work_type,w.work_status,w.work_name,client_name,client_contact,work_location,total_budget_amount,u.user_alias as created_user,w.created_date,u3.user_alias as updated_user,w.updated_date",$data);
      if ($projects->num_rows() ==1) {
        $message = array();
        $row = $projects->row();

        if($row->work_status==1){
          $work_status="Completed";
        }elseif($row->work_status==3){
          $work_status="Freeze";
        }else{
          $work_status="In Progress";
        }

        $message['work_id'] = $row->work_id;
        $message['work_name'] = $row->work_name;
        $message['work_type'] = $row->wcat_name;
        $message['work_status'] = $work_status;
        $message['work_location'] = $row->work_location;
        $message['total_budget_amount'] = $row->total_budget_amount;
        $message['client_name'] = $row->client_name;
        $message['client_contact'] = $row->client_contact;
        if($row->planned_date_of_completion!='0000-00-00'){
          $message['date_of_completion'] = date('d-m-Y',strtotime($row->planned_date_of_completion));
        }else{
          $message['date_of_completion'] = "";
        }

        $reference_type='client_payment';
        $client_payment_data['ats.tr_type'] = $reference_type."_transaction";
        $client_payment_data['ats.reference_type'] = 'project';
        $client_payment_data['ats.reference_id'] = $row->work_id;
        $message['client_payments']	= $this->Account->select_account_transaction("ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,",$client_payment_data,$reference_type)->result();
        $message['total_client_payments_received'] = round($this->Account->select_account_transaction("COALESCE(SUM(ats.tr_amount),0) as total_amount",$client_payment_data,'client_payment')->row()->total_amount,$this->config->item('Currency_amount_decimals_2'));
        $message['balance_to_receive'] = round($message['total_budget_amount']-$message['total_client_payments_received'],$this->config->item('Currency_amount_decimals_2'));

        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'Project Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function dash_icons_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      $message = array();
      $slno = 0;

      //          Select Assigned Works Only
      $user_id = $this->get('user_id');
      $user_data = $this->User->select_user("",array("user_id"=>$user_id));
      if($user_data->num_rows()==1){
        $user_data = $user_data->row();

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'CLIENT PAYMENT';
        $message[$slno]['icon_name'] = 'CLIENT PAYMENT';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        if($this->config->item('app_module_project_schedule')==1){
          $message[$slno]['slno'] = $slno+1;
          $message[$slno]['icon_title'] = 'PROJECT TASK';
          $message[$slno]['icon_name'] = 'PROJECT TASK';
          $message[$slno]['sub_icons'] = array();
          $slno++;
        }

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'DAILY NOTE';
        $message[$slno]['icon_name'] = 'DAILY NOTE';
        $message[$slno]['sub_icons'] = array();
        $slno++;


        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'DAILY TASK';
        $message[$slno]['icon_name'] = 'DAILY TASK';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'PURCHASE SLIP';
        $message[$slno]['icon_name'] = 'PURCHASE';
        if($this->config->item('Mobile_App_purchase_icon_tabs') && $this->config->item('Mobile_App_purchase_icon_tabs')!=''){
          $message[$slno]['sub_icons'] = explode(',',$this->config->item('Mobile_App_purchase_icon_tabs'));
        }else{
          $message[$slno]['sub_icons'] = array();
        }
        $slno++;

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'EXPENSE';
        $message[$slno]['icon_name'] = 'EXPENSE';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'SUBCONTRACT';
        $message[$slno]['icon_name'] = 'SUBCONTRACT';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'STOCK TRANSFER';
        $message[$slno]['icon_name'] = 'STOCK TRANSFER';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'DAILY CONSUMPTION';
        $message[$slno]['icon_name'] = 'DAILY CONSUMPTION';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'STOCK REPORT';
        $message[$slno]['icon_name'] = 'STOCK REPORT';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        $message[$slno]['slno'] = $slno+1;
        $message[$slno]['icon_title'] = 'LABOUR';
        $message[$slno]['icon_name'] = 'LABOUR';
        $message[$slno]['sub_icons'] = array();
        $slno++;

        if($this->config->item('app_module_vehicle')==1){
          $message[$slno]['slno'] = $slno+1;
          $message[$slno]['icon_title'] = 'VEHICLE';
          $message[$slno]['icon_name'] = 'VEHICLE';
          $message[$slno]['sub_icons'] = array();
          $slno++;
        }

        if($this->config->item('app_module_daily_progress_report')==1){
          $message[$slno]['slno'] = $slno+1;
          $message[$slno]['icon_title'] = 'PROGRESS REPORT';
          $message[$slno]['icon_name'] = 'PROGRESS REPORT';
          $message[$slno]['sub_icons'] = array();
          $slno++;
        }

        if($this->config->item('app_module_tools_management')==1){
          $message[$slno]['slno'] = $slno+1;
          $message[$slno]['icon_title'] = 'TOOLS';
          $message[$slno]['icon_name'] = 'TOOLS';
          $message[$slno]['sub_icons'] = array();
          $slno++;
        }

        if($this->config->item('app_module_project_documents')==1){
          $message[$slno]['slno'] = $slno+1;
          $message[$slno]['icon_title'] = 'DOCUMENTS';
          $message[$slno]['icon_name'] = 'DOCUMENTS';
          $message[$slno]['sub_icons'] = array();
          $slno++;
        }

        if($this->config->item('app_module_hr')==1 && $this->config->item('HR_employee_site_visit') && $this->config->item('HR_employee_site_visit')==1){
          $message[$slno]['slno'] = $slno+1;
          $message[$slno]['icon_title'] = 'HR';
          $message[$slno]['icon_name'] = 'HR';
          $message[$slno]['sub_icons'] = array();
          $slno++;
        }

      }

      $json_data['status'] = TRUE;
      $json_data['data'] = $message;
      $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
