<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Project_tasks extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model','User');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Project_tasks_model', 'Project_tasks');
    $this->load->model('Work_model', 'Work');
    $this->load->library('Projects_management','projects_management');
  }
  public function index_get()
  {
    //     Default Method
    $this->projects_get();
  }

  //  Project Tasks
  public function select_tasks_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Works Only
      $user_id = $this->get('user_id');
      $user_details = $this->User->select_user("",array("user_id"=>$user_id));
      if($user_details->num_rows()==1){
        if($user_details->row()->user_role==9 && $user_details->row()->project_area_location!=0 && $user_details->row()->project_area_location!=''){ //Area Manager
          $assigned_areas = $user_details->row()->project_area_location;
          $this->db->where("FIND_IN_SET(wc.location_area, '$assigned_areas')");
        }elseif($user_details->row()->role_name=='supervisor'){
          $this->db->where("FIND_IN_SET($user_id, wc.assigned_users)");
        }
        $data['pt.user_id'] = $this->get('user_id');
        $data['pt.work_id'] = $this->get('work_id');
        // $data['pt.parent_id'] = 0;
        $task_ids_array = array();
        $tasks_array = $this->Project_tasks->select_tasks("pt.task_id,pt.parent_id",$data)->result();
        foreach ($tasks_array as $key => $value) {
          if($value->parent_id==0){
            $task_ids_array[] = $value->task_id;
          }else{
            $task_ids_array[] = $value->parent_id;
          }
        }
        $task_ids_array = array_unique($task_ids_array);
        if(sizeof($task_ids_array)>0){
          $this->db->where("pt.task_id IN(".implode(',',$task_ids_array).")");
          $tasks = $this->Project_tasks->select_tasks("pt.*,pt.created_date AS pt_created_date,u1.user_alias AS pt_created_by,u1.user_id AS pt_created_by_id,u2.user_alias AS supervisor,u2.user_id AS supervisor_id");
          if ($tasks->num_rows() > 0) {
            $message = array();
            $j = 0;
            foreach ($tasks->result() as $row):
              $actual_start_date = $actual_end_date = '';
              if($row->actual_start_date!='0000-00-00'){
                $actual_start_date = date('d-m-Y',strtotime($row->actual_start_date));
              }
              if($row->actual_end_date!='0000-00-00'){
                $actual_end_date = date('d-m-Y',strtotime($row->actual_end_date));
              }

              if($row->task_status==1){
                $task_status_text="Completed";
              }elseif($row->task_status==2){
                $task_status_text="In Progress";
              }else{
                $task_status_text="Pending";
              }
              $task_date_status_text = '';
              if($row->task_status!=1){
                if(date("Y-m-d") > $row->planned_end_date){
                  $task_date_status_text.=" Overdue";
                }
              }
              if($row->planned_end_date!='0000-00-00' && date('Y-m-d')>$row->planned_end_date){
                $task_date_status_text .= " Not Finished Yet";
              }
              if($row->planned_start_date!='0000-00-00' && date('Y-m-d')>$row->planned_start_date){
                $task_date_status_text .= " Not Started Yet";
              }

              // Declare and define two dates
              $sdate = date("Y-m-d",strtotime($row->planned_start_date));
              $edate = date("Y-m-d",strtotime($row->planned_end_date));
              $date_diff = abs(strtotime($edate) - strtotime($sdate));
              $years = floor($date_diff / (365*60*60*24));
              $months = floor(($date_diff - $years * 365*60*60*24) / (30*60*60*24));
              $days = floor(($date_diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));


              $message[$j]['task_id'] = $row->task_id;
              $message[$j]['task_title'] = $row->task_title;
              $message[$j]['task_description'] = $row->task_description;
              $message[$j]['planned_start_date'] = date('d-m-Y',strtotime($row->planned_start_date));
              $message[$j]['planned_end_date'] = date('d-m-Y',strtotime($row->planned_end_date));
              $message[$j]['actual_start_date'] = $actual_start_date;
              $message[$j]['actual_end_date'] = $actual_end_date;
              $message[$j]['progress'] = round($row->progress,1);
              $message[$j]['supervisor'] = $row->supervisor;
              $message[$j]['task_status_text'] = $task_status_text;
              $message[$j]['task_status'] = $row->task_status;
              $message[$j]['task_date_status_text'] = $task_date_status_text;
              $message[$j]['created_by'] = $row->pt_created_by;
              $message[$j]['created_date'] =  date('d-m-Y',strtotime($row->pt_created_date));
              $message[$j]['duration'] = $days;
              $message[$j]['task_type'] = 'Main Task';

              $j++;
            endforeach;
            $json_data['status'] = TRUE;
            $json_data['data'] = $message;
            $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
          } else {
            $message = [
              'status' => FALSE,
              'message' => 'No Tasks Found'
            ];
            $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
          }
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'No Tasks Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Not Found!'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_task_details_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('task_id')!="" && $this->get('task_id') !== NULL) {

      $data=array();
      //          Select Assigned Works Only
      $user_id = $this->get('user_id');

      // $data['pt.user_id'] = $user_id;
      $data['pt.task_id'] = $this->get('task_id');
      $tasks = $this->Project_tasks->select_tasks("pt.*,pt.created_date AS pt_created_date,u1.user_alias AS pt_created_by,u1.user_id AS pt_created_by_id,u2.user_alias AS supervisor,u2.user_id AS supervisor_id",$data);
      if ($tasks->num_rows() == 1) {
        $message = array();
        $j = 0;
        $row = $tasks->row();

        $actual_start_date = $actual_end_date = '';
        if($row->actual_start_date!='0000-00-00'){
          $actual_start_date = date('d-m-Y',strtotime($row->actual_start_date));
        }
        if($row->actual_end_date!='0000-00-00'){
          $actual_end_date = date('d-m-Y',strtotime($row->actual_end_date));
        }

        if($row->task_status==1){
          $task_status_text="Completed";
        }elseif($row->task_status==2){
          $task_status_text="In Progress";
        }else{
          $task_status_text="Pending";
        }
        $task_date_status_text = '';
        if($row->task_status!=1){
          if(date("Y-m-d") > $row->planned_end_date){
            $task_date_status_text.=" Overdue";
          }
        }
        if($row->planned_end_date!='0000-00-00' && date('Y-m-d')>$row->planned_end_date){
          $task_date_status_text .= " Not Finished Yet";
        }
        if($row->planned_start_date!='0000-00-00' && date('Y-m-d')>$row->planned_start_date){
          $task_date_status_text .= " Not Started Yet";
        }

        // Declare and define two dates
        $sdate = date("Y-m-d",strtotime($row->planned_start_date));
        $edate = date("Y-m-d",strtotime($row->planned_end_date));
        $date_diff = abs(strtotime($edate) - strtotime($sdate));
        $years = floor($date_diff / (365*60*60*24));
        $months = floor(($date_diff - $years * 365*60*60*24) / (30*60*60*24));
        $days = floor(($date_diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));

        if($row->parent_id==0){
          $task_type= 'Main Task';
        }else{
          $task_type= 'Sub Task';
        }

        $json_data['task_id'] = $row->task_id;
        $json_data['task_title'] = $row->task_title;
        $json_data['task_description'] = $row->task_description;
        $json_data['planned_start_date'] = date('d-m-Y',strtotime($row->planned_start_date));
        $json_data['planned_end_date'] = date('d-m-Y',strtotime($row->planned_end_date));
        $json_data['actual_start_date'] = $actual_start_date;
        $json_data['actual_end_date'] = $actual_end_date;
        $json_data['progress'] = round($row->progress,1);
        $json_data['supervisor'] = $row->supervisor;
        $json_data['task_status_text'] = $task_status_text;
        $json_data['task_status'] = $row->task_status;
        $json_data['task_date_status_text'] = $task_date_status_text;
        $json_data['created_by'] = $row->pt_created_by;
        $json_data['created_date'] =  date('d-m-Y',strtotime($row->pt_created_date));
        $json_data['duration'] = $days;
        $json_data['task_type'] = $task_type;

        $subtasks = array();
        $subtask_data['pt.parent_id'] = $row->task_id;
        $subtask_data['pt.user_id'] = $user_id;
        $sub_task_result = $this->Project_tasks->select_tasks("pt.*,pt.created_date AS pt_created_date,u1.user_alias AS pt_created_by,u1.user_id AS pt_created_by_id,u2.user_alias AS supervisor,u2.user_id AS supervisor_id",$subtask_data);
        if ($sub_task_result->num_rows() > 0) {
          $j = 0;
          foreach ($sub_task_result->result() as $row2):
            $actual_start_date_sub = $actual_end_date_sub = '';
            if($row2->actual_start_date!='0000-00-00'){
              $actual_start_date_sub = date('d-m-Y',strtotime($row2->actual_start_date));
            }
            if($row2->actual_end_date!='0000-00-00'){
              $actual_end_date_sub = date('d-m-Y',strtotime($row2->actual_end_date));
            }

            if($row2->task_status==1){
              $task_status_text_sub="Completed";
            }elseif($row2->task_status==2){
              $task_status_text_sub="In Progress";
            }else{
              $task_status_text_sub="Pending";
            }
            $task_date_status_text_sub = '';
            if($row2->task_status!=1){
              if(date("Y-m-d") > $row2->planned_end_date){
                $task_date_status_text_sub.=" Overdue";
              }
            }
            if($row2->planned_end_date!='0000-00-00' && date('Y-m-d')>$row2->planned_end_date){
              $task_date_status_text_sub .= " Not Finished Yet";
            }
            if($row2->planned_start_date!='0000-00-00' && date('Y-m-d')>$row2->planned_start_date){
              $task_date_status_text_sub .= " Not Started Yet";
            }

            // Declare and define two dates
            $sdate_sub = date("Y-m-d",strtotime($row2->planned_start_date));
            $edate_sub = date("Y-m-d",strtotime($row2->planned_end_date));
            $date_diff_sub = abs(strtotime($edate_sub) - strtotime($sdate_sub));
            $years_sub = floor($date_diff_sub / (365*60*60*24));
            $months_sub = floor(($date_diff_sub - $years_sub * 365*60*60*24) / (30*60*60*24));
            $days_sub = floor(($date_diff_sub - $years_sub * 365*60*60*24 - $months_sub*30*60*60*24)/ (60*60*24));


            $subtasks[$j]['task_id'] = $row2->task_id;
            $subtasks[$j]['task_title'] = $row2->task_title;
            $subtasks[$j]['task_description'] = $row2->task_description;
            $subtasks[$j]['planned_start_date'] = date('d-m-Y',strtotime($row2->planned_start_date));
            $subtasks[$j]['planned_end_date'] = date('d-m-Y',strtotime($row2->planned_end_date));
            $subtasks[$j]['actual_start_date'] = $actual_start_date_sub;
            $subtasks[$j]['actual_end_date'] = $actual_end_date_sub;
            $subtasks[$j]['progress'] = round($row2->progress,1);
            $subtasks[$j]['supervisor'] = $row2->supervisor;
            $subtasks[$j]['task_status_text'] = $task_status_text_sub;
            $subtasks[$j]['task_status'] = $row2->task_status;
            $subtasks[$j]['task_date_status_text'] = $task_date_status_text_sub;
            $subtasks[$j]['created_by'] = $row2->pt_created_by;
            $subtasks[$j]['created_date'] =  date('d-m-Y',strtotime($row2->pt_created_date));
            $subtasks[$j]['duration'] = $days_sub;
            $subtasks[$j]['task_type'] = 'Sub Task';

            $j++;
          endforeach;
        }

        $activities = array();
        // Select Activities of This Task & SubTasks
        $activities_data = "(pta.task_id=".$row->task_id." or pt.parent_id=".$row->task_id.")";
        $activities_result = $this->Project_tasks->select_task_activity("pt.task_id,pt.task_title,pt.work_id,pta.*,u2.*",$activities_data);
        if ($activities_result->num_rows() > 0) {
          $k = 0;
          foreach ($activities_result->result() as $row3):
            $activities[$k]['id'] = $row3->id;
            $activities[$k]['date'] = date('d-m-Y',strtotime($row3->activity_date));
            $activities[$k]['title'] = $row3->activity_title;
            $activities[$k]['description'] = $row3->activity_description;
            $activities[$k]['created_by'] = $row3->user_alias;
            $activities[$k]['created_date'] =  date('d-m-Y H:i:s',strtotime($row3->created_date));
            $k++;
          endforeach;
        }
        $json_data['subtasks'] = $subtasks;
        $json_data['activities'] = $activities;

        $json_data['status'] = TRUE;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Tasks Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_task_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('parent_id')!="" && $this->post('parent_id') !== NULL) {

      $data['parent_id'] = $this->post('parent_id');
      $data['task_title'] = $this->post('title');
      $data['task_description'] = $this->post('description');
      $data['planned_start_date'] = date('Y-m-d',strtotime($this->post('start_date')));
      $data['planned_end_date'] = date('Y-m-d',strtotime($this->post('end_date')));
      $data['work_id'] = $this->post('work_id');
      $data['user_id'] = $this->post('user_id');
      $data['task_status'] = 0;
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');

      $result =   $this->Project_tasks->create_task($data);
      if($result['status'] == 1) {
        // Update Project Progress
        $this->projects_management->update_project_progress($data['work_id'],$this->post('user_id'));

        $message = [
          'status' => TRUE,
          'message' => 'Project Task Created Succesfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Parent Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_task_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('task_id')!="" && $this->post('task_id') !== NULL) {

      $data['task_id'] = $this->post('task_id');
      $data['task_title'] = $this->post('title');
      $data['task_description'] = $this->post('description');
      $data['planned_start_date'] = date('Y-m-d',strtotime($this->post('start_date')));
      $data['planned_end_date'] = date('Y-m-d',strtotime($this->post('end_date')));
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');

      $result =   $this->Project_tasks->update_task($data);
      if($result == 1) {
        $task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$data['task_id']));
        // Update Project Progress
        $this->projects_management->update_project_progress($task_data->row()->work_id,$this->post('user_id'));

        $message = [
          'status' => TRUE,
          'message' => 'Task Detail Updated Succesfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_task_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('task_id')!="" && $this->post('task_id') !== NULL) {

      $data['task_id'] = $this->post('task_id');
      $data['delete_status'] = 1;
      $task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$data['task_id']));
      $result =   $this->Project_tasks->update_task($data);
      if($result == 1) {
        // Update Project Progress
        $this->projects_management->update_project_progress($task_data->row()->work_id,$this->post('user_id'));

        $message = [
          'status' => TRUE,
          'message' => 'Task Deleted Succesfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_task_progress_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('task_id')!="" && $this->post('task_id') !== NULL) {

      $data['task_id'] = $this->post('task_id');
      $data['progress'] = $this->post('progress');
      if($data['progress']<=100 && $data['progress']>=0){
        $task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$data['task_id']));
        $task_data_result_array=$task_data->result();
        if($data['progress']==100){
          $data['task_status'] = 1;
          // Update Task Actual End Date If Not Updated
          if($task_data->row()->actual_end_date=='0000-00-00'){
            $data['actual_end_date'] = date('Y-m-d');
          }
        }elseif($data['progress']==0){
          $data['task_status'] = 0;
        }else{
          $data['task_status'] = 2;
        }
        // Update Task Actual STart Date If Not Updated
        if($task_data->row()->actual_start_date=='0000-00-00'){
          $data['actual_start_date'] = date('Y-m-d');
        }
        $result = $this->Project_tasks->update_task($data);
        if($result == 1) {
          //if this task is subtask, updating it parent task progress
          $parent_task_id = $data3['pt.parent_id'] = $task_data_result_array[0]->parent_id;
          if($parent_task_id>0){
            $parent_task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$parent_task_id));
            if($parent_task_data->num_rows()==1){
              $result2 = $this->Project_tasks->select_tasks("pt.*",$data3);
              $subtask_count=$result2->num_rows();
              $subtask_result_array=$result2->result();

              foreach($subtask_result_array as $row2):
                if($row2->progress>0){
                  $main_task_progress[] = $row2->progress;
                }
                else{
                  $main_task_progress[] = 0;
                }
              endforeach;
              // $main_task_progress = array_filter($main_task_progress);

              $final_progress = array_sum($main_task_progress)/count($main_task_progress);
              $data_parent['progress'] = $final_progress;
              $data_parent['task_id'] = $parent_task_id;
              if($parent_task_data->row()->actual_start_date=='0000-00-00'){
                $data_parent['actual_start_date'] = date('Y-m-d');
              }
              if($data_parent['progress']==100){
                $data_parent['task_status'] = 1;
                // Update Task Actual End Date If Not Updated
                if($parent_task_data->row()->actual_end_date=='0000-00-00'){
                  $data_parent['actual_end_date'] = date('Y-m-d');
                }
              }elseif($data_parent['progress']==0){
                $data_parent['task_status'] = 0;
              }else{
                $data_parent['task_status'] = 2;
              }
              $result2 = $this->Project_tasks->update_task($data_parent);

              // Add to Progress Update Log
              $progress_log_data_1['reference_id'] = $data_parent['task_id'];
              $progress_log_data_1['reference_type'] = "project_task";
              $progress_log_data_1['old_value'] = $parent_task_data->row()->progress;
              $progress_log_data_1['new_value'] = $data_parent['progress'];
              $progress_log_data_1['variation'] = $data_parent['progress']-$parent_task_data->row()->progress;
              $progress_log_data_1['created_date'] = date('Y-m-d H:i:s');
              $progress_log_data_1['created_by'] = $this->post('user_id');
              $this->Work->insert_progress_log($progress_log_data_1);
            }
          }

          // Add to Progress Update Log
          $progress_log_data['reference_id'] = $data['task_id'];
          $progress_log_data['reference_type'] = "project_task";
          $progress_log_data['old_value'] = $task_data->row()->progress;
          $progress_log_data['new_value'] = $data['progress'];
          $progress_log_data['variation'] = $data['progress']-$task_data->row()->progress;
          $progress_log_data['created_date'] = date('Y-m-d H:i:s');
          $progress_log_data['created_by'] = $this->post('user_id');
          $this->Work->insert_progress_log($progress_log_data);

          // Update Project Progress
          $this->projects_management->update_project_progress($task_data->row()->work_id,$this->post('user_id'));

          $message = [
            'status' => TRUE,
            'message' => 'Task Detail Updated Succesfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'Progress Value Allowed only Between 0 To 100'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('task_id')!="" && $this->post('task_id') !== NULL) {

      $data['task_id'] = $this->post('task_id');
      $data['activity_title'] = $this->post('title');
      $data['activity_description'] = $this->post('description');
      $data['activity_date'] = date('Y-m-d',strtotime($this->post('date')));
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      $result =   $this->Project_tasks->create_task_activity($data);
      if($result['status'] == 1) {
        // Update Task Actual STart Date If Not Updated
        $task_data = $this->Project_tasks->select_tasks("pt.actual_start_date,pt.parent_id",array("pt.task_id"=>$data['task_id']))->row();
        if($task_data->actual_start_date=='0000-00-00'){
          $task_update_data['actual_start_date'] = date('Y-m-d');
          $task_update_data['task_id'] = $data['task_id'];
          $this->Project_tasks->update_task($task_update_data);
        }
        if($task_data->parent_id!=0){
          $parent_task_data = $this->Project_tasks->select_tasks("pt.*",array("pt.task_id"=>$task_data->parent_id));
          if($parent_task_data->num_rows()==1){
            $parent_task_data = $parent_task_data->row();
            if($parent_task_data->actual_start_date=='0000-00-00'){
              $parent_task_update_data['actual_start_date'] = date('Y-m-d');
              $parent_task_update_data['task_id'] = $parent_task_data->task_id;
              $this->Project_tasks->update_task($parent_task_update_data);
            }
          }
        }

        // Update Project Actual STart Date If Not Updated
        $project_data = $this->Project_tasks->select_tasks("wc.actual_start_date,wc.work_id",array("pt.task_id"=>$data['task_id']))->row();
        if($project_data->actual_start_date=='0000-00-00'){
          $project_update_data['actual_start_date'] = date('Y-m-d');
          $project_update_data['work_id'] = $project_data->work_id;
          $this->Work->update_work($project_update_data);
        }

        $message = [
          'status' => TRUE,
          'message' => 'Task Activity Created Succesfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('activity_id')!="" && $this->post('activity_id') !== NULL) {

      $data['id'] = $this->post('activity_id');
      $data['activity_title'] = $this->post('title');
      $data['activity_description'] = $this->post('description');
      $data['activity_date'] = date('Y-m-d',strtotime($this->post('date')));
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');
      $result =   $this->Project_tasks->update_task_activity($data);
      if($result == 1) {

        $message = [
          'status' => TRUE,
          'message' => 'Task Activity Updated Succesfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Activity ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('activity_id')!="" && $this->post('activity_id') !== NULL) {

      $data['id'] = $this->post('activity_id');
      $data['delete_status'] = 1;

      $result =   $this->Project_tasks->update_task_activity($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Task Activity Deleted Succesfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Activity ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
