<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Labours extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");


    //      Load Models
    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Labour_model', 'Labour');
    $this->load->model('Labour_wages_model', 'Labour_wages');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Bills_model', 'Bills');
    $this->load->library('Bills_management','bills_management');
    $this->load->model('Subcontracts_model', 'Subcontracts');
    $this->load->model('Daily_reports_model', 'Daily_reports');

    $this->load->library('Projects_management','projects_management');

  }
  public function index_get()
  {
    //     Default Method
    $this->labour_reports_get();
  }
  //  Labour Report
  public function labour_reports_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dr.created_by'] = $user_id;
      $data['dr.report_type'] = 'labour';
      if($this->get('work_id')){
        $data['dr.work_id'] = $this->get('work_id');
      }
      $labour_report	= $this->Daily_reports->select_labour_report("dr.*,l.labour_name,wt1.type_name,u.user_alias as created_user,wc.work_id,wc.work_name",$data);
      if ($labour_report->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($labour_report->result() as $row):

          $message[$j]['report_id'] = $row->report_id;
          $message[$j]['work_name'] = $row->work_name;
          $message[$j]['labour_name'] = $row->labour_name;
          $message[$j]['work_type'] = $row->type_name;
          $message[$j]['date'] = date('d-m-Y',strtotime($row->report_date));
          $message[$j]['description'] = $row->description;
          $message[$j]['created_by'] = $row->created_user;
          $message[$j]['created_date'] = date('d-m-Y',strtotime($row->created_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Daily Labour Reports Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_labours_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['l.delete_status'] = 0;
      if($this->get('work_id') && $this->get('work_id')!='' && $this->config->item('Labour_projet_assigning')==1){
        $work_id = $this->get('work_id');
        $this->db->where("FIND_IN_SET($work_id, l.assigned_projects)");
      }
      if($this->get('labour_id') && $this->get('labour_id')!=''){
        $data['l.labour_id'] = $this->get('labour_id');
      }
      if($this->get('labour_type') && $this->get('labour_type')!=''){
        $data['l.labour_type'] = $this->get('labour_type');
      }
      if($this->get('group_position') && $this->get('group_position')!=''){
        $data['l.group_position'] = $this->get('group_position');
      }
      if($this->get('labour_group') && $this->get('labour_group')!=''){
        $data['l.labour_group'] = $this->get('labour_group');
      }
      $labours	= $this->Labour->select_labours("l.*,wt.type_id,wt.type_name,u.user_alias",$data);
      if ($labours->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($labours->result() as $row):

          $message[$j]['labour_id'] = $row->labour_id;
          $message[$j]['labour_name'] = $row->labour_name;
          $message[$j]['contact_no'] = $row->labour_contact;
          $message[$j]['work_type'] = $row->type_name;
          $message[$j]['work_type_id'] = $row->work_type;
          $message[$j]['op_balance'] = (float)$row->opening_balance;
          $message[$j]['fixed_wage_status'] = $row->fixed_wage;
          $message[$j]['daily_wage'] = (float)$row->daily_wage;
          $message[$j]['overtime_rate'] = (float)$row->overtime_rate_per_hr;
          $message[$j]['labour_type'] = $row->labour_type;
          if($row->created_by == $this->get('user_id')){
            $message[$j]['editable'] = 1;
          }else{
            $message[$j]['editable'] = 0;
          }
          $message[$j]['contact_no_2'] = $row->labour_contact_2;
          $message[$j]['address'] = $row->address;
          $message[$j]['aadhar_no'] = $row->aadhar_no;
          if($row->photo!=''){
            $photo = base_url().'uploads/labours/'.$row->photo;
          }else{
            $photo = base_url().'uploads/labours/default.png';
          }
          $message[$j]['photo'] = $photo;

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Registered Labours Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_subcontracts_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['wc.work_id'] = $this->get('work_id');
      $subcontracts	= $this->Subcontracts->select_subcontract("sc.*,u.user_alias,wc.work_name,wt.type_name",$data);
      if ($subcontracts->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($subcontracts->result() as $row):

          $message[$j]['contract_id'] = $row->contract_id;
          $message[$j]['sub_work_name'] = $row->sub_work_name;
          $message[$j]['work_type'] = $row->type_name;
          $message[$j]['contractor'] = $row->contractor;

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Subcontracts Found For This Project'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function create_labour_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL) {

      $data2['labour_name'] = $this->post('name');
      $count = $this->Labour->select_labours("",$data2)->num_rows();
      $data2['labour_contact'] = $this->post('contact_no');
      $data2['labour_type'] = 0;
      $data2['fixed_wage'] = $this->post('fixed_wage');
      $data2['work_type'] = $this->post('work_type');
      $data2['daily_wage'] = $this->post('daily_wage');
      if($this->post('overtime_rate')){
        $data2['overtime_rate_per_hr'] = $this->post('overtime_rate');
      }
      if($this->post('ta_per_day')){
        $data2['ta_per_day'] = $this->post('ta_per_day');
      }
      $data2['opening_balance'] = $this->post('op_balance');
      if($this->post('address')){
        $data2['address'] = $this->post('address');
      }
      if($this->post('aadhar_no')){
        $data2['aadhar_no'] = $this->post('aadhar_no');
      }
      if($this->post('contact_no_2')){
        $data2['labour_contact_2'] = $this->post('contact_no_2');
      }
      if($this->post('image') && $this->post('image')!=''){
        $data2['photo'] = date('dmY-His') . '.png';
        $Image_Data = $this->post('image');
        $Image_Path = "uploads/labours/".$files[0];
        file_put_contents($Image_Path,base64_decode($Image_Data));
      }
      $data2['created_date'] = date('Y-m-d H:i:s');
      $data2['created_by'] = $this->post('user_id');
      if($count==0) {
        $result = $this->Labour->create_labour($data2);
        if($result['status'] == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Labour Profile Created Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'A Labour with Same Name Already Exist'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function update_labour_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('labour_id')!="" && $this->post('labour_id') !== NULL) {

      $data2['labour_id'] = $data3['labour_id !='] = $this->post('labour_id');
      $data2['labour_name'] = $data3['labour_name'] = $this->post('name');
      $count = $this->Labour->select_labours("",$data3)->num_rows();
      $data2['labour_contact'] = $this->post('contact_no');
      $data2['fixed_wage'] = $this->post('fixed_wage');
      $data2['work_type'] = $this->post('work_type');
      $data2['daily_wage'] = $this->post('daily_wage');
      $data2['opening_balance'] = $this->post('op_balance');
      $data2['updated_date'] = date('Y-m-d H:i:s');
      $data2['updated_by'] = $this->post('user_id');
      if($count==0) {
        $result = $this->Labour->update_labour($data2);
        if($result== 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Labour Profile Details Updated Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'A Labour with Same Name Already Exist'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Labour ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_labour_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('labour_id')!="" && $this->post('labour_id') !== NULL) {

      $data2['labour_id'] = $this->post('labour_id');
      $data2['delete_status'] = 1;
      $result = $this->Labour->update_labour($data2);
      if($result== 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Labour Profile Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Labour ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function create_labour_wage_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('labour_id')!="" && $this->post('labour_id') !== NULL) {

      $data2['labour_id'] = $data3['lw.labour_id'] = $this->post('labour_id');
      $labour_details = $this->Labour->select_labours("l.*",array("labour_id"=>$data2['labour_id']))->row();
      $data2['work_date'] = $data3['lw.work_date'] = date('Y-m-d',strtotime($this->post('work_date')));
      $data2['work_id'] = $this->post('work_id');
      $data2['project_stage_id'] = $this->projects_management->get_project_stage_id($data2['work_id']);
      if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
        $data3['lw.work_id'] = $data2['work_id'];
      }
      $total_wage = $data2['extra_wage'] = $data2['overtime_wage'] = 0;
      $count = $this->Labour_wages->select_labour_wages("",$data3)->num_rows();
      $data2['wage_per_day'] = $this->post('wage_per_day');
      $data2['overtime_type'] = $this->config->item('Labour_wage_overtime_calculation');
      $data2['overtime_hours'] = 0;
      if($data2['overtime_type']=='hour'){
        if($this->post('overtime_duration')){
          $data2['overtime_hours'] = $this->post('overtime_duration');
        }
        if($this->post('overtime_rate')){
          $data2['overtime_hourly_rate'] = $this->post('overtime_rate');
        }
      }
      if($this->post('overtime_wage')){
        $data2['overtime_wage'] = $this->post('overtime_wage');
        if($data2['overtime_type']=='hour' && isset($data2['overtime_hours']) && ($data2['overtime_hours']==0 || $data2['overtime_hours']=="0")){
          $data2['overtime_wage'] = 0;
        }
      }
      if($this->post('extra_wage')){
        $data2['extra_wage'] = $this->post('extra_wage');
      }
      $data2['work_days'] = $this->post('no_of_days');
      $data2['no_of_labours'] = $this->post('no_of_labours');

      if($data2['no_of_labours']==0){
        $data2['no_of_labours'] = 1;
      }
      $data2['ta_wage'] = 0;
      if($this->config->item('Labour_include_ta_in_mobile_app_labour_wage')==1 && $labour_details->ta_per_day!=0){
        $data2['ta_wage'] = $labour_details->ta_per_day;
      }
      $total_wage = ($data2['no_of_labours']*$data2['work_days']*$data2['wage_per_day'])+$data2['extra_wage']+$data2['overtime_wage']+$data2['ta_wage'];
      $data2['total_wage'] = (float)$this->post('total_wage');
      $data2['total_wage'] += $data2['ta_wage'];
      // if($data2['overtime_type']=='hour' && $total_wage!=$data2['total_wage']){
      // $data2['total_wage'] = $total_wage;
      // }
      $data2['remarks'] = $this->post('remarks');
      $data2['created_date'] = date('Y-m-d H:i:s');
      $data2['created_by'] = $this->post('user_id');
      if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $data2['entry_approval_status'] = 0;
      }
      if($count==0) {
        $result2 = $this->Labour_wages->create_labour_wage($data2);
        $flash_data['status'] = $result2['status'];
        if ($result2['status'] == 1) {
          $message = 'Labour Wage Slip Added Successfully!.';

          // Insert IF Payment Exist
          if($this->post('paid_amount')>0){
            $account_heads_where['ah.delete_status'] = 0;
            $account_heads_where['ah.acc_user_id'] = $this->post('user_id');
            $account_heads_data	= $this->Account->select_account_heads("acc_head_id",$account_heads_where)->row();
            $transaction_data['tr_debit_acc'] = $account_heads_data->acc_head_id;

            $transaction_data['reference_id'] = $this->post('labour_id');
            $transaction_data['reference_type'] = "labour";
            $transaction_data['tr_type'] = "labour_transaction";
            $transaction_data['tr_date'] = date('Y-m-d',strtotime($this->post('paid_date')));
            // $transaction_data['tr_debit_acc'] = $this->post('debit_acc');
            $transaction_data['tr_credit_acc'] = 7;//labour wage payments
            $transaction_data['tr_description'] = "Labour Wage Transaction";
            $transaction_data['tr_amount'] = $this->post('paid_amount');
            $transaction_data['tr_mode'] = $this->post('payment_mode');
            // $transaction_data['tr_reference_no'] = $this->post('reference_no');
            // if($this->post('reference_date')!=''){
            //   $transaction_data['tr_reference_date'] = date('Y-m-d',strtotime($this->post('reference_date')));
            // }
            $transaction_data['tr_remarks'] = $this->post('tr_remarks');
            $transaction_data['created_date'] = date('Y-m-d H:i:s');
            $transaction_data['created_by'] = $this->post('user_id');
            if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
              $transaction_data['tr_entry_approval_status'] = 0;
            }
            $transaction_result =  $this->Account->create_account_transaction($transaction_data);
            $message = 'Labour Wage Slip & Transaction Added Successfully!.';
          }
          $message = [
            'status' => TRUE,
            'message' => $message
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code

        } else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else{
        if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
          $message_text = 'Sorry.. Labour Wage Slip on Same Date & Project Already Exist!';
        }else{
          $message_text = 'Sorry.. Labour Wage Slip on Same Date Already Exist!';
        }
        $message = [
          'status' => FALSE,
          'message' => $message_text
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Labour ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
    }
  }
  public function update_labour_wage_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('wage_id')!="" && $this->post('wage_id') !== NULL) {

      $total_wage = $data2['extra_wage'] = $data2['overtime_wage'] = 0;
      $data2['wage_id'] = $data3['lw.wage_id !='] = $this->post('wage_id');
      $data2['labour_id'] = $data3['lw.labour_id'] = $this->post('labour_id');
      $data2['work_date'] = $data3['lw.work_date'] = date('Y-m-d',strtotime($this->post('work_date')));
      $data2['work_id'] = $this->post('work_id');
      if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
        $data3['lw.work_id'] = $data2['work_id'];
      }
      $count = $this->Labour_wages->select_labour_wages("",$data3)->num_rows();
      $data2['work_days'] = $this->post('no_of_days');
      $data2['no_of_labours'] = $this->post('no_of_labours');
      if($data2['no_of_labours']==0){
        $data2['no_of_labours'] = 1;
      }
      $data2['wage_per_day'] = $this->post('wage_per_day');
      $data2['overtime_type'] = $this->config->item('Labour_wage_overtime_calculation');
      if($data2['overtime_type']=='hour'){
        if($this->post('overtime_duration')){
          $data2['overtime_hours'] = $this->post('overtime_duration');
        }
        if($this->post('overtime_rate')){
          $data2['overtime_hourly_rate'] = $this->post('overtime_rate');
        }
      }
      if($this->post('overtime_wage')){
        $data2['overtime_wage'] = $this->post('overtime_wage');
        if($data2['overtime_type']=='hour' && isset($data2['overtime_hours']) && ($data2['overtime_hours']==0 || $data2['overtime_hours']=="0")){
          $data2['overtime_wage'] = 0;
        }
      }
      if($this->post('extra_wage')){
        $data2['extra_wage'] = $this->post('extra_wage');
      }
      $total_wage = ($data2['no_of_labours']*$data2['work_days']*$data2['wage_per_day'])+$data2['extra_wage']+$data2['overtime_wage'];
      $data2['total_wage'] = $this->post('total_wage');
      // if($data2['overtime_type']=='hour' && $total_wage!=$data2['total_wage']){
      // $data2['total_wage'] = $total_wage;
      // }
      $data2['remarks'] = $this->post('remarks');
      $data2['updated_date'] = date('Y-m-d H:i:s');
      $data2['updated_by'] = $this->post('user_id');
      if($count==0) {
        $result2 = $this->Labour_wages->update_labour_wage($data2);
        $flash_data['status'] = $result2;
        if ($result2 == 1) {
          $success_message = 'Labour Wage Slip Updated Successfully!.';
          $message = [
            'status' => TRUE,
            'message' => $success_message
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else{
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      } else{
        if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
          $message_text = 'Sorry.. Labour Wage Slip on Same Date & Project Already Exist!';
        }else{
          $message_text = 'Sorry.. Labour Wage Slip on Same Date Already Exist!';
        }
        $message = [
          'status' => FALSE,
          'message' => $message_text
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Wage ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
    }
  }
  public function delete_labour_wage_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('wage_id')!="" && $this->post('wage_id') !== NULL) {

      $data2['wage_id'] = $this->post('wage_id');
      $data2['delete_status'] = 1;

      $result2 = $this->Labour_wages->update_labour_wage($data2);
      $flash_data['status'] = $result2;
      if ($result2 == 1) {
        $success_message = 'Labour Wage Slip Deleted Successfully!.';
        $message = [
          'status' => TRUE,
          'message' => $success_message
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }

    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Wage ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
    }
  }

  public function create_labour_wage_attendance_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('labour_id')!="" && $this->post('labour_id') !== NULL) {

      $data2['labour_id'] = $data3['lw.labour_id'] = $this->post('labour_id');
      // $data2['work_date'] = $data3['lw.work_date'] = date('Y-m-d',strtotime($this->post('work_date')));
      $data2['work_date'] = $data3['lw.work_date'] = date('Y-m-d');
      $data2['work_id'] = $this->post('work_id');
      if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
        $data3['lw.work_id'] = $data2['work_id'];
      }
      $data2['project_stage_id'] = $this->projects_management->get_project_stage_id($data2['work_id']);
      $labour_data = $this->Labour->select_labours("l.*",array("l.labour_id"=>$data2['labour_id']));
      if($labour_data->num_rows()==1){
        $count = $this->Labour_wages->select_labour_wages("",$data3)->num_rows();
        $data2['wage_per_day'] = $labour_data->row()->daily_wage;
        $data2['overtime_type'] = $this->config->item('Labour_wage_overtime_calculation');
        $data2['work_days'] = 1;
        $data2['no_of_labours'] = 1;
        $data2['total_wage'] = $data2['wage_per_day'];
        $data2['created_date'] = date('Y-m-d H:i:s');
        $data2['created_by'] = $this->post('user_id');
        if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $data2['entry_approval_status'] = 0;
        }
        if($count==0) {
          $result2 = $this->Labour_wages->create_labour_wage($data2);
          $flash_data['status'] = $result2['status'];
          if ($result2['status'] == 1) {
            $message = 'Labour Wage Slip Added Successfully!.';
            $message = [
              'status' => TRUE,
              'message' => $message
            ];
            $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code

          } else {
            $message = [
              'status' => FALSE,
              'message' => 'There Has Been Some Error Occurred'
            ];
            $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
          }
        }else{
          if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
            $message_text = 'Sorry.. Labour Wage Slip on Same Date & Project Already Exist!';
          }else{
            $message_text = 'Sorry.. Labour Wage Slip on Same Date Already Exist!';
          }
          $message = [
            'status' => FALSE,
            'message' => $message_text
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'Sorry.. Labour Not Found!'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Labour ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
    }
  }
  public function create_labour_wage_quick_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {
      $wage_duplication=$wage_success=$transaction_success=0;

      $data2['work_date'] = $data3['lw.work_date'] = date('Y-m-d',strtotime($this->post('work_date')));
      $data2['work_id'] = $this->post('work_id');
      if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
        $data3['lw.work_id'] = $data2['work_id'];
      }
      $data2['overtime_type'] = $this->config->item('Labour_wage_overtime_calculation');
      $data2['work_days'] = 1;
      $data2['no_of_labours'] = 1;
      if($this->post('remarks')){
        $data2['remarks'] = $this->post('remarks');
      }
      $data2['created_date'] = date('Y-m-d H:i:s');
      $data2['created_by'] = $this->post('user_id');
      if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $data2['entry_approval_status'] = 0;
      }
      $labours = json_decode($this->post('labours'), true);
      if (!empty($labours)) {
        for ($i = 0; $i < sizeof($labours); $i++) {
          $data3['lw.labour_id'] = $data2['labour_id'] = $labours[$i]['labour_id'];
          $data2['wage_per_day'] = $labours[$i]['basic_wage'];
          if(isset($labours[$i]['work_days'])){
            $data2['work_days'] = $labours[$i]['work_days'];
          }
          if($data2['overtime_type']=='hour'){
            $data2['overtime_hours'] = $labours[$i]['overtime_duration'];
            $data2['overtime_hourly_rate'] = $labours[$i]['overtime_rate'];
          }elseif(isset($labours[$i]['overtime_duration'])){
            $data2['overtime_hours'] = $labours[$i]['overtime_duration'];
            $data2['overtime_hourly_rate'] = $labours[$i]['overtime_rate'];
          }
          $data2['overtime_wage'] = $labours[$i]['overtime_wage'];
          $data2['total_wage'] = $data2['wage_per_day']+$data2['overtime_wage'];
          $count = $this->Labour_wages->select_labour_wages("",$data3)->num_rows();
          if($count==0) {
            $result2 = $this->Labour_wages->create_labour_wage($data2);
            $status = $result2['status'];
            if ($result2['status'] == 1) {
              $wage_success++;
            }
          }else{
            $wage_duplication++;
          }
        }
      }
      $responsemsg = $wage_success." Wage Slip Added.";
      if($wage_duplication>0){
        $responsemsg.=$wage_duplication." Wage Slip Not Added Because of Duplication.";
      }
      $message = [
        'status' => TRUE,
        'message' => $responsemsg
      ];
      $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
    }
  }
  public function create_labour_wage_group_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {
      $wage_duplication=$wage_success=$transaction_success=0;

      $data2['work_date'] = $data3['lw.work_date'] = date('Y-m-d',strtotime($this->post('work_date')));
      $data2['work_id'] = $this->post('work_id');
      if($this->config->item('Labour_wage_slip_allow_multiple_day_by_site')==1){
        $data3['lw.work_id'] = $data2['work_id'];
      }
      $data2['overtime_type'] = $this->config->item('Labour_wage_overtime_calculation');
      if($this->post('remarks')){
        $data2['remarks'] = $this->post('remarks');
      }
      $data2['created_date'] = date('Y-m-d H:i:s');
      $data2['created_by'] = $this->post('user_id');
      if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $data2['entry_approval_status'] = 0;
      }
      $labours = json_decode($this->post('labours'), true);
      if (!empty($labours)) {
        for ($i = 0; $i < sizeof($labours); $i++) {
          $data3['lw.labour_id'] = $data2['labour_id'] = $labours[$i]['labour_id'];
          $data2['work_days'] = $labours[$i]['work_days'];
          $data2['no_of_labours'] = $labours[$i]['no_of_labours'];
          $data2['wage_per_day'] = $labours[$i]['basic_wage'];
          $data2['overtime_wage'] = $labours[$i]['overtime_wage'];
          $data2['extra_wage'] = $labours[$i]['extra_wage'];
          $data2['ta_wage'] = $labours[$i]['ta_wage'];
          $data2['total_wage'] = ($data2['wage_per_day']*$data2['work_days']*$data2['no_of_labours'])+$data2['overtime_wage']+$data2['extra_wage']+$data2['ta_wage'];
          $count = $this->Labour_wages->select_labour_wages("",$data3)->num_rows();
          if($count==0) {
            $result2 = $this->Labour_wages->create_labour_wage($data2);
            $status = $result2['status'];
            if ($result2['status'] == 1) {
              $wage_success++;
            }
          }else{
            $wage_duplication++;
          }
        }
      }
      $responsemsg = $wage_success." Wage Slip Added.";
      if($this->post('paid_amount')>0){
        $account_heads_where['ah.delete_status'] = 0;
        $account_heads_where['ah.acc_user_id'] = $this->post('user_id');
        $account_heads_data	= $this->Account->select_account_heads("acc_head_id",$account_heads_where)->row();
        $transaction_data['tr_debit_acc'] = $account_heads_data->acc_head_id;

        $transaction_data['reference_id'] = $this->post('team_leader_id');
        $transaction_data['reference_type'] = "labour";
        $transaction_data['tr_type'] = "labour_transaction";
        $transaction_data['tr_date'] = date('Y-m-d',strtotime($this->post('paid_date')));
        // $transaction_data['tr_debit_acc'] = $this->post('debit_acc');
        $transaction_data['tr_credit_acc'] = 7;//labour wage payments
        $transaction_data['tr_description'] = "Labour Wage Transaction";
        $transaction_data['tr_amount'] = $this->post('paid_amount');
        $transaction_data['tr_mode'] = $this->post('payment_mode');
        // $transaction_data['tr_reference_no'] = $this->post('reference_no');
        // if($this->post('reference_date')!=''){
        //   $transaction_data['tr_reference_date'] = date('Y-m-d',strtotime($this->post('reference_date')));
        // }
        $transaction_data['tr_remarks'] = $this->post('payment_remarks');
        $transaction_data['created_date'] = date('Y-m-d H:i:s');
        $transaction_data['created_by'] = $this->post('user_id');
        if($this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $transaction_data['tr_entry_approval_status'] = 0;
        }
        $transaction_result =  $this->Account->create_account_transaction($transaction_data);
        $responsemsg .= 'Transaction Added Successfully!.';
      }
      if($wage_duplication>0){
        $responsemsg.=$wage_duplication." Wage Slip Not Added Because of Duplication.";
      }
      $message = [
        'status' => TRUE,
        'message' => $responsemsg
      ];
      $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
    }
  }
  public function select_labour_wages_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=$summary=array();
      $summary['total_present'] = 0;
      $summary['total_wage'] = 0;
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['lw.created_by'] = $user_id;
      if($this->get('work_id')){
        $data['lw.work_id'] = $this->get('work_id');
      }
      $labour_wages	= $this->Labour_wages->select_labour_wages("lw.*,wt.type_name,l.fixed_wage,l.labour_group,l.labour_name,wt.type_name,u.user_alias,wc.work_name",$data,"","","","","",$this->config->item('select_data_entry_approval'));
      if ($labour_wages->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($labour_wages->result() as $row):

          $message[$j]['wage_id']=$row->wage_id;
          $message[$j]['labour_name']=$row->labour_name;
          $message[$j]['labour_id']=$row->labour_id;
          $message[$j]['work_type']=$row->type_name;
          $message[$j]['work_date']=date('d-m-Y',strtotime($row->work_date));
          $message[$j]['work_name']=$row->work_name;
          $message[$j]['work_id']=$row->work_id;
          $message[$j]['fixed_wage_status']=$row->fixed_wage;
          $message[$j]['no_of_days']=(float)$row->work_days;
          $message[$j]['no_of_labours']=$row->no_of_labours;
          $message[$j]['wage_per_day']=$row->wage_per_day;
          $message[$j]['overtime_wage']=$row->overtime_wage;
          $message[$j]['overtime_duration']=$row->overtime_hours;
          $message[$j]['extra_wage']=$row->extra_wage;
          $message[$j]['total_wage']=(float)$row->total_wage;
          $message[$j]['remarks']=$row->remarks;
          $message[$j]['created_by']=$row->user_alias;
          $message[$j]['created_date']=date('d-m-Y',strtotime($row->created_date));
          $message[$j]['days_badge']='';
          $message[$j]['overtime_badge']='';
          if($this->config->item('Labour_wage_calculation_type')=='day'){
            if($row->work_days==1){
              $message[$j]['days_badge']='Full Day';
            }elseif($row->work_days==0.5){
              $message[$j]['days_badge']='Half Day';
            }
          }
          if($row->overtime_hours>0){
            $message[$j]['overtime_badge']='OT Added';
          }
          $message[$j]['entry_approval_status']=$row->entry_approval_status;
          if($this->config->item('Labour_wage_calculation_type')=='day' && $row->no_of_labours!=''){
            $summary['total_present'] += ((float)$row->work_days*(float)$row->no_of_labours);
          }else{
            $summary['total_present'] += (float)$row->no_of_labours;
          }
          $summary['total_wage'] += (float)$row->total_wage;

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $json_data['summary'] = $summary;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Wage Slips Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function select_labour_payments_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['ats.created_by'] = $user_id;
      $data['ats.reference_type'] = 'labour';
      $data['ats.tr_type'] = 'labour_transaction';
      $labour_payments	= $this->Account->select_account_transaction("ats.*,l.labour_name,wt.type_name,l.labour_group,l.labour_id,ah1.acc_head_name as debit_account,u1.user_alias as created_user",$data,'labour','','','',$this->config->item('select_data_entry_approval'));
      if ($labour_payments->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($labour_payments->result() as $row):

          $message[$j]['transaction_id']=$row->transaction_id;
          $message[$j]['labour_name']=$row->labour_name;
          $message[$j]['labour_id']=$row->labour_id;
          $message[$j]['tr_amount']=$row->tr_amount;
          $message[$j]['debit_account']=$row->debit_account;
          $message[$j]['tr_mode']=$row->tr_mode;
          $message[$j]['tr_remarks']=$row->tr_remarks;
          $message[$j]['created_by']=$row->created_user;
          $message[$j]['tr_date']=date('d-m-Y',strtotime($row->tr_date));
          $message[$j]['created_date']=date('d-m-Y',strtotime($row->created_date));
          $message[$j]['debit_acc_id']=$row->tr_debit_acc;
          $message[$j]['entry_approval_status']=$row->tr_entry_approval_status;

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Labour Payments Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }


  public function create_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {

      $data['work_id'] = $this->post('work_id');
      $data['report_date'] = date('Y-m-d');
      $data['title'] = $this->post('title');
      $data['description'] = $this->post('description');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      $data['labour_id'] = $this->post('labour_id');
      $data['report_type'] = 'labour';

      $result =  $this->Daily_reports->create_labour_report($data);
      if($result['status'] == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Labour Activity Submitted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function update_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL && $this->post('report_id')!="" && $this->post('report_id') !== NULL) {

      $data['report_id'] = $this->post('report_id');
      $data['description'] = $this->post('description');
      $data['title'] = $this->post('title');
      if($this->post('labour_id')){
        $data['labour_id'] = $this->post('labour_id');
      }
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');

      $result =  $this->Daily_reports->update_labour_report($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Labour Activity Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('report_id')!="" && $this->post('report_id') !== NULL) {

      $data['report_id'] = $this->post('report_id');
      $data['delete_status'] = 1;
      $result =  $this->Daily_reports->update_labour_report($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Labour Activity Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Report ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function select_activities_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dr.created_by'] = $user_id;
      $data['dr.report_type'] = 'labour';
      if($this->get('work_id')){
        $data['dr.work_id'] = $this->get('work_id');
      }
      if($this->get('labour_id')){
        $data['dr.labour_id'] = $this->get('labour_id');
      }
      $labour_report	= $this->Daily_reports->select_labour_report("dr.*,l.labour_name,wt1.type_name,u.user_alias as created_user,wc.work_id,wc.work_name",$data);
      if ($labour_report->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($labour_report->result() as $row):

          $message[$j]['report_id'] = $row->report_id;
          $message[$j]['work_name'] = $row->work_name;
          $message[$j]['labour_name'] = $row->labour_name;
          $message[$j]['labour_id'] = $row->labour_id;
          $message[$j]['work_type'] = $row->type_name;
          $message[$j]['date'] = date('d-m-Y',strtotime($row->report_date));
          $message[$j]['title'] = $row->title;
          $message[$j]['description'] = $row->description;
          $message[$j]['created_by'] = $row->created_user;
          $message[$j]['created_date'] = date('d-m-Y',strtotime($row->created_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Daily Labour Reports Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

}
