<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Hr extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Labour_model', 'Labour');
    $this->load->model('Labour_wages_model', 'Labour_wages');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Bills_model', 'Bills');
    $this->load->library('Bills_management','bills_management');
    $this->load->model('Subcontracts_model', 'Subcontracts');
    $this->load->model('Daily_reports_model', 'Daily_reports');
    $this->load->model('Employees_model', 'Employee');
  }
  public function index_get()
  {

  }

  public function select_employees_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      $user_id = $this->get('user_id');
      $employees	= $this->Employee->select_employee("e.*,u.user_alias",$data);
      $attendance_where['ea.attendance_date'] = date('Y-m-d');
      $attendance = $this->Employee->select_employee_attendance("ea.employee_id",$attendance_where)->result();
      $empoloyees_attendance_marked = array();
      foreach ($attendance as $key => $value) {
        $empoloyees_attendance_marked[] = $value->employee_id;
      }
      if ($employees->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($employees->result() as $row):
          if (!in_array( $row->employee_id,$empoloyees_attendance_marked)) {
            $message[$j]['employee_id'] = $row->employee_id;
            $message[$j]['employee_name'] = $row->employee_name;
            $message[$j]['designation'] = $row->user_designation;
            $message[$j]['phone'] = $row->phone_no;
            $message[$j]['basic_wage'] = $row->basic_wage;
            $message[$j]['basic_wage_type'] = $row->basic_wage_type;
            $message[$j]['basic_wage_fixed'] = $row->basic_wage_fixed;

            $j++;
          }
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Registered Employees Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_attendance_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {
      $wage_duplication=$wage_success=$transaction_success=0;
      $success = $duplicate = 0;
      $data['visit_date'] = $data_where['esv.visit_date'] = date('Y-m-d');
      $data['project_id'] = $data_where['esv.project_id'] = $this->post('work_id');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      $employees = json_decode($this->post('employees'), true);
      if (!empty($employees)) {
        for ($i = 0; $i < sizeof($employees); $i++) {
          $data['employee_id'] = $data_where['esv.employee_id'] = $employees[$i]['employee_id'];
          // check already Created
          $count = $this->Employee->select_employee_site_vist("esv.visit_id",$data_where)->num_rows();
          if($count==0){
            $result = $this->Employee->create_employee_site_vist($data);
            $success++;
          }else{
            $duplicate++;
          }
        }
      }
      $msg='';
      if($success>0){
        $msg.= $success.' Employees Site Visit Added Successfully.';
      }
      if($duplicate>0){
        $msg.= $duplicate.' Employees Site Visit Not Added (Already Exist).';
      }
      $message = [
        'status' => TRUE,
        'message' => $msg
      ];
      $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // NOT_FOUND (400) being the HTTP response code
    }
  }
  public function select_attedance_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      $data['esv.created_by'] = $this->get('user_id');
      $data['esv.project_id'] = $this->get('work_id');
      $data['esv.visit_date'] = date('Y-m-d');
      $employee_site_visit	= $this->Employee->select_employee_site_vist("esv.*,e.employee_name,e.user_designation,wc.work_name,u.user_alias",$data);
      if ($employee_site_visit->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($employee_site_visit->result() as $row):

          $message[$j]['employee_id'] = $row->employee_id;
          $message[$j]['employee_name'] = $row->employee_name;
          $message[$j]['designation'] = $row->user_designation;
          $message[$j]['project_name'] = $row->work_name;
          $message[$j]['date'] = date('d-m-Y',strtotime($row->visit_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Site Visits Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
