<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Enquiries extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model','User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Customers_model','Customers');
    $this->load->model('Enquiries_model','Enquiries');
    $this->load->model('Services_model','Services');
    $this->load->model('Employees_model', 'Employee');
  }
  public function index_get()
  {
    //     Default Method
    $this->select_get();
  }

  public function select_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        // $data['e.created_by'] = $user_id;
        $enquiries	= $this->Enquiries->select_enquiries("*,e.created_date as e_created_date,u2.user_alias",$data);
        if ($enquiries->num_rows() > 0) {
          $message = array();
          $j = 0;
          foreach ($enquiries->result() as $row):


            $message[$j]['enquiry_id'] = $row->enquiry_id;
            $message[$j]['customer_name'] = $row->customer_name;
            $message[$j]['customer_phone'] = $row->customer_phone;
            $message[$j]['customer_location'] = $row->customer_location;
            $message[$j]['enquiry_date'] = date('d-m-Y',strtotime($row->enquiry_date));
            $message[$j]['service_name'] = $row->service_name;
            $message[$j]['remarks'] = $row->remarks;
            $message[$j]['enquiry_status'] = $row->enquiry_status;
            $message[$j]['enquiry_status_name'] = $row->enquiry_status;
            $message[$j]['created_by'] = $row->user_alias;
            $message[$j]['created_date'] = date('d-m-Y',strtotime($row->e_created_date));

            $j++;
          endforeach;
          $json_data['status'] = TRUE;
          $json_data['data'] = $message;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'No Enquiries Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function select_details_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('enquiry_id')!="" && $this->get('enquiry_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$user_id));
      if ($employee_data->num_rows() == 1) {
        $data['e.enquiry_id'] = $this->get('enquiry_id');
        $enquiries	= $this->Enquiries->select_enquiries("e.*,c.*,tsc.*,s.*,e.created_date as e_created_date,u2.user_alias",$data);
        if ($enquiries->num_rows()==1) {
          $message = array();
          $j = 0;
          $row = $enquiries->row();

          $message['enquiry_id'] = $row->enquiry_id;
          $message['customer_id'] = $row->customer_id;
          $message['customer_name'] = $row->customer_name;
          $message['customer_phone'] = $row->customer_phone;
          $message['customer_location'] = $row->customer_location;
          $message['customer_email'] = $row->customer_email;
          $message['sale_price_category'] = $this->config->item('Material_sale_price'.$row->sale_price_category.'_name');
          $message['sale_price_category_id'] = $row->sale_price_category;
          $message['customer_tax_no'] = $row->customer_tax_no;
          $message['customer_tax_state'] = $row->state_code.'-'.$row->state_name;
          $message['enquiry_date'] = date('d-m-Y',strtotime($row->enquiry_date));
          $message['service_name'] = $row->service_name;
          $message['service_id'] = $row->service_id;
          $message['remarks'] = $row->remarks;
          $message['enquiry_status'] = $row->enquiry_status;
          $message['enquiry_status_name'] = $row->enquiry_status;
          $message['created_by'] = $row->user_alias;
          $message['created_date'] = date('d-m-Y',strtotime($row->e_created_date));

          // Call Responses
          $enquiry_responses_where['er.enquiry_id'] = $row->enquiry_id;
          $message['enquiry_responses'] = $this->Enquiries->select_enquiry_responses("er.*,u.user_alias as created_by",$enquiry_responses_where)->result_array();

          // Followups
          $enquiry_followups_where['ef.enquiry_id'] = $row->enquiry_id;
          $message['enquiry_followups'] = $this->Enquiries->select_enquiry_followups("ef.*,DATE_FORMAT(followup_date,'%d-%m-%Y') AS followup_date,u.user_alias as created_by",$enquiry_followups_where)->result_array();

          $json_data['status'] = TRUE;
          $json_data['data'] = $message;
          $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'Enquiry Details Not Found'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
        }
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Enquiry ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  public function create_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL ) {
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$this->post('user_id')));
      if ($employee_data->num_rows() == 1) {
        if ($employee_data->row()->branch_id != 0) {
          $data['branch_id'] = $enquiry_where['branch_id']=$employee_data->row()->branch_id;
        }
        $data['enquiry_date']=$enquiry_where['enquiry_date']=date('Y-m-d', strtotime($this->post('enquiry_date')));
        $data['customer_id']=$enquiry_where['e.customer_id']=$this->post('customer_id');
        $data['service']=$enquiry_where['service']=$this->post('service');
        $count = $this->Enquiries->select_enquiries("*",$enquiry_where)->num_rows();
        if($count == 0) {

          $data['enquiry_status'] = $this->post('status');
          $data['remarks'] = $this->post('remarks');
          $data['created_date'] = date('Y-m-d H:i:s');
          $data['created_by'] = $this->post('user_id');
          $result = $this->Enquiries->insert_enquiry($data);
          if($result['status'] == 1) {
            $message = [
              'status' => TRUE,
              'message' => 'Enquiry Added Successfully'
            ];
            $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
          }else {
            $message = [
              'status' => FALSE,
              'message' => 'There Has Been Some Error Occurred'
            ];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
          }
        }else{
          $message = [
            'status' => FALSE,
            'message' => 'Enquiry With Same Customer & Service Already Exist on Selected Day'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('enquiry_id')!="" && $this->post('enquiry_id') !== NULL) {

      $data['enquiry_date']=$enquiry_where['enquiry_date']=date('Y-m-d', strtotime($this->post('enquiry_date')));
      $data['customer_id']=$enquiry_where['e.customer_id']=$this->post('customer_id');
      $data['service']=$enquiry_where['service']=$this->post('service');
      $data['enquiry_id'] = $enquiry_where['enquiry_id !='] = $this->post('enquiry_id');
      $count = $this->Enquiries->select_enquiries("",$enquiry_where)->num_rows();
      if($count == 0) {

        $data['enquiry_status'] = $this->post('status');
        $data['remarks'] = $this->post('remarks');
        $data['updated_date'] = date('Y-m-d H:i:s');
        $data['updated_by'] = $this->post('user_id');
        $result = $this->Enquiries->update_enquiry($data);

        if($result == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Enquiry Updated Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'Enquiry With Same Customer & Service Already Exist on Selected Day'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Enquiry ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_customer_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL ) {
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$this->post('user_id')));
      if ($employee_data->num_rows() == 1) {
        if ($employee_data->row()->branch_id != 0) {
          $data['branch_id'] = $customer_where['branch_id']=$employee_data->row()->branch_id;
        }
        $data['customer_phone']=$customer_where['customer_phone']=$this->post('phone');
        $count = $this->Customers->select_customer("",$customer_where)->num_rows();
        if($count == 0) {
          $data['customer_name'] = $this->post('name');
          $data['customer_location'] = $this->post('location');
          $data['customer_email'] = $this->post('email');
          if($this->post('taxno')){
            $data['customer_tax_no'] = $this->post('taxno');
          }
          if($this->post('state')){
            $data['customer_tax_state'] = $this->post('state');
          }
          if($this->post('sale_price_category')){
            $data['sale_price_category'] = $this->post('sale_price_category');
          }
          $data['created_date'] = date('Y-m-d H:i:s');
          $data['created_by'] = $this->post('user_id');
          $result = $this->Customers->create_customer($data);
          if($result['status'] == 1) {
            $message = [
              'status' => TRUE,
              'message' => 'Enquiry Added Successfully'
            ];
            $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
          }else {
            $message = [
              'status' => FALSE,
              'message' => 'There Has Been Some Error Occurred'
            ];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
          }
        }else{
          $message = [
            'status' => FALSE,
            'message' => 'Customer With Same Mobile Already Exist'
          ];
          $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_response_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('enquiry_id')!="" && $this->post('enquiry_id') !== NULL ) {
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$this->post('user_id')));
      if ($employee_data->num_rows() == 1) {
        $data['enquiry_id'] = $this->post('enquiry_id');
        $data['response'] = $this->post('response');
        $data['created_date'] = date('Y-m-d H:i:s');
        $data['created_by'] = $this->post('user_id');
        $result = $this->Enquiries->insert_enquiry_response($data);
        if($result['status'] == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Enquiry Reponse Added Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Enquiry ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_response_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('response_id')!="" && $this->post('response_id') !== NULL ) {
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$this->post('user_id')));
      if ($employee_data->num_rows() == 1) {
        $data['response_id'] = $this->post('response_id');
        $data['response'] = $this->post('response');
        $result = $this->Enquiries->update_enquiry_response($data);
        if($result == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Enquiry Response Updated Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Response ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_followup_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('enquiry_id')!="" && $this->post('enquiry_id') !== NULL ) {
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$this->post('user_id')));
      if ($employee_data->num_rows() == 1) {
        $data['enquiry_id'] = $this->post('enquiry_id');
        $data['followup_date'] = date('Y-m-d H:i',strtotime($this->post('date')));
        $data['remarks'] = $this->post('remarks');
        $data['created_date'] = date('Y-m-d H:i:s');
        $data['created_by'] = $this->post('user_id');
        $result = $this->Enquiries->insert_enquiry_followup($data);
        if($result['status'] == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Enquiry Followup Added Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Enquiry ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_followup_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('followup_id')!="" && $this->post('followup_id') !== NULL ) {
      $employee_data	= $this->Employee->select_employee("e.*",array("e.user_id"=>$this->post('user_id')));
      if ($employee_data->num_rows() == 1) {
        $data['followup_id'] = $this->post('followup_id');
        $data['followup_status'] = $this->post('status');
        $data['remarks'] = $this->post('remarks');
        $data['updated_date'] = date('Y-m-d H:i:s');
        $data['updated_by'] = $this->post('user_id');
        $result = $this->Enquiries->update_enquiry_followup($data);
        if($result == 1) {
          $message = [
            'status' => TRUE,
            'message' => 'Enquiry Followup Updated Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        }else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
      }else{
        $message = [
          'status' => FALSE,
          'message' => 'User Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Response ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
