<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Documents extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Documents_model', 'Documents');
    $this->load->library('Projects_management','projects_management');
  }
  public function index_get()
  {
    //     Default Method
    $this->select_get();
  }


  public function select_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['pd.work_id'] = $this->get('work_id');
      $data['pd.visibility'] = 1;
      $documents	= $this->Documents->select_documents("*,pd.created_date AS pd_created_date,pd.created_by AS pd_created_by",$data);
      if ($documents->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($documents->result() as $row):

          $message[$j]['id'] = $row->id;
          $message[$j]['title'] = $row->title;
          $message[$j]['description'] = $row->description;
          $message[$j]['file'] = $row->filename;
          // $message[$j]['file_type'] = mime_content_type(base_url().'uploads/documents/'.$row->filename);
          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Documents Found For This Project'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

}
