<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Daily_task extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");


    //      Load Models
    $this->load->model('User_model','User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Daily_tasks_model', 'Daily_tasks');
    $this->load->model('Daily_reports_model', 'Daily_reports');
    $this->load->library('Projects_management','projects_management');
  }
  public function index_get()
  {
    //     Default Method
    $this->tasks_get();
  }

  //  Daily Task
  public function tasks_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dt.user_id'] = $user_id;
      if($this->get('project_id')){
        $data['dt.work_id'] = $this->get('project_id');
      }
      $tasks	= $this->Daily_tasks->select("dt.*,u2.user_alias as created_user,u1.user_alias as assigned_to,wc.work_id,wc.work_name",$data);
      if ($tasks->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($tasks->result() as $row):

          if($row->task_status==1){
            $task_status="Completed";
          }elseif($row->task_status==2){
            $task_status="In Progress";
          }else{
            $task_status="Pending";
          }
          $message[$j]['task_id'] = $row->task_id;
          $message[$j]['work_id'] = $row->work_id;
          $message[$j]['work_name'] = $row->work_name;
          $message[$j]['task_title'] = $row->task_title;
          $message[$j]['task_status'] = $task_status;
          $message[$j]['due_date'] = date('d-m-Y',strtotime($row->task_due_date));
          $message[$j]['task_description'] = $row->task_description;
          $message[$j]['created_by'] = $row->created_user;
          $message[$j]['created_date'] = date('d-m-Y',strtotime($row->created_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Assigned Tasks Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  //  Daily Task Details
  public function task_details_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('task_id')!="" && $this->get('task_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dt.user_id'] = $user_id;
      $data['dt.task_id'] = $this->get('task_id');
      $tasks	= $this->Daily_tasks->select("dt.*,u2.user_alias as created_user,u1.user_alias as assigned_to,wc.work_id,wc.work_name",$data);
      if ($tasks->num_rows() == 1) {
        $message = array();
        $j = 0;
        $task_data = $tasks->row();
        if($task_data->task_status==1){
          $task_status="Completed";
        }elseif($task_data->task_status==2){
          $task_status="In Progress";
        }else{
          $task_status="Pending";
        }
        $activities = array();
        $task_activites = $this->Daily_reports->select_task_report('dr.*,u.user_alias,wc.work_id,wc.work_name',array('dr.task_id'=>$task_data->task_id))->result();
        foreach ($task_activites as $key => $value) {
          $activities[$j]['activity_id'] = $value->report_id;
          $activities[$j]['task_id'] = $value->task_id;
          $activities[$j]['activity_date'] = date('d-m-Y',strtotime($value->report_date));
          $activities[$j]['description'] = $value->description;
          $activities[$j]['created_by'] = $value->user_alias;
          $activities[$j]['created_date'] = date('d-m-Y',strtotime($value->created_date));

          $j++;
        }
        $message = [
          'status' => TRUE,
          'task_id' => $task_data->task_id,
          'title' => $task_data->task_title,
          'task_status' => $task_status,
          'work_name' => $task_data->work_name,
          'due_date' =>  date('d-m-Y',strtotime($task_data->task_due_date)),
          'task_description' => $task_data->task_description,
          'created_by' => $task_data->created_user,
          'created_date' => date('d-m-Y',strtotime($task_data->created_date)),
          'message' => 'Task Details Retrieved Successfully',
          'activities' => $activities,
        ];
        $this->set_response($message, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'Task Details Not Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  //  Add Activity
  public function add_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('task_id')!="" && $this->post('task_id') !== NULL) {

      $data['task_id'] = $this->post('task_id');
      $data['report_date'] = date('Y-m-d',strtotime($this->post('activity_date')));
      $data['description'] = $this->post('description');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');

      $result =  $this->Daily_reports->create_task_report($data);
      if($result['status'] == 1) {

        $actvity_data['user_id'] = $this->post('user_id');
        $actvity_data['activity_type'] = 'Daily Activity';
        $actvity_data['activity_through'] = 'Mobile App';
        $actvity_data['activity_date'] = $data['created_date'];
        $actvity_data['activity_description'] = 'Daily Task Activity';
        $actvity_data['activity_location_address'] = $this->post('address');
        // $actvity_data['activity_location_landmark'] = $this->post('landmark');
        $actvity_data['activity_location_latitude'] = $this->post('latitude');
        $actvity_data['activity_location_longitude'] = $this->post('longitude');
        $actvity_data['reference_id'] = $result['insert_id'];
        $result2 = $this->User->insert_activity($actvity_data);

        $update_data['activity_id'] = $result2['insert_id'];
        $update_data['report_id'] = $result['insert_id'];
        $this->Daily_reports->update_task_report($update_data);

        $message = [
          'status' => TRUE,
          'message' => 'Task Activity Added Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('activity_id')!="" && $this->post('activity_id') !== NULL) {

      $data['report_id'] = $this->post('activity_id');
      $data['report_date'] = date('Y-m-d',strtotime($this->post('activity_date')));
      $data['description'] = $this->post('description');
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');

      $result =  $this->Daily_reports->update_task_report($data);
      if($result == 1) {

        $message = [
          'status' => TRUE,
          'message' => 'Task Activity Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Activity ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_activity_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('activity_id')!="" && $this->post('activity_id') !== NULL) {

      $data['report_id'] = $this->post('activity_id');
      $data['delete_status'] = 1;

      $result =  $this->Daily_reports->update_task_report($data);
      if($result == 1) {

        $message = [
          'status' => TRUE,
          'message' => 'Task Activity Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Activity ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  // Update Status
  public function update_status_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('task_id')!="" && $this->post('task_id') !== NULL) {

      $data['task_id'] = $this->post('task_id');
      $data['task_status'] = $this->post('status');
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');

      $result =  $this->Daily_tasks->update($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Task Status Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Task ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

}
