<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Daily_report extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model','User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Daily_reports_model', 'Daily_reports');
    $this->load->library('Projects_management','projects_management');
  }
  public function index_get()
  {
    //     Default Method
    $this->subcontract_reports_get();
  }
  //  Labour Report
  public function labour_reports_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dr.created_by'] = $user_id;
      $data['dr.report_type'] = 'labour';
      if($this->get('work_id')){
        $data['dr.work_id'] = $this->get('work_id');
      }
      $labour_report	= $this->Daily_reports->select_labour_report("dr.*,l.labour_name,wt1.type_name,u.user_alias as created_user,wc.work_id,wc.work_name",$data);
      if ($labour_report->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($labour_report->result() as $row):

          $message[$j]['report_id'] = $row->report_id;
          $message[$j]['work_name'] = $row->work_name;
          $message[$j]['labour_name'] = $row->labour_name;
          $message[$j]['work_type'] = $row->type_name;
          $message[$j]['date'] = date('d-m-Y',strtotime($row->report_date));
          $message[$j]['description'] = $row->description;
          $message[$j]['created_by'] = $row->created_user;
          $message[$j]['created_date'] = date('d-m-Y',strtotime($row->created_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Daily Labour Reports Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  // Subcontract Report
  public function subcontract_reports_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL && $this->get('work_id')!="" && $this->get('work_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dr.created_by'] = $user_id;
      $data['dr.report_type'] = 'subcontract';
      if($this->get('work_id')){
        $data['dr.work_id'] = $this->get('work_id');
      }
      $subcontract_report	= $this->Daily_reports->select_labour_report("dr.*,sc.contract_id,sc.contractor,sc.sub_work_name,wt2.type_name,u.user_alias as created_user,wc.work_id,wc.work_name",$data);
      if ($subcontract_report->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($subcontract_report->result() as $row):

          $message[$j]['report_id'] = $row->report_id;
          $message[$j]['work_name'] = $row->work_name;
          $message[$j]['contractor'] = $row->contractor;
          $message[$j]['contract_id'] = $row->contract_id;
          $message[$j]['work_type'] = $row->type_name;
          $message[$j]['sub_work_name'] = $row->sub_work_name;
          $message[$j]['date'] = date('d-m-Y',strtotime($row->report_date));
          $message[$j]['title'] = $row->title;
          $message[$j]['description'] = $row->description;
          $message[$j]['created_by'] = $row->created_user;
          $message[$j]['created_date'] = date('d-m-Y',strtotime($row->created_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Daily Subcontract Reports Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function create_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('work_id')!="" && $this->post('work_id') !== NULL) {

      $data['work_id'] = $this->post('work_id');
      $data['title'] = $this->post('title');
      $data['report_date'] = date('Y-m-d');
      $data['description'] = $this->post('description');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');
      $data['report_type'] = $this->post('report_type');
      if($this->post('report_type')=='labour'){
        $data['labour_id'] = $this->post('id');
        $success_msg = 'Labour Report Submitted Successfully';
      }else{
        $data['subcontract_id'] = $this->post('id');
        $success_msg = 'Subcontract Report Submitted Successfully';
      }

      $result =  $this->Daily_reports->create_labour_report($data);
      if($result['status'] == 1) {
        $message = [
          'status' => TRUE,
          'message' => $success_msg
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function update_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('report_id')!="" && $this->post('report_id') !== NULL) {

      $data['report_id'] = $this->post('report_id');
      $data['title'] = $this->post('title');
      $data['description'] = $this->post('description');
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');
      $data['report_type'] = $this->post('report_type');
      if($this->post('report_type')=='labour'){
        $success_msg = 'Labour Report Updated Successfully';
      }else{
        $success_msg = 'Subcontract Report Updated Successfully';
      }

      $result =  $this->Daily_reports->update_labour_report($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => $success_msg
        ];
        $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Report ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('report_id')!="" && $this->post('report_id') !== NULL) {

      $data['report_id'] = $this->post('report_id');
      $data['delete_status'] = 1;
      $result =  $this->Daily_reports->update_labour_report($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Report Deleted Succesfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_OK); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Report ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  //  Daily Progress Report
  public function progress_reports_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dpr.created_by'] = $user_id;
      if($this->get('work_id')){
        $data['dpr.work_id'] = $this->get('work_id');
      }
      $progress_reports	= $this->Daily_reports->select_daily_progress_report("dpr.*,u.user_alias as created_user,wc.work_id,wc.work_name",$data);
      if ($progress_reports->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($progress_reports->result() as $row):

          $message[$j]['report_id'] = $row->report_id;
          $message[$j]['title'] = $row->title;
          $message[$j]['work_name'] = $row->work_name;
          $message[$j]['report_date'] = date('d-m-Y',strtotime($row->report_date));
          $message[$j]['description'] = $row->description;
          $message[$j]['image'] = $row->image;
          $message[$j]['created_by'] = $row->created_user;
          $message[$j]['created_date'] = date('d-m-Y',strtotime($row->created_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Daily Progress Reports Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  //  Add Note
  public function create_progress_report_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL ) {

      $data['report_date'] = date('Y-m-d');
      $data['title'] = $this->post('title');
      $data['description'] = $this->post('description');
      if($this->post('work_id')){
        $data['work_id'] = $this->post('work_id');
        $data['project_stage_id'] = $this->projects_management->get_project_stage_id($data['work_id']);
      }
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');

      $files = array();
      if($this->post('image') && $this->post('image')!=''){
        $files[0] = date('dmY-His') . '.png';
        $Image1_Data = $this->post('image');
        $Image1_Path = "uploads/daily_notes/".$files[0];
        file_put_contents($Image1_Path,base64_decode($Image1_Data));
      }
      if($this->post('image2') && $this->post('image2')!=''){
        $files[1] = date('dmY-His') . '-2.png';
        $Image2_Data = $this->post('image2');
        $Image2_Path = "uploads/daily_notes/".$files[1];
        file_put_contents($Image2_Path,base64_decode($Image2_Data));
      }
      if($this->post('image3') && $this->post('image3')!=''){
        $files[2] = date('dmY-His') . '-3.png';
        $Image3_Data = $this->post('image3');
        $Image3_Path = "uploads/daily_notes/".$files[2];
        file_put_contents($Image3_Path,base64_decode($Image3_Data));
      }
      $data['image'] = implode(',',$files);

      $result =  $this->Daily_reports->create_daily_progress_report($data);
      if($result['status'] == 1) {

        if($this->post('address')){
          $actvity_data['user_id'] = $this->post('user_id');
          $actvity_data['activity_type'] = 'Daily Progress Report';
          $actvity_data['activity_through'] = 'Mobile App';
          $actvity_data['activity_date'] = $data['created_date'];
          $actvity_data['activity_description'] = 'Daily Progress Report Activity';
          $actvity_data['activity_location_address'] = $this->post('address');
          // $actvity_data['activity_location_landmark'] = $this->post('landmark');
          $actvity_data['activity_location_latitude'] = $this->post('latitude');
          $actvity_data['activity_location_longitude'] = $this->post('longitude');
          $actvity_data['reference_id'] = $result['insert_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['activity_id'] = $result2['insert_id'];
          $update_data['report_id'] = $result['insert_id'];
          $this->Daily_reports->update_daily_progress_report($update_data);
        }

        $message = [
          'status' => TRUE,
          'message' => 'Progress Report Added Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  //  Update Note
  public function update_progress_report_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('report_id')!="" && $this->post('report_id') !== NULL) {

      $data['title'] = $this->post('title');
      $data['description'] = $this->post('description');
      $data['report_id'] = $this->post('report_id');
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');

      $result =  $this->Daily_reports->update_daily_progress_report($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Progress Report Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Report ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function delete_progress_report_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('report_id')!="" && $this->post('report_id') !== NULL) {

      $data['report_id'] = $this->post('report_id');
      $data['delete_status'] = 1;
      $result =  $this->Daily_reports->update_daily_progress_report($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Report Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Report ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
