<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Daily_note extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model','User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Daily_reports_model', 'Daily_reports');
    $this->load->library('Projects_management','projects_management');
  }
  public function index_get()
  {
    //     Default Method
    $this->notes_get();
  }

  //  Daily Notes
  public function notes_get()
  {
    if($this->get('user_id')!="" && $this->get('user_id') !== NULL) {

      $data=array();
      //          Select Assigned Tasks Only
      $user_id = $this->get('user_id');
      $data['dn.created_by'] = $user_id;
      if($this->get('work_id')){
        $data['dn.work_id'] = $this->get('work_id');
      }else{
        $data['dn.work_id'] = 0;
      }
      $notes	= $this->Daily_reports->select_daily_notes("dn.*,u.user_alias as created_user,wc.work_id,wc.work_name",$data);
      if ($notes->num_rows() > 0) {
        $message = array();
        $j = 0;
        foreach ($notes->result() as $row):

          $message[$j]['note_id'] = $row->note_id;
          $message[$j]['title'] = $row->title;
          $message[$j]['work_name'] = $row->work_name;
          $message[$j]['note_date'] = date('d-m-Y',strtotime($row->note_date));
          $message[$j]['description'] = $row->description;
          $message[$j]['image'] = $row->image;
          $message[$j]['created_by'] = $row->created_user;
          $message[$j]['created_date'] = date('d-m-Y',strtotime($row->created_date));

          $j++;
        endforeach;
        $json_data['status'] = TRUE;
        $json_data['data'] = $message;
        $this->set_response($json_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
      } else {
        $message = [
          'status' => FALSE,
          'message' => 'No Daily Notes Found'
        ];
        $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // 400
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  //  Add Note
  public function create_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL ) {

      $data['note_date'] = date('Y-m-d');
      $data['title'] = $this->post('title');
      $data['description'] = $this->post('description');
      if($this->post('work_id')){
        $data['work_id'] = $this->post('work_id');
        $data['project_stage_id'] = $this->projects_management->get_project_stage_id($data['work_id']);
      }
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $this->post('user_id');

      $files = array();
      if($this->post('image') && $this->post('image')!=''){
        $files[0] = date('dmY-His') . '.png';
        $Image1_Data = $this->post('image');
        $Image1_Path = "uploads/daily_notes/".$files[0];
        file_put_contents($Image1_Path,base64_decode($Image1_Data));
      }

      if($this->post('image2') && $this->post('image2')!=''){
        $files[1] = date('dmY-His') . '-2.png';
        $Image2_Data = $this->post('image2');
        $Image2_Path = "uploads/daily_notes/".$files[1];
        file_put_contents($Image2_Path,base64_decode($Image2_Data));
      }
      if($this->post('image3') && $this->post('image3')!=''){
        $files[2] = date('dmY-His') . '-3.png';
        $Image3_Data = $this->post('image3');
        $Image3_Path = "uploads/daily_notes/".$files[2];
        file_put_contents($Image3_Path,base64_decode($Image3_Data));
      }

      $data['image'] = implode(',',$files);

      $result =  $this->Daily_reports->create_daily_note($data);
      if($result['status'] == 1) {

        if($this->post('address')){
          $actvity_data['user_id'] = $this->post('user_id');
          $actvity_data['activity_type'] = 'Daily Note';
          $actvity_data['activity_through'] = 'Mobile App';
          $actvity_data['activity_date'] = $data['created_date'];
          $actvity_data['activity_description'] = 'Daily Note Activity';
          $actvity_data['activity_location_address'] = $this->post('address');
          // $actvity_data['activity_location_landmark'] = $this->post('landmark');
          $actvity_data['activity_location_latitude'] = $this->post('latitude');
          $actvity_data['activity_location_longitude'] = $this->post('longitude');
          $actvity_data['reference_id'] = $result['insert_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['activity_id'] = $result2['insert_id'];
          $update_data['note_id'] = $result['insert_id'];
          $this->Daily_reports->update_daily_note($update_data);
        }

        $message = [
          'status' => TRUE,
          'message' => 'Note Added Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  //  Update Note
  public function update_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('note_id')!="" && $this->post('note_id') !== NULL) {

      $data['title'] = $this->post('title');
      $data['description'] = $this->post('description');
      $data['note_id'] = $this->post('note_id');
      $data['updated_date'] = date('Y-m-d H:i:s');
      $data['updated_by'] = $this->post('user_id');

      $result =  $this->Daily_reports->update_daily_note($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Note Updated Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Note ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  // Delete Note
  public function delete_post()
  {
    if($this->post('user_id')!="" && $this->post('user_id') !== NULL && $this->post('note_id')!="" && $this->post('note_id') !== NULL) {

      $data['note_id'] = $this->post('note_id');
      $data['delete_status'] = 1;
      $result =  $this->Daily_reports->update_daily_note($data);
      if($result == 1) {
        $message = [
          'status' => TRUE,
          'message' => 'Note Deleted Successfully'
        ];
        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
      }else {
        $message = [
          'status' => FALSE,
          'message' => 'There Has Been Some Error Occurred'
        ];
        $this->response($message, REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Note ID Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
