<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require APPPATH . 'libraries/REST_Controller.php';

class Attendance extends REST_Controller {

  function __construct()
  {
    parent::__construct();
    // Construct the parent class
    header('Content-type: application/json');
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
      die();
    }

    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    ini_set("allow_url_fopen", "1");
    

    //      Load Models
    $this->load->model('User_model','User');
    $this->load->model('Attendance_model','Attendance');
  }
  public function index_post()
  {
    //     Default Method
    $this->attendance_post();
  }

  //  Attendance
  public function attendance_post()
  {
    if($this->post('user_id')!="" && $this->post('attendance')!="" ) {

      $data['user_id'] = $this->post('user_id');
      $data['attendance_date'] = date('Y-m-d');
      $data['attendance_status'] = $this->post('attendance');
      $data['signed_in_time'] = date('H:i:s');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $data['user_id'];

      $actvity_data['user_id'] = $data['user_id'];
      $actvity_data['activity_type'] = 'Attendance';
      $actvity_data['activity_through'] = 'Mobile App';
      $actvity_data['activity_date'] = $data['created_date'];
      if($data['attendance_status']==1){
        $actvity_data['activity_description'] = 'Signed In';
      }else{
        $actvity_data['activity_description'] = 'Marked as Leave';
      }
      $actvity_data['activity_location_address'] = $this->post('address');
      $actvity_data['activity_location_landmark'] = $this->post('landmark');
      $actvity_data['activity_location_latitude'] = $this->post('latitude');
      $actvity_data['activity_location_longitude'] = $this->post('longitude');
      if($this->post('device')){
        $actvity_data['activity_device'] = $this->post('device');
      }
      //          Check Already Exist
      $where['uat.user_id'] = $data['user_id'];
      $where['uat.attendance_date'] = $data['attendance_date'];
      $where['uat.delete_status'] = 0;
      $count = $this->Attendance->select_attendance('attendance_id',$where);
      if($count->num_rows()==0){
        //              Insert Attendance
        $result = $this->Attendance->insert_attendance($data);
        if ($result['status'] == 1) {
          $actvity_data['reference_id'] = $result['insert_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['sign_in_activity_id'] = $result2['insert_id'];
          $update_data['attendance_id'] = $result['insert_id'];
          $this->Attendance->update_attendance($update_data);

          $message = [
            'status' => TRUE,
            'message' => 'Attendance Marked Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }
      }else {
        $message = [
          'status' => FALSE,
          'message' => "Your Attendance is Marked Already for Today"
        ];
        $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Attendance are Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function sign_off_post()
  {
    if($this->post('user_id')!=""  ) {

      $data['user_id'] = $this->post('user_id');
      $data['attendance_date'] = date('Y-m-d');
      $data2['signed_off_time'] = date('H:i:s');

      $actvity_data['user_id'] = $data['user_id'];
      $actvity_data['activity_type'] = 'Attendance';
      $actvity_data['activity_through'] = 'Mobile App';
      $actvity_data['activity_date'] = date('Y-m-d H:i:s');
      $actvity_data['activity_description'] = 'Signed Off';
      $actvity_data['activity_location_address'] = $this->post('address');
      $actvity_data['activity_location_landmark'] = $this->post('landmark');
      $actvity_data['activity_location_latitude'] = $this->post('latitude');
      $actvity_data['activity_location_longitude'] = $this->post('longitude');
      if($this->post('device')){
        $actvity_data['activity_device'] = $this->post('device');
      }
      //          Check Attendance Exist
      $where['uat.user_id'] = $data['user_id'];
      // $where['uat.attendance_date'] = $data['attendance_date'];
      $where['uat.delete_status'] = 0;
      $where['uat.attendance_status'] = 1;
      // $this->db->where("CONCAT(uat.attendance_date,' ',signed_in_time) >= now() - INTERVAL 1 DAY");
      $attendance = $this->Attendance->select_attendance('attendance_id',$where,array("uat.attendance_date","desc"),1);
      if($attendance->num_rows()==1){
        //              Update Attendance
        $data2['attendance_id'] = $attendance->row()->attendance_id;
        $result = $this->Attendance->update_attendance($data2);
        if ($result == 1) {
          $actvity_data['reference_id'] = $data2['attendance_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['sign_off_activity_id'] = $result2['insert_id'];
          $update_data['attendance_id'] = $data2['attendance_id'];
          $this->Attendance->update_attendance($update_data);

          $message = [
            'status' => TRUE,
            'message' => 'You Are Signed Off From Duty Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }
      }else {
        $message = [
          'status' => FALSE,
          'message' => "Your Sign in Attendance is Not Marked"
        ];
        $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID are Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }

  //  Attendance
  public function project_sign_in_post()
  {
    if($this->post('user_id')!="" && $this->post('work_id')!="" ) {

      $data['user_id'] = $this->post('user_id');
      $data['attendance_date'] = date('Y-m-d');
      $data['project_id'] = $this->post('work_id');
      $data['signed_in_time'] = date('H:i:s');
      $data['created_date'] = date('Y-m-d H:i:s');
      $data['created_by'] = $data['user_id'];

      $actvity_data['user_id'] = $data['user_id'];
      $actvity_data['activity_type'] = 'Project Attendance';
      $actvity_data['activity_through'] = 'Mobile App';
      $actvity_data['activity_date'] = $data['created_date'];
      $actvity_data['activity_description'] = 'Signed In';
      $actvity_data['activity_location_address'] = $this->post('address');
      $actvity_data['activity_location_latitude'] = $this->post('latitude');
      $actvity_data['activity_location_longitude'] = $this->post('longitude');
      if($this->post('device')){
        $actvity_data['activity_device'] = $this->post('device');
      }
      //          Check Already Exist
      $where['uat.user_id'] = $data['user_id'];
      $where['uat.attendance_date'] = $data['attendance_date'];
      $where['uat.delete_status'] = 0;
      $where['uat.signed_off_time'] = "00:00:00";
      $count = $this->Attendance->select_attendance_projectwise('attendance_id',$where);
      if($count->num_rows()==0){
        //              Insert Attendance
        $result = $this->Attendance->insert_attendance_projectwise($data);
        if ($result['status'] == 1) {
          $actvity_data['reference_id'] = $result['insert_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['sign_in_activity_id'] = $result2['insert_id'];
          $update_data['attendance_id'] = $result['insert_id'];
          $this->Attendance->update_attendance_projectwise($update_data);

          $message = [
            'status' => TRUE,
            'message' => 'Signed In Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }
      }else {
        $message = [
          'status' => FALSE,
          'message' => "Please Sign off From Previously Signed in Project"
        ];
        $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID are Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
  public function project_sign_off_post()
  {
    if($this->post('user_id')!="" && $this->post('work_id')!=""  ) {

      $data['user_id'] = $this->post('user_id');
      $data['attendance_date'] = date('Y-m-d');
      $data2['signed_off_time'] = date('H:i:s');

      $actvity_data['user_id'] = $data['user_id'];
      $actvity_data['activity_type'] = 'Project Attendance';
      $actvity_data['activity_through'] = 'Mobile App';
      $actvity_data['activity_date'] = date('Y-m-d H:i:s');
      $actvity_data['activity_description'] = 'Signed Off';
      $actvity_data['activity_location_address'] = $this->post('address');
      $actvity_data['activity_location_latitude'] = $this->post('latitude');
      $actvity_data['activity_location_longitude'] = $this->post('longitude');
      if($this->post('device')){
        $actvity_data['activity_device'] = $this->post('device');
      }
      //          Check Attendance Exist
      $where['uat.user_id'] = $data['user_id'];
      $where['uat.project_id'] = $this->post('work_id');
      $where['uat.attendance_date'] = $data['attendance_date'];
      $where['uat.delete_status'] = 0;
      $where['uat.signed_in_time !='] = "00:00:00";
      $where['uat.signed_off_time'] = "00:00:00";
      $attendance = $this->Attendance->select_attendance_projectwise('attendance_id',$where);
      if($attendance->num_rows()==1){
        //              Update Attendance
        $data2['attendance_id'] = $attendance->row()->attendance_id;
        $result = $this->Attendance->update_attendance_projectwise($data2);
        if ($result == 1) {
          $actvity_data['reference_id'] = $data2['attendance_id'];
          $result2 = $this->User->insert_activity($actvity_data);

          $update_data['sign_off_activity_id'] = $result2['insert_id'];
          $update_data['attendance_id'] = $data2['attendance_id'];
          $this->Attendance->update_attendance_projectwise($update_data);

          $message = [
            'status' => TRUE,
            'message' => 'Signed Off From Project Successfully'
          ];
          $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
        } else {
          $message = [
            'status' => FALSE,
            'message' => 'There Has Been Some Error Occurred'
          ];
          $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }
      }else {
        $message = [
          'status' => FALSE,
          'message' => "Your Sign in Not Marked or Already Signed Out"
        ];
        $this->set_response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
      }
    }else{
      $message = [
        'status' => FALSE,
        'message' => 'Required Parameters Missing . User ID, Work ID are Required'
      ];
      $this->response($message, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
    }
  }
}
