<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Work_order extends CI_Controller {

  public $page_data=array();

  function __construct()
  {
    parent::__construct();
    //Calling Initial Functions
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model','User');

    $this->load->model('Work_order_model','Work_order');
    $this->load->model('Sales_quotation_model','Sales_quotation');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Stock_model', 'Stock');
    $this->load->library('Accounts_management', 'accounts_management');
    $this->load->library('Projects_management','projects_management');

    //        File Directory
    $this->page_data['directory'] = "work_order";

    $sales_staff_where = array();
    // sale_staff type user from users table
    // $sales_staff_where['user_role'] = 25;
    $this->page_data['sales_staffs'] = $this->User->select_user("*",$sales_staff_where)->result();

  }
  public function index()
  {
    $this->view();
  }
  public function add($step='1',$order_id='')
  {
    $this->page_data['step'] = $step;

    $this->page_data['quotation_data'] = array();
    $this->page_data['terms_and_condition_templates'] = $this->Settings->select_terms_and_condition_templates('',array("terms_type"=>'Work Order'))->result();
    //        Check User Logged in or Not
    $data = array();
    $allowed_user_roles = array("madmin","admin","sales_manager","general_manager","supervisor","sales_staff","accounts_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    $this->page_data['supervisors'] = $this->User->select_user("",array("role_name"=>'supervisor'))->result();
    $this->page_data['selected_quotation_id'] = '';
    $this->page_data['quotation_data'] = array();
    if(isset($_GET['quotation_id']) && $_GET['quotation_id']!=''){
      $this->page_data['selected_quotation_id'] = $_GET['quotation_id'];
    }

    if($this->session->userdata('branch_id') != 0){
      $data['sq.branch_id'] = $this->session->userdata('branch_id');
    }
    $this->page_data['sales_quotations'] = $this->Sales_quotation->select_quotations('',$data)->result();
    foreach ($this->page_data['sales_quotations'] as $key => $value) {
      if($value->branch_id==0){
        $default_branch_data = $this->config->item('default_branch_data');
        $value->branch_name = $default_branch_data['branch_name'];
        $value->quotation_prefix = $default_branch_data['quotation_prefix'];
        $value->quotation_header = $default_branch_data['quotation_header'];
        $value->quotation_footer = $default_branch_data['quotation_footer'];
      }
    }
    $this->page_data['bank_accounts'] = $this->Settings->select_bank_account_details()->result();
    if(isset($_GET['quotation_id']) && $_GET['quotation_id']!=''){
      $this->page_data['quotation_data'] = $this->Sales_quotation->select_quotations("sq.*,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,c.customer_location,c.contact_person,c.customer_email as c_customer_email", array("quotation_id"=>$_GET['quotation_id']));
      if($this->page_data['quotation_data']->num_rows()==1){
        $this->page_data['quotation_data'] = $this->page_data['quotation_data']->row();
        if($this->page_data['quotation_data']->branch_id==0){
          $default_branch_data = $this->config->item('default_branch_data');
          $this->page_data['quotation_data']->branch_name = $default_branch_data['branch_name'];
          $this->page_data['quotation_data']->quotation_prefix = $default_branch_data['quotation_prefix'];
        }

      }
    }
    if($order_id!=''){
      $data['wo.order_id'] = $order_id;
      $this->page_data['work_order_data'] = $this->Work_order->select_work_orders("wo.*,tt.*,ba.*,b.*,sq.quotation_no,u2.user_alias as site_coordinator_name", $data);
      if($this->page_data['work_order_data']->num_rows()==1){
        $this->page_data['work_order_data'] = $this->page_data['work_order_data']->row();
        if($this->page_data['work_order_data']->quotation_id!=0){
          $this->page_data['quotation_data'] = $this->Sales_quotation->select_quotations("sq.*,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,c.customer_location,c.contact_person,c.customer_email as c_customer_email", array("quotation_id"=>$this->page_data['work_order_data']->quotation_id));
          if($this->page_data['quotation_data']->num_rows()==1){
            $this->page_data['quotation_data'] = $this->page_data['quotation_data']->row();
            if($this->page_data['quotation_data']->branch_id==0){
              $default_branch_data = $this->config->item('default_branch_data');
              $this->page_data['quotation_data']->branch_name = $default_branch_data['branch_name'];
              $this->page_data['quotation_data']->quotation_prefix = $default_branch_data['quotation_prefix'];
            }
          }
        }
      }
    }

    if($this->config->item('Work_order_template')==1){
      $this->page_data['page_name'] = 'work_order_add_'.$this->config->item('Work_order_template')."_step_".$step;
    }else{
      $this->page_data['page_name'] = 'work_order_add_'.$this->config->item('Work_order_template');
    }
    $this->load->view('Index',$this->page_data);
  }
  public function view()
  {
    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","sales_manager","general_manager","supervisor","sales_staff","accounts_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }

    $this->page_data['page_name'] = 'work_order_view';
    $this->load->view('Index',$this->page_data);
  }

  public function profile($view_type='',$id='')
  {
    if($id!=""){
      if($this->config->item('user_data_access_view_all')!=1){
        $data['wo.created_by'] = $this->session->userdata('user_id');
      }
      if($this->session->userdata('user_role')=='general_manager' && $this->config->item('User_general_manager_client_payment_view_all')==0){
        $data['wo.created_by'] = $this->session->userdata('user_id');
      }
      $data['wo.order_id'] = $id;
      $this->page_data['order_data'] = $this->Work_order->select_work_orders("wo.*,tt.*,ba.*,b.*,sq.quotation_no,u2.user_alias as site_coordinator_name,u3.user_alias as prepared_by_name,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,c.customer_location,c.contact_person,tsc.state_name,tt.tax_percentage", $data);
      if($this->page_data['order_data']->num_rows()==1){
        $this->page_data['order_data'] = $this->page_data['order_data']->row();
        if($this->page_data['order_data']->branch_id==0){
          $default_branch_data = $this->config->item('default_branch_data');
          $this->page_data['order_data']->branch_name = $default_branch_data['branch_name'];
          $this->page_data['order_data']->quotation_prefix = $default_branch_data['quotation_prefix'];
          $this->page_data['order_data']->workorder_prefix = $default_branch_data['workorder_prefix'];
          $this->page_data['order_data']->workorder_header = $default_branch_data['workorder_header'];
          $this->page_data['order_data']->workorder_footer = $default_branch_data['workorder_footer'];
          $this->page_data['order_data']->workorder_logo = $default_branch_data['workorder_logo'];
        }
        $this->page_data['order_data']->receivable_amount_in_words = $this->accounts_management->amount_in_words($this->page_data['order_data']->total_order_amount);
        $this->page_data['work_types'] = array();
        if($this->page_data['order_data']->work_types!=''){
          $work_types = explode(",",$this->page_data['order_data']->work_types);
          foreach ($work_types as $key => $value) {
            $this->page_data['work_types'][$key]['type_id'] = $value;
            $this->page_data['work_types'][$key]['type_name'] = $this->Work->select_work_types("",array("type_id"=>$value))->row()->type_name;
            $this->page_data['work_types'][$key]['items'] = $this->Work_order->select_work_order_items("woi.*,mu.unit_name",array("woi.order_id"=>$this->page_data['order_data']->order_id,'woi.work_type_id'=>$value,'woi.item_type'=>'task'))->result();
            $this->page_data['work_types'][$key]['descriptions'] = $this->Work_order->select_work_order_items("woi.*,mu.unit_name",array("woi.order_id"=>$this->page_data['order_data']->order_id,'woi.work_type_id'=>$value,'woi.item_type'=>'description'))->result();
          }
        }
        $this->page_data['quotation_data'] = array();
        if($this->page_data['order_data']->quotation_id!=0){
          $this->page_data['quotation_data'] = $this->Sales_quotation->select_quotations("sq.*,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,c.customer_location,c.contact_person,c.customer_email as c_customer_email", array("quotation_id"=>$this->page_data['order_data']->quotation_id));
          if($this->page_data['quotation_data']->num_rows()==1){
            $this->page_data['quotation_data'] = $this->page_data['quotation_data']->row();
            if($this->page_data['quotation_data']->branch_id==0){
              $default_branch_data = $this->config->item('default_branch_data');
              $this->page_data['quotation_data']->branch_name = $default_branch_data['branch_name'];
              $this->page_data['quotation_data']->quotation_prefix = $default_branch_data['quotation_prefix'];
            }
          }
        }
        $this->page_data['items_data'] = $this->Work_order->select_work_order_items("woi.*",array("woi.order_id"=>$this->page_data['order_data']->order_id))->result();
        if($view_type=='print'){
          $this->load->view('modules/work_order/work_order_print_'.$this->config->item('Work_order_template'), $this->page_data);
        }else{
          $this->page_data['page_name'] = 'work_order_profile_'.$this->config->item('Work_order_template');
          $this->load->view('Index', $this->page_data);
        }
      }else{
        show_404();
      }
    }else{
      show_404();
    }
  }
  public function edit($id='')
  {
    if($id!=""){
      $data['wo.order_id'] = $id;
      $this->page_data['order_data'] = $this->Work_order->select_work_orders("wo.*,ba.*", $data);
      if($this->page_data['order_data']->num_rows()==1){
        $this->page_data['order_data'] = $this->page_data['order_data']->row();
        $this->page_data['items_data'] = $this->Work_order->select_work_order_items("woi.*",array("woi.order_id"=>$this->page_data['order_data']->order_id))->result();
        $this->page_data['page_name'] = 'work_order_edit_'.$this->config->item('Work_order_template');
        $this->load->view('Index', $this->page_data);
      }else{
        show_404();
      }
    }else{
      show_404();
    }
  }

  public function create()
  {
    $data['order_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('order_date'))));
    $data['customer_id'] = $this->security->xss_clean($this->input->post('customer'));
    if($this->input->post('quotation_id')){
      $data['quotation_id'] = $this->security->xss_clean($this->input->post('quotation_id'));
      $quotation_data = $this->Sales_quotation->select_quotations("sq.*",array("sq.quotation_id"=>$data['quotation_id']));
      if($quotation_data->num_rows()==1){
        $quotation_data = $quotation_data->row();
        $data['work_types'] = $quotation_data->work_types;
        $data['tax_percent'] = $quotation_data->quotation_tax_percent;
        $data['enquiry_id'] = $quotation_data->enquiry_id;
      }
    }
    if($this->config->item('Work_order_template')==1){
      $data['order_reference_no'] = $this->security->xss_clean($this->input->post('order_reference_no'));
      $data['customer_order_ref_no'] = $this->security->xss_clean($this->input->post('customer_order_ref_no'));
      if($this->input->post('customer_order_date')!=''){
        $data['customer_order_ref_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('customer_order_date'))));
      }
      if($this->input->post('prepared_by')){
        $data['prepared_by'] = $this->security->xss_clean($this->input->post('prepared_by'));
      }
      $data['project_name'] = $this->security->xss_clean($this->input->post('project_name'));
      if($this->input->post('prepared_by')){
        $data['order_description'] = $this->security->xss_clean($this->input->post('order_description'));
      }
    }
    if($this->input->post('site_coordinator')){
      $data['site_coordinator'] = $this->security->xss_clean($this->input->post('site_coordinator'));
    }
    if($this->config->item('Work_order_template')==2){
      $data['customer_name'] = $this->security->xss_clean($this->input->post('customer_name'));
      $data['customer_address'] = $this->security->xss_clean($this->input->post('address'));
      $data['project_start_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('project_start_date'))));
      $data['state'] = $this->security->xss_clean($this->input->post('state'));
      $data['bank_account'] = $this->security->xss_clean($this->input->post('bank_account'));
      $data['grand_total_amount'] = $this->security->xss_clean($this->input->post('grand_total'));
      $data['discount_amount'] = $this->security->xss_clean($this->input->post('discount_amount'));
      if($this->input->post('tax_percent')){
        $data['tax_percent'] = $this->security->xss_clean($this->input->post('tax_percent'));
        $data['tax_amount'] = $this->security->xss_clean($this->input->post('tax_amount'));
      }
      $data['total_order_amount'] = $this->security->xss_clean($this->input->post('total_order_amount'));
    }
    $data['created_date'] = date('Y-m-d H:i:s');
    $data['created_by'] = $this->session->userdata('user_id');

    $last_data = $this->Work_order->select_work_orders("max(wo.order_no) as max_order_no");
    if($last_data->num_rows()==1){
      $data['order_no'] = ($last_data->row()->max_order_no)+1;
    }else{
      $data['order_no'] = 1;
    }

    //terms and conditions
    $terms_array=$newArrayterms=array();
    if($this->input->post('terms')){
      $terms_array = $this->input->post('terms');
    }
    $terms_array_length = sizeof($terms_array);
    foreach (array_keys($terms_array) as $fieldKey) {
      foreach ($terms_array[$fieldKey] as $key=>$value) {
        $newArrayterms[$key][$fieldKey] = $value;
      }
    }

    $i = 0;
    foreach ($newArrayterms as $row) {
      if(isset($row['title'])){
        $terms_new[$i]['title'] = $row['title'];
      }
      $terms_new[$i]['description'] = $row['description'];
      $i++;
    }
    if(sizeof($newArrayterms)){
      $data['terms_and_conditions'] = serialize($terms_new);
    }

    if($this->config->item('Work_order_template')==2){
      //Payment Schedul
      $schedule_array=$newArrayschedule=array();
      if($this->input->post('schedule')){
        $schedule_array = $this->input->post('schedule');
      }
      $schedule_array_length = sizeof($schedule_array);
      foreach (array_keys($schedule_array) as $fieldKey) {
        foreach ($schedule_array[$fieldKey] as $key=>$value) {
          $newArrayschedule[$key][$fieldKey] = $value;
        }
      }

      $i = 0;
      foreach ($newArrayschedule as $row) {
        $schedule_new[$i]['particulars'] = $row['particulars'];
        $schedule_new[$i]['percent'] = $row['percent'];
        $schedule_new[$i]['amount'] = $row['amount'];
        $schedule_new[$i]['remarks'] = $row['remarks'];
        $i++;
      }
      if(sizeof($newArrayschedule)){
        $data['payment_schedule'] = serialize($schedule_new);
      }
    }

    $result = $this->Work_order->insert_work_order($data);

    $flash_data['status'] = $result['status'];
    if ($flash_data['status'] == 1) {
      if(isset($data['enquiry_id'])){
        $enquiry_update_data['enquiry_id'] = $data['enquiry_id'];
        $enquiry_update_data['enquiry_status'] = 'Work Order Created';
        $enquiry_result = $this->Enquiries->update_enquiry($enquiry_update_data);
      }
      if($this->config->item('Work_order_template')==1 && isset($data['quotation_id']) && $data['quotation_id']!=''){
        // Copy Quotation  to Work Order
        $quotation_items_data = $this->Sales_quotation->select_quotation_items("sqi.*,sqt.template_no,mu.unit_name,wt.item_code",array("sqi.quotation_id"=>$data['quotation_id']))->result();
        foreach ($quotation_items_data as $key => $value) {
          $item_data['order_id'] = $result['insert_id'];
          $item_data['description'] = $value->description;
          $item_data['work_type_id'] = $value->work_type_id;
          $item_data['unit'] = $value->unit;
          $item_data['item_code'] = $value->item_code;
          $item_data['item_type'] = $value->item_type;
          $item_data['quantity'] = $value->quantity;
          $item_data['unit_price'] = $value->unit_price;
          $item_data['unit_price_2'] = $value->unit_price_2;
          $item_data['total_price'] = $value->total_amount;
          $item_result = $this->Work_order->insert_work_order_item($item_data);
        }
      }

      if($this->config->item('Work_order_template')==2){
        // Insert Items
        $row_count = $this->input->post('current_row_count');
        $item_data['order_id'] = $result['insert_id'];
        if($row_count > 0){
          for ($i=0; $i < $row_count ; $i++)
          {
            if($this->config->item('Work_order_template')==1){
              $item_data['item_code'] = $this->input->post('item_code['.$i.']');
              $item_data['size'] = $this->input->post('item_size['.$i.']');
              $item_data['type'] = $this->input->post('item_type['.$i.']');
              $item_data['quantity'] = $this->input->post('item_qty['.$i.']');
            }
            if($this->config->item('Work_order_template')==2){
              $item_data['area_type'] = $this->input->post('item_area_type['.$i.']');
              $item_data['quantity'] = $this->input->post('item_area['.$i.']');
              $item_data['warranty'] = $this->input->post('item_warranty['.$i.']');
            }
            $item_data['unit_price'] = $this->input->post('item_price['.$i.']');
            $item_data['total_price'] = $this->input->post('item_total['.$i.']');
            $result_items = $this->Work_order->insert_work_order_item($item_data);
          }
        }
      }

      $flash_data['flashdata_msg'] = 'Work Order Added Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
      $flash_data['order_id'] = $result['insert_id'];

      // Create Project
      if($this->config->item('Work_order_project_creation_on_order_create')==1){
        $this->projects_management->create_project('project_creation_on_order_create',$result['insert_id'],'work_order');
      }
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function update()
  {
    $data['order_id'] = $this->security->xss_clean($this->input->post('order_id'));
    $data['order_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('order_date'))));
    $data['customer_id'] = $this->security->xss_clean($this->input->post('customer'));
    if($this->input->post('site_coordinator')){
      $data['site_coordinator'] = $this->security->xss_clean($this->input->post('site_coordinator'));
    }
    if($this->config->item('Work_order_template')==1){
      $data['order_reference_no'] = $this->security->xss_clean($this->input->post('order_reference_no'));
      $data['customer_order_ref_no'] = $this->security->xss_clean($this->input->post('customer_order_ref_no'));
      if($this->input->post('customer_order_date')!=''){
        $data['customer_order_ref_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('customer_order_date'))));
      }
      if($this->input->post('prepared_by')){
        $data['prepared_by'] = $this->security->xss_clean($this->input->post('prepared_by'));
      }
      $data['project_name'] = $this->security->xss_clean($this->input->post('project_name'));
      if($this->input->post('prepared_by')){
        $data['order_description'] = $this->security->xss_clean($this->input->post('order_description'));
      }
    }
    if($this->input->post('grand_total')){
      $data['grand_total_amount'] = $this->security->xss_clean($this->input->post('grand_total'));
      $data['discount_amount'] = $this->security->xss_clean($this->input->post('discount_amount'));
      $data['total_order_amount'] = $this->security->xss_clean($this->input->post('total_order_amount'));
    }
    $data['updated_date'] = date('Y-m-d H:i:s');
    $data['updated_by'] = $this->session->userdata('user_id');

    if($this->config->item('Work_order_template')==2){
      //terms and conditions
      $terms_array=$newArrayterms=array();
      if($this->input->post('terms')){
        $terms_array = $this->input->post('terms');
      }
      $terms_array_length = sizeof($terms_array);
      foreach (array_keys($terms_array) as $fieldKey) {
        foreach ($terms_array[$fieldKey] as $key=>$value) {
          $newArrayterms[$key][$fieldKey] = $value;
        }
      }

      $i = 0;
      foreach ($newArrayterms as $row) {
        $terms_new[$i]['description'] = $row['description'];
        $i++;
      }
      if(sizeof($newArrayterms)){
        $data['terms_and_conditions'] = serialize($terms_new);
      }

      //Payment Schedul
      $schedule_array=$newArrayschedule=array();
      if($this->input->post('schedule')){
        $schedule_array = $this->input->post('schedule');
      }
      $schedule_array_length = sizeof($schedule_array);
      foreach (array_keys($schedule_array) as $fieldKey) {
        foreach ($schedule_array[$fieldKey] as $key=>$value) {
          $newArrayschedule[$key][$fieldKey] = $value;
        }
      }

      $i = 0;
      foreach ($newArrayschedule as $row) {
        $schedule_new[$i]['particulars'] = $row['particulars'];
        $schedule_new[$i]['percent'] = $row['percent'];
        $schedule_new[$i]['amount'] = $row['amount'];
        $schedule_new[$i]['remarks'] = $row['remarks'];
        $i++;
      }
      if(sizeof($newArrayschedule)){
        $data['payment_schedule'] = serialize($schedule_new);
      }
    }

    $result = $this->Work_order->update_work_order($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {

      // Insert Items
      $row_count = $this->input->post('current_row_count');
      if($row_count > 0){
        for ($i=0; $i < $row_count ; $i++)
        {
          $item_data = array();
          if($this->config->item('Work_order_template')==1){
            $item_data['item_code'] = $this->input->post('item_code['.$i.']');
            $item_data['size'] = $this->input->post('item_size['.$i.']');
            $item_data['type'] = $this->input->post('item_type['.$i.']');
            $item_data['quantity'] = $this->input->post('item_qty['.$i.']');
          }
          $item_data['unit_price'] = $this->input->post('item_price['.$i.']');
          $item_data['total_price'] = $this->input->post('item_total['.$i.']');
          if($this->input->post('item_id['.$i.']')){
            // update
            $item_data['item_id'] = $this->input->post('item_id['.$i.']');
            $result_items = $this->Work_order->update_work_order_item($item_data);
          }else{
            $item_data['order_id'] = $data['order_id'];
            // create
            $result_items = $this->Work_order->insert_work_order_item($item_data);
          }

        }
      }

      // Check Items Deleted
      if($this->input->post('deleted_items')){
        $deleted_items = $this->security->xss_clean($this->input->post('deleted_items'));
        if($deleted_items!=''){
          $items = explode(',',$deleted_items);
          foreach ($items as $key => $value) {
            $item_data=array();
            $item_data['delete_status'] = 1;
            $item_data['item_id'] = $value;
            $this->Work_order->update_work_order_item($item_data);
          }
        }
      }

      $flash_data['flashdata_msg'] = 'Work Order Details Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
      $flash_data['order_id'] = $data['order_id'];
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }
  public function update_2()
  {
    $data['order_id'] = $this->security->xss_clean($this->input->post('work_order_id'));
    if($this->config->item('Quotation_template')==1){
      $data['grand_total_amount'] = $this->security->xss_clean($this->input->post('grand_total_amount'));
      $data['discount_amount'] = $this->security->xss_clean($this->input->post('discount_amount'));
      $data['tax_percent'] = $this->security->xss_clean($this->input->post('tax_percent'));
      $data['tax_amount'] = $this->security->xss_clean($this->input->post('total_tax_amount'));
      $data['total_order_amount'] = $this->security->xss_clean($this->input->post('net_total_amount'));

    }
    $result = $this->Work_order->update_work_order($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Work Order Saved Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
      $flash_data['work_order_id'] = $data['order_id'];
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo(json_encode($flash_data));
  }
  public function approve()
  {
    $data['order_id']=$this->security->xss_clean($this->input->post('order_id'));
    $data['order_approval']=$this->security->xss_clean($this->input->post('order_approval_status'));
    $data['approval_remarks']=$this->security->xss_clean($this->input->post('remarks'));
    $data['approved_by'] = $this->session->userdata('user_id');
    $result = $this->Work_order->update_work_order($data);

    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      if($data['order_approval']==1 && $this->config->item('Work_order_project_creation_on_order_approval')==1){
        $this->projects_management->create_project('project_creation_on_order_approval',$data['order_id'],'work_order');
      }
      $flash_data['flashdata_msg'] = 'Work Order Approval Status Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo(json_encode($flash_data));
  }
  public function select_work_order($type='')
  {
    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();
    if($this->config->item('user_data_access_view_all')!=1){
      $data['wo.created_by'] = $this->session->userdata('user_id');
    }
    if($this->session->userdata('user_role')=='general_manager' && $this->config->item('User_general_manager_client_payment_view_all')==0){
      $data['wo.created_by'] = $this->session->userdata('user_id');
    }
    if(isset($_POST['branch_id']) && $_POST['branch_id']!='' && $_POST['branch_id']!='all'){
      $data['wo.branch_id'] = $_POST['branch_id'];
    }
    if($this->session->userdata('branch_id') != 0){
      $data['wo.branch_id'] = $this->session->userdata('branch_id');
    }
    $result = $this->Work_order->select_work_orders("wo.*,u.user_alias,b.*,sq.quotation_no,u2.user_alias as site_coordinator_name,u3.user_alias as prepared_by_name,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,c.customer_location,c.contact_person",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    foreach($result_array as $row):

      $btn_edit = $btn_delete = '';
      if($this->config->item('Work_order_template')==1 && ($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager')){
        // $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="work_order_delete_btn" href="#work_order_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        // <i class="la la-trash"></i>
        // </a>';
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="work_order_edit_btn" href="'.base_url().'work_order/edit/'.$row->order_id.'"  class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }
      if($row->branch_id==0){
        $default_branch_data = $this->config->item('default_branch_data');
        $row->branch_name = $default_branch_data['branch_name'];
        $row->quotation_prefix = $default_branch_data['quotation_prefix'];
        $row->workorder_prefix = $default_branch_data['workorder_prefix'];
      }

      $array[$j][]=$j+1;
      $array[$j][]=$row->branch_name;
      $array[$j][]=$row->order_id;
      if($this->config->item('Work_order_template')==2){
        $array[$j][]='<a  href="'.base_url().'work_order/profile/view/'.$row->order_id.'" >#'.$row->workorder_prefix.'-'.$row->order_no.'</a>';
      }else{
        $array[$j][]='<a  href="'.base_url().'work_order/profile/view/'.$row->order_id.'" >#'.$this->config->item('workorder_prefix')."".$row->order_no.'</a>';
      }
      if($row->quotation_id!='' && $row->quotation_id!=0){
        $array[$j][]='<a  href="'.base_url().'sales_quotation/profile/view/'.$row->quotation_id.'" >#'.$row->quotation_prefix.'-'.$row->quotation_no.'</a>';
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$row->project_name;
      if($row->customer_id==0){
        $array[$j][]=$row->customer_name;
        $array[$j][]=nl2br($row->customer_address.'<br/>'.$row->customer_pin.'<br/>'.$row->customer_district);
      }else{
        $array[$j][]=$row->c_customer_name."<br/>".$row->contact_person;
        $array[$j][]=nl2br($row->customer_location);
      }
      $array[$j][]=date('d-m-Y',strtotime($row->order_date));
      $array[$j][]=date('d-m-Y',strtotime($row->project_start_date));
      $array[$j][]=$row->total_order_amount;
      if($this->config->item('Work_order_template')==2){
        if(is_numeric($row->site_coordinator)){
          $array[$j][]=$row->site_coordinator_name;
        }else{
          $array[$j][]=nl2br($row->site_coordinator);
        }
      }else{
        $array[$j][]=$row->prepared_by_name;
      }
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->created_date))."</li><li>Created By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->user_alias.'</li>';
      }
      $array[$j][]=$btn_edit.$btn_delete;

      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }


  public function create_item()
  {
    $item_data['order_id'] = $this->input->post('work_order_id');
    $item_data['description'] = $this->input->post('item_description');
    $item_data['item_type'] = $this->input->post('item_type');
    $item_data['item_code'] = $this->input->post('item_code');
    if($this->input->post('work_type_id')){
      $item_data['work_type_id'] = $this->input->post('work_type_id');
    }
    if($item_data['item_type']=='task'){
      $item_data['unit'] = $this->input->post('item_unit');
      $item_data['quantity'] = $this->input->post('item_qty');
      $item_data['unit_price'] = $this->input->post('item_unit_price');
      if($this->config->item('Quotation_rate_type')=='supply_installation'){
        $item_data['unit_price_2'] = $this->input->post('item_unit_price_2');
      }
      $item_data['total_price'] = $this->input->post('item_total');
    }
    $result = $this->Work_order->insert_work_order_item($item_data);
    $flash_data['status'] = $result['status'];
    if($flash_data['status'] == 1){
      $flash_data['flashdata_msg'] = 'Item Added Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else{
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    redirect($this->input->post('redirect_url'),'refresh');
    // echo(json_encode($flash_data));
  }
  public function update_item()
  {
    $item_data['item_id'] = $this->input->post('item_id');
    $item_data['description'] = $this->input->post('item_description');
    $item_data['work_type_id'] = $this->input->post('work_type_id');
    $item_data['item_type'] = $this->input->post('item_type_edit');
    $item_data['item_code'] = $this->input->post('item_code');
    if($item_data['item_type']=='task'){
      $item_data['unit'] = $this->input->post('item_unit');
      $item_data['quantity'] = $this->input->post('item_qty');
      $item_data['unit_price'] = $this->input->post('item_unit_price');
      if($this->config->item('Quotation_rate_type')=='supply_installation'){
        $item_data['unit_price_2'] = $this->input->post('item_unit_price_2');
      }
      $item_data['total_price'] = $this->input->post('item_total');
    }
    $result = $this->Work_order->update_work_order_item($item_data);
    $flash_data['status'] = $result;
    if($flash_data['status'] == 1){
      $flash_data['flashdata_msg'] = 'Item Details Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else{
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    redirect($this->input->post('redirect_url'),'refresh');
    // echo(json_encode($flash_data));
  }
  public function create_work_type()
  {
    $work_order_id = $this->input->post('work_order_id');
    $work_type = $this->input->post('work_type');
    $data['wo.order_id'] = $work_order_id;
    $work_order_data = $this->Work_order->select_work_orders("wo.*", array("wo.order_id"=>$work_order_id));
    if($work_order_data->num_rows()==1){
      $work_order_data = $work_order_data->row();
      $work_types_array = array();
      if($work_order_data->work_types!=''){
        $work_types_array = explode(',',$work_order_data->work_types);
        if (!in_array($work_type,$work_types_array)){
          array_push($work_types_array,$work_type);
        }
      }else{
        $work_types_array[] = $work_type;
      }

      $update_data['order_id'] = $work_order_id;
      $update_data['work_types'] = implode(',',$work_types_array);
      $result = $this->Work_order->update_work_order($update_data);
      $flash_data['status'] = $result;
      if($result == 1){
        $flash_data['flashdata_msg'] = 'Work Type Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      }else{
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    redirect($this->input->post('redirect_url'),'refresh');
    // echo(json_encode($flash_data));
  }
  public function select_work_order_items() {
    $item_table_body ='';
    $data['wo.order_id'] = $this->input->post('work_order_id');
    $work_order_data = $this->Work_order->select_work_orders("wo.*", $data);
    if($work_order_data->num_rows()==1){
      $work_order_data = $work_order_data->row();
      $work_types_array = array();
      if($work_order_data->work_types!=''){
        $work_types_array = explode(',',$work_order_data->work_types);
        $item_no = 1;
        foreach ($work_types_array as $key => $value) {
          $item_subno = 1;
          $work_type_name = $this->Work->select_work_types("",array("type_id"=>$value))->row()->type_name;
          $item_table_body.='<tr>'.
          '<td><strong>'.$item_no.'</strong></td>'.
          '<td colspan="6"><strong>'.$work_type_name.'</strong></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td style="display: none"></td>'.
          '<td></td>'.
          '<td style="display: none"></td>'.
          '<td  class="delete_column"><a style="margin-left: 5px;margin-right: 5px" id="btn_work_type_delete" data-work-type-id="'.$value.'" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air"  href="#quotation_work_type_delete_modal" data-toggle="modal"><i class="la la-trash"></i></a></td>'.
          '<td></td>'.
          '<td></td>'.
          '<td></td>'.
          '<td></td>'.
          '<td></td>'.
          '</tr>';
          // Get Items
          $items_where["woi.order_id"] = $data['wo.order_id'];
          $items_where["woi.work_type_id"] = $value;
          $items_where["woi.item_type"] = 'description';
          $items = $this->Work_order->select_work_order_items("woi.*,mu.unit_name",$items_where)->result();
          foreach ($items as $key2 => $value2) {
            $item_table_body.='<tr>'.
            '<td></td>'.
            '<td>'.$value2->description.'</td>'.
            '<td></td>'.
            '<td></td>'.
            '<td></td>'.
            '<td></td>'.
            '<td></td>'.
            '<td></td>'.
            '<td class="delete_column">'.
            '<a style="margin-left: 5px;margin-right: 5px" id="btn_work_order_item_edit" data-item-id="'.$value2->item_id .'" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air"  href="#item_edit_modal" data-toggle="modal"><i class="la la-edit"></i></a>'.
            '<a style="margin-left: 5px;margin-right: 5px" id="btn_work_order_item_delete" data-item-id="'.$value2->item_id .'" class="btn btn-warning m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air"  href="#work_order_item_delete_modal" data-toggle="modal"><i class="la la-trash"></i></a></td>'.
            '<td><input type="text" class="item_total_amount" value="'.$value2->total_price.'"></td>'.
            '<td></td>'.
            '<td>'.$value2->work_type_id.'</td>'.
            '<td>'.$value2->description.'</td>'.
            '<td>'.$value2->item_type.'</td>'.
            '</tr>';
            // $item_subno++;
          }

          $items_where["woi.order_id"] = $data['wo.order_id'];
          $items_where["woi.work_type_id"] = $value;
          $items_where["woi.item_type"] = 'task';
          $items = $this->Work_order->select_work_order_items("woi.*,mu.unit_name",$items_where)->result();
          foreach ($items as $key2 => $value2) {
            $item_table_body.='<tr>'.
            '<td><strong>'.$item_no.'.'.$item_subno.'</strong></td>'.
            '<td>'.$value2->description.'</td>'.
            '<td>'.$value2->item_code.'</td>'.
            '<td>'.$value2->quantity.'</td>'.
            '<td>'.$value2->unit_name.'</td>'.
            '<td>'.$value2->unit_price.'</td>'.
            '<td>'.$value2->unit_price_2.'</td>'.
            '<td>'.$value2->total_price.'</td>'.
            '<td class="delete_column">'.
            '<a style="margin-left: 5px;margin-right: 5px" id="btn_work_order_item_edit" data-item-id="'.$value2->item_id .'" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air"  href="#item_edit_modal" data-toggle="modal"><i class="la la-edit"></i></a>'.
            '<a style="margin-left: 5px;margin-right: 5px" id="btn_work_order_item_delete" data-item-id="'.$value2->item_id .'" class="btn btn-warning m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air"  href="#work_order_item_delete_modal" data-toggle="modal"><i class="la la-trash"></i></a></td>'.
            '<td><input type="text" class="item_total_amount" value="'.$value2->total_price.'"></td>'.
            '<td>'.$value2->unit.'</td>'.
            '<td>'.$value2->work_type_id.'</td>'.
            '<td>'.$value2->description.'</td>'.
            '<td>'.$value2->item_type.'</td>'.
            '</tr>';
            $item_subno++;
          }
          $item_no++;
        }
        echo json_encode(array("items_count"=>$item_no,"content"=>$item_table_body));
      }else{
        $items_where["woi.order_id"] = $data['wo.order_id'];
        $items = $this->Work_order->select_work_order_items("woi.*,mu.unit_name",$items_where)->result();
        $item_no=1;
        foreach ($items as $key2 => $value2) {
          $item_table_body.='<tr>'.
          '<td><strong>'.$item_no.'</strong></td>'.
          '<td>'.$value2->description.'</td>'.
          '<td>'.$value2->quantity.'</td>'.
          '<td>'.$value2->unit_name.'</td>'.
          '<td>'.$value2->unit_price.'</td>'.
          '<td>'.$value2->total_amount.'</td>'.
          '<td class="delete_column">'.
          '<a style="margin-left: 5px;margin-right: 5px" id="btn_work_order_item_edit" data-item-id="'.$value2->item_id .'" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air"  href="#item_edit_modal" data-toggle="modal"><i class="la la-edit"></i></a>'.
          '<a style="margin-left: 5px;margin-right: 5px" id="btn_work_order_item_delete" data-item-id="'.$value2->item_id .'" class="btn btn-warning m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air"  href="#work_order_item_delete_modal" data-toggle="modal"><i class="la la-trash"></i></a></td>'.
          '<td><input type="text" class="item_total_amount" value="'.$value2->total_price.'"></td>'.
          '<td>'.$value2->unit.'</td>'.
          '<td>'.$value2->work_type_id.'</td>'.
          '<td>'.$value2->description.'</td>'.
          '<td>'.$value2->item_type.'</td>'.
          '</tr>';
          $item_no++;
        }
        echo json_encode(array("items_count"=>$item_no,"content"=>$item_table_body));
      }
    }else{
      echo json_encode(array("items_count"=>0));
    }
  }
  public function select_work_order_work_types() {
    $data['wo.order_id'] = $this->input->post('work_order_id');
    $work_order_data = $this->Work_order->select_work_orders("wo.*", $data);
    if($work_order_data->num_rows()==1){
      $work_order_data = $work_order_data->row();
      $work_types_array = array();
      if($work_order_data->work_types!=''){
        $work_types_array = explode(',',$work_order_data->work_types);
        $id = array();
        foreach ($work_types_array as $key => $value) {
          $work_type_details = $this->Work->select_work_types("",array("type_id"=>$value))->row();
          $id[] = $value;
          $name[] = $work_type_details->type_name;
          $item_code[] = $work_type_details->item_code;
        }
        echo json_encode(array("count" => sizeof($id),"id" => $id,"name" => $name,"item_code"=>$item_code));
      }else{
        echo json_encode(array("count" => 0));
      }
    }else{
      echo json_encode(array("count" => 0));
    }
  }
  public function delete_work_order_item()
  {
    $data['item_id'] = $this->input->post('item_id');
    $data['delete_status'] = 1;

    $result = $this->Work_order->update_work_order_item($data);
    $flash_data['status'] = $result;
    if($result == 1){
      $flash_data['flashdata_msg'] = 'Item Deleted Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else{
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    redirect($this->input->post('redirect_url'),'refresh');
    // echo(json_encode($flash_data));
  }
  public function delete_work_type()
  {
    $data['order_id'] = $this->input->post('work_order_id');
    $work_type_id = $this->input->post('work_type_id');
    $work_order_data = $this->Work_order->select_work_orders("wo.*", $data);
    if($work_order_data->num_rows()==1){
      $work_order_data = $work_order_data->row();
      // Check Items Exist
      $items_where["woi.order_id"] = $data['order_id'];
      $items_where["woi.work_type_id"] = $work_type_id;
      $items = $this->Work_order->select_work_order_items("woi.*,mu.unit_name",$items_where);
      if($items->num_rows()==0){
        if($work_order_data->work_types!=''){
          $work_types_array = explode(',',$work_order_data->work_types);
          if (($key = array_search($work_type_id, $work_types_array)) !== false) {
            unset($work_types_array[$key]);
          }
          $update_data['order_id'] = $data['order_id'];
          $update_data['work_types'] = implode(',',$work_types_array);
          $result = $this->Work_order->update_work_order($update_data);
          $flash_data['status'] = $result;
          if($result == 1){
            $flash_data['flashdata_msg'] = 'Item Deleted Successfully!.';
            $flash_data['flashdata_type'] = 'success';
            $flash_data['alert_type'] = 'success';
            $flash_data['flashdata_title'] = 'Success !';
          }else{
            $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
            $flash_data['flashdata_type'] = 'error';
            $flash_data['alert_type'] = 'danger';
            $flash_data['flashdata_title'] = 'Error !!';
          }
        }else{
          $flash_data['status'] = 2;
          $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['alert_type'] = 'danger';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      }else{
        $flash_data['status'] = 2;
        $flash_data['flashdata_msg'] = 'Sorry.. Items Exist under Selected Work Type. Please Delete Items first!';
        $flash_data['flashdata_type'] = 'warning';
        $flash_data['alert_type'] = 'warning';
        $flash_data['flashdata_title'] = 'Items Exist !!';
      }
    }else{
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    redirect($this->input->post('redirect_url'),'refresh');
    // echo(json_encode($flash_data));
  }
  public function select_items(){
    $data=array();
    if(isset($_POST['work_id']) && $_POST['work_id']!=""){
      $data['work_id'] = $_POST['work_id'];
    }
    $result	= $this->Work->select_work("*,c.tax_no as client_taxno",$data);
    if($result->num_rows()==1) {
      $work_order_id = $result->row()->work_order_id;
      $work_order_data = $this->Work_order->select_work_orders("*", array("wo.order_id"=>$work_order_id));
      if($work_order_data->num_rows()==1) {
        $json_data = array();
        $work_order_data = $work_order_data->row();
        $work_order_data->order_date=date('d-m-Y',strtotime($work_order_data->order_date));
        $work_order_data->quotation_date = $work_order_data->quotation_no = '';
        $work_order_data->order_no = $this->config->item('workorder_prefix')."".$work_order_data->order_no;

        $quotation_data = $this->Sales_quotation->select_quotations("sq.*,u1.user_alias as prepared_by_name,u1.phone_no as prepared_by_phone,c.customer_name as c_customer_name,c.customer_phone as c_customer_phone,c.customer_location,c.contact_person,b.*,tsc.state_name,tt.tax_percentage", array("sq.quotation_id"=>$work_order_data->quotation_id));
        if($quotation_data->num_rows()==1) {
          $json_data = array();
          $quotation_data = $quotation_data->row();
          $quotation_data->quotation_date=$work_order_data->quotation_date = date('d-m-Y',strtotime($quotation_data->date));

          if($this->config->item('Quotation_sales_quotation_no_manual')==1){
            $quotation_data->quotation_no=$quotation_data->quotation_no_suffix;
          }else{
            if($quotation_data->quotation_prefix!=''){
              $quotation_data->quotation_prefix = $quotation_data->quotation_prefix."-";
            }
            if($quotation_data->quotation_no_prefix!=''){
              $quotation_data->quotation_prefix = $quotation_data->quotation_no_prefix;
            }
            $quotation_data->quotation_no = sprintf("%04d", $quotation_data->quotation_no);
            $quotation_data->quotation_no=$quotation_data->quotation_prefix.$quotation_data->quotation_no.$quotation_data->quotation_no_suffix;
          }
          $work_order_data->quotation_no = $quotation_data->quotation_no;
          $work_order_data->quotation_details = $quotation_data;
        }
        if($work_order_data->work_types!=''){
          $work_types = explode(",",$work_order_data->work_types);
          foreach ($work_types as $key => $value) {
            $json_data[$key]['type_id'] = $value;
            $json_data[$key]['item_no'] = $key+1;
            $json_data[$key]['type_name'] = $this->Work->select_work_types("",array("type_id"=>$value))->row()->type_name;
            $json_data[$key]['items'] = $this->Work_order->select_work_order_items("woi.*,mu.unit_name",array("woi.order_id"=>$work_order_id,'woi.work_type_id'=>$value,'woi.item_type'=>'task'))->result_array();
          }
        }
        echo json_encode(array("count" => $result->num_rows(),"work_order_data"=>$work_order_data,"items_data" => $json_data));
      }else{
        echo json_encode(array("count" => 0));
      }
    }else{
      echo json_encode(array("count" => 0));
    }
  }
  public function select_item_details(){
    $data=array();
    if(isset($_POST['item_id']) && $_POST['item_id']!=""){
      $data['woi.item_id'] = $_POST['item_id'];
    }
    $result	= $this->Work_order->select_work_order_items("woi.*,mu.unit_name,wt.item_code",$data);
    if($result->num_rows()==1) {
      $json_data = $result->row();
      $json_data->description = strip_tags($json_data->description);
      echo json_encode(array("count" => $result->num_rows(),"data" => $json_data));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
}
?>
