<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Work_categories extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Supplier_model', 'Supplier');
    $this->load->model('Material_model', 'Material');
    $this->load->model('Settings_model', 'Settings');

    //        Check User Logged in or Not
    $allowed_user_roles = array("auditor","madmin","admin","supervisor","general_manager","accounts_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "work";

  }

  public function index()
  {
    $this->view();
  }

  public function view()
  {
    $this->page_data['page_name'] = 'work_categories';
    $this->load->view('Index', $this->page_data);
  }
  public function select_work_categories(){

    $json_data=array();
    $j=0;

    $data=array();
    // $data['delete_status'] = 0;
    $result	= $this->Work->select_work_category("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();
    $sl_no = 1;
    foreach($result_array as $row):
      $btn_edit='';
      if($this->session->userdata('user_role')!='auditor'){
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="work_category_edit_btn" href="#work_category_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }
      $array[$j][]=$row->wcat_id;
      $array[$j][]=$sl_no++;
      $array[$j][]=$row->wcat_name;
      $array[$j][]=$btn_edit;

      $j++;
    endforeach;

    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function update()
  {
    $data2['wcat_id'] = $this->security->xss_clean($this->input->post('work_category_id'));
    $data2['wcat_name'] = $this->security->xss_clean($this->input->post('work_category_name'));
    $count = $this->Work->select_work_category("wcat_id",array('wcat_name' => $data2['wcat_name'],'wcat_id !=' => $data2['wcat_id']))->num_rows();
    if($count==0){
      $result2 = $this->Work->update_work_category($data2);
      $flash_data['status'] = $result2;
      if ($result2 == 1) {
        $flash_data['flashdata_msg'] = 'Work Category Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Work Type Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }

    echo(json_encode($flash_data));

  }
  public function create()
  {
    $data2['wcat_name'] = $this->security->xss_clean($this->input->post('name'));
    $count = $this->Work->select_work_category("wcat_id",array('wcat_name' => $data2['wcat_name']))->num_rows();
    if($count==0){
      $result2 =  $this->Work->insert_work_category($data2);
      $flash_data['status'] = $result2['status'];
      if ($result2['status'] == 1) {
        $flash_data['flashdata_msg'] = 'New Work Category Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. Submitted Work Type Already Exists!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));

  }
  public function select(){
    $data['delete_status'] = 0;
    $result	= $this->Work->select_work_types("",$data);
    if($result->num_rows()>0) {
      foreach ($result->result() as $row):
        $id[] = $row->type_id;
        $name[] = $row->type_name;
      endforeach;
      echo json_encode(array("count" => $result->num_rows(),"id" => $id,"name" => $name));
    }else{
      echo json_encode(array("count" => $result->num_rows()));
    }
  }
}
?>
