<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Vehicle_work_slips extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }

  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Bills_model', 'Bills');
    $this->load->model('Settings_model', 'Settings');
    $this->load->library('Bills_management','bills_management');
    $this->load->model('Vehicle_model', 'Vehicle');
    $this->load->model('Vehicle_work_slips_model', 'Vehicle_work_slips');
    $this->load->model('Labour_model', 'Labour');
    $this->load->model('Employees_model', 'Employee');
    $this->load->library('Projects_management','projects_management');

    //        Check User Logged in or Not
    // "madmin","admin","supervisor","manager"
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","auditor","accounts_manager","qs","qs_manager","operation_manager");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "vehicles";

    $user_accounts_where = "ur.role_name='supervisor' or ur.role_name='general_manager'";
    $this->page_data['user_accounts'] = $this->Account->select_account_heads("",$user_accounts_where,"user")->result();
    if($this->config->item('Labour_group_member_payment')==0){
      $this->db->where('(l.labour_type=0 or (l.labour_type=1 and group_position=1))');
    }
    $this->page_data['labours_2'] = $this->Labour->select_labours()->result();
    $this->page_data['vehicle_categories'] = $this->Vehicle->select_vehicle("distinct(v.vehicle_category)")->result();

  }

  public function index()
  {
    $this->view();
  }

  public function view()
  {

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();
    $this->page_data['work_types'] = $this->Work->select_work_types()->result();
    $this->page_data['vehicles'] = $this->Vehicle->select_vehicle()->result();
    $this->page_data['driver_employees'] = $this->Employee->select_employee("e.*",array('e.department'=>1))->result();

    $this->page_data['page_name'] = 'vehicle_work_slips_view';
    $this->load->view('Index', $this->page_data);
  }
  public function print($id='')
  {
    $this->page_data['page_name'] = 'vehicle_work_slips_print';
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();

    if($id!=''){
      $data['vws.work_slip_id'] = $id;
      $this->page_data['work_slip_data'] = $this->Vehicle_work_slips->select_vehicle_work_slips("u.*,v.*,wc.*,vws.*,e.employee_name,vws.basic_charge AS vws_basic_charge,vws.basic_charge_2 AS vws_basic_charge_2,vws.basic_charge_3 AS vws_basic_charge_3,vws.remarks AS vws_remarks,vws.balance AS vws_balance,vws.created_by AS vws_created_by,vws.created_date AS vws_created_date,vws.updated_by AS vws_updated_by,vws.updated_date AS vws_updated_date,vc.consignee_name,vc.consignee_mobile,vc.consignee_place,u.user_role as created_user_role_id",$data,"","","","","",1);
      if($this->page_data['work_slip_data']->num_rows()==1){
        $this->page_data['work_slip_data'] = $this->page_data['work_slip_data']->row();

        $this->load->view('Index', $this->page_data);
      }else{
        show_404();
      }
    }else{
      show_404();
    }
  }

  public function select_vehicle_work_slip($page_data_type=''){

    $json_data=$array=array();
    $j=$sl_no=0;
    $total_total_balance=$total_worked_durations=$total_total_payable_amount=$total_total_paid=$total_overtime_duration=$total_overtime_amount=$total_driver_bata=$total_fuel_amount=$total_loading_amount=$total_commission=$total_labour_charge=$total_other_expenses=0;
    $data=array();
    if(isset($_POST['vehicle_id']) && $_POST['vehicle_id']!='' && $_POST['vehicle_id']!='all'){
      $data['vws.vehicle_id'] = $_POST['vehicle_id'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['vws.vehicle_work_id'] = $_POST['work'];
    }

    if(isset($_POST['consignee']) && $_POST['consignee']!='' && $_POST['consignee']!='all'){
      $data['v.consignee'] = $_POST['consignee'];
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['vws.created_by'] = $_POST['user_id'];
    }
    if(isset($_POST['driver']) && $_POST['driver']!='' && $_POST['driver']!='all'){
      $data['vws.driver_id'] = $_POST['driver'];
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!='' && $_POST['start_date']!='all'){
      $data['vws.worked_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!='' && $_POST['end_date']!='all'){
      $data['vws.worked_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
    }
    if(isset($_POST['payment_status']) && $_POST['payment_status']!='' && $_POST['payment_status']!='all'){
      $payment_status = $_POST['payment_status'];
      if($payment_status==1){
        $data['vws.balance <='] = 0;
      }else{
        $data['vws.balance >'] = 0;
      }
    }
    $vehicles	= $this->Vehicle->select_vehicle("")->result();
    $btn_delete=$btn_edit=$payment_status=$btn_add_payment='';
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(vws.worked_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(vws.worked_date,'%Y-%m-%d') >="]= $start_date;
    }
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, wc.assigned_users)");
    }
    $entry_approval = 1;
    if($this->config->item('User_enable_data_entry_approval')==1){//webapp users approval
      $entry_approval = 'all';
    }
    if($page_data_type=='approval_entries'){
      $entry_approval = 'all';
      $data['u.user_role >'] =2;
      if(isset($_POST['approval_status']) && $_POST['approval_status']!='' && $_POST['approval_status']!='all'){
        $entry_approval = $_POST['approval_status'];
      }
    }
    if(isset($_POST['work_ids']) && $_POST['work_ids']!='' && $_POST['work_ids']!='all'){
      $this->db->where_in('vws.vehicle_work_id',explode(',',$_POST['work_ids']));
    }
    $result	= $this->Vehicle_work_slips->select_vehicle_work_slips("u.*,v.*,wc.*,vws.*,e.employee_name,vws.basic_charge AS vws_basic_charge,vws.basic_charge_2 AS vws_basic_charge_2,vws.basic_charge_3 AS vws_basic_charge_3,vws.remarks AS vws_remarks,vws.balance AS vws_balance,vws.created_by AS vws_created_by,vws.created_date AS vws_created_date,vws.updated_by AS vws_updated_by,vws.updated_date AS vws_updated_date,vc.consignee_name,u.user_role as created_user_role_id",$data,"","","","","",$entry_approval);

    foreach($result->result() as $row):
      $sl_no++;
      $btn_add_payment = $btn_delete = $btn_edit = $btn_print = '';
      if(($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')==$row->created_by) && ($this->config->item('User_enable_data_entry_approval')!=1 || $row->entry_approval_status!=1 || $this->session->userdata('user_role')=='admin')) {
        $btn_delete='<a style="margin-left: 5px;margin-right: 5px" id="vehicles_work_slip_delete_btn" href="#vehicle_work_slip_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-trash"></i>
        </a>';
        $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="vehicle_work_slip_edit_btn" href="#vehicle_work_slip_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }
      $btn_print='<a data-slip-id="'.$row->work_slip_id.'" style="margin-left: 5px;margin-right: 5px" id="btn_print_work_slip"  class="btn btn-warning m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      <i class="fa fa-print"></i>
      </a>';

      if($row->vws_balance<=0){
        $payment_status="<span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Paid</span>";
      }else{
        if($row->vws_balance==$row->total_payable_amount){
          $payment_status="<span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-times-circle'></i> Not Paid</span>";
        }else{
          $payment_status="<span class='m-badge m-badge--info m-badge--wide'><i class='fa fa-times-circle'></i> Partially Paid</span>";
        }
        if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_role')=='admin' || $this->session->userdata('user_id')==$row->created_by) {
          if($this->config->item('Vehicle_payment_based_on')=='work_slip'){
          $btn_add_payment = '<a style="margin-left: 5px;margin-right: 5px" data-bill-type="vehicle_work_slip" data-bill-id="'.$row->work_slip_id.'" id="btn_add_bill_payment" data-toggle="modal"
          href="#bill_payment_add_modal" class="btn btn-focus m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
          <i class="la la-plus-circle"></i>
          </a>';
        }
        }
      }

      if($row->work_slip_type=='inside_work'){
        $work_slip_type="<span class='m-badge m-badge--success m-badge--wide'> Inside</span>";
      }else{
        $work_slip_type="<span class='m-badge m-badge--info m-badge--wide'> Outside</span>";
      }

      $btn_approve = $entry_approval_status = '';
      if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="vehicle_work_slip" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->work_slip_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
        <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
        </a>';
      }
      if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
        if($row->entry_approval_status==1){
          $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
        }elseif($row->entry_approval_status==2){
          $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
        }else{
          $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
        }
      }



      $work_slip_expense_details = '';
      $expense_where_data['vwse.work_slip_id'] = $row->work_slip_id;
      $work_slip_expenses	= $this->Vehicle_work_slips->select_vehicle_work_slip_expense("vwse.*,s.supplier_name,sl.location_name",$expense_where_data,"","","","","",$entry_approval)->result();
      foreach ($work_slip_expenses as $key => $value) {
        if($value->supplier_type=='supplier'){
          // Supplier
          $supplier_name = $value->supplier_name;
        }else{
          // Warehouse
          $supplier_name = $value->location_name;
        }
        if($value->include_work_slip_payable==1){
          $include_work_slip_payable = '&nbsp;<i class="fa fa-check-circle"></i>';
        }else{
          $include_work_slip_payable = '&nbsp;<i class="fa fa-minus-circle"></i>';
        }
        if($value->expense_head=="Fuel"){
          $expense_head = $value->expense_head."(".$value->expense_type.")";
        }else{
          $expense_head = $value->expense_head;
        }
        $work_slip_expense_details.=$expense_head." [".$supplier_name."] - ".$value->total_qty."/".$value->total_amount."/".$value->remarks.$include_work_slip_payable."<br/>";
      }

      if($row->driver_bata_include==1){
        $driver_bata_include = '&nbsp;<i class="fa fa-check-circle"></i>';
      }else{
        $driver_bata_include = '&nbsp;<i class="fa fa-minus-circle"></i>';
      }

      $duration = $row->worked_duration." ".$row->duration_type;
      $basic_charge = $row->vws_basic_charge."X".$row->worked_duration." = ".($row->vws_basic_charge*$row->worked_duration);
      if($this->config->item('app_module_vehicle_management')==1){
        if($row->worked_duration_2!=0){
          $duration .= "<br/>".$row->worked_duration_2." ".$row->duration_type_2;
          $basic_charge .= "<br/>".$row->vws_basic_charge_2."X".$row->worked_duration_2." = ".($row->vws_basic_charge_2*$row->worked_duration_2);
        }
        if($row->worked_duration_3!=0){
          $duration .= "<br/>".$row->worked_duration_3." ".$row->duration_type_3;
          $basic_charge .= "<br/>".$row->vws_basic_charge_3."X".$row->worked_duration_3." = ".($row->vws_basic_charge_3*$row->worked_duration_3);
        }
      }
      $purchase_details='';
      if($row->purchase_bill_id!=0){
        $purchase_details.='<br/><a target="_blank" href="'.base_url().'purchases/profile/'.$row->purchase_bill_id.'">For Purchase Bill #'.$row->purchase_bill_id.'</a>';
      }elseif($row->stock_transfer_bill_id!=0){
        $purchase_details.='<br/><a target="_blank" href="'.base_url().'stock/transfer_bill/'.$row->stock_transfer_bill_id.'">For Stock Transfer Bill #'.$row->stock_transfer_bill_id.'</a>';
      }

      $array[$j][]=$row->vehicle_id;
      $array[$j][]=$sl_no;
      $array[$j][]=$row->work_slip_id;
      $array[$j][]='<a href="' . base_url() . 'vehicles/profile/' . $row->vehicle_id . '">'.$row->vehicle_name." : ".$row->vehicle_no. '</a>';
      $array[$j][]='<a href="' . base_url() . 'vehicles/consignees/profile/' . $row->consignee . '">'.$row->consignee_name.'</a>';
      $array[$j][]=$work_slip_type;
      $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>'.$purchase_details;
      $array[$j][]=date('d-m-Y',strtotime($row->worked_date));
      $array[$j][]=$duration;
      $array[$j][]=$basic_charge;
      $array[$j][]=$row->overtime_duration;
      $array[$j][]=$row->overtime_rate;
      $array[$j][]=$row->overtime_amount;
      $array[$j][]=$row->employee_name;
      $array[$j][]=date('h:i A',strtotime($row->start_time));
      $array[$j][]=($row->job_status==1)?date('h:i A',strtotime($row->end_time)):"";
      $array[$j][]=$row->start_km;
      $array[$j][]=$row->end_km;
      $array[$j][]=$row->load_type;
      $array[$j][]=$row->load_qty;
      $array[$j][]=$row->total_load_qty;
      $array[$j][]=$row->load_qty_in;
      $array[$j][]=$row->location;
      $array[$j][]=$row->driver_bata;
      $array[$j][]=$row->driver_bata_include;
      $array[$j][]=$work_slip_expense_details;
      $array[$j][]=$row->total_expense_amount;
      $array[$j][]=$row->driver_bata.$driver_bata_include;
      $array[$j][]=$row->loading_amount;
      $array[$j][]=$row->commission;
      $array[$j][]=$row->labour_charge;
      $array[$j][]=$row->other_expenses;
      $array[$j][]=$row->total_payable_amount;
      $array[$j][]=$row->total_paid;
      $array[$j][]=$row->vws_balance;
      $array[$j][]=$row->vws_remarks;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->vws_created_date))."</li><li>Created By : ".$row->user_alias."</li>".$entry_approval_status;
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->user_alias.'</li>'.$entry_approval_status;
      }
      $array[$j][]=$payment_status;
      $array[$j][]=$btn_add_payment.$btn_print.$btn_edit.$btn_delete.$btn_approve;
      $array[$j][]=$row->vehicle_work_id;
      $array[$j][]=$row->duration_type;
      $array[$j][]=$row->worked_duration;
      $array[$j][]=$row->work_slip_type;
      $array[$j][]=$row->load_qty_in;
      $array[$j][]=$row->entry_approval_status;
      $array[$j][]=$row->driver_id;
      $array[$j][]=$row->vehicle_type;

      $total_total_payable_amount+=$row->total_payable_amount;
      $total_total_paid+=$row->total_paid;
      $total_overtime_duration+=$row->overtime_duration;
      $total_overtime_amount+=$row->overtime_amount;
      $total_driver_bata+=$row->driver_bata;
      $total_fuel_amount+=$row->fuel_amount;
      $total_loading_amount+=$row->loading_amount;
      $total_commission+=$row->commission;
      $total_labour_charge+=$row->labour_charge;
      $total_other_expenses+=$row->other_expenses;
      $total_total_balance+=$row->vws_balance;

      $j++;
    endforeach;

    if($result->num_rows()>0){
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>Total</strong>";
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>".$total_overtime_duration."</strong>";
      $array[$j][]='';
      $array[$j][]="<strong>".$total_overtime_amount."</strong>";
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>".$total_fuel_amount."</strong>";
      $array[$j][]="<strong>".$total_driver_bata."</strong>";
      $array[$j][]="<strong>".$total_loading_amount."</strong>";
      $array[$j][]="<strong>".$total_commission."</strong>";
      $array[$j][]="<strong>".$total_labour_charge."</strong>";
      $array[$j][]="<strong>".$total_other_expenses."</strong>";
      $array[$j][]="<strong>".$total_total_payable_amount."</strong>";
      $array[$j][]="<strong>".$total_total_paid."</strong>";
      $array[$j][]="<strong>".$total_total_balance."</strong>";
      $array[$j][]='';
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
      $array[$j][]="";
    }

    $json_data['data']=$array;
    $json_data['draw']=5;
    $json_data['recordsTotal']=sizeof($array);
    $json_data['recordsFiltered']=sizeof($array);
    echo json_encode($json_data);  // send data as json format
  }


  public function create()
  {
    $data2['vehicle_id'] = $data3['vehicle_id'] = $this->security->xss_clean($this->input->post('vehicle_id'));
    if($this->config->item('app_module_vehicle_management')==1){
      $data2['work_slip_type'] = $this->security->xss_clean($this->input->post('work_slip_type'));
    }else{
      $data2['work_slip_type'] = 'inside_work';
    }
    $data2['worked_date'] = $data3['worked_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('worked_date'))));
    if($data2['work_slip_type']=='inside_work'){
      $data2['vehicle_work_id'] = $data3['work_id'] = $this->security->xss_clean($this->input->post('work_id'));
      $data2['project_stage_id'] = $this->projects_management->get_project_stage_id($data2['vehicle_work_id']);
      // $count = $this->Vehicle_work_slips->select_vehicle_work_slips("",$data3)->num_rows();
      $count = 0;
    }else{
      $count = 0;
    }
    if($this->config->item('app_module_vehicle_management')==1){
      //Basic Wages
      $basic_wage_array=$newArraybasic_wage=array();
      if($this->input->post('work_slip_basic_wage')){
        $basic_wage_array = $this->input->post('work_slip_basic_wage');
      }
      foreach (array_keys($basic_wage_array) as $fieldKey) {
        foreach ($basic_wage_array[$fieldKey] as $key=>$value) {
          $newArraybasic_wage[$key][$fieldKey] = $value;
        }
      }
      foreach ($newArraybasic_wage as $key=>$row) {
        if($key==0){
          $data2['duration_type'] = $row['duration_type'];
          $data2['worked_duration'] = $row['duration'];
          $data2['basic_charge'] = $row['unit_price'];
        }
        if($key==1){
          $data2['duration_type_2'] = $row['duration_type'];
          $data2['worked_duration_2'] = $row['duration'];
          $data2['basic_charge_2'] = $row['unit_price'];
        }
        if($key==2){
          $data2['duration_type_3'] = $row['duration_type'];
          $data2['worked_duration_3'] = $row['duration'];
          $data2['basic_charge_3'] = $row['unit_price'];
        }
      }
    }else{
      $data2['duration_type'] = $this->security->xss_clean($this->input->post('work_duration_type'));
      $data2['worked_duration'] = $this->security->xss_clean($this->input->post('worked_duration'));
      $data2['basic_charge'] = $this->security->xss_clean($this->input->post('basic_charge'));
    }
    $data2['overtime_duration'] = $this->security->xss_clean($this->input->post('overtime_duration'));
    $data2['overtime_rate'] = $this->security->xss_clean($this->input->post('overtime_rate'));
    $data2['overtime_amount'] = $this->security->xss_clean($this->input->post('overtime_amount'));
    $data2['commission'] = $this->security->xss_clean($this->input->post('commission'));
    $data2['labour_charge'] = $this->security->xss_clean($this->input->post('labour_charge'));
    $data2['other_expenses'] = $this->security->xss_clean($this->input->post('other_expenses'));
    if($this->config->item('app_module_vehicle_management')==1){
      $data2['driver_id'] = $this->security->xss_clean($this->input->post('driver'));
      $data2['start_time'] = date('H:i:s',strtotime($this->input->post('start_time')));
      $data2['end_time'] = date('H:i:s',strtotime($this->input->post('end_time')));
      $data2['start_km'] = $this->security->xss_clean($this->input->post('start_km'));
      $data2['end_km'] = $this->security->xss_clean($this->input->post('end_km'));
      $data2['total_km'] = $this->security->xss_clean($this->input->post('total_km'));
      $data2['location'] = $this->security->xss_clean($this->input->post('location'));
      $data2['load_type'] = $this->security->xss_clean($this->input->post('load_type'));
      $data2['load_qty'] = $this->security->xss_clean($this->input->post('load_qty'));
      $data2['load_qty_in'] = $this->security->xss_clean($this->input->post('load_qty_type'));
      $data2['total_load_qty'] = $this->security->xss_clean($this->input->post('total_load_qty'));
      $data2['driver_bata'] = $this->security->xss_clean($this->input->post('driver_bata'));
      $data2['driver_bata_include'] = $this->security->xss_clean($this->input->post('driver_bata_include'));
      $data2['loading_amount'] = $this->security->xss_clean($this->input->post('loading_amount'));
    }
    $data2['total_expense_amount'] = $this->security->xss_clean($this->input->post('expense_total_amount'));
    $data2['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
    $data2['total_payable_amount'] = $this->security->xss_clean($this->input->post('total_payable_amount'));
    $data2['total_paid'] = $this->security->xss_clean($this->input->post('paid_amount'));
    $data2['balance'] = $this->security->xss_clean($this->input->post('total_balance'));
    if($this->config->item('User_enable_data_entry_approval')==1 && $this->session->userdata('user_role_id')>2){
      $data2['entry_approval_status'] = 0;
    }
    $data2['created_date'] = date('Y-m-d H:i:s');
    $data2['created_by'] = $this->session->userdata('user_id');
    if($count==0) {
      $result2 = $this->Vehicle_work_slips->create_vehicle_work_slip($data2);
      $flash_data['status'] = $result2['status'];
      if ($result2['status'] == 1) {
        $flash_data['flashdata_msg'] = 'Vehicle Work Slip Added Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';

        if($this->config->item('app_module_vehicle_management')==1){
          //Expenses
          $expense_data['work_slip_id'] = $result2['insert_id'];
          $expense_array=$newArrayexpense=array();
          if($this->input->post('work_slip_expense')){
            $expense_array = $this->input->post('work_slip_expense');
          }
          $expense_array_length = sizeof($expense_array);
          foreach (array_keys($expense_array) as $fieldKey) {
            foreach ($expense_array[$fieldKey] as $key=>$value) {
              $newArrayexpense[$key][$fieldKey] = $value;
            }
          }
          foreach ($newArrayexpense as $row) {
            $supplier = explode('_',$row['supplier']);
            $expense_data['expense_head'] = $row['expense_type'];
            if(isset($row['fuel_type'])){
              $expense_data['expense_type'] = $row['fuel_type'];
            }
            $expense_data['supplier_id'] = $supplier[1];
            $expense_data['supplier_type'] = $supplier[0];
            $expense_data['total_qty'] = $row['qty'];
            $expense_data['unit_price'] = $row['price'];
            $expense_data['total_amount'] = $row['total'];
            $expense_data['remarks'] = $row['remarks'];
            if(isset($row['includable'])){
              $expense_data['include_work_slip_payable'] = $row['includable'];
            }else{
              $expense_data['include_work_slip_payable'] = 0;
            }
            $result3 = $this->Vehicle_work_slips->create_vehicle_work_slip_expense($expense_data);
          }
        }

        // Insert IF Payment Exist
        if($this->input->post('paid_amount') && $this->security->xss_clean($this->input->post('paid_amount'))>0){
          $transaction_data['reference_id'] = $result2['insert_id'];
          $transaction_data['reference_type'] = "vehicle_work_slip";
          $transaction_data['tr_type'] = "vehicle_work_slip_transaction";
          $transaction_data['tr_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('paid_date'))));
          $transaction_data['tr_debit_acc'] = $this->security->xss_clean($this->input->post('debit_acc'));
          $transaction_data['tr_credit_acc'] = 12;//vehicle work slip
          $transaction_data['tr_description'] = "Vehicle Work Slip Transaction";
          $transaction_data['tr_amount'] = $this->security->xss_clean($this->input->post('paid_amount'));
          $transaction_data['tr_mode'] = $this->security->xss_clean($this->input->post('payment_mode'));
          $transaction_data['tr_reference_no'] = $this->security->xss_clean($this->input->post('reference_no'));
          if($this->input->post('reference_date')!=''){
            $transaction_data['tr_reference_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('reference_date'))));
          }
          $transaction_data['tr_remarks'] = $this->security->xss_clean($this->input->post('tr_remarks'));
          $transaction_data['created_date'] = date('Y-m-d H:i:s');
          $transaction_data['created_by'] = $this->session->userdata('user_id');
          $transaction_result =  $this->Account->create_account_transaction($transaction_data);
          $flash_data['flashdata_msg'] = 'Vehicle Work Slip & Transaction Added Successfully!.';
        }
        $this->bills_management->calculate_vehicle_work_slip_total($result2['insert_id']);
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else{
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. Vehicle Work Slip on Same Date & Work Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Duplication !!';
    }
    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));
  }
  public function update()
  {
    $data2['work_slip_id'] = $this->security->xss_clean($this->input->post('work_slip_id'));
    $data2['vehicle_id'] = $data3['vehicle_id'] = $this->security->xss_clean($this->input->post('vehicle_id'));
    if($this->config->item('app_module_vehicle_management')==1){
      $data2['work_slip_type'] = $this->security->xss_clean($this->input->post('work_slip_type_edit'));
    }else{
      $data2['work_slip_type'] = 'inside_work';
    }
    $data2['worked_date'] = $data3['worked_date'] = date('Y-m-d',strtotime($this->security->xss_clean($this->input->post('worked_date'))));
    if($data2['work_slip_type']=='inside_work'){
      $data2['vehicle_work_id'] = $data3['work_id'] = $this->security->xss_clean($this->input->post('work_id'));
      // $data2['project_stage_id'] = $this->projects_management->get_project_stage_id($data2['vehicle_work_id']);
      // $count = $this->Vehicle_work_slips->select_vehicle_work_slips("",$data3)->num_rows();
      $count = 0;
    }else{
      $count = 0;
    }
    $data2['duration_type'] = $this->security->xss_clean($this->input->post('work_duration_type'));
    $data2['worked_duration'] = $this->security->xss_clean($this->input->post('worked_duration'));
    $data2['basic_charge'] = $this->security->xss_clean($this->input->post('basic_charge'));
    $data2['overtime_duration'] = $this->security->xss_clean($this->input->post('overtime_duration'));
    $data2['overtime_rate'] = $this->security->xss_clean($this->input->post('overtime_rate'));
    $data2['overtime_amount'] = $this->security->xss_clean($this->input->post('overtime_amount'));
    $data2['commission'] = $this->security->xss_clean($this->input->post('commission'));
    $data2['labour_charge'] = $this->security->xss_clean($this->input->post('labour_charge'));
    $data2['other_expenses'] = $this->security->xss_clean($this->input->post('other_expenses'));
    if($this->config->item('app_module_vehicle_management')==1){
      $data2['driver_id'] = $this->security->xss_clean($this->input->post('driver'));
      $data2['start_time'] = date('H:i:s',strtotime($this->input->post('start_time')));
      $data2['end_time'] = date('H:i:s',strtotime($this->input->post('end_time')));
      $data2['start_km'] = $this->security->xss_clean($this->input->post('start_km'));
      $data2['end_km'] = $this->security->xss_clean($this->input->post('end_km'));
      // $data2['total_km'] = $this->security->xss_clean($this->input->post('total_km'));
      $data2['location'] = $this->security->xss_clean($this->input->post('location'));
      $data2['load_type'] = $this->security->xss_clean($this->input->post('load_type'));
      $data2['load_qty'] = $this->security->xss_clean($this->input->post('load_qty'));
      $data2['load_qty_in'] = $this->security->xss_clean($this->input->post('load_qty_type'));
      $data2['total_load_qty'] = $this->security->xss_clean($this->input->post('total_load_qty'));
      $data2['driver_bata'] = $this->security->xss_clean($this->input->post('driver_bata'));
      // $data2['driver_bata_include'] = $this->security->xss_clean($this->input->post('driver_bata_include'));

      $data2['loading_amount'] = $this->security->xss_clean($this->input->post('loading_amount'));
    }
    $data2['remarks'] = $this->security->xss_clean($this->input->post('remarks'));
    $data2['total_payable_amount'] = $this->security->xss_clean($this->input->post('total_payable_amount'));
    $data2['updated_date'] = date('Y-m-d H:i:s');
    $data2['updated_by'] = $this->session->userdata('user_id');

    $result2 = $this->Vehicle_work_slips->update_vehicle_work_slip($data2);
    $flash_data['status'] = $result2;
    if ($result2 == 1) {
      $this->bills_management->calculate_vehicle_work_slip_total($data2['work_slip_id']);
      $flash_data['flashdata_msg'] = 'Vehicle Work Slip Updated Successfully!.';
      $flash_data['message'] = 'Vehicle Work Slip Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['message'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));

  }
  public function delete()
  {
    $data['work_slip_id'] = $this->security->xss_clean($this->input->post('work_slip_id'));
    $data['delete_status'] = 1;

    $result = $this->Vehicle_work_slips->update_vehicle_work_slip($data);
    $flash_data['status'] = $result;
    if ($result == 1) {
      $flash_data['flashdata_msg'] = 'Vehicle Work Slip Deleted Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo(json_encode($flash_data));
  }

  public function select_vehicle_fuel_report($page_data_type=''){

    $json_data=$array=array();
    $j=$sl_no=0;
    $total_worked_durations=$total_total_payable_amount=$total_total_paid=$total_overtime_duration=$total_overtime_amount=$total_driver_bata=$total_fuel_amount=$total_loading_amount=$total_commission=$total_labour_charge=$total_other_expenses=0;
    $data=array();
    if(isset($_POST['vehicle_id']) && $_POST['vehicle_id']!='' && $_POST['vehicle_id']!='all'){
      $data['vws.vehicle_id'] = $_POST['vehicle_id'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['vws.vehicle_work_id'] = $_POST['work'];
    }
    if(isset($_POST['consignee']) && $_POST['consignee']!='' && $_POST['consignee']!='all'){
      $data['v.consignee'] = $_POST['consignee'];
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['vws.created_by'] = $_POST['user_id'];
    }
    if(isset($_POST['driver']) && $_POST['driver']!='' && $_POST['driver']!='all'){
      $data['vws.driver_id'] = $_POST['driver'];
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!='' && $_POST['start_date']!='all'){
      $data['vws.worked_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!='' && $_POST['end_date']!='all'){
      $data['vws.worked_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
    }
    $vehicles	= $this->Vehicle->select_vehicle("")->result();
    $btn_delete=$btn_edit=$payment_status=$btn_add_payment='';
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(vws.worked_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(vws.worked_date,'%Y-%m-%d') >="]= $start_date;
    }
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, wc.assigned_users)");
    }

    $data['expense_head'] = 'Fuel';
    $result	= $this->Vehicle_work_slips->select_vehicle_work_slip_expense("vwse.*,vwse.remarks as vwse_remarks,vws.basic_charge AS vws_basic_charge,vws.basic_charge_2 AS vws_basic_charge_2,vws.basic_charge_3 AS vws_basic_charge_3,s.supplier_name,u.user_alias,v.vehicle_name,v.vehicle_no,vws.*,vc.consignee_name,wc.work_name,wc.work_id,vws.created_date as vws_created_date,sl.location_name as warehouse_name",$data,"","","","","");

    foreach($result->result() as $row):
      $sl_no++;
      $btn_add_payment = $btn_delete = $btn_edit = '';

      if($row->work_slip_type=='inside_work'){
        $work_slip_type="<span class='m-badge m-badge--success m-badge--wide'> Inside</span>";
        $project = '<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
      }else{
        $work_slip_type="<span class='m-badge m-badge--info m-badge--wide'> Outside</span>";
        $project = '';
      }

      $duration = $row->worked_duration." ".$row->duration_type;
      $basic_charge = $row->vws_basic_charge."X".$row->worked_duration." = ".($row->vws_basic_charge*$row->worked_duration);
      if($this->config->item('app_module_vehicle_management')==1){
        if($row->worked_duration_2!=0){
          $duration .= "<br/>".$row->worked_duration_2." ".$row->duration_type_2;
          $basic_charge .= "<br/>".$row->vws_basic_charge_2."X".$row->worked_duration_2." = ".($row->vws_basic_charge_2*$row->worked_duration_2);
        }
        if($row->worked_duration_3!=0){
          $duration .= "<br/>".$row->worked_duration_3." ".$row->duration_type_3;
          $basic_charge .= "<br/>".$row->vws_basic_charge_3."X".$row->worked_duration_3." = ".($row->vws_basic_charge_3*$row->worked_duration_3);
        }
      }

      if($row->supplier_type=='warehouse'){
        $supplier_name = $row->warehouse_name;
      }else{
        $supplier_name = $row->supplier_name;
      }

      if($row->include_work_slip_payable==1){
        $include_work_slip_payable = '&nbsp;<i class="fa fa-check-circle"></i>';
      }else{
        $include_work_slip_payable = '&nbsp;<i class="fa fa-minus-circle"></i>';
      }

      $array[$j][]=$sl_no;
      $array[$j][]=$row->work_slip_id;
      $array[$j][]=date('d-m-Y',strtotime($row->worked_date));
      $array[$j][]='<a href="' . base_url() . 'vehicles/profile/' . $row->vehicle_id . '">'.$row->vehicle_name." : ".$row->vehicle_no. '</a>';
      $array[$j][]=$supplier_name;
      $array[$j][]=$row->supplier_type;
      $array[$j][]=$row->expense_type;
      $array[$j][]=$row->total_qty;
      $array[$j][]=$row->total_amount;
      $array[$j][]=$row->vwse_remarks;
      $array[$j][]=$include_work_slip_payable;
      $array[$j][]=$work_slip_type;
      $array[$j][]=$project;
      $array[$j][]=$duration;
      $array[$j][]=$row->start_km;
      $array[$j][]=$row->end_km;
      $array[$j][]=$row->total_payable_amount;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->vws_created_date))."</li><li>Created By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->user_alias.'</li>';
      }


      $total_total_payable_amount+=$row->total_payable_amount;
      $total_fuel_amount+=$row->total_amount;

      $j++;
    endforeach;

    if($result->num_rows()>0){
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>Total</strong>";
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>".$total_fuel_amount."</strong>";
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>".$total_total_payable_amount."</strong>";
      $array[$j][]="";
    }

    $json_data['data']=$array;
    $json_data['draw']=5;
    $json_data['recordsTotal']=sizeof($array);
    $json_data['recordsFiltered']=sizeof($array);
    echo json_encode($json_data);  // send data as json format
  }

  public function select_driver_bata_report($page_data_type=''){

    $json_data=$array=array();
    $j=$sl_no=0;
    $total_worked_durations=$total_total_payable_amount=$total_total_paid=$total_overtime_duration=$total_overtime_amount=$total_driver_bata=$total_fuel_amount=$total_loading_amount=$total_commission=$total_labour_charge=$total_other_expenses=0;
    $data=array();
    if(isset($_POST['vehicle_id']) && $_POST['vehicle_id']!='' && $_POST['vehicle_id']!='all'){
      $data['vws.vehicle_id'] = $_POST['vehicle_id'];
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $data['vws.vehicle_work_id'] = $_POST['work'];
    }
    if(isset($_POST['consignee']) && $_POST['consignee']!='' && $_POST['consignee']!='all'){
      $data['v.consignee'] = $_POST['consignee'];
    }
    if(isset($_POST['user_id']) && $_POST['user_id']!='' && $_POST['user_id']!='all'){
      $data['vws.created_by'] = $_POST['user_id'];
    }
    if(isset($_POST['driver']) && $_POST['driver']!='' && $_POST['driver']!='all'){
      $data['vws.driver_id'] = $_POST['driver'];
    }
    if(isset($_POST['start_date']) && $_POST['start_date']!='' && $_POST['start_date']!='all'){
      $data['vws.worked_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
    }
    if(isset($_POST['end_date']) && $_POST['end_date']!='' && $_POST['end_date']!='all'){
      $data['vws.worked_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
    }
    $vehicles	= $this->Vehicle->select_vehicle("")->result();
    $btn_delete=$btn_edit=$payment_status=$btn_add_payment='';
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(vws.worked_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(vws.worked_date,'%Y-%m-%d') >="]= $start_date;
    }
    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, wc.assigned_users)");
    }
    $entry_approval = 1;
    if($this->config->item('User_enable_data_entry_approval')==1){//webapp users approval
      $entry_approval = 'all';
    }
    if($page_data_type=='approval_entries'){
      $entry_approval = 'all';
      $data['u.user_role >'] =2;
      if(isset($_POST['approval_status']) && $_POST['approval_status']!='' && $_POST['approval_status']!='all'){
        $entry_approval = $_POST['approval_status'];
      }
    }

    $result	= $this->Vehicle_work_slips->select_vehicle_work_slips("u.*,v.*,wc.*,vws.*,e.employee_name,vws.basic_charge AS vws_basic_charge,vws.basic_charge_2 AS vws_basic_charge_2,vws.basic_charge_3 AS vws_basic_charge_3,vws.remarks AS vws_remarks,vws.balance AS vws_balance,vws.created_by AS vws_created_by,vws.created_date AS vws_created_date,vws.updated_by AS vws_updated_by,vws.updated_date AS vws_updated_date,vc.consignee_name,u.user_role as created_user_role_id",$data,"","","","","",$entry_approval);

    foreach($result->result() as $row):
      $sl_no++;

      if($row->work_slip_type=='inside_work'){
        $work_slip_type="<span class='m-badge m-badge--success m-badge--wide'> Inside</span>";
      }else{
        $work_slip_type="<span class='m-badge m-badge--info m-badge--wide'> Outside</span>";
      }

      if($row->driver_bata_include==1){
        $driver_bata_include = '&nbsp;<i class="fa fa-check-circle"></i>';
      }else{
        $driver_bata_include = '&nbsp;<i class="fa fa-minus-circle"></i>';
      }

      $duration = $row->worked_duration." ".$row->duration_type;
      $basic_charge = $row->vws_basic_charge."X".$row->worked_duration." = ".($row->vws_basic_charge*$row->worked_duration);
      if($this->config->item('app_module_vehicle_management')==1){
        if($row->worked_duration_2!=0){
          $duration .= "<br/>".$row->worked_duration_2." ".$row->duration_type_2;
          $basic_charge .= "<br/>".$row->vws_basic_charge_2."X".$row->worked_duration_2." = ".($row->vws_basic_charge_2*$row->worked_duration_2);
        }
        if($row->worked_duration_3!=0){
          $duration .= "<br/>".$row->worked_duration_3." ".$row->duration_type_3;
          $basic_charge .= "<br/>".$row->vws_basic_charge_3."X".$row->worked_duration_3." = ".($row->vws_basic_charge_3*$row->worked_duration_3);
        }
      }
      $purchase_details='';
      if($row->purchase_bill_id!=0){
        $purchase_details.='<br/><a target="_blank" href="'.base_url().'purchases/profile/'.$row->purchase_bill_id.'">For Purchase Bill #'.$row->purchase_bill_id.'</a>';
      }elseif($row->stock_transfer_bill_id!=0){
        $purchase_details.='<br/><a target="_blank" href="'.base_url().'stock/transfer_bill/'.$row->stock_transfer_bill_id.'">For Stock Transfer Bill #'.$row->stock_transfer_bill_id.'</a>';
      }

      $array[$j][]=$sl_no;
      $array[$j][]=$row->work_slip_id;
      $array[$j][]=date('d-m-Y',strtotime($row->worked_date));
      $array[$j][]='<a href="' . base_url() . 'vehicles/profile/' . $row->vehicle_id . '">'.$row->vehicle_name." : ".$row->vehicle_no. '</a>';
      $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>'.$purchase_details;
      $array[$j][]=$duration;
      $array[$j][]=$row->employee_name;
      $array[$j][]=$row->driver_bata;
      $array[$j][]=$row->driver_bata_include;
      $array[$j][]=date('h:i A',strtotime($row->start_time));
      $array[$j][]=($row->job_status==1)?date('h:i A',strtotime($row->end_time)):"";
      $array[$j][]=$row->start_km;
      $array[$j][]=$row->end_km;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created on : '.date('d-m-Y',strtotime($row->vws_created_date))."</li><li>Created By : ".$row->user_alias."</li>";
      }else{
        $array[$j][]='<ul style="padding: .75rem;margin-bottom: 0"><li>Created By : '.$row->user_alias.'</li>';
      }

      $total_total_payable_amount+=$row->driver_bata;
      $total_total_paid+=$row->total_paid;
      $total_overtime_duration+=$row->overtime_duration;
      $total_overtime_amount+=$row->overtime_amount;
      $total_driver_bata+=$row->driver_bata;
      $total_fuel_amount+=$row->fuel_amount;
      $total_loading_amount+=$row->loading_amount;
      $total_commission+=$row->commission;
      $total_labour_charge+=$row->labour_charge;
      $total_other_expenses+=$row->other_expenses;

      $j++;
    endforeach;

    if($result->num_rows()>0){
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>Total</strong>";
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]="<strong>".$total_driver_bata."</strong>";
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';
      $array[$j][]='';

    }

    $json_data['data']=$array;
    $json_data['draw']=5;
    $json_data['recordsTotal']=sizeof($array);
    $json_data['recordsFiltered']=sizeof($array);
    echo json_encode($json_data);  // send data as json format
  }
}
?>
