<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class User_payments extends CI_Controller
{
  public $page_data = array();

  function __construct()
  {
    parent::__construct();
    $this->initial();
  }
  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");
    
    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Labour_model', 'Labour');
    $this->load->model('Employees_model', 'Employee');
    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin","admin","supervisor","general_manager","accounts_manager","auditor");
    if($this->User->is_logged_in($allowed_user_roles)==false){
      redirect(base_url(), 'refresh');
    }
    //        File Directory
    $this->page_data['directory'] = "user";
    $this->page_data['labours_2'] = $this->Labour->select_labours()->result();
  }
  public function index()
  {
    $this->view();
  }

  public function view()
  {
    // Check Module is Enabled or Not
    if($this->config->item('app_module_user_payments')==0){
      redirect(base_url().'dashboard', 'refresh');
    }

    $this->page_data['page_name'] = 'user_payments';

    if($this->session->userdata('user_role')=='supervisor') {
      //          Select Assigned Works Only
      $supervisor_id = $this->session->userdata('user_id');
      $this->db->where("FIND_IN_SET($supervisor_id, w.assigned_users)");
    }
    $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();

    $employee_where = "";
    // if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin'){
    //   $user_where = "role_name='supervisor' or role_name='general_manager'";
    // }else{
    //   $user_where = "role_name='supervisor'";
    // }

    // $accounts_where = "ur.role_name='supervisor' or ur.role_name='general_manager'";
    $accounts_where = "";
    $this->page_data['user_accounts'] = $this->Account->select_account_heads("",$accounts_where,"user")->result();
    $this->load->view('Index',$this->page_data);
  }

}
?>
