<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class User extends CI_Controller
{
  public $page_data = array();
  function __construct()
  {
    parent::__construct();
    //Calling Initial Functions
    $this->initial();
  }
  public function initial()
  {
    ini_set('max_execution_time', 5000);
    ini_set("memory_limit", "-1");

    $this->load->model('User_model', 'User');
    $this->load->model('Work_model', 'Work');
    $this->load->model('Client_model', 'Client');
    $this->load->model('Supplier_model', 'Supplier');
    $this->load->model('Purchase_bill_model', 'Purchases');
    $this->load->model('Subcontracts_model', 'Subcontracts');
    $this->load->model('Purchase_order_model', 'Purchase_order');
    $this->load->model('Settings_model', 'Settings');
    $this->load->model('Labour_model', 'Labour');
    $this->load->model('Bills_model', 'Bills');
    $this->load->model('Labour_wages_model', 'Labour_wages');
    $this->load->model('Account_model', 'Account');
    $this->load->model('Attendance_model', 'Attendance');
    $this->load->model('Employees_model', 'Employee');
    $this->load->model('Invoices_model', 'Invoices');
    $this->load->model('Stock_model', 'Stock');
    $this->load->model('Tools_model', 'Tools');
    $this->load->model('Vehicle_model', 'Vehicle');
    $this->load->model('Employees_model', 'Employee');
    $this->load->model('Labour_wages_model', 'Labour_wages');
    $this->load->model('Travel_allowance_model', 'Travel_allowance');
    $this->load->model('Salary_slips_model', 'Salary_slips');
    $this->load->library('Bills_management', 'bills_management');
    $this->load->library('Accounts_management', 'accounts_management');
    $this->load->library('Projects_management', 'projects_management');
    $this->load->library('Supplier_management', 'supplier_management');
    $this->load->library('Stock_management', 'stock_management');
    $this->load->model('Loan_model', 'Loan');

    //        File Directory
    $this->page_data['directory'] = "user";
  }
  public function index()
  {
    $this->view();
  }
  public function view()
  {
    //        Check User Logged in or Not
    $allowed_user_roles = array("madmin", "admin");
    if ($this->User->is_logged_in($allowed_user_roles) == false) {
      redirect(base_url(), 'refresh');
    }

    $this->page_data['owned_vehicles'] = $this->Vehicle->select_vehicle('v.*',array('v.vehicle_type'=>'own'))->result();
    $this->page_data['project_area_locations'] = $this->Work->select_project_area("")->result();
    $role_where_data['ur.active_status'] = 1;
    $role_where_data['ur.role_id >'] = 1;
    if ($this->session->userdata('user_role') == 'admin' && $this->session->userdata('user_login_type') == 'client_user') {
      $role_where_data['ur.role_id >'] = 2;
    }
    if ($this->session->userdata('user_role') == 'general_manager') {
      $role_where_data['ur.role_id >'] = 3;
    }

    $this->page_data['user_roles'] = $this->User->select_user_roles("", $role_where_data)->result();
    $this->page_data['user_roles_all'] = $this->User->select_user_roles("", array("ur.active_status"=>1,"ur.role_id >"=>1))->result();
    foreach ($this->page_data['user_roles_all'] as $key => $value) {
      $value->user_account_count_total = $this->User->select_user("", array("user_role" => $value->role_id))->num_rows();
      $value->user_account_count_active = $this->User->select_user("", array("acc_status" =>1,"user_role" => $value->role_id))->num_rows();
    }
    $this->page_data['invoices'] = $this->Invoices->select_invoices("*,u1.user_id as i_created_by,u1.user_alias as i_created")->result();

    $this->page_data['page_name'] = 'users';
    $this->load->view('Index', $this->page_data);
  }
  public function roles_permissions()
  {
    $allowed_user_roles = array("madmin", "admin");
    if ($this->User->is_logged_in($allowed_user_roles) == false) {
      redirect(base_url(), 'refresh');
    }

    //**Module Settings**//
    $module_element_no = 7003;
    $module_element_type = 'view';
    // $this->page_data['module_element_data'] = $this->Settings->select_module_elements("*,me.slno as elem_slno",array("me.elementno"=>$module_element_no),true)->row();
    // $this->page_data['user_element_details'] = $this->User->check_user_have_module_element_access($module_element_no,$module_element_type);
    //****//

    $this->page_data['page_name'] = 'user_roles';
    $this->load->view('Index',$this->page_data);
  }
  public function print_work_hour_report($user_id = '')
  {
    if ($user_id != '' && isset($_GET['start_date']) && $_GET['start_date'] != '' && isset($_GET['end_date']) && $_GET['end_date'] != '') {
      $this->page_data['page_name'] = 'print_work_hour_report';
      $this->page_data['user_data'] = $this->User->select_user("", array("u.user_id" => $user_id),true)->row();
      $this->page_data['start_date'] = $_GET['start_date'];
      $this->page_data['end_date'] = $_GET['end_date'];
      $this->load->view('Index', $this->page_data);
    } else {
      show_404();
    }
  }
  public function modules()
  {
    $allowed_user_roles = array("madmin", "admin");
    if ($this->User->is_logged_in($allowed_user_roles) == false) {
      redirect(base_url(), 'refresh');
    }

    //**Module Settings**//
    $module_element_no = 7003;
    $module_element_type = 'view';
    // $this->page_data['module_element_data'] = $this->Settings->select_module_elements("*,me.slno as elem_slno",array("me.elementno"=>$module_element_no),true)->row();
    // $this->page_data['user_element_details'] = $this->User->check_user_have_module_element_access($module_element_no,$module_element_type);
    //****//

    $this->page_data['modules'] = $this->config->item('main_menu');
    if(isset($_GET['role']) && $_GET['role']!=''){
      $data['ur.role_id'] = $_GET['role'];
      $data['ur.modulemanagement'] = 1;
      $role_data	= $this->User->select_user_roles("",$data);
      if($role_data->num_rows()==1){
        $this->page_data['role_data'] = $role_data->row();
        if($role_data->row()->modulebasedtype=='role'){
          // Role Based Module Management
          // Get User Module Elements
          $user_element_where['user_id'] = $role_data->row()->role_id;
          $user_element_where['user_id_type'] = 'role';
          foreach ($this->page_data['modules'] as $key0 => $value0) {
            foreach ($value0->menu_list as $key => $value) {
              $value->opened = 0;
              foreach ($value->submenu as $key2 => $value2) {
                $value2->opened = 0;
                // Check User Element Exist & Its Values
                $user_element_where['ue.elementno'] = $value2->elementno;
                $user_element_data = $this->Settings->select_user_module_elements("ue.*",$user_element_where,false);
                if($user_element_data->num_rows()==1 && $user_element_data->row()->activestatus==1){
                  $value2->user_element_data = $user_element_data->row();
                  $value->opened = $value2->opened = 1;
                }else{
                  $value2->user_element_data = 0;
                }
              }
            }
          }

          $this->page_data['modulebasedtype'] = 'role';
          $this->page_data['page_name'] = 'user_modules';
          $this->load->view('Index', $this->page_data);
        }else{
          // Account Based Module Management
          //Get Accounts
          $this->page_data['user_accounts'] = $this->page_data['selected_account'] = '';
          if($role_data->row()->linked_table=='users'){
            $this->page_data['user_accounts'] = $this->User->select_user("",array("u.user_role"=>$role_data->row()->role_id))->result();
          }
          if(isset($_GET['account_id']) && $_GET['account_id']!=''){
            $this->page_data['selected_account'] = $_GET['account_id'];
            // Get User Module Elements
            $user_element_where['user_id'] = $_GET['account_id'];
            $user_element_where['user_id_type'] = 'account';
            foreach ($this->page_data['modules'] as $key0 => $value0) {
              foreach ($value0->menu_list as $key => $value) {
                $value->opened = 0;
                foreach ($value->submenu as $key2 => $value2) {
                  $value2->opened = 0;
                  // Check User Element Exist & Its Values
                  $user_element_where['ue.elementno'] = $value2->elementno;
                  $user_element_data = $this->Settings->select_user_module_elements("ue.*",$user_element_where,false);
                  if($user_element_data->num_rows()==1 && $user_element_data->row()->activestatus==1){
                    $value2->user_element_data = $user_element_data->row();
                    $value->opened = $value2->opened = 1;
                  }else{
                    $value2->user_element_data = 0;
                  }
                }
              }
            }
          }

          $this->page_data['modulebasedtype'] = 'account';
          $this->page_data['page_name'] = 'user_modules';
          $this->load->view('Index', $this->page_data);
        }
      }else{
        show_404();
      }
    }else{
      show_404();
    }
  }

  public function data_approval($level=1,$type='')
  {
    if ($this->session->userdata('user_role') == 'admin' || $this->session->userdata('user_role') == 'accounts_manager') {
      $this->page_data['invoices'] = $this->Invoices->select_invoices("*,u1.user_id as i_created_by,u1.user_alias as i_created")->result();
      $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();
      $user_accounts_where = "ur.role_name='supervisor' or ur.role_name='general_manager'";
      $this->page_data['user_accounts'] = $this->Account->select_account_heads("", $user_accounts_where, "user")->result();
      if ($this->config->item('Labour_group_member_payment') == 0) {
        $this->db->where('(l.labour_type=0 or (l.labour_type=1 and group_position=1))');
      }
      $this->page_data['labours_2'] = $this->Labour->select_labours()->result();
      $this->page_data['labours'] = $this->Labour->select_labours()->result();
      $data['u.user_role >'] = 2;
      $this->page_data['users'] = $this->User->select_user("", $data)->result();

      if($level==2 && $this->session->userdata('user_role') == 'admin'){
        $this->page_data['page_name'] = 'data_entry_approval_2_level';
      }elseif($type=='bulk'){
        $this->page_data['page_name'] = 'data_entry_approval_bulk';
      }else{
        $this->page_data['page_name'] = 'data_entry_approval';
      }
      $this->load->view('Index', $this->page_data);
    } else {
      show_404();
    }
  }
  public function change_password()
  {
    $this->page_data['page_name'] = 'change_password';
    $this->load->view('Index', $this->page_data);
  }
  public function today_salary()
  {
    $this->page_data['page_name'] = 'user_today_salary';
    $this->load->view('Index', $this->page_data);
  }
  public function activity_log()
  {
    $this->page_data['users']  = $this->User->select_user("")->result();
    $this->page_data['page_name'] = 'user_activities_view';
    $this->load->view('Index', $this->page_data);
  }
  public function leave_applications()
  {
    $this->page_data['page_name'] = 'user_leave_applications';
    $this->load->view('Index', $this->page_data);
  }
  public function work_hour_report()
  {
    $data['u.user_role !='] = 1;
    $data['u.user_role !='] = 2;
    if ($this->session->userdata('branch_id') != 0) {
      $data['u.branch_id'] = $this->session->userdata('branch_id');
    }
    $this->page_data['users']  = $this->User->select_user("", $data)->result();

    $this->page_data['user_data'] = '';
    if (isset($_GET['user_id']) && $_GET['user_id'] != '') {
      $this->page_data['user_data'] = $this->User->select_user("", array("u.user_id" => $_GET['user_id']),true)->row();
    }
    if (isset($_POST['user_id']) && $_POST['user_id'] != '') {
      $this->page_data['user_data'] = $this->User->select_user("", array("u.user_id" => $_POST['user_id']),true)->row();
    }
    $this->page_data['page_name'] = 'user_work_hour_report';
    $this->load->view('Index', $this->page_data);
  }
  public function update_password()
  {

    $current_pass_posted = $this->input->post('current_pass');
    $user = $this->User->select_user("", array("user_id" => $this->session->userdata('user_id')));
    if ($user->num_rows() == 1) {
      $current_password = $user->row()->password;
      if ($current_password == $current_pass_posted) {
        $new_pss = $this->input->post('new_pass');
        $new_pass_confirm = $this->input->post('new_pass_confirm');
        if ($new_pss == $new_pass_confirm) {
          $data['password'] = $new_pss;
          $data['user_id'] = $this->session->userdata('user_id');
          // Load the model
          $result = $this->User->update_user($data);
          // Now we verify the result
          if ($result == 1) {
            $flash_data['flashdata_msg'] = 'Password Updated Successfully! ';
            $flash_data['flashdata_type'] = 'success';
            $flash_data['flashdata_title'] = 'Success !';
          } else {
            $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
            $flash_data['flashdata_type'] = 'error';
            $flash_data['flashdata_title'] = 'Error !!';
          }
        } else {
          $flash_data['flashdata_msg'] = 'Sorry.. New Password and Confirmation Password is Not Matching!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. Entered Password is Not Matching Your Current Password!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There has been Some Error Occurred. Please Try Later!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    $this->session->set_flashdata($flash_data);
    redirect(base_url() . 'user/change_password', 'refresh');
  }
  public function profile($id = "")
  {
    $this->page_data['supplier_categories'] = $this->Supplier->select_supplier_category()->result();
    $this->page_data['account_head_data'] = array();
    if ($id != "") {
      $this->page_data['user_data'] = $this->User->select_user("", array("u.user_id" => $id),true);
      if ($this->page_data['user_data']->num_rows() == 1 && ($this->page_data['user_data']->row()->user_role > 2 || ($this->page_data['user_data']->row()->user_role <= 2 && $this->session->userdata('user_role') == 'admin'))) {
        if ($this->session->userdata('user_role') == 'madmin' || $this->session->userdata('user_role') == 'admin' || $this->session->userdata('user_role') == 'general_manager' || ($this->session->userdata('user_role') != 'madmin' && $this->session->userdata('user_role') != 'admin' && $this->session->userdata('user_id') == $this->page_data['user_data']->row()->user_id)) {

          $this->page_data['user_data'] = $this->page_data['user_data']->row();
          $employee_data = $this->Employee->select_employee("e.*", array("e.user_id" => $id));
          if ($employee_data->num_rows() == 1) {
            $employee_data = $employee_data->row();
            $account_head_data = $this->Account->select_account_heads("", array("acc_employee_id" => $employee_data->employee_id));
            if ($account_head_data->num_rows() == 1) {
              $this->page_data['account_head_data'] = $account_head_data->row();
            }
          }
          $this->page_data['invoices'] = $this->Invoices->select_invoices("*,u1.user_id as i_created_by,u1.user_alias as i_created")->result();
          $this->page_data['stock_locations'] = $this->Stock->select_stock_locations()->result();
          $this->page_data['suppliers_list'] = $this->Supplier->select_supplier('*')->result();
          $this->page_data['materials'] = $this->Material->select_material()->result();
          $this->page_data['labours'] = $this->Labour->select_labours()->result();
          $this->page_data['work_contracts'] = $this->Work->select_work("*")->result();
          $this->page_data['vehicles'] = $this->Vehicle->select_vehicle()->result();
          $this->page_data['works'] = $this->Work->select_work("*")->result();
          $this->page_data['employees'] = $this->Employee->select_employee("e.*,u.user_alias")->result();

          $this->page_data['page_name'] = 'user_profile';

          $this->load->view('Index', $this->page_data);
        } else {
          show_404();
        }
      } else {
        show_404();
      }
    } else {
      show_404();
    }
  }
  public function create()
  {
    $allowed_user_count_webapp = $this->config->item('User_max_user_accounts_allowed_web');
    $allowed_user_count_mobileapp = $this->config->item('User_max_user_accounts_allowed_mobile');
    $created_user_count_webapp = $this->User->select_user("u.user_id", array("u.acc_status" => 1,"ur.mobile_app_access" => 0))->num_rows();
    $created_user_count_mobileapp = $this->User->select_user("u.user_id", array("u.acc_status" => 1,"ur.mobile_app_access" => 1))->num_rows();
    $data['user_role'] = $this->security->xss_clean($this->input->post('user_role'));
    // Select Role Details
    $role_data = $this->User->select_user_roles("", array("role_id" => $data['user_role']))->row();
    if (($role_data->mobile_app_access == 0 && $created_user_count_webapp < $allowed_user_count_webapp) || ($role_data->mobile_app_access == 1 && $created_user_count_mobileapp < $allowed_user_count_mobileapp)) {
      $employee_count = 0;
      $data['username'] = $this->security->xss_clean($this->input->post('email'));
      $user_where = "(username='" . $data['username'] . "'";
      if ($this->input->post('employee_code') != '') {
        $data['employee_code'] = $employee_data['employee_code'] = $this->security->xss_clean($this->input->post('employee_code'));
        $user_where .= " or employee_code='" . $data['employee_code'] . "'";
        $employee_count = $this->Employee->select_employee("e.employee_code",array("e.employee_code"=>$data['employee_code']))->num_rows();
      }
      $user_where .= ")";

      $count = $this->User->select_user("", $user_where)->num_rows();
      if ($count == 0 && $employee_count==0) {
        $data['user_alias'] = $employee_data['employee_name'] = $this->security->xss_clean($this->input->post('user_name'));
        $data['acc_status'] = $this->security->xss_clean($this->input->post('acc_status'));
        if ($data['acc_status'] == 'on') {
          $data['acc_status'] = 1;
        } else {
          $data['acc_status'] = 0;
        }
        if ($this->input->post('joined_date') != '') {
          $data['joined_date'] = $employee_data['joined_date'] = date('Y-m-d', strtotime($this->security->xss_clean($this->input->post('joined_date'))));
        }
        if ($this->input->post('dob') != '') {
          $data['dob'] = $employee_data['dob'] = date('Y-m-d', strtotime($this->security->xss_clean($this->input->post('dob'))));
        }
        $data['address'] =  $employee_data['address'] = $this->security->xss_clean($this->input->post('address'));
        $data['user_designation'] = $employee_data['user_designation'] = $this->security->xss_clean($this->input->post('designation'));
        $data['created_date'] = $employee_data['created_date'] = date('Y-m-d H:i:s');
        $data['phone_no'] = $employee_data['phone_no'] = $this->security->xss_clean($this->input->post('mobile_number_1'));
        $data['duty_start_time'] = $employee_data['duty_start_time'] = date("H:i:s", strtotime($this->security->xss_clean($this->input->post('duty_start_time'))));
        $data['duty_end_time'] = $employee_data['duty_end_time'] = date("H:i:s", strtotime($this->security->xss_clean($this->input->post('duty_end_time'))));
        function generate_password($length = 6)
        {
          $chars = "123456789";
          $password = substr(str_shuffle($chars), 0, $length);
          return $password;
        }
        $data['password'] = generate_password();
        if ($data['user_role'] == 9) { //area Manager
          $data['project_area_location'] = implode(',', $this->input->post('project_area_location'));
        }
        $result = $this->User->insert_user($data);
        $flash_data['status'] = $result['status'];
        if ($result['status'] == 1) {

          $data2['login_id'] = $result['insert_id'];
          $email_status = $this->send_email($data2['login_id'], "activation");
          $flash_data['flashdata_msg'] = 'User Account & Employee Account Created Successfully!.';
          if ($email_status == 1) {
            $flash_data['flashdata_msg'] .= " & Email With Account Credentials Sent Successfully";
          } else {
            $flash_data['flashdata_msg'] .= "<strong> & Email With Account Credentials Sending Failed!!</strong>";
          }

          ##storing Email Sent Status
          $data5['email_sent_status'] = $email_status;
          $data5['user_id'] =  $data2['login_id'];
          // Load the model
          $result5 = $this->User->update_user($data5);



          // Create Employee A/C
          $employee_data['user_id'] = $data2['login_id'];
          $employee_data['civil_id'] = $this->security->xss_clean($this->input->post('civil_id'));
          $employee_data['op_balance'] = $this->security->xss_clean($this->input->post('opening_balance_salary'));
          $employee_data['basic_wage'] = $this->security->xss_clean($this->input->post('basic_wage'));
          $employee_data['basic_wage_type'] = $this->security->xss_clean($this->input->post('basic_wage_type'));
          $employee_data['basic_wage_fixed'] = $this->security->xss_clean($this->input->post('fixed_basic_wage'));
          $employee_data['department'] = $this->security->xss_clean($this->input->post('department'));
          if($employee_data['department']==1 && $this->input->post('assigned_vehicles') && !empty($this->input->post('assigned_vehicles'))){
            $employee_data['assigned_vehicles'] = implode(',',$this->input->post('assigned_vehicles'));
          }
          $employee_data['created_by'] = $this->session->userdata('user_id');
          $employee_result = $this->Employee->create_employee($employee_data);

          // CReate Account Head
          $account_data['acc_head_name'] = $data['user_alias'] . "'s Account";
          $account_data['account_type'] = 32; //Cash Account
          $account_data['acc_user_id'] = $data2['login_id'];
          $account_data['acc_employee_id'] = $employee_result['insert_id'];
          $account_data['head_editable'] = 0;
          $account_data['op_balance'] = $this->security->xss_clean($this->input->post('opening_balance_user_acc'));
          $account_data['created_date'] = date('Y-m-d H:i:s');
          $account_data['created_by'] = $this->session->userdata('user_id');
          $account_result = $this->Account->create_account_head($account_data);

          $flash_data['flashdata_type'] = 'success';
          $flash_data['alert_type'] = 'success';
          $flash_data['flashdata_title'] = 'Success !';
        } else {
          $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
          $flash_data['flashdata_type'] = 'error';
          $flash_data['alert_type'] = 'danger';
          $flash_data['flashdata_title'] = 'Error !!';
        }
      } else {
        $flash_data['status'] = 0;
        $flash_data['flashdata_msg'] = 'Sorry.. An User/Employee Account with Same Email / Employee Code Already Exist!';
        $flash_data['flashdata_type'] = 'warning';
        $flash_data['alert_type'] = 'warning';
        $flash_data['flashdata_title'] = 'Email/Employee Code Duplication !!';
      }
    } else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. No of User Account Creation Reached Maximum in Current Plan!. Please Contact Developer to Upgrade Plan';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'No of User Account Reached Maximum !!';
    }

    // $this->session->set_flashdata($flash_data);
    // redirect(base_url(). 'User ','refresh');
    echo (json_encode($flash_data));
  }
  public function update()
  {

    $data1['user_id'] = $this->security->xss_clean($this->input->post('user_id'));
    $old_email = $this->User->select_user("", $data1)->row()->username;
    //      Check Email Duplication
    $data['username'] = $this->security->xss_clean($this->input->post('email'));
    $user_where = "(username='" . $data['username'] . "'";
    $data['user_id'] = $this->security->xss_clean($this->input->post('user_id'));
    $employee_count = 0;
    if ($this->input->post('employee_code') != '') {
      $data['employee_code'] = $this->security->xss_clean($this->input->post('employee_code'));
      $user_where .= " or employee_code='" . $data['employee_code'] . "'";
      $employee_count = $this->Employee->select_employee("e.employee_code",array("e.employee_code"=>$data['employee_code'],"e.user_id !="=>$data['user_id']))->num_rows();
    }
    $user_where .= ") and user_id!=" . $data['user_id'];
    $count = $this->User->select_user("", $user_where)->num_rows();
    if ($count == 0 && $employee_count==0) {

      $data1['username'] = $data['username'];
      $data1['user_alias'] = $this->security->xss_clean($this->input->post('user_name'));
      $data1['acc_status'] = $this->security->xss_clean($this->input->post('acc_status'));
      if ($data1['acc_status'] == 'on') {
        $data1['acc_status'] = 1;
      } else {
        $data1['acc_status'] = 0;
      }
      if ($this->input->post('joined_date') != '') {
        $data1['joined_date'] = $employee_update_data['joined_date'] = date('Y-m-d', strtotime($this->security->xss_clean($this->input->post('joined_date'))));
      } else {
        $data1['joined_date'] = $employee_update_data['joined_date'] = "0000-00-00";
      }
      if ($this->input->post('dob') && $this->input->post('dob') != '') {
        $data1['dob'] = $employee_update_data['dob'] = date('Y-m-d', strtotime($this->security->xss_clean($this->input->post('dob'))));
      }
      if ($this->input->post('address') && $this->input->post('address') != '') {
        $data1['address'] = $employee_update_data['address'] = $this->security->xss_clean($this->input->post('address'));
      }
      $data1['user_designation'] = $employee_update_data['user_designation'] = $this->security->xss_clean($this->input->post('designation'));
      $data1['employee_code'] = $employee_update_data['employee_code'] = $this->security->xss_clean($this->input->post('employee_code'));
      $data1['user_role'] = $this->security->xss_clean($this->input->post('user_role'));
      $data1['phone_no'] = $employee_update_data['phone_no'] = $this->security->xss_clean($this->input->post('mobile_number_1'));
      $data1['duty_start_time'] = $employee_update_data['duty_start_time'] = date("H:i:s", strtotime($this->security->xss_clean($this->input->post('duty_start_time'))));
      $data1['duty_end_time'] = $employee_update_data['duty_end_time'] = date("H:i:s", strtotime($this->security->xss_clean($this->input->post('duty_end_time'))));
      if ($data1['user_role'] == 9) { //area Manager
        $data1['project_area_location'] = implode(',', $this->input->post('project_area_location'));
      }
      $result = $this->User->update_user($data1);
      $flash_data['status'] = $result;
      if ($result == 1) {

        $employee_data = $this->Employee->select_employee("e.*", array("e.user_id" => $data1['user_id']));
        if ($employee_data->num_rows() == 1) {
          $employee_data = $employee_data->row();
          // Update Employee A/C
          $employee_update_data['employee_id'] = $employee_data->employee_id;
          $employee_update_data['employee_name'] = $data1['user_alias'];
          $employee_update_data['updated_by'] = $this->session->userdata('user_id');
          $employee_update_data['updated_date'] = date('Y-m-d H:i:s');
          $employee_result = $this->Employee->update_employee($employee_update_data);

          $account_head_data = $this->Account->select_account_heads("", array("acc_employee_id" => $employee_data->employee_id));
          if ($account_head_data->num_rows() == 1) {
            // Update Account Head
            $account_data['acc_head_name'] = $data1['user_alias'] . "'s Account";
            $account_data['acc_head_id'] = $account_head_data->row()->acc_head_id;
            $account_data['updated_date'] = date('Y-m-d H:i:s');
            $account_data['updated_by'] = $this->session->userdata('user_id');
            $account_result = $this->Account->update_account_head($account_data);
          }
        }
        $flash_data['flashdata_msg'] = 'User  Account Details & Employee Details Updated Successfully!.';
        //                  Send Email When User Email Changed
        if ($old_email != $data1['username']) {
          $email_status = $this->send_email($data1['user_id'], "activation");
          if ($email_status == 1) {
            $flash_data['flashdata_msg'] .= " & Email With Account Credentials Sent Successfully";
          } else {
            $flash_data['flashdata_msg'] .= "<strong> & Email With Account Credentials Sending Failed!!</strong>";
          }
          ##storing Email Sent Status
          $data5['email_sent_status'] = $email_status;
          $data5['user_id'] =  $data1['user_id'];
          // Load the model
          $result5 = $this->User->update_user($data5);
        }
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    } else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. An User/Employee Account with Same Email/Employee Code Already Exist!';
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Email/Employee Code Duplication !!';
    }
    // $this->session->set_flashdata($flash_data);
    // redirect(base_url(). 'User ','refresh');
    echo (json_encode($flash_data));
  }

  public function update_leave_application()
  {

    $data['application_id'] = $this->security->xss_clean($this->input->post('application_id'));
    $leave_application_data = $this->User->select_leave_applications("ula.*,u.user_alias,ur.role_title", $data)->row();
    $data['approval_status'] = $this->security->xss_clean($this->input->post('application_status'));
    $data['approval_remarks'] = $this->security->xss_clean($this->input->post('remarks'));
    $data['approved_by'] = $this->session->userdata('user_id');

    $result = $this->User->update_leave_application($data);
    $flash_data['status'] = $result;
    if ($result == 1) {
      if($data['approval_status']==1){
        // Create Leave Entry in Attendance
        $leave_data['user_id'] = $leave_application_data->user_id;
        $leave_data['attendance_date'] = $leave_application_data->leave_date;
        $leave_data['attendance_status'] = 2;
        $leave_data['created_date'] = date('Y-m-d H:i:s');
        $leave_data['created_by'] = $this->session->userdata('user_id');
        //          Check Already Exist
        $where['uat.user_id'] = $leave_data['user_id'];
        $where['uat.attendance_date'] = $leave_data['attendance_date'];
        $where['uat.delete_status'] = 0;
        $count = $this->Attendance->select_attendance('attendance_id',$where);
        if($count->num_rows()==0){
          $result = $this->Attendance->insert_attendance($leave_data);
        }
      }

      $flash_data['flashdata_msg'] = 'Leave Application Status Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo (json_encode($flash_data));
  }
  public function select()
  {

    $json_data = array();
    $j = 0;
    $sl_no = 0;
    $data = array();
    $data['u.user_role !='] = 1;
    if($this->session->userdata('user_role') == 'auditor' || $this->session->userdata('user_role') == 'admin') {
      if ($this->session->userdata('branch_id') != 0) {
        $data['u.user_role !='] = 2;
      }else{
        $this->db->where('(u.branch_id !=0 or (u.branch_id=0 and u.user_role !=1))');
      }
    }
    if($this->session->userdata('user_role') == 'general_manager'){
      $data['u.user_role >'] = 3;
    }

    // if branch admin is logged in , then only show the users of that branch
    if ($this->session->userdata('branch_id') != 0) {
      $data['u.branch_id'] = $this->session->userdata('branch_id');
    }

    if (isset($_POST['branch_id']) && $_POST['branch_id'] != '' && $_POST['branch_id'] != 'all') {
      $data['u.branch_id'] = $_POST['branch_id'];
    }

    $result  = $this->User->select_user_2("*", $data,true);
    $result_array = $result->result();

    $json_data['draw'] = 5;
    $json_data['recordsTotal'] = $result->num_rows();
    $json_data['recordsFiltered'] = $result->num_rows();
    $array = array();

    foreach ($result_array as $row) :
      $id = $row->user_id;
      if ($row->user_id != 1) {

        $btn_edit = $btn_delete = $btn_resend = '';

        if ($this->session->userdata('user_role') != 'auditor') {
          if ($row->user_role > 2) {
            $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="user_edit_btn" href="#user_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
            <i class="la la-edit"></i>
            </a>';
            $btn_delete = '<a style="margin-left: 5px;margin-right: 5px" id="user_delete_btn" href="#user_delete_modal" data-toggle="modal" class="btn btn-danger m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
            <i class="la la-trash"></i>
            </a>';
          }
          $btn_resend = '<a style="margin-left: 5px;margin-right: 5px" id="resend_email_btn" href="#resend_email_modal" data-toggle="modal" class="btn btn-warning m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
          <i class="la la-refresh"></i>
          </a>';
        }

        $btn_profile = '<a style="margin-left: 5px;margin-right: 5px"  href="' . base_url() . 'user/profile/' . $row->user_id . '" class="btn btn-primary m-btn m-btn--icon  m-btn--icon-only  m-btn--pill m-btn--air">
        <i class="la la-eye"></i>
        </a>';
        if ($row->acc_status == 1) {
          $acc_status = '<span class="m-badge m-badge--primary m-badge--wide">Active</span>';
        } else {
          $acc_status = '<span class="m-badge m-badge--warning m-badge--wide">Deactivated</span>';
        }

        if ($row->email_sent_status == 1) {
          $email_status = '<span style="margin-top: 5px" class="m-badge m-badge--success m-badge--wide"><i class="fa fa-check-circle-o"></i> Email Sent</span>';
        } else {
          $email_status = '<span style="margin-top: 5px" class="m-badge m-badge--danger m-badge--wide"><i class="fa fa-close"></i> Email Sending Failed</span>';
        }
        $account_type = $row->role_title;
        if ($row->user_role == 9 && $row->assigned_area != '') {
          $account_type .= '<br/>[' . $row->assigned_area . ']';
        }
        $sl_no++;


        $user_profile = '<a href="' . base_url() . 'user/profile/' . $row->user_id . '">' . $row->user_alias . '</a>';
        $branch_name = 'No Branch';
        $branch_details = $this->Branches->select_branches('*',array('branch_id'=>$row->branch_id));
        if($branch_details->num_rows()==1){
          $branch_name = $branch_details->row()->branch_name;
        }

        $array[$j][] = $row->user_id;
        $array[$j][] = $sl_no;
        $array[$j][] = $branch_name;
        $array[$j][] = $user_profile;
        $array[$j][] = $row->employee_code;
        $array[$j][] = $row->username;
        $array[$j][] = $row->phone_no;
        $array[$j][] = $row->password;
        $array[$j][] = $row->user_designation;
        $array[$j][] = $account_type;
        if ($row->duty_start_time != '00:00:00' && $row->duty_start_time!=null && $row->duty_start_time!='') {
          $array[$j][] = date('h:i A', strtotime($row->duty_start_time));
        } else {
          $array[$j][] = "";
        }
        if ($row->duty_end_time != '00:00:00' && $row->duty_end_time!=null && $row->duty_end_time!='') {
          $array[$j][] = date('h:i A', strtotime($row->duty_end_time));
        } else {
          $array[$j][] = "";
        }
        if ($row->joined_date != '0000-00-00' && $row->joined_date!=null && $row->joined_date!='') {
          $array[$j][] = date('d-m-Y', strtotime($row->joined_date));
        } else {
          $array[$j][] = "";
        }
        if ($row->dob != '0000-00-00' && $row->dob!=null && $row->dob!='') {
          $array[$j][] = date('d-m-Y', strtotime($row->dob));
        } else {
          $array[$j][] = "";
        }
        if($row->address!=''){
          $array[$j][] = nl2br($row->address);
        }else{
          $array[$j][] = '';
        }
        $array[$j][] = $acc_status . "<br/>" . $email_status;
        if($row->created_date!='0000-00-00 00:00:00' && $row->created_date!=null && $row->created_date!=''){
          if ($this->config->item('UI_hide_created_date_field')==0){
            $array[$j][] = date('d-m-Y', strtotime($row->created_date));
          }else{
            $array[$j][] = '';
          }
        }else{
          $array[$j][] = '';
        }
        $array[$j][] = $row->acc_status;
        $array[$j][] = $btn_resend . $btn_edit . $btn_delete;
        $array[$j][] = $row->user_role;
        if ($row->duty_start_time != '00:00:00' && $row->duty_start_time!=null && $row->duty_start_time!='') {
          $array[$j][] = date('h:i A', strtotime($row->duty_start_time));
        } else {
          $array[$j][] = "";
        }
        if ($row->duty_end_time != '00:00:00' && $row->duty_end_time!=null && $row->duty_end_time!='') {
          $array[$j][] = date('h:i A', strtotime($row->duty_end_time));
        } else {
          $array[$j][] = "";
        }
        $array[$j][] = $row->project_area_location;

        $j++;
      }
    endforeach;
    $json_data['data'] = $array;
    echo json_encode($json_data);  // send data as json format
  }
  public function select_today_salary()
  {

    $json_data = array();
    $j = 0;
    $sl_no = 0;
    $data = array();
    $data['u.user_role !='] = 1;
    $data['u.user_role !='] = 2;
    if ($this->session->userdata('branch_id') != 0) {
      $data['u.branch_id'] = $this->session->userdata('branch_id');
    }
    if (isset($_POST['branch_id']) && $_POST['branch_id'] != '' && $_POST['branch_id'] != 'all') {
      $data['u.branch_id'] = $_POST['branch_id'];
    }
    $result  = $this->User->select_user("", $data,true);
    $result_array = $result->result();

    $json_data['draw'] = 5;
    $json_data['recordsTotal'] = $result->num_rows();
    $json_data['recordsFiltered'] = $result->num_rows();
    $array = array();

    foreach ($result_array as $row) :
      $id = $row->user_id;
      if (isset($_POST['date']) && $_POST['date'] != '' && $row->joined_date != '0000-00-00') {
        $date = array();
        $date = explode('-', $_POST['date']);
        $start_date = date('d', strtotime($date[0]));
        $end_date = date('d', strtotime($date[1]));
        $joined_day = date('d', strtotime($row->joined_date));
        if ($joined_day <= $end_date && $joined_day >= $start_date) {
          $sl_no++;
          $user_profile = '<a href="' . base_url() . 'user/profile/' . $row->user_id . '">' . $row->user_alias . '</a>';

          $array[$j][] = $sl_no;
          $array[$j][] = ($row->branch_id == 0) ? 'No Branch' : $this->Branches->select_branches('*', array('branch_id' => $row->branch_id))->row()->branch_name;
          $array[$j][] = $user_profile;
          if ($row->joined_date != '0000-00-00') {
            $array[$j][] = date('d-m-Y', strtotime($row->joined_date));
          } else {
            $array[$j][] = "";
          }
          if ($row->joined_date != '0000-00-00') {
            $array[$j][] = date('d', strtotime($row->joined_date));
          } else {
            $array[$j][] = "";
          }
          $array[$j][] = '<a style="margin-left: 5px;margin-right: 5px"  href="' . base_url() . 'user/work_hour_report?user_id=' . $row->user_id . '" class="btn btn-sm btn-info m-btn m-btn--icon m-btn--pill m-btn--air">
          <i class="la la-eye"></i> View Work Report
          </a>';
          $j++;
        }
      }
    endforeach;
    $json_data['data'] = $array;
    echo json_encode($json_data);  // send data as json format
  }
  public function select_activities()
  {

    $json_data = array();
    $j = 0;
    $sl_no = 0;
    $data = array();
    if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
      $work_id = $_POST['work'];
    }
    if (isset($_POST['user']) && $_POST['user'] != '' && $_POST['user'] != 'all') {
      $data['ua.user_id'] = $_POST['user'];
    }
    if(isset($_POST['date']) && $_POST['date']!=''){
      $date=array();
      $date=explode('-',$_POST['date']);
      $start_date=date('Y-m-d', strtotime($date[0]));
      $end_date=date('Y-m-d', strtotime($date[1]));
      $data["STR_TO_DATE(ua.activity_date,'%Y-%m-%d') <="]= $end_date;
      $data["STR_TO_DATE(ua.activity_date,'%Y-%m-%d') >="]= $start_date;
    }
    if ($this->session->userdata('branch_id') != 0) {
      $data['u.branch_id'] = $this->session->userdata('branch_id');
    }
    if ($this->session->userdata('user_role') != 'admin') {
      $data['ur.role_id >'] = 2;
    }
    $result  = $this->User->select_activities("", $data);
    $result_array = $result->result();

    $json_data['draw'] = 5;
    $json_data['recordsTotal'] = $result->num_rows();
    $json_data['recordsFiltered'] = $result->num_rows();
    $array = array();

    foreach ($result_array as $row) :
      $id = $row->user_id;

      $sl_no++;
      $reference = "";
      if($row->reference_id!=0){
        $reference = " (#" . $row->reference_id . ")";
      }

      $array[$j][] = $sl_no;
      $array[$j][] = date('d-m-Y H:i:s', strtotime($row->activity_date));
      $array[$j][] = '<a href="' . base_url() . 'user/profile/' . $row->user_id . '">' . $row->user_alias . '</a>';
      $array[$j][] = ucwords(str_replace("_","",$row->activity_through));
      $array[$j][] = $row->activity_description;
      $array[$j][] = $row->activity_type . $reference;

      $j++;

    endforeach;


    $json_data['data'] = $array;
    echo json_encode($json_data);  // send data as json format
  }
  public function select_leave_applications()
  {

    $json_data = array();
    $j = 0;
    $sl_no = 0;
    $data = array();

    if (isset($_POST['branch_id']) && $_POST['branch_id'] != '' && $_POST['branch_id'] != 'all') {
      $data['u.branch_id'] = $_POST['branch_id'];
    }

    $result  = $this->User->select_leave_applications("ula.*,u.user_alias,ur.role_title", $data);
    $result_array = $result->result();

    $json_data['draw'] = 5;
    $json_data['recordsTotal'] = $result->num_rows();
    $json_data['recordsFiltered'] = $result->num_rows();
    $array = array();

    foreach ($result_array as $row) :
      $id = $row->user_id;
      $btn_edit = '';
      if ($this->session->userdata('user_role') != 'auditor') {
        $btn_edit = '<a style="margin-left: 5px;margin-right: 5px" id="application_edit_btn" href="#application_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
        <i class="la la-edit"></i>
        </a>';
      }

      if ($row->approval_status == 1) {
        $approval_status = '<span class="m-badge m-badge--primary m-badge--wide">Approved</span>';
      } elseif ($row->approval_status == 2) {
        $approval_status = '<span class="m-badge m-badge--danger m-badge--wide">Rejected</span>';
      } else {
        $approval_status = '<span class="m-badge m-badge--warning m-badge--wide">Pending</span>';
      }

      $sl_no++;

      $array[$j][] = $row->application_id;
      $array[$j][] = $sl_no;
      $array[$j][] = '';
      $array[$j][] = $row->user_alias;
      $array[$j][] = $row->role_title;
      $array[$j][] = date('d-m-Y', strtotime($row->leave_date));
      $array[$j][] = ucwords(str_replace('_','',$row->leave_type));
      $array[$j][] = $row->reason;
      $array[$j][] = $approval_status;
      $array[$j][] = $row->approval_remarks;
      $array[$j][] = date('d-m-Y', strtotime($row->created_date));
      $array[$j][] = $btn_edit;
      $array[$j][] = $row->approval_status;
      $array[$j][] = $row->leave_type;

      $j++;

    endforeach;
    $json_data['data'] = $array;
    echo json_encode($json_data);  // send data as json format
  }
  public function send_email($user_id, $email_type)
  {

    if ($email_type == 'activation') {
      $result  = $this->User->select_user("", array("user_id" => $user_id));
      if ($result->num_rows() == 1) {
        ##Send Mail
        $password = $result->row()->password;
        $email = $result->row()->username;
        $user_name = $result->row()->user_alias;
        $data5['subject'] = "Account Activation in " . $this->config->item('company_name') . " Application";
        $message = file_get_contents(base_url() . 'template/email/welcome.html');
        $message = str_replace("#username", $user_name, $message);
        $message = str_replace("#email", $email, $message);
        $message = str_replace("#password", $password, $message);
        $message = str_replace("#url", base_url() . "template/email", $message);
        $message = str_replace("#login_link", base_url() . "", $message);
        $data5['message'] = $message;
        $data5['to'] = $email;
        $result4 = $this->User->send_email($data5);
        if ($result4 == 1) {
          return 1;
        } else {
          return 0;
        }
      } else {
        return 0;
      }
    } else {
      return 0;
    }
  }
  public function resend_email()
  {
    $redirect_url = $this->security->xss_clean($this->input->post('redirect_url'));
    $data['user_id'] = $this->security->xss_clean($this->input->post('user_id'));
    $email_status = $this->send_email($data['user_id'], "activation");
    $flash_data['status'] = $email_status;
    if ($email_status == 1) {
      $flash_data['flashdata_msg'] = "Email With Account Credentials Sent Successfully";
      $flash_data['flashdata_type'] = 'info';
      $flash_data['alert_type'] = 'info';
      $flash_data['flashdata_title'] = 'Success !';
    } else {
      $flash_data['flashdata_msg'] = "Email With Account Credentials Sending Failed!!";
      $flash_data['flashdata_type'] = 'warning';
      $flash_data['alert_type'] = 'warning';
      $flash_data['flashdata_title'] = 'Failed !!';
    }

    ##storing Email Sent Status
    $data5['email_sent_status'] = $email_status;
    $data5['user_id'] = $data['user_id'];
    // Load the model
    $result5 = $this->User->update_user($data5);

    // $this->session->set_flashdata($flash_data);
    // redirect($redirect_url,'refresh');
    echo (json_encode($flash_data));
  }
  public function delete()
  {

    $data['user_id'] = $this->security->xss_clean($this->input->post('user_id'));
    $employee_data = $this->Employee->select_employee("e.*", array("e.user_id" => $data['user_id']));
    if ($employee_data->num_rows() == 1) {
      $employee_data = $employee_data->row();
      // Delete Employee A/C
      $employee_update_data['employee_id'] = $employee_data->employee_id;

      //  Delete Account Head
      $account_data['account_type'] = 32;
      $account_data['acc_employee_id'] = $employee_data->employee_id;
      $account_details = $this->Account->select_account_heads("*", $account_data);
      if ($account_details->num_rows() == 1) {
        $account_data['acc_head_id'] = $account_details->row()->acc_head_id;

        // CHeck User Account Have Petty Balance
        $end_date = date('Y-m-d');
        $cash_balance_amount = $this->accounts_management->get_account_statement('trial_balance',"acchead_".$account_data['acc_head_id'], '', $end_date,$this->session->userdata('user_role'),$this->session->userdata('user_id'),'Petty Cash');

        if($cash_balance_amount==0){
          $data['delete_status'] = 1;
          $result = $this->User->update_user($data);
          $flash_data['status'] = $result;
          if ($result == 1) {
            $employee_update_data['delete_status'] = 1;
            $employee_result = $this->Employee->update_employee($employee_update_data);

            $account_data['delete_status'] = 1;
            $this->Account->update_account_head($account_data);

            $flash_data['flashdata_msg'] = 'User Account & Employee Account Deleted Successfully!';
            $flash_data['flashdata_type'] = 'success';
            $flash_data['alert_type'] = 'success';
            $flash_data['flashdata_title'] = 'Success !!';
          } else {
            $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
            $flash_data['flashdata_type'] = 'error';
            $flash_data['alert_type'] = 'danger';
            $flash_data['flashdata_title'] = 'Error !!';
          }
        }else{
          $flash_data['status'] = 2;
          $flash_data['flashdata_msg'] = 'Sorry.. User Have Petty Cash Balance. Please Clear Accounts before Deletion!';
          $flash_data['flashdata_type'] = 'warning';
          $flash_data['alert_type'] = 'warning';
          $flash_data['flashdata_title'] = 'Warning !!';
        }
      }else {
        $flash_data['status'] = 2;
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    }else {
      $flash_data['status'] = 2;
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    // $this->session->set_flashdata($flash_data);
    // redirect(base_url().'User','refresh');
    echo (json_encode($flash_data));
  }
  public function select_summary($return_type = '')
  {
    $json_data = $json_data2 = array();
    $j = $sl_no = 0;
    $data = array();

    // Get User Account
    $start_date = $end_date = '';
    if (isset($_POST['user_id']) && $_POST['user_id'] != '' && $_POST['user_id'] != 'all') {
      $data['acc_user_id'] = $_POST['user_id'];
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $data['acc_head_id'] = $_POST['acc_head_id'];
    }
    if (isset($_POST['start_date']) && $_POST['start_date'] != '' && $_POST['start_date'] != 'all') {
      $start_date = date('Y-m-d', strtotime($_POST['start_date']));
    }
    if (isset($_POST['end_date']) && $_POST['end_date'] != '' && $_POST['end_date'] != 'all') {
      $end_date = date('Y-m-d', strtotime($_POST['end_date']));
    }
    $account_head_data = $this->Account->select_account_heads("", $data, 'user');
    if ($account_head_data->num_rows() == 1) {
      $user_account_id = $account_head_data->row()->acc_head_id;
      // if ($account_head_data->row()->role_name == 'general_manager' && $this->CI->config->item('User_general_manager_tr_user_accounts_only') != 1) {
      //   $json_data = $this->accounts_management->calculate_user_summary($user_account_id, $start_date, $end_date, "user_created_transactions", $account_head_data->row()->user_id);
      // } else {
      $json_data = $this->accounts_management->calculate_user_summary($user_account_id, $start_date, $end_date);
      // }

      if ($return_type != 'count') {
        foreach ($json_data as $key => $value) {
          $json_data[$key] = $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($value, $this->config->item('Currency_currency_shortname'));
        }
      }
      echo json_encode($json_data);  // send data as json format
    }
  }
  public function select_user_account_counts()
  {
    $json_data = array();
    $json_data['allowed_user_count_webapp'] = $this->config->item('User_max_user_accounts_allowed_web');
    $json_data['allowed_user_count_mobileapp'] = $this->config->item('User_max_user_accounts_allowed_mobile');
    $json_data['created_user_count_webapp'] = $this->User->select_user("u.user_id", array("u.acc_status" => 1,"ur.web_app_access" => 1))->num_rows();
    $json_data['created_user_count_mobileapp'] = $this->User->select_user("u.user_id", array("u.acc_status" => 1,"ur.mobile_app_access" => 1))->num_rows();
    echo json_encode($json_data);  // send data as json format
  }
  public function select_details()
  {
    $json_data = array();
    $j = $sl_no = 0;
    $data = array();
    if (isset($_POST['user_id']) && $_POST['user_id'] != '' && $_POST['user_id'] != 'all') {
      $data['user_id'] = $_POST['user_id'];
    }
    $user_data = $this->User->select_user("", $data);
    if ($user_data->num_rows() == 1) {
      $json_data = $user_data->row();
      $json_data->count = $user_data->num_rows();
      $json_data->duty_start_time_1 = date('H:i A', strtotime($json_data->duty_start_time));
      $json_data->duty_end_time_1 = date('H:i A', strtotime($json_data->duty_end_time));
      echo json_encode($json_data);
    } else {
      $json_data['count'] = $user_data->num_rows();
      echo json_encode($json_data);
    }
  }

  public function select_work_hour_report($param = "")
  {
    $table_data = '';
    $total_days = $not_marked_count = $holidays_count = $weekly_holidays_count = $full_day_leave = $half_day_leave = $total_days = $overtime_days = $holiday_working = $extra_work_hours = 0;
    if (isset($_POST['user']) && $_POST['user'] != '' && $_POST['user'] != 'all') {
      $json_data = array();
      $j = $i = $sl_no = $total_extra_work_hour = $total_extra_work_minutes = $total_work_hour = $total_work_minutes = $total_early_in_hour = $total_early_in_minutes = $total_late_in_hour = $total_late_in_minutes = $total_early_out_hour = $total_early_out_minutes = 0;
      $array = array();

      $users  = $this->User->select_user("", array("u.user_id" => $_POST['user']),true);
      if ($users->num_rows() == 1 && isset($_POST['start_date']) && $_POST['start_date'] != '' && isset($_POST['end_date']) && $_POST['end_date'] != '') {
        $users = $users->row();

        $table_data .= '<caption style="caption-side: top;text-align: center" class="lead" id="work_hour_report_view_table_caption"></caption>
        <thead>
        <tr class="">
        <th style="white-space:nowrap">Date</th>
        <th style="white-space:nowrap">Entry Time</th>
        <th style="white-space:nowrap">Exit Time</th>
        <th style="white-space:nowrap">Early IN</th>
        <th style="white-space:nowrap">Late IN</th>
        <th style="white-space:nowrap">Early Out</th>
        <th style="white-space:nowrap">Extra Work</th>
        <th style="white-space:nowrap">Net Work</th>
        <th></th>
        </tr>
        </thead>
        <tbody>';

        $start_date = date('Y-m-d', strtotime($_POST['start_date']));
        $end_date = date('Y-m-d', strtotime($_POST['end_date']));

        // of period 1 day
        $interval = new DateInterval('P1D');
        $realEnd = new DateTime($end_date);
        $realEnd->add($interval);
        $date_period = new DatePeriod(new DateTime($start_date), $interval, $realEnd);
        $attendance_data = array();
        foreach ($date_period as $key => $value) {
          $total_days++;
          $attendance_data[$i]['day'] =  date('l', strtotime($value->format('Y-m-d')));
          $attendance_data[$i]['date'] = $value->format('d-m-Y');
          // Check Attendece Exist ot Not
          $where['uat.user_id'] = $users->user_id;
          $where['uat.attendance_date'] = $value->format('Y-m-d');
          $where['uat.delete_status'] = 0;
          $attendance = $this->Attendance->select_attendance('uat.*,u2.user_alias as created_user,ua1.activity_location_address as signed_in_location,ua1.activity_location_landmark as signed_in_landmark,ua1.activity_location_latitude as signed_in_latitude,ua1.activity_location_longitude as signed_in_longitude,
          ua2.activity_location_address as signed_off_location,ua2.activity_location_latitude as signed_off_latitude,ua2.activity_location_longitude as signed_off_longitude,', $where);

          if ($attendance->num_rows() > 0) {
            $attendance = $attendance->row();
            if ($attendance->attendance_status == 1) {
              $attendance_data[$i]['status'] = 1;
              $signed_in_time = $signed_off_time = $late_in = $early_out = $extra_work = $net_work = '';
              if ($attendance->signed_in_time != '00:00:00') {
                $signed_in_time = date('h:i A', strtotime($attendance->signed_in_time));
              }
              if ($attendance->signed_off_time != '00:00:00') {
                $signed_off_time = date('h:i A', strtotime($attendance->signed_off_time));
              }
              if ($signed_in_time != '' && date('H:i', strtotime($attendance->signed_in_time)) > date('H:i', strtotime($users->duty_start_time))) {
                $signed_in_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($signed_in_time)));
                $duty_start_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($users->duty_start_time)));
                $late_in = $signed_in_time_1->diff($duty_start_time_1);
                $total_late_in_hour += $late_in->format('%H');
                $total_late_in_minutes += $late_in->format('%I');
                $late_in = $late_in->format('%H') . ":" . $late_in->format('%I');
              } else {
                $late_in = 0;
              }

              if ($signed_in_time != '' && date('H:i', strtotime($attendance->signed_in_time)) < date('H:i', strtotime($users->duty_start_time))) {
                $signed_in_time_12 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($signed_in_time)));
                $duty_start_time_12 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($users->duty_start_time)));
                $early_in = $signed_in_time_12->diff($duty_start_time_12);
                $total_early_in_hour += $early_in->format('%H');
                $total_early_in_minutes += $early_in->format('%I');
                $early_in = $early_in->format('%H') . ":" . $early_in->format('%I');
              } else {
                $early_in = 0;
              }

              if ($signed_off_time != '' && date('H:i', strtotime($attendance->signed_off_time)) < date('H:i', strtotime($users->duty_end_time))) {
                $signed_off_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($signed_off_time)));
                $duty_end_time_1 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($users->duty_end_time)));
                $early_out = $signed_off_time_1->diff($duty_end_time_1);
                $total_early_out_hour += $early_out->format('%H');
                $total_early_out_minutes += $early_out->format('%I');
                $early_out = $early_out->format('%H') . ":" . $early_out->format('%I');

                if (date('H:i A', strtotime($attendance->signed_off_time)) <= date('H:i A', strtotime('02:00 PM'))) {
                  $half_day_leave++;
                }
              } else {
                $early_out = 0;
              }

              if ($signed_in_time != '' && $signed_off_time != '') {
                $work_start_time = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($signed_in_time)));
                $work_end_time = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($signed_off_time)));
                $actual_worked_time = $work_start_time->diff($work_end_time);
                $total_work_hour += $actual_worked_time->format('%H');
                $total_work_minutes += $actual_worked_time->format('%I');
                $actual_worked_time = $actual_worked_time->format('%H') . ":" . $actual_worked_time->format('%I');
                $attendance_data[$i]['actual_worked_time'] = $actual_worked_time;


                if ($users->duty_start_time != '' && $users->duty_start_time != '00:00:00' && $users->duty_end_time != '' && $users->duty_end_time != '00:00:00') {
                  $duty_start_time_normal = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($users->duty_start_time)));
                  $duty_end_time_normal = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($users->duty_end_time)));
                  $normal_work_time = $duty_start_time_normal->diff($duty_end_time_normal);
                  $normal_work_time = $normal_work_time->format('%H') . ":" . $normal_work_time->format('%I');

                  $normal_work_time_1 = new DateTime($normal_work_time . ":00");
                  $actual_worked_time_1 = new DateTime($actual_worked_time . ":00");
                  $overtime = $normal_work_time_1->diff($actual_worked_time_1);
                  if ($overtime->format("%r%h") > 0 || $overtime->format("%r%i") > 0) {
                    $total_extra_work_hour += $overtime->format('%H');
                    $total_extra_work_minutes += $overtime->format('%I');
                    $overtime =  $overtime->format('%H') . ":" . $overtime->format('%I');
                    $attendance_data[$i]['over_time'] = $overtime;
                  } else {
                    $attendance_data[$i]['over_time'] = 0;
                  }
                } else {
                  $attendance_data[$i]['over_time'] = 0;
                }
              } else {
                $attendance_data[$i]['actual_worked_time'] = 0;
                $attendance_data[$i]['over_time'] = 0;
              }
              $attendance_data[$i]['entry_time'] = $signed_in_time;
              $attendance_data[$i]['exit_time'] = $signed_off_time;
              $attendance_data[$i]['early_in'] = $early_in;
              $attendance_data[$i]['late_in'] = $late_in;
              $attendance_data[$i]['early_out'] = $early_out;

              $i++;
            } elseif ($attendance->attendance_status == 2) {
              $attendance_data[$i]['status'] = 2;
              $i++;
            }
          } else {
            $attendance_data[$i]['status'] = 3;
          }
          $i++;
        }
        foreach ($attendance_data as $key => $value) {
          if ($value['day'] == 'Sunday') {
            $status = "S";
            $weekly_holidays_count++;
          } else {
            // CHeck Holiday
            $holiday = $this->Settings->select_holidays('', array("holiday_date" => date('Y-m-d', strtotime($value['date']))));
            if ($holiday->num_rows() == 1) {
              $status = "H";
              $holidays_count++;
            } elseif ($value['status'] == 2) {
              $status = "L";
              $full_day_leave++;
            } elseif ($value['status'] == 3) {
              $status = "N";
              $not_marked_count++;
            } else {
              $status = "";
            }
          }

          if ($status == 'S' || $status == 'H') {
            $bg_colour = "rgb(224, 224, 224)";
          } elseif ($status == 'L') {
            $bg_colour = "#7f7f7f";
          } elseif ($status == 'N') {
            $bg_colour = "rgb(237 237 237 / 52%) !important";
          } else {
            $bg_colour = "";
          }

          $table_data .= '<tr id="row-' . $sl_no . '" class="bg_row bg_' . $status . '" data-bg-color="' . $bg_colour . '" style="background-color: ' . $bg_colour . ' !important">';
          $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . date('d-m-Y', strtotime($value['date'])) . "</td>";
          if ($value['status'] == 1) {
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . $value['entry_time'] . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . $value['exit_time'] . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . $value['early_in'] . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . $value['late_in'] . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . $value['early_out'] . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . $value['over_time'] . " Hrs" . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . $value['actual_worked_time'] . " Hrs" . "</td>";
          } elseif ($value['status'] == 2 || $value['status'] == 3) {
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . "" . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . "" . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . "" . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . "" . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . "" . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . "" . "</td>";
            $table_data .= '<td style="white-space:nowrap;background-color: ' . $bg_colour . ' !important">' . "" . "</td>";
          }


          $table_data .= '<td style="background-color: ' . $bg_colour . ' !important">' . $status . "</td>";
          $table_data .= '</tr>';
          $j++;
          $sl_no++;
        }

        if (sizeof($attendance_data) > 0) {
          $total_extra_work_hour += floor($total_extra_work_minutes / 60);
          $total_extra_work_minutes = ($total_extra_work_minutes % 60);
          $total_extra_worked = sprintf("%02d", $total_extra_work_hour) . ":" . sprintf("%02d", $total_extra_work_minutes) . " Hrs";

          $total_work_hour += floor($total_work_minutes / 60);
          $total_work_minutes = ($total_work_minutes % 60);
          $total_worked = sprintf("%02d", $total_work_hour) . ":" . sprintf("%02d", $total_work_minutes) . " Hrs";

          $total_early_in_hour += floor($total_early_in_minutes / 60);
          $total_early_in_minutes = ($total_early_in_minutes % 60);
          $total_early_in = sprintf("%02d", $total_early_in_hour) . ":" . sprintf("%02d", $total_early_in_minutes) . " Hrs";

          $total_early_out_hour += floor($total_early_out_minutes / 60);
          $total_early_out_minutes = ($total_early_out_minutes % 60);
          $total_early_out = sprintf("%02d", $total_early_out_hour) . ":" . sprintf("%02d", $total_early_out_minutes) . " Hrs";

          $total_late_in_hour += floor($total_late_in_minutes / 60);
          $total_late_in_minutes = ($total_late_in_minutes % 60);
          $total_late_in = sprintf("%02d", $total_late_in_hour) . ":" . sprintf("%02d", $total_late_in_minutes) . " Hrs";

          $table_data .= '<tr>';
          $table_data .= '<td><strong>Total</strong></td>';
          $table_data .= '<td></td>';
          $table_data .= '<td></td>';
          $table_data .= '<td style="white-space:nowrap;"><strong>' . $total_early_in . '</strong></td>';
          $table_data .= '<td style="white-space:nowrap;"><strong>' . $total_late_in . '</strong></td>';
          $table_data .= '<td style="white-space:nowrap;"><strong>' . $total_early_out . '</strong></td>';
          $table_data .= '<td style="white-space:nowrap;"><strong>' . $total_extra_worked . '</strong></td>';
          $table_data .= '<td style="white-space:nowrap;"><strong>' . $total_worked . '</strong></td>';
          $table_data .= '<td style="white-space:nowrap;"></td>';
          $table_data .= '</tr>';
        }

        $duty_start_time_2 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($users->duty_start_time)));
        $duty_end_time_2 = new DateTime(date('Y-m-d') . ' ' . date("h:i:s A", strtotime($users->duty_end_time)));
        $total_time_per_day = $duty_start_time_2->diff($duty_end_time_2);
        $total_hour_per_day = $total_time_per_day->format('%H');
        $total_minutes_per_day = $total_time_per_day->format('%I');
        $total_working_days = $total_days - $weekly_holidays_count - $holidays_count;

        $total_working_hour = $total_hour_per_day * $total_working_days;
        $total_working_minutes = $total_minutes_per_day * $total_working_days;
        $total_working_hour += floor($total_working_minutes / 60);
        $total_working_minutes = ($total_working_minutes % 60);
        $total_working_time = $total_working_hour . ":" . $total_working_minutes;

        $table_data .= '<tr><th colspan="9">&nbsp;</th></tr>';
        $table_data .= '<tr>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Weekly Holidays</th>';
        $table_data .= '<th style="white-space:nowrap;">' . $weekly_holidays_count . '</th>';
        $table_data .= '<th></th>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Full Day Leave</th>';
        $table_data .= '<th style="white-space:nowrap;">' . $full_day_leave . '</th>';
        $table_data .= '</tr>';
        $table_data .= '<tr>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Holidays</th>';
        $table_data .= '<th style="white-space:nowrap;">' . $holidays_count . '</th>';
        $table_data .= '<th></th>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Half Day Leave</th>';
        $table_data .= '<th style="white-space:nowrap;">' . $half_day_leave . '</th>';
        $table_data .= '</tr>';
        $table_data .= '<tr>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Total Hours</th>';
        $table_data .= '<th style="white-space:nowrap;">' . $total_working_time . ' Hrs</th>';
        $table_data .= '<th></th>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Overtime</th>';
        $table_data .= '<th style="white-space:nowrap;"> Days</th>';
        $table_data .= '</tr>';
        $table_data .= '<tr>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Total Days</th>';
        $table_data .= '<th style="white-space:nowrap;">' . $total_working_days . '</th>';
        $table_data .= '<th></th>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Holiday Working</th>';
        $table_data .= '<th style="white-space:nowrap;">Days ()</th>';
        $table_data .= '</tr>';
        $table_data .= '<tr>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Not Marked</th>';
        $table_data .= '<th style="white-space:nowrap;">' . $not_marked_count . '</th>';
        $table_data .= '<th></th>';
        $table_data .= '<th style="white-space:nowrap;" colspan="3">Extra Work Hours</th>';
        $table_data .= '<th></th>';
        $table_data .= '</tr>';
        $table_data .= '</tbody>';
      }
    }
    echo json_encode(array("table_data" => $table_data));  // send data as json format
  }
  public function data_entry_approval($level=1)
  {
    $data_type = $this->security->xss_clean($this->input->post('data_type'));
    $data_id = $this->security->xss_clean($this->input->post('data_id'));
    $approval_status = $this->security->xss_clean($this->input->post('data_entry_approval'));
    $result = $this->data_entry_approval_action($data_type,$data_id,$approval_status,$level);
    if (isset($result)) {
      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        if($approval_status==1){
          $flash_data['flashdata_msg'] = 'Selected Data Approved Successfully!.';
        }else{
          $flash_data['flashdata_msg'] = 'Selected Data Rejected Successfully!.';
        }
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    } else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    echo json_encode($flash_data);
  }
  public function data_entry_approval_bulk($level=1)
  {
    $entry_ids=implode(',',$this->input->post('entry_ids'));
    ##makes array
    $entry_ids_array=explode(',',$entry_ids);
    $action_type = $this->security->xss_clean($this->input->post('action_type'));
    if($action_type=='approve'){
      $approval_status = 1;
      $flash_data['flashdata_msg'] = 'Selected Data Approved Successfully!.';
    }else{
      $approval_status = 2;
      $flash_data['flashdata_msg'] = 'Selected Data Rejected Successfully!.';
    }
    for($i=0;$i<sizeof($entry_ids_array);$i++)
    {
      if($entry_ids_array[$i]!=''){
        $data_details = explode('-',$entry_ids_array[$i]);
        $data_type = $data_details[0];
        $data_id = $data_details[1];
        $result = $this->data_entry_approval_action($data_type,$data_id,$approval_status,$level);
      }
    }
    if (isset($result)) {
      $flash_data['status'] = $result;
      if ($flash_data['status'] == 1) {
        // $flash_data['flashdata_msg'] = 'Data Approval Status Updated Successfully!.';
        $flash_data['flashdata_type'] = 'success';
        $flash_data['alert_type'] = 'success';
        $flash_data['flashdata_title'] = 'Success !';
      } else {
        $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
        $flash_data['flashdata_type'] = 'error';
        $flash_data['alert_type'] = 'danger';
        $flash_data['flashdata_title'] = 'Error !!';
      }
    } else {
      $flash_data['status'] = 0;
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    echo json_encode($flash_data);
  }
  public function data_entry_approval_action($data_type,$data_id,$approval_status,$level)
  {
    if ($data_type == 'expense_bill' || $data_type == 'subcontract_bill') {
      $bill_data['bill_id'] = $data_id;
      if($level==2){
        $bill_data['entry_approval_status_2'] = $approval_status;
      }else{
        $bill_data['entry_approval_status'] = $approval_status;
      }
      $bill_details  = $this->Bills->select_bills("b.bill_type", array("b.bill_id" => $bill_data['bill_id']),'','','','all','all')->row();
      $result = $this->Bills->update_bills($bill_data);
      $this->bills_management->calculate_bill_total($bill_data['bill_id']);
    } elseif ($data_type == 'expense_bill_payment') {
      $transaction_data['transaction_id'] = $data_id;
      if($level==2){
        $transaction_data['tr_entry_approval_status_2'] = $approval_status;
      }else{
        $transaction_data['tr_entry_approval_status'] = $approval_status;
      }
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all', 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
        $this->bills_management->calculate_bill_total($transaction_details->row()->reference_id);
      }
    }elseif($data_type=='account_transfer'){
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*",array("ats.transaction_id"=>$transaction_data['transaction_id']),'','','','',$entry_approval);
      if($transaction_details->num_rows()==1){
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    }elseif($data_type=='client_payment'){
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval);
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
        if ($transaction_details->row()->invoice_id != 0) {
          $this->bills_management->calculate_invoice_payment_total($transaction_details->row()->invoice_id);
        }
      }
    } elseif ($data_type == 'client_invoice') {
      $invoice_data['invoice_id'] = $data_id;
      $invoice_data['entry_approval_status'] = $approval_status;
      $result = $this->Invoices->update_invoice($invoice_data);
      $this->bills_management->calculate_invoice_payment_total($invoice_data['invoice_id']);
    } elseif ($data_type == 'purchase_bill') {
      $purchase_update_data['purchase_id'] = $data_id;
      if($level==2){
        $purchase_update_data['entry_approval_status_2'] = $approval_status;
      }else{
        $purchase_update_data['entry_approval_status'] = $approval_status;
      }
      $result = $this->Purchases->update_purchase($purchase_update_data);
      $this->bills_management->calculate_purchase_bill_total($purchase_update_data['purchase_id']);
      $this->stock_management->update_stock_register($purchase_update_data['purchase_id']);
    } elseif ($data_type == 'purchase_bill_payment') {
      $transaction_data['transaction_id'] = $data_id;
      if($level==2){
        $transaction_data['tr_entry_approval_status_2'] = $approval_status;
      }else{
        $transaction_data['tr_entry_approval_status'] = $approval_status;
      }
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all', 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
        $this->bills_management->calculate_purchase_bill_total($transaction_details->row()->reference_id);
      }

    }elseif ($data_type == 'purchase_order_payment') {
      $transaction_data['transaction_id'] = $data_id;
      if($level==2){
        $transaction_data['tr_entry_approval_status_2'] = $approval_status;
      }else{
        $transaction_data['tr_entry_approval_status'] = $approval_status;
      }
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all', 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    } elseif ($data_type == 'purchase_order') {
      $order_update_data['order_id'] = $data_id;
      $order_update_data['entry_approval_status'] = $approval_status;
      $result = $this->Purchase_order->update_purchase_order($order_update_data);
    } elseif ($data_type == 'subcontract_payment') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval);
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
        if ($transaction_details->row()->reference_type == 'subcontract_bill') {
          $this->bills_management->calculate_bill_total($transaction_details->row()->reference_id);
        }
      }
    } elseif ($data_type == 'stock_transfer') {
      $transfer_data_where['transfer_id'] = $data_id;
      $transfer_update_data['entry_approval_status'] = $approval_status;
      $stock_transfer  = $this->Stock->select_stock_transfers("COALESCE(SUM(st.transferred_qty),0) as total_transferred_qty,COALESCE(SUM(st.transferred_qty*sr2.unit_price),0) as total_transferred_amt,st.*,sr1.unit_price,sr1.material_id,m.material_name,mu.unit_name,sr1.unit,sl1.location_name as transferred_from_loc_name,sl2.location_name as transferred_to_loc_name,u.user_alias as created_user", $transfer_data_where, array("st.trans_group_id", "sr1.material_id", "sr1.unit"), $this->config->item('select_data_entry_approval'));
      foreach ($stock_transfer->result() as $row) {
        $transfer_update_data['transfer_id'] = $row->transfer_id;
        $result = $this->Stock->update_stock_transfer($transfer_update_data);
        $result2 = $this->stock_management->calculate_stock_balance($row->transferred_from_stock_id);

        $stock_update_data['stock_id'] = $row->transferred_to_stock_id;
        $stock_update_data['entry_approval_status'] = $approval_status;
        $result3 = $this->Stock->update_stock_register($stock_update_data);
        $result4 = $this->stock_management->calculate_stock_balance($row->transferred_to_stock_id);
      }
    } elseif ($data_type == 'stock_consumption') {
      $consumption_data_where['cons_id'] = $data_id;
      $consumption_update_data['entry_approval_status'] = $approval_status;
      $consumption  = $this->Stock->select_stock_consumption("COALESCE(SUM(sc.consumption_qty),0) as total_consumed_qty,sc.*,sr.unit_price,sr.material_id,m.material_name,mu.unit_name,sr.unit,sr.location_id,u.user_alias as created_user,wc.work_name", $consumption_data_where, array("sc.cons_group_id", "sr.material_id", "sr.unit"), $this->config->item('select_data_entry_approval'));
      foreach ($consumption->result() as $row) {
        $consumption_update_data['cons_id'] = $row->cons_id;
        $result = $this->Stock->update_stock_consumption($consumption_update_data);
        $result2 = $this->stock_management->calculate_stock_balance($row->stock_id);
      }
    } elseif ($data_type == 'labour_wage') {
      $labour_wage_data['wage_id'] = $data_id;
      $labour_wage_data['entry_approval_status'] = $approval_status;
      $result = $this->Labour_wages->update_labour_wage($labour_wage_data);
    } elseif ($data_type == 'labour_payment') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval);
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    } elseif ($data_type == 'tool_transfer') {
      $tool_transfer_data['transfer_id'] = $data_id;
      $tool_transfer_data['entry_approval_status'] = $approval_status;
      $result = $this->Tools->update_tool_transfer($tool_transfer_data);
    } elseif ($data_type == 'tool_rent') {
      $tool_rent_data['id'] = $data_id;
      $tool_rent_data['entry_approval_status'] = $approval_status;
      $result = $this->Tools->update_tool_rent($tool_rent_data);
    } elseif ($data_type == 'tool_payment') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval);
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    } elseif ($data_type == 'supplier_payment') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval);
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    } elseif ($data_type == 'travel_allowance') {
      $data['ta_id'] = $data_id;
      $data['entry_approval_status'] = $approval_status;
      $result = $this->Travel_allowance->update_ta($data);

      $ta_transaction_where['ats.reference_type'] = 'travel_allowance';
      $ta_transaction_where['ats.tr_type'] = 'travel_allowance_transaction';
      $ta_transaction_where['ats.reference_id'] = $data['ta_id'];
      $ta_transactions = $this->Account->select_account_transaction("ats.transaction_id", $ta_transaction_where, 'travel_allowance')->result();
      foreach ($ta_transactions as $key => $value) {
        $transaction_data['transaction_id'] = $value->transaction_id;
        $transaction_data['tr_entry_approval_status'] = $approval_status;
        $this->Account->update_account_transaction($transaction_data);
      }
    } elseif ($data_type == 'salary_slip') {
      $salary_slip_update_data['salary_id'] = $data_id;
      $salary_slip_update_data['entry_approval_status'] = $approval_status;
      $result = $this->Salary_slips->update_salary_slip($salary_slip_update_data);
      $this->bills_management->calculate_salary_slip_total($salary_slip_update_data['salary_id']);
    } elseif ($data_type == 'employee_payment') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
        if ($transaction_details->row()->reference_type == 'salary_slip') {
          $this->bills_management->calculate_salary_slip_total($transaction_details->row()->reference_id);
        }
      }
    } elseif ($data_type == 'vehicle_work_slip') {
      $vehicle_work_slip_update_data['work_slip_id'] = $data_id;
      $vehicle_work_slip_update_data['entry_approval_status'] = $approval_status;
      $result = $this->Vehicle_work_slips->update_vehicle_work_slip($vehicle_work_slip_update_data);
      $this->bills_management->calculate_vehicle_work_slip_total($vehicle_work_slip_update_data['work_slip_id']);
    } elseif ($data_type == 'vehicle_work_slip_payment') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
        if ($transaction_details->row()->reference_type == 'vehicle_work_slip') {
          $this->bills_management->calculate_vehicle_work_slip_total($transaction_details->row()->reference_id);
        }
      }
    } elseif ($data_type == 'user_payment_receipt_payment' || $data_type == 'user_payment_return_payment') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    } elseif ($data_type == 'loan') {
      $loan_update_data['loan_id'] = $data_id;
      if($level==2){
        $loan_update_data['entry_approval_status_2'] = $approval_status;
      }else{
        $loan_update_data['entry_approval_status'] = $approval_status;
      }
      $result = $this->Loan->update_loan($loan_update_data);
    } elseif ($data_type == 'loan_payment') {
      $transaction_data['transaction_id'] = $data_id;
      if($level==2){
        $transaction_data['tr_entry_approval_status_2'] = $approval_status;
      }else{
        $transaction_data['tr_entry_approval_status'] = $approval_status;
      }
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all', 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    } elseif ($data_type == 'other_income') {
      $transaction_data['transaction_id'] = $data_id;
      $transaction_data['tr_entry_approval_status'] = $approval_status;
      // Select Detail
      $entry_approval = 'all';
      $transaction_details = $this->Account->select_account_transaction("ats.*", array("ats.transaction_id" => $transaction_data['transaction_id']), '', '', '', '', $entry_approval, 'all');
      if ($transaction_details->num_rows() == 1) {
        $result =  $this->Account->update_account_transaction($transaction_data);
      }
    }
    if(isset($result)){
      return $result;
    }else{
      return 0;
    }
  }
  public function select_users()
  {
    $data = array();
    if (isset($_POST['id']) && $_POST['id'] != "") {
      $data['user_id'] = $_POST['id'];
    }
    if (isset($_POST['branch_id']) && $_POST['branch_id'] != "") {
      $data['branch_id'] = $_POST['branch_id'];
    }
    if (isset($_POST['user_role']) && $_POST['user_role'] != "") {
      $data['role_name'] = $_POST['user_role'];
    }
    $result = $this->User->select_user("", $data);
    if ($result->num_rows() > 0) {
      echo json_encode(array("count" => $result->num_rows(), "data" => $result->result()));
    } else {
      echo json_encode(array("count" => $result->num_rows()));
    }
  }

  public function update_role()
  {
    //**Module Settings**//
    $module_element_no = 7003;
    $module_element_type = 'edit';
    // $this->page_data['module_element_data'] = $this->Settings->select_module_elements("*,me.slno as elem_slno",array("me.elementno"=>$module_element_no),true)->row();
    // $this->page_data['user_element_details'] = $this->User->check_user_have_module_element_access($module_element_no,$module_element_type);
    //****//

    $data['role_id'] = $this->security->xss_clean($this->input->post('role_id'));
    $data['role_title'] = $this->security->xss_clean($this->input->post('role_title'));
    $data['active_status'] = $this->security->xss_clean($this->input->post('status'));
    if($data['active_status'] == 'on'){
      $data['active_status'] = 1;
    }else{
      $data['active_status'] = 0;
    }
    $result = $this->User->update_user_role($data);
    $flash_data['status'] = $result;
    if ($flash_data['status'] == 1) {
      $flash_data['flashdata_msg'] = 'Role Details Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';

    } else {
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }

    $flash_data['message'] = $flash_data['flashdata_msg'];
    echo(json_encode($flash_data));

  }
  public function select_roles(){

    //**Module Settings**//
    $module_element_no = 7003;
    $module_element_type = 'view';
    // $this->page_data['module_element_data'] = $this->Settings->select_module_elements("*,me.slno as elem_slno",array("me.elementno"=>$module_element_no),true)->row();
    // $this->page_data['user_element_details'] = $this->User->check_user_have_module_element_access($module_element_no,$module_element_type);
    //****//

    $json_data=array();
    $j=0;
    $sl_no=0;
    $data=array();
    $data['ur.editable_status'] = 1;
    $data['ur.active_status'] = 1;
    $result	= $this->User->select_user_roles("",$data);
    $result_array=$result->result();

    $json_data['draw']=5;
    $json_data['recordsTotal']=$result->num_rows();
    $json_data['recordsFiltered']=$result->num_rows();
    $array=array();

    $slno=0;
    foreach($result_array as $row):

      $btn_edit=$btn_module=$action=$btn_title='';
      // $btn_edit='<a style="margin-left: 5px;margin-right: 5px" id="role_edit_btn" href="#role_edit_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--icon-only m-btn--pill m-btn--air">
      // <i class="la la-edit"></i>
      // </a>';
      if($row->modulemanagement==1){
        if($row->modulebasedtype=='account'){
          if($row->linked_table=='users'){
            $action = base_url().'user/view?role_id='.$row->role_id."&modulemanage=1";
            $btn_title='View Accounts & Manage Modules';
          }
        }else{
          $action = base_url().'user/modules?role='.$row->role_id;
          $btn_title='Manage Modules';
        }
        $btn_module='<a style="margin-left: 5px;margin-right: 5px"  href="'.$action.'" class="btn btn-sm btn-focus m-btn m-btn--icon  m-btn--pill m-btn--air">
        <i class="fa fa-sitemap"></i> '.$btn_title.'</a>';
      }

      if($row->active_status==1){
        $active_status='<span class="m-badge m-badge--primary m-badge--wide">Active</span>';
      }else{
        $active_status='<span class="m-badge m-badge--danger m-badge--wide">In Activate</span>';
      }

      $slno++;
      $array[$j][]=$row->role_id;
      $array[$j][]=$slno;
      $array[$j][]=$row->role_title;
      $array[$j][]=$active_status;
      $array[$j][]=$row->active_status;
      $array[$j][]=$btn_edit.$btn_module;

      $j++;

    endforeach;


    $json_data['data']=$array;
    echo json_encode($json_data);  // send data as json format
  }
  public function update_modules()
  {
    //**Module Settings**//
    $module_element_no = 7003;
    $module_element_type = 'edit';
    // $this->page_data['module_element_data'] = $this->Settings->select_module_elements("*,me.slno as elem_slno",array("me.elementno"=>$module_element_no),true)->row();
    // $this->page_data['user_element_details'] = $this->User->check_user_have_module_element_access($module_element_no,$module_element_type);
    //****//

    $success = 0;
    $user_element_data['user_id'] = $this->security->xss_clean($this->input->post('user_id'));
    $user_element_data['user_id_type'] = $this->security->xss_clean($this->input->post('user_type'));

    $module_elements = $this->Settings->select_module_elements("*,me.slno as elem_slno","",true)->result();
    foreach ($module_elements as $key => $value) {
      // CHeck ELement is Fully or Prtially Enables
      if($this->input->post('element_'.$value->elementno)>0){
        $user_element_data['elementno'] = $value->elementno;
        $user_element_data['entrystatus'] = $user_element_data['editstatus'] = $user_element_data['viewstatus'] = 0;
        if($this->input->post('element_'.$value->elementno."_add")){
          $user_element_data['entrystatus'] = $this->input->post('element_'.$value->elementno."_add");
        }
        if($this->input->post('element_'.$value->elementno."_edit")){
          $user_element_data['editstatus'] = $this->input->post('element_'.$value->elementno."_edit");
        }
        if($this->input->post('element_'.$value->elementno."_view")){
          $user_element_data['viewstatus'] = $this->input->post('element_'.$value->elementno."_view");
        }

        if($user_element_data['entrystatus']==0 && $user_element_data['editstatus']==0 && $user_element_data['viewstatus']==0){
          $user_element_data['activestatus'] = 0;
        }else{
          $user_element_data['activestatus'] = 1;
        }
        $user_element = $this->Settings->select_user_module_elements("",array("user_id"=>$user_element_data['user_id'],"user_id_type"=>$user_element_data['user_id_type'],"elementno"=>$user_element_data['elementno']));
        if($user_element->num_rows()==1){
          // Update Existing Data
          unset($user_element_data['createddate']);
          $result = $this->Settings->update_user_module_elements($user_element_data);
          if($result==1){
            $success = 1;
          }
        }else{
          // Insert Data
          $user_element_data['createddate']=date('Y-m-d H:i:s');
          $result = $this->Settings->insert_user_module_elements($user_element_data);
          if($result['status']==1){
            $success = 1;
          }
        }
      }else{
        // If Element is Fully Disabled
        $user_element_data['elementno'] = $value->elementno;
        $user_element = $this->Settings->select_user_module_elements("",array("user_id"=>$user_element_data['user_id'],"user_id_type"=>$user_element_data['user_id_type'],"elementno"=>$user_element_data['elementno']));
        if($user_element->num_rows()==1){
          // Update Existing Data
          unset($user_element_data['createddate']);
          $user_element_data['entrystatus'] = $user_element_data['editstatus'] = $user_element_data['viewstatus'] = 0;
          $user_element_data['activestatus'] = 0;
          $result = $this->Settings->update_user_module_elements($user_element_data);
          if($result==1){
            $success = 1;
          }
        }
      }
    }

    if($success==1){
      $flash_data['flashdata_msg'] = 'User Modules Updated Successfully!.';
      $flash_data['flashdata_type'] = 'success';
      $flash_data['alert_type'] = 'success';
      $flash_data['flashdata_title'] = 'Success !';
    }else{
      $flash_data['flashdata_msg'] = 'Sorry.. There Have been Some Error Occurred. Please Try Again!';
      $flash_data['flashdata_type'] = 'error';
      $flash_data['alert_type'] = 'danger';
      $flash_data['flashdata_title'] = 'Error !!';
    }
    $this->session->set_flashdata($flash_data);
    if($user_element_data['user_id_type']=='account'){
      redirect(base_url(). 'user/modules?role='.$this->input->post('role_id').'&account_id='.$user_element_data['user_id'],'refresh');
    }else{
      redirect(base_url(). 'user/modules?role='.$user_element_data['user_id'],'refresh');
    }
  }

  public function select_data_entry_approval_data($page_data_type=''){

    $data_entry_approval_2_level_tr_types=array("purchase_bill_transaction","loan_receipt_transaction","expense_bill_transaction","loan_transaction");
    $j=0;
    $sl_no=1;
    $json_data=$array=array();
    $transaction_where=$invoice_where=$purchase_order_where=$purchase_bill_where=$expense_bill_where=$subcontract_bill_where=$stock_transfer_where=$stock_consumption_where=$labour_wage_slip_where=$tool_transfer_where = $tool_rent_where = $travel_allowance_where = $salary_slip_where = $vehicle_work_slip_where = $loan_where = array();

    $entry_approval  = $join_table_entry_approval = 1;
    if($this->config->item('User_enable_data_entry_approval')==1){//webapp users approval
      $entry_approval = 'all';
    }
    if($page_data_type=='approval_entries'){
      $entry_approval = 'all';
      $transaction_where['u1.user_role >'] =2;
      if(isset($_POST['approval_status']) && $_POST['approval_status']!='' && $_POST['approval_status']!='all'){
        $entry_approval = $_POST['approval_status'];
        $join_table_entry_approval = 'all';
      }
    }
    if (isset($_POST['start_date']) && $_POST['start_date'] != '' && $_POST['start_date'] != 'all') {
      $transaction_where['ats.tr_date >='] = date('Y-m-d', strtotime($_POST['start_date']));
      $invoice_where["i.invoice_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $purchase_order_where["po.order_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $purchase_bill_where["p.purchase_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $expense_bill_where["b.bill_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $subcontract_bill_where["b.bill_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $stock_transfer_where["st.transfer_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $stock_consumption_where["sc.consumption_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $labour_wage_slip_where["lw.work_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $tool_transfer_where["tt.transfer_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $tool_rent_where["tr.rented_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $travel_allowance_where["ta.ta_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $start_date=date('Y-m', strtotime($_POST['start_date']));
      $salary_slip_where["ss.month >="]= $start_date."-01";
      $vehicle_work_slip_where["vws.worked_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
      $loan_where["l.loan_date >="]= date('Y-m-d', strtotime($_POST['start_date']));
    }
    if (isset($_POST['end_date']) && $_POST['end_date'] != '' && $_POST['end_date'] != 'all') {
      $transaction_where['ats.tr_date <='] = date('Y-m-d', strtotime($_POST['end_date']));
      $invoice_where["i.invoice_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $purchase_order_where["po.order_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $purchase_bill_where["p.purchase_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $expense_bill_where["b.bill_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $subcontract_bill_where["b.bill_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $stock_transfer_where["st.transfer_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $stock_consumption_where["sc.consumption_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $labour_wage_slip_where["lw.work_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $tool_transfer_where["tt.transfer_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $tool_rent_where["tr.rented_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $travel_allowance_where["ta.ta_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $end_date=date('Y-m', strtotime($_POST['end_date']));
      $salary_slip_where["ss.month <="]= $end_date."-".date('t',strtotime($_POST['end_date']));
      $vehicle_work_slip_where["vws.worked_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
      $loan_where["l.loan_date <="]= date('Y-m-d', strtotime($_POST['end_date']));
    }
    if(isset($_POST['created_by']) && $_POST['created_by']!='' && $_POST['created_by']!='all'){
      $transaction_where['ats.created_by'] = $_POST['created_by'];
      $invoice_where['i.created_by'] = $_POST['created_by'];
      $purchase_order_where['po.created_by'] = $_POST['created_by'];
      $purchase_bill_where['p.created_by'] = $_POST['created_by'];
      $expense_bill_where['b.created_by'] = $_POST['created_by'];
      $subcontract_bill_where['b.created_by'] = $_POST['created_by'];
      $stock_transfer_where['st.created_by'] = $_POST['created_by'];
      $stock_consumption_where['sc.created_by'] = $_POST['created_by'];
      $labour_wage_slip_where['lw.created_by'] = $_POST['created_by'];
      $tool_transfer_where['tt.created_by'] = $_POST['created_by'];
      $tool_rent_where['tr.created_by'] = $_POST['created_by'];
      $travel_allowance_where['ta.created_by'] = $_POST['created_by'];
      $salary_slip_where['ss.created_by'] = $_POST['created_by'];
      $vehicle_work_slip_where['vws.created_by'] = $_POST['created_by'];
      $loan_where['l.created_by'] = $_POST['created_by'];
    }

    // Account Transfer
    if((isset($_POST['work']) && $_POST['work']=='all') || !isset($_POST['work'])){
      $account_transfer_where = $transaction_where;
      $account_transfer_where['tr_type'] = 'account_transfer';
      if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
        $this->db->where('(tr_credit_acc='.$_POST['acc_head_id'].' or tr_debit_acc='.$_POST['acc_head_id'].')');
      }
      $account_transfers = $this->Account->select_account_transfer("*,ah1.acc_head_name AS transfer_from,ah1.acc_head_id AS acc_from_id,ah2.acc_head_name AS transfer_to,ah2.acc_head_id AS acc_to_id,u1.user_alias AS created_by,ats.created_date AS t_created_date,u1.user_role as created_user_role_id",$account_transfer_where,'',$entry_approval)->result();
      foreach($account_transfers as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="account_transfer" data-approval-status="'.$row->tr_entry_approval_status.'" data-id="'.$row->transaction_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          if($row->tr_entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->tr_entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $array[$j][]='account_transfer-'.$row->transaction_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Account Transfer</strong>';
        $array[$j][]="#".$row->transaction_id;
        $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
        $array[$j][]='From: '.$row->transfer_from." - To: ".$row->transfer_to;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]="Mode: ".$row->tr_mode;
        $array[$j][]='';
        $array[$j][]=$row->tr_remarks;
        $array[$j][]=$row->created_by.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->t_created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->tr_entry_approval_status;

        $j++;
      }
    }

    // Client Invoice
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $invoice_where['i.project_id'] = $_POST['work'];
        $invoice_where['i.invoice_type'] = 'project_invoice';
      }
      $client_invoices = $this->Invoices->select_invoices("*,u1.user_id as i_created_by,u1.user_alias as i_created,i.created_date as i_created_date,wc.work_name,c.client_name,wc.branch_id as branch_id,i.client_id as invoice_client_id",$invoice_where,$entry_approval)->result();
      foreach($client_invoices as $row){
        $btn_approve = $entry_approval_status = '';
        if($this->session->userdata('user_role')=='admin' && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="client_invoice" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->invoice_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $invoice_no = '';
        if($row->invoice_type=='proforma'){
          $invoice_no .= $this->config->item('client_invoice_proforma_prefix');
        }else{
        if($row->tax_invoice==1){
          if($row->business_type=='B2B'){
            $invoice_no .= $this->config->item('client_invoice_tax_b2b_prefix');
          }else{
            $invoice_no .= $this->config->item('client_invoice_tax_b2c_prefix');
          }
        }else{
          $invoice_no .= $this->config->item('client_invoice_prefix');
        }
      }
        if (strpos($invoice_no, 'y') !== false) {
          $year = date('y',strtotime($row->invoice_date));
          $invoice_no = str_replace('y', $year, $invoice_no);
        }
        $invoice_no .= sprintf('%04u', $row->invoice_no);
        $invoice_no .= $row->invoice_suffix;
        if($row->reference_no!=''){
          $invoice_no .= '<br/>Ref No: '.$row->reference_no;
        }

        $array[$j][]='client_invoice-'.$row->invoice_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Client Invoice</strong>';
        $array[$j][]='<a href="'. base_url().'invoices/profile/'.$row->invoice_id.'">'.$invoice_no.'</a>';
        $array[$j][]=date('d-m-Y',strtotime($row->invoice_date));
        $array[$j][]=ucwords(str_replace('_',' ',$row->invoice_type)).' Invoice<br/>Invoice No: '.$invoice_no."<br/>Client: ".$row->client_name;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->invoice_total_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]="";
        if($row->invoice_type=='project_invoice'){
          $array[$j][]='#' .$row->work_id." - ".$row->work_name;
        }else{
          $array[$j][]='';
        }
        $array[$j][]='';
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->i_created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Client Payment
    $client_payment_where = $transaction_where;
    $client_payment_where['ats.tr_type'] = 'client_payment_transaction';
    $client_payment_where['ats.reference_type'] = 'project';
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_credit_acc='.$_POST['acc_head_id'].')');
    }
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $this->db->where("((wc.work_id=".$_POST['work']." and ats.reference_type='project' and ats.invoice_id=0) or (ci.project_id=".$_POST['work']." and ats.reference_type='project' and ats.invoice_id!=0))");
    }
    $client_payments	= $this->Account->select_account_transaction("ats.*,c.client_contact,c.client_email,c.client_id,c.client_name,wc.work_id,wc.work_name,u1.user_alias as created_user,u2.user_alias as updated_user,ah2.acc_head_name as credit_account,u1.user_role as created_user_role_id",$client_payment_where,'client_payment','','','',$entry_approval)->result();
    foreach($client_payments as $row){
      $btn_approve = $entry_approval_status = '';
      if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
        $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="client_payment" data-approval-status="'.$row->tr_entry_approval_status.'" data-id="'.$row->transaction_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
        <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
        </a>';
      }
      if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
        if($row->tr_entry_approval_status==1){
          $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
        }elseif($row->tr_entry_approval_status==2){
          $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
        }else{
          $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
        }
      }

      $invoice_details = $row->client_name;
      if($row->invoice_id != 0){
        $invoice_details = "<br/><span class='m-badge m-badge--success m-badge--wide'><a href='".base_url()."invoices/profile/".$row->invoice_id."' style='color: #000; text-decoration: none;'>Invoice Payment  #".$row->invoice_id."</a></span>";
      }

      $array[$j][]='client_payment-'.$row->transaction_id;
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Client Payment</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$invoice_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Credit Account: ".$row->credit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]='#' .$row->work_id." - ".$row->work_name;
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Purchase Order
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $purchase_order_where['sl.work_id'] = $_POST['work'];
      }
      $purchase_orders = $this->Purchase_order->select_purchase_order("po.*,u.user_alias,s.supplier_name,s.supplier_id,sl.location_name,sl.work_id,sl.location_type,sl.work_id as location_work_id,u.user_role as created_user_role_id,u1.user_alias as approved_1_user,u2.user_alias as approved_2_user",$purchase_order_where,$entry_approval)->result();
      foreach($purchase_orders as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="purchase_order" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->order_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $order_prefix = $this->config->item('purchase_order_prefix');
        if (strpos($order_prefix, 'fy-y') !== false) {
          if (date('m',strtotime($row->order_date)) <= 3) {//Upto March
            $financial_year = (date('y',strtotime($row->order_date))-1) . '-' . date('y',strtotime($row->order_date));
          } else {//After March
            $financial_year = date('y',strtotime($row->order_date)) . '-' . (date('y',strtotime($row->order_date)) + 1);
          }
          $order_prefix = str_replace('fy-y', $financial_year, $order_prefix);
        }
        if($this->config->item('Purchase_order_show_order_no')==1){
          $order_id =  $order_prefix.$row->order_no.$row->orde_no_suffix;
        }else{
          $order_id =  $order_prefix.$row->order_id.$row->orde_no_suffix;
        }

        $location_name = $row->location_name;
        if ($row->location_type == 'work_site') {
          $location_name = '<a href="' . base_url() . 'work/profile/' . $row->location_work_id . '">#'.$row->location_work_id." - ". $row->location_name . '<br/>[Work Site]</a>';
        } elseif ($row->location_type == 'ware_house') {
          $location_name = '<a href="' . base_url() . 'stock/locations/profile/' . $row->location_id . '">' . $row->location_name . '<br/>[Warehouse]</a>';
        }

        $array[$j][]='purchase_order-'.$row->order_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Purchase Order</strong>';
        $array[$j][]='<a href="' . base_url() . 'purchase_order/profile/' . $row->order_id . '">#' . $order_id. '</a>';
        $array[$j][]=date('d-m-Y',strtotime($row->order_date));
        $array[$j][]='Supplier: '.$row->supplier_name;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->total_est_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][]=$location_name;
        $array[$j][]='';
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Purchase Order Payments
    $reference_type = 'purchase_order';
    $purchase_order_payment_where = $transaction_where;
    $purchase_order_payment_where['ats.reference_type'] = $reference_type;
    $purchase_order_payment_where['ats.tr_type'] = $reference_type . "_transaction";
    $select_columns = "po.order_id,po.reference_no,s.supplier_name,wc.work_name,sl.work_id as location_work_id,sl.location_name,sl.work_id,sl.location_type,sl.location_id";
    if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
      $purchase_order_payment_where['sl.work_id'] = $_POST['work'];
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $purchase_order_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $purchase_order_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($purchase_order_payments as $row){
      $reference_type_2 = $reference_type;
      $bill_details = 'Purchase Order : <a href="' . base_url() . 'purchase_order/profile/' . $row->order_id . '">#' . $row->order_id . '</a>';
      $bill_details .= "<br/>Supplier: ".$row->supplier_name;
      if ($row->location_type == 'work_site') {
        $location_name = '<a href="' . base_url() . 'work/profile/' . $row->location_work_id . '">#'.$row->location_work_id." - ". $row->location_name . '<br/>[Work Site]</a>';
      } elseif ($row->location_type == 'ware_house') {
        $location_name = '<a href="' . base_url() . 'stock/locations/profile/' . $row->location_id . '">' . $row->location_name . '<br/>[Warehouse]</a>';
      }

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='purchase_order_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Purchase Order Payment</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]=$location_name;
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Purchase Bills
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $purchase_bill_where['sl.work_id'] = $_POST['work'];
      }
      $purchase_bills = $this->Purchases->select_purchase("p.*,u.user_alias,s.supplier_id,s.supplier_name,sl.location_name,sl.work_id,sl.location_type,sl.work_id as location_work_id,u.user_role as created_user_role_id",$purchase_bill_where,$entry_approval,'','','all')->result();
      foreach($purchase_bills as $row){
        $entry_selectable = 0;
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status_2 == 0)){
            $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="purchase_bill" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->purchase_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
            <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
            </a>';
            $entry_selectable = 1;
          }
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          $level='';
          if($this->config->item('User_enable_data_entry_approval_2_level')==1){
            $level='1st Level ';
          }
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
          }
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status == 1){
            if ($row->entry_approval_status_2 == 1) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
            } elseif ($row->entry_approval_status_2 == 2) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
            } else {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
            }
          }
        }

        $location_name = $row->location_name;
        if ($row->location_type == 'work_site') {
          $location_name = '<a href="' . base_url() . 'work/profile/' . $row->location_work_id . '">#'.$row->location_work_id." - ". $row->location_name . '<br/>[Work Site]</a>';
        } elseif ($row->location_type == 'ware_house') {
          $location_name = '<a href="' . base_url() . 'stock/locations/profile/' . $row->location_id . '">' . $row->location_name . '<br/>[Warehouse]</a>';
        }

        if($entry_selectable==1){
          $array[$j][]='purchase_bill-'.$row->purchase_id;
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Purchase Bill</strong>';
        $array[$j][]='<a href="' . base_url() . 'purchases/profile/' . $row->purchase_id . '">#' . $row->purchase_id. '</a>';
        $array[$j][]=date('d-m-Y',strtotime($row->purchase_date));
        $array[$j][]='Supplier: '.$row->supplier_name;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->bill_payable_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][]=$location_name;
        $array[$j][]='';
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Purchase Bill Payments
    $reference_type = 'purchase_bill';
    $purchase_bill_payment_where = $transaction_where;
    $purchase_bill_payment_where['ats.reference_type'] = $reference_type;
    $purchase_bill_payment_where['ats.tr_type'] = $reference_type . "_transaction";
    $select_columns = "p.purchase_order_id,p.purchase_id,p.bill_invoice_no,s.supplier_name,wc.work_name,sl.work_id as location_work_id,sl.location_name,sl.work_id,sl.location_type,sl.location_id";
    if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
      $purchase_bill_payment_where['sl.work_id'] = $_POST['work'];
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $purchase_bill_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $purchase_bill_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($purchase_bill_payments as $row){
      $reference_type_2 = $reference_type;
      $bill_details = 'Purchase Bill : <a href="' . base_url() . 'purchases/profile/' . $row->purchase_id . '">#' . $row->purchase_id . '</a>';
      $bill_details .= "<br/>Supplier: ".$row->supplier_name;
      if ($row->location_type == 'work_site') {
        $location_name = '<a href="' . base_url() . 'work/profile/' . $row->location_work_id . '">#'.$row->location_work_id." - ". $row->location_name . '<br/>[Work Site]</a>';
      } elseif ($row->location_type == 'ware_house') {
        $location_name = '<a href="' . base_url() . 'stock/locations/profile/' . $row->location_id . '">' . $row->location_name . '<br/>[Warehouse]</a>';
      }

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='purchase_bill_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Purchase Bill Payment</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]=$location_name;
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Supplier Payments
    if((isset($_POST['work']) && $_POST['work']=='all') || !isset($_POST['work'])){
      $reference_type = 'supplier';
      $supplier_payment_where = $transaction_where;
      $supplier_payment_where['ats.reference_type'] = $reference_type;
      if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
        $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
      }
      // $supplier_payment_where['ats.tr_type'] = $reference_type . "_transaction";
      $this->db->where("(ats.tr_type='supplier_advance_transaction' or ats.tr_type='supplier_opbalance_transaction')");
      $select_columns = "s.supplier_name,s.supplier_id,s.supplier_type,s.supplier_address,s.supplier_phone";
      $supplier_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $supplier_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
      foreach($supplier_payments as $row){
        $reference_type_2 = $reference_type;
        if ($row->tr_type == 'supplier_opbalance_transaction') {
          $bill_details = "Supplier Opening Balance Payment";
        } elseif ($row->tr_type == 'supplier_advance_transaction') {
          $bill_details = "Supplier Advance Payment";
        }
        $bill_details .= "<br/>Supplier: ".$row->supplier_name;

        $btn_approve = $entry_approval_status = '';
        $entry_selectable = 0;
        if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
            $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
            <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
            </a>';
            $entry_selectable = 1;
          }
        }
        if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
          $level='';
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            $level='1st Level ';
          }
          if ($row->tr_entry_approval_status == 1) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
          } elseif ($row->tr_entry_approval_status == 2) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
          } else {
            $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
          }
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            if ($row->tr_entry_approval_status_2 == 1) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
            } elseif ($row->tr_entry_approval_status_2 == 2) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
            } else {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
            }
          }
        }
        if($entry_selectable==1){
          $array[$j][]='supplier_payment-'.$row->transaction_id;
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Supplier Payment</strong>';
        $array[$j][]="#".$row->transaction_id;
        $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
        $array[$j][]='';
        $array[$j][]=$row->tr_remarks;
        $array[$j][]=$row->created_user.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->tr_entry_approval_status;

        $j++;
      }
    }

    // Expense Bills
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $expense_bill_where['b.work_id'] = $_POST['work'];
      }
      $expense_bill_where['b.bill_type'] = 'expense';
      $expense_bills = $this->Bills->select_bills("b.*,ah1.acc_head_name as expense_head_name,u.user_alias,wc.work_name,u.user_role,tt.tax_percentage,tt.tax1_percent,tt.tax2_percent,tt.tax3_percent,u.user_role as created_user_role_id",$expense_bill_where,'','','',$entry_approval,'all')->result();
      foreach($expense_bills as $row){
        $entry_selectable = 0;
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status_2 == 0)){
            $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="expense_bill" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->bill_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
            <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
            </a>';
            $entry_selectable = 1;
          }
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          $level='';
          if($this->config->item('User_enable_data_entry_approval_2_level')==1){
            $level='1st Level ';
          }
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
          }
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status == 1){
            if ($row->entry_approval_status_2 == 1) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
            } elseif ($row->entry_approval_status_2 == 2) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
            } else {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
            }
          }
        }
        $expense_type=ucwords($row->bill_expense_type)." Expense";

        if($entry_selectable==1){
          $array[$j][]='expense_bill-'.$row->bill_id;
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Expense Bill</strong>';
        $array[$j][]='<a id="m_quick_sidebar_toggle" data-type="bill_profile" data-bill-type="expense_bill" data-id="'.$row->bill_id.'" href="javascript:;">#'.$row->bill_id.'</a>';
        $array[$j][]=date('d-m-Y',strtotime($row->bill_date));
        $array[$j][]=$expense_type."<br>Head :".$row->expense_head_name;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->bill_payable_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
        $array[$j][]='';
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Expense Bill Transactions
    $reference_type = 'expense_bill';
    $expense_bill_payment_where = $transaction_where;
    $expense_bill_payment_where['ats.reference_type'] = $reference_type;
    $expense_bill_payment_where['ats.tr_type'] = $reference_type . "_transaction";
    $select_columns = "b.bill_id,b.bill_no,b.bill_consignee_name,b.bill_type,wc.work_name,b.work_id,sc.sub_work_name,sc.contract_id,c.contractor_name";
    if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
      $expense_bill_payment_where['b.work_id'] = $_POST['work'];
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $expense_bill_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $expense_bill_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($expense_bill_payments as $row){
      $reference_type_2 = $reference_type;
      $bill_details = 'Expense Bill : <a id="m_quick_sidebar_toggle" data-type="bill_profile" data-bill-type="' . $reference_type . '" data-id="' . $row->bill_id . '" href="javascript:;">#' . $row->bill_id . '</a>';
      $bill_details .= "<br/>Head: ".$row->credit_account;

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='expense_bill_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Expense Bill Payment</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Subcontract Bills
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $subcontract_bill_where['b.work_id'] = $_POST['work'];
      }
      $subcontract_bill_where['b.bill_type'] = 'subcontract';
      $subcontract_bills = $this->Bills->select_bills("b.*,c.contractor_name,ah1.acc_head_name as credtit_account,u.user_alias,wc.work_name,sc.contractor,sc.sub_work_name,sc.contract_id,tt.tax_percentage,tt.tax1_percent,tt.tax2_percent,tt.tax3_percent,u.user_role as created_user_role_id,wc.branch_id",$subcontract_bill_where,'','','',$entry_approval,'all')->result();
      foreach($subcontract_bills as $row){
        $entry_selectable = 0;
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="expense_bill" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->bill_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }
        $bill_details=$row->sub_work_name.'<br>Contractor: '.$row->contractor_name;

        if($entry_selectable==1){
          $array[$j][]='expense_bill-'.$row->bill_id;
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Subcontract Bill</strong>';
        $array[$j][]='<a id="m_quick_sidebar_toggle" data-type="bill_profile" data-bill-type="expense_bill" data-id="'.$row->bill_id.'" href="javascript:;">#'.$row->bill_id.'</a>';
        $array[$j][]=date('d-m-Y',strtotime($row->bill_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->bill_payable_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
        $array[$j][]='';
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Subcontract payments
    $reference_type = 'subcontract_transactions';
    $subcontract_bill_payment_where = $transaction_where;
    $this->db->where("(ats.reference_type='subcontract_bill' or ats.reference_type='subcontract')");
    $this->db->where("(ats.tr_type='subcontract_bill_transaction' or ats.tr_type='subcontract_advance_transaction')");
    $select_columns = "b.bill_id,b.bill_no,b.bill_consignee_name,b.bill_type,wc.work_name,b.work_id,sc.sub_work_name,sc.contract_id,sc2.contract_id as contract_id_2,wc2.work_name as work_name_2,wc2.work_id as work_id_2,sc2.sub_work_name as sub_work_name_2,sc2.contractor as contractor_2,c.contractor_name,c2.contractor_name as contractor_name_2";
    if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
      $this->db->where("((ats.reference_type='subcontract_bill' and b.work_id=".$_POST['work'].") or (ats.reference_type='subcontract' and sc2.work_id=".$_POST['work']."))");
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $subcontract_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $subcontract_bill_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($subcontract_payments as $row){
      $reference_type_2 = $reference_type;
      if ($reference_type == 'subcontract_transactions') {
        $reference_type_2 = 'subcontract';
      }
      if($row->reference_type=='subcontract_bill'){
        $bill_details = 'Bill Payment';
        $bill_details .= '<br/>Subcontract Bill : <a id="m_quick_sidebar_toggle" data-type="bill_profile" data-bill-type="' . $reference_type . '" data-id="' . $row->bill_id . '" href="javascript:;">#' . $row->bill_id . '</a>';
        $bill_details .= "<br/>Contractor: ".$row->contractor_name;
        $bill_details .= "<br/>Work: ".$row->sub_work_name;
      }else{
        $bill_details = 'Advance Payment';
        $bill_details .= "<br/>Contract ID: ".$row->contract_id_2;
        $bill_details .= "<br/>Contractor: ".$row->contractor_name_2;
        $bill_details .= "<br/>Work: ".$row->sub_work_name_2;
      }

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='expense_bill_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Subcontract Payment</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
      if($row->reference_type=='subcontract_bill'){
        $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
      }else{
        $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id_2.'">'.$row->work_name_2.'</a>';
      }
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Stock Transfer
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
        $this->db->where('(sl1.work_id=' . $_POST['work'] . ' or sl2.work_id=' . $_POST['work'] . ')');
      }
      $stock_transfers  = $this->Stock->select_stock_transfers("COALESCE(SUM(st.transferred_qty),0) as total_transferred_qty,COALESCE(SUM(st.transferred_qty*sr2.unit_price),0) as total_transferred_amt,st.*,sr1.unit_price,sr1.material_id,m.material_name,mu.unit_name,sr1.unit,sl1.location_name as transferred_from_loc_name,sl2.location_name as transferred_to_loc_name,u.user_alias as created_user,u.user_role as created_user_role_id,sl1.location_type as location_type_from,sl2.location_type as location_type_to,sl1.work_id as location_work_id_from,sl2.work_id as location_work_id_to ", $stock_transfer_where, array("st.transfer_date", "st.trans_group_id", "sr1.material_id", "sr1.unit"), $entry_approval);
      foreach ($stock_transfers->result() as $row){
        $btn_approve = $entry_approval_status = '';
        if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="stock_transfer" data-approval-status="' . $row->entry_approval_status . '" data-id="' . $row->transfer_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if ($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          if ($row->entry_approval_status == 1) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          } elseif ($row->entry_approval_status == 2) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          } else {
            $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        if($row->location_type_from=='work_site'){
          $location_name_from = '<a href="' . base_url() . 'work/profile/' . $row->location_work_id_from . '">' . $row->transferred_from_loc_name . '<br/>[Work Site]</a>';
        }elseif($row->location_type_from=='ware_house'){
          $location_name_from = '<a href="' . base_url() . 'stock/locations/profile/' . $row->transferred_from_loc_id . '">' . $row->transferred_from_loc_name . '<br/>[Warehouse]</a>';
        }

        if($row->location_type_to=='work_site'){
          $location_name_to = '<a href="' . base_url() . 'work/profile/' . $row->location_work_id_to . '">' . $row->transferred_to_loc_name . '<br/>[Work Site]</a>';
        }elseif($row->location_type_to=='ware_house'){
          $location_name_to = '<a href="' . base_url() . 'stock/locations/profile/' . $row->transferred_to_loc_id . '">' . $row->transferred_to_loc_name . '<br/>[Warehouse]</a>';
        }

        $bill_details = 'Material: '.$row->material_name;
        $bill_details .= '<br/>Unit: '.$row->unit_name;
        $bill_details .= '<br/>Qty: '.$this->config->item('currency_format')->formatCurrency($row->total_transferred_qty, $this->config->item('Currency_currency_shortname'));

        $array[$j][]='stock_transfer-'.$row->transfer_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Stock Transfer</strong>';
        $array[$j][]='#'.$row->transfer_id;
        $array[$j][]=date('d-m-Y',strtotime($row->transfer_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->total_transferred_amt, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][]="From: ".$location_name_from." - <br/>To: ".$location_name_to;
        $array[$j][]='';
        $array[$j][]=$row->created_user.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Stock Consumption
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
        $stock_consumption_where['sc.work_id'] = $_POST['work'];
      }
      $stock_consumptions  = $this->Stock->select_stock_consumption("GROUP_CONCAT(sc.cons_id) AS cons_ids,COALESCE(SUM(sc.consumption_qty),0) as total_consumed_qty,COALESCE(SUM(sc.consumption_qty*sr.unit_price),0) as total_consumed_amt,sc.*,sr.unit_price,sr.material_id,m.material_name,mu.unit_name,sr.unit,sr.location_id,u.user_alias as created_user,wc.work_name,u.user_role as created_user_role_id", $stock_consumption_where, array("sc.consumption_date", "sc.cons_group_id", 'sr.material_id','sr.unit','sr.purchase_supplier_id','sr.unit_price','sr.location_id'), $entry_approval);
      foreach ($stock_consumptions->result() as $row){
        $btn_approve = $entry_approval_status = '';
        if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="stock_consumption" data-approval-status="' . $row->entry_approval_status . '" data-id="' . $row->cons_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if ($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          if ($row->entry_approval_status == 1) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          } elseif ($row->entry_approval_status == 2) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          } else {
            $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }


        $bill_details = 'Material: '.$row->material_name;
        $bill_details .= '<br/>Unit: '.$row->unit_name;
        $bill_details .= '<br/>Qty: '.$this->config->item('currency_format')->formatCurrency($row->total_consumed_qty, $this->config->item('Currency_currency_shortname'));

        $array[$j][]='stock_consumption-'.$row->cons_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Stock Consumption</strong>';
        $array[$j][]='#'.$row->cons_id;
        $array[$j][]=date('d-m-Y',strtotime($row->consumption_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->total_consumed_amt, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][] = '<a href="' . base_url() . 'work/profile/' . $row->work_id . '">' . $row->work_name . '</a>';
        $array[$j][]='';
        $array[$j][]=$row->created_user.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Labour Wage Slip
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $labour_wage_slip_where['lw.work_id'] = $_POST['work'];
      }
      $labour_wage_slips	= $this->Labour_wages->select_labour_wages("lw.*,wt.type_name,l.labour_group,l.labour_name,wt.type_name,u.user_alias,wc.work_name,u.user_role as created_user_role_id",$labour_wage_slip_where,"","","","","",$entry_approval)->result();
      foreach ($labour_wage_slips as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="labour_wage" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->wage_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }


        $bill_details = 'Labour: '.'<a href="' . base_url() . 'labours/profile/' . $row->labour_id . '">' . $row->labour_name . '</a>';
        $bill_details .= '<br/>Work Type: '.$row->type_name;
        $bill_details .= '<br/>Worked Days: '.$row->work_days;
        $bill_details .= '<br/>Overtime Amt: '.$row->overtime_wage;

        $array[$j][]='labour_wage-'.$row->wage_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Labour Wage Slip</strong>';
        $array[$j][]='#'.$row->wage_id;
        $array[$j][]=date('d-m-Y',strtotime($row->work_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->total_wage, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][] = '<a href="' . base_url() . 'work/profile/' . $row->work_id . '">' . $row->work_name . '</a>';
        $array[$j][]=$row->remarks;
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Labour Payment
    if((isset($_POST['work']) && $_POST['work']=='all') || !isset($_POST['work'])){
      $reference_type = 'labour';
      $labour_payment_where = $transaction_where;
      $labour_payment_where['ats.reference_type'] = $reference_type;
      $labour_payment_where['ats.tr_type'] = $reference_type . "_transaction";
      if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
        $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
      }
      $select_columns = "l.labour_name,wt.type_name,l.labour_group,l.labour_id";
      $labour_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $labour_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
      foreach($labour_payments as $row){
        $reference_type_2 = $reference_type;
        $bill_details = 'Labour : <a href="' . base_url() . 'labours/profile/' . $row->labour_id . '">' . $row->labour_name . '</a>';
        $bill_details .= "<br/>Work Type: ".$row->type_name;

        $btn_approve = $entry_approval_status = '';
        $entry_selectable = 0;
        if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
            $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
            <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
            </a>';
            $entry_selectable = 1;
          }
        }
        if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
          $level='';
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            $level='1st Level ';
          }
          if ($row->tr_entry_approval_status == 1) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
          } elseif ($row->tr_entry_approval_status == 2) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
          } else {
            $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
          }
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            if ($row->tr_entry_approval_status_2 == 1) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
            } elseif ($row->tr_entry_approval_status_2 == 2) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
            } else {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
            }
          }
        }
        if($entry_selectable==1){
          $array[$j][]='labour_payment-'.$row->transaction_id;
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Labour Payment</strong>';
        $array[$j][]="#".$row->transaction_id;
        $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
        $array[$j][]='';
        $array[$j][]=$row->tr_remarks;
        $array[$j][]=$row->created_user.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->tr_entry_approval_status;

        $j++;
      }
    }

    // Tool Transfer
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $this->db->where(('tt.transfer_to ='.$_POST['work'].' or tt.transfer_from ='.$_POST['work']));
      }
      $tool_transfers	= $this->Tools->select_tool_transfers("tt.*,t.name,wc1.work_name as tranfer_from_location,wc2.work_name as transfer_to_location,u.user_alias,u.user_role as created_user_role_id",$tool_transfer_where,'','','','','','',$entry_approval)->result();
      foreach ($tool_transfers as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="tool_transfer" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->transfer_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $bill_details = 'Tool: '.$row->name;;
        $bill_details .= '<br/>Qty: '.$row->transferred_qty;
        $bill_details .= '<br/>Transfer By: '.$row->transferred_by;

        if($row->transfer_from!=0){
          $transfer_from = $row->tranfer_from_location;
        }else{
          $transfer_from = $this->config->item('Tools_transfer_default_location_name');
        }

        if($row->transfer_to!=0){
          $transfer_to = $row->transfer_to_location;
        }else{
          $transfer_to = $this->config->item('Tools_transfer_default_location_name');
        }

        $array[$j][]='tool_transfer-'.$row->transfer_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Tool Transfer</strong>';
        $array[$j][]='#'.$row->transfer_id;
        $array[$j][]=date('d-m-Y',strtotime($row->transfer_date));
        $array[$j][]=$bill_details;
        $array[$j][]="";
        $array[$j][]='';
        $array[$j][] = 'From: '.$transfer_from." -<br/>To: ".$transfer_to;
        $array[$j][]=$row->remarks;
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Tool Rent
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $tool_rent_where['tr.rented_to'] = $_POST['work'];
      }
      $tool_rents	= $this->Tools->select_tool_rent("tr.*,t.name,t.total_owned_qty,wc2.work_name as rented_to_location,u.user_alias,u.user_role as created_user_role_id",$tool_rent_where,'','','','','','',$entry_approval)->result();
      foreach ($tool_rents as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="tool_rent" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $bill_details = 'Tool: '.$row->name;;
        $bill_details .= '<br/>Qty: '.$row->rented_qty;
        $bill_details .= '<br/>Rented From: '.$row->rented_from;

        if($row->rented_to!=0){
          $rented_to = $row->rented_to_location;
        }else{
          $rented_to = $this->config->item('Tools_transfer_default_location_name');
        }

        $array[$j][]='tool_rent-'.$row->id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Tool Rent</strong>';
        $array[$j][]='#'.$row->id;
        $array[$j][]=date('d-m-Y',strtotime($row->rented_date));
        $array[$j][]=$bill_details;
        $array[$j][]="";
        $array[$j][]='';
        $array[$j][] = $rented_to;
        $array[$j][]=$row->remarks;
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Tool Payment
    $reference_type = 'tool';
    $tool_payment_where = $transaction_where;
    $tool_payment_where['ats.tr_type'] = "tool_payment_transaction";
    if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
      $workid = $_POST['work'];
      $this->db->where("(((ats.reference_type='tool_rent' and tr.rented_to='$workid') or (ats.reference_type='tool_transfer' and tt.transfer_to='$workid')))");
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $select_columns = "t.tool_id,t.name,t.description,t.tool_type,tc.cat_name,wc.work_name as rented_to_location,tr.rented_from,t2.tool_id as tool_id_2,t2.name as name_2,t2.description as description_2,t2.tool_type as tool_type_2,tc2.cat_name as cat_name_2,wc2.work_name as transfer_to_location,tt.transfer_from,";
    $tool_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $tool_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($tool_payments as $row){
      $reference_type_2 = $reference_type;
      $bill_details = 'Tool: '.$row->name;

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }

      if ($row->reference_type == 'tool_transfer') {
        $project = ucfirst($row->name_2) . ' [' . $row->cat_name_2 . ']';
        $project .= "<br/>(Own)";
      } elseif ($row->reference_type == 'tool_rent') {
        $project = ucfirst($row->name) . ' [' . $row->cat_name . ']';
        $project .= "<br/>(Rent)";
      }

      if($entry_selectable==1){
        $array[$j][]='tool_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Tool Payment</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]=$project;
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Travel Allowance
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $travel_allowance_where['ta.project_id'] = $_POST['work'];
      }
      $travel_allowances = $this->Travel_allowance->select_ta("ta.*,u1.user_alias AS ta_created_by,e.employee_name AS ta_user_name,u1.user_role as created_user_role_id,wc.work_name,v.vehicle_name",$travel_allowance_where,'',$entry_approval)->result();
      foreach ($travel_allowances as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="travel_allowance" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->ta_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $bill_details = 'Employee: '.$row->ta_user_name;;
        $bill_details .= '<br/>Vehicle Type: '.$row->vehicle_type;
        $bill_details .= '<br/>KMS: '.$row->kms;
        $bill_details .= '<br/>From: '.$row->ta_from." - To: ".$row->ta_to;

        $array[$j][]='travel_allowance-'.$row->ta_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Travel Allowance</strong>';
        $array[$j][]='#'.$row->ta_id;
        $array[$j][]=date('d-m-Y',strtotime($row->ta_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][]=($row->project_id!=0)?$row->work_name:"Office";
        $array[$j][]=$row->ta_remarks;
        $array[$j][]=$row->ta_created_by.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Salary Slip
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $salary_slip_where['ss.work_id'] = $_POST['work'];
      }
      $salary_slips	= $this->Salary_slips->select_salary_slips("ss.*,e.employee_name,e.user_designation,u.user_alias,wc.work_name,u.user_role as created_user_role_id",$salary_slip_where,'','','','','',$entry_approval)->result();
      foreach ($salary_slips as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="salary_slip" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->salary_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $bill_details = 'Employee: '.$row->employee_name;;
        $bill_details .= '<br/>Designation: '.$row->user_designation;
        $bill_details .= '<br/>'.$row->slip_type." Expense";;

        $array[$j][]='salary_slip-'.$row->salary_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Salary Slip</strong>';
        $array[$j][]='<a href="'.base_url().'salary_slips/profile/'.$row->salary_id.'">'."#".$row->salary_id.'</a>';
        $array[$j][]=date('M Y',strtotime($row->month));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->net_salary_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        if($row->work_id!='' && $row->work_id!=0){
          $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$row->remarks;
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Employee Payments
    $reference_type = 'employee';
    $employee_payment_where = $transaction_where;
    if (isset($_POST['work']) && $_POST['work'] != '' && $_POST['work'] != 'all') {
      $this->db->where("((ats.tr_type='salary_slip_transaction' and ss.work_id='" . $_POST['work'] . "') or (ats.tr_type='salary_advance_transaction' and ats.tr_work_id='" . $_POST['work'] . "') or (ats.tr_type='employee_bata_transaction' and ats.tr_work_id='" . $_POST['work'] . "'))");
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $this->db->where("(ats.reference_type='salary_slip' or ats.reference_type='employee')");
    $select_columns = "ss.work_id,ss.month,ss.salary_id,e.employee_name,e.employee_id,e.user_designation,ats.tr_type,e2.employee_name as employee_name_2,e2.employee_id as employee_id_2,e2.user_designation as user_designation_2,wc.work_name as salary_project_name,wc2.work_name as expense_under_project";
    $employee_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $employee_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($employee_payments as $row){
      $reference_type_2 = $reference_type;
      $bill_details = 'Employee : ' . $row->employee_name;
      if ($row->tr_type == "salary_slip_transaction") {
        $bill_details .= "<br/>Slip: #".$row->reference_id;
      }

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='employee_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      if ($row->tr_type == "salary_slip_transaction") {
        $array[$j][] = "<strong>Salary Slip Payment</strong>";
      } else if ($row->tr_type == "employee_opbalance_transaction") {
        $array[$j][] = "<strong>Employee Opening Balance Payment</strong>";
      } else if ($row->tr_type == "salary_advance_transaction") {
        $array[$j][] = "<strong>Advance Salary Payment</strong>";
      }else if ($row->tr_type == "employee_bata_transaction") {
        $array[$j][] = "<strong>Employee Bata Payment</strong>";
      } else {
        $array[$j][]='<strong>Employee Payment</strong>';
      }
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]='';
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Vehicle Work Slip
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $vehicle_work_slip_where['vws.vehicle_work_id'] = $_POST['work'];
      }
      $vehicle_work_slips	= $this->Vehicle_work_slips->select_vehicle_work_slips("u.*,v.*,wc.*,vws.*,e.employee_name,vws.basic_charge AS vws_basic_charge,vws.basic_charge_2 AS vws_basic_charge_2,vws.basic_charge_3 AS vws_basic_charge_3,vws.remarks AS vws_remarks,vws.balance AS vws_balance,vws.created_by AS vws_created_by,vws.created_date AS vws_created_date,vws.updated_by AS vws_updated_by,vws.updated_date AS vws_updated_date,vc.consignee_name,u.user_role as created_user_role_id",$vehicle_work_slip_where,"","","","","",$entry_approval)->result();
      foreach ($vehicle_work_slips as $row){
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="vehicle_work_slip" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->work_slip_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> Pending</span>";
          }
        }

        $duration = $row->worked_duration." ".$row->duration_type;
        $basic_charge = $row->vws_basic_charge."X".$row->worked_duration." = ".($row->vws_basic_charge*$row->worked_duration);
        if($this->config->item('app_module_vehicle_management')==1){
          if($row->worked_duration_2!=0){
            $duration .= "<br/>".$row->worked_duration_2." ".$row->duration_type_2;
            $basic_charge .= "<br/>".$row->vws_basic_charge_2."X".$row->worked_duration_2." = ".($row->vws_basic_charge_2*$row->worked_duration_2);
          }
          if($row->worked_duration_3!=0){
            $duration .= "<br/>".$row->worked_duration_3." ".$row->duration_type_3;
            $basic_charge .= "<br/>".$row->vws_basic_charge_3."X".$row->worked_duration_3." = ".($row->vws_basic_charge_3*$row->worked_duration_3);
          }
        }

        $bill_details = 'Vehicle: '.'<a href="' . base_url() . 'vehicles/profile/' . $row->vehicle_id . '">'.$row->vehicle_name." : ".$row->vehicle_no. '</a>';
        $bill_details .= '<br/>Consignee: '.'<a href="' . base_url() . 'vehicles/consignees/profile/' . $row->consignee . '">'.$row->consignee_name.'</a>';
        $bill_details .= '<br/>Duration: '.$duration;

        $array[$j][]='vehicle_work_slip-'.$row->work_slip_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Vehicle Work Slip</strong>';
        $array[$j][]="#".$row->work_slip_id;
        $array[$j][]=date('d-m-Y',strtotime($row->worked_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->total_payable_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]='';
        $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
        $array[$j][]=$row->vws_remarks;
        $array[$j][]=$row->user_alias.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->vws_created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Vehicle Work Slip Payments
    $reference_type = 'vehicle_work_slip';
    $vehicle_work_slip_payment_where = $transaction_where;
    $vehicle_work_slip_payment_where['ats.reference_type'] = $reference_type;
    $vehicle_work_slip_payment_where['ats.tr_type'] = $reference_type . "_transaction";
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $vehicle_work_slip_payment_where['vws.vehicle_work_id'] = $_POST['work'];
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $select_columns = "v.id,v.vehicle_name,v.vehicle_no,vws.work_slip_id,vws.worked_date,vc.consignee_name";
    $vehicle_work_slip_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $vehicle_work_slip_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($vehicle_work_slip_payments as $row){
      $reference_type_2 = $reference_type;
      $bill_details = 'Vehicle : <a href="' . base_url() . 'vehicles/profile/' . $row->id . '">' . $row->vehicle_name . " : " . $row->vehicle_no . '</a>';
      $bill_details .= "<br/>Slip: #" . $row->work_slip_id." [".date('d-m-Y', strtotime($row->worked_date))."]";

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='vehicle_work_slip_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Vehicle Work Slip Payment</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]='';
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // User Payments
    if((isset($_POST['work']) && $_POST['work']=='all') || !isset($_POST['work'])){
      $reference_type = 'user_payment_receipt';
      $user_payment_receipt_where = $transaction_where;
      $user_payment_receipt_where['ats.reference_type'] = 'user_account_head';
      $user_payment_receipt_where['ats.tr_type'] = $reference_type . "_transaction";
      if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
        $this->db->where('(tr_credit_acc='.$_POST['acc_head_id'].' or tr_debit_acc='.$_POST['acc_head_id'].')');
      }
      $select_columns = "ah2.acc_head_id,u3.user_id,u3.user_alias,u3.user_role,ur.role_title,e.employee_id,e.employee_name,ed.department_name";
      $user_payment_receipts = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $user_payment_receipt_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
      foreach($user_payment_receipts as $row){
        $reference_type_2 = $reference_type;
        $bill_details = 'Employee : ' . $row->employee_name;

        $btn_approve = $entry_approval_status = '';
        $entry_selectable = 0;
        if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
            $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
            <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
            </a>';
            $entry_selectable = 1;
          }
        }
        if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
          $level='';
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            $level='1st Level ';
          }
          if ($row->tr_entry_approval_status == 1) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
          } elseif ($row->tr_entry_approval_status == 2) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
          } else {
            $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
          }
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            if ($row->tr_entry_approval_status_2 == 1) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
            } elseif ($row->tr_entry_approval_status_2 == 2) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
            } else {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
            }
          }
        }
        if($entry_selectable==1){
          $array[$j][]='user_payment_receipt_payment-'.$row->transaction_id;
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Petty Cash Payment</strong>';
        $array[$j][]="#".$row->transaction_id;
        $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]="Debit Account: ".$row->debit_account."<br/>Mode: ".$row->tr_mode;
        $array[$j][]='';
        $array[$j][]=$row->tr_remarks;
        $array[$j][]=$row->created_user.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->tr_entry_approval_status;

        $j++;
      }
    }

    // User Payment Returns
    if((isset($_POST['work']) && $_POST['work']=='all') || !isset($_POST['work'])){
      $reference_type = 'user_payment_return';
      $user_payment_return_where = $transaction_where;
      $user_payment_return_where['ats.reference_type'] = 'user_account_head';
      $user_payment_return_where['ats.tr_type'] = $reference_type . "_transaction";
      if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
        $this->db->where('(tr_credit_acc='.$_POST['acc_head_id'].' or tr_debit_acc='.$_POST['acc_head_id'].')');
      }
      $select_columns = "ah1.acc_head_id,u4.user_id,u4.user_alias,u4.user_role,ur.role_title,e2.employee_id,e2.employee_name,ed.department_name";
      $user_payment_returns = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $user_payment_return_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
      foreach($user_payment_returns as $row){
        $reference_type_2 = $reference_type;
        $bill_details = 'Employee : ' . $row->employee_name;

        $btn_approve = $entry_approval_status = '';
        $entry_selectable = 0;
        if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
          if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
            $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
            <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
            </a>';
            $entry_selectable = 1;
          }
        }
        if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
          $level='';
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            $level='1st Level ';
          }
          if ($row->tr_entry_approval_status == 1) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
          } elseif ($row->tr_entry_approval_status == 2) {
            $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
          } else {
            $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
          }
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
            if ($row->tr_entry_approval_status_2 == 1) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
            } elseif ($row->tr_entry_approval_status_2 == 2) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
            } else {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
            }
          }
        }
        if($entry_selectable==1){
          $array[$j][]='user_payment_return_payment-'.$row->transaction_id;
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>Petty Cash Return</strong>';
        $array[$j][]="#".$row->transaction_id;
        $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        $array[$j][]="Credit Account: ".$row->credit_account."<br/>Mode: ".$row->tr_mode;
        $array[$j][]='';
        $array[$j][]=$row->tr_remarks;
        $array[$j][]=$row->created_user.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->tr_entry_approval_status;

        $j++;
      }
    }

    // Loans
    if((isset($_POST['acc_head_id']) && $_POST['acc_head_id']=='all') || !isset($_POST['acc_head_id'])){
      if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
        $loan_where['l.work_id'] = $_POST['work'];
      }
      $loans	= $this->Loan->select_loan("l.*,u.user_alias as created_user,ah1.acc_head_name,wc.work_name,lp.loan_provider_name,u.user_role as created_user_role_id",$loan_where,$entry_approval,'all')->result();
      foreach ($loans as $row){
        $entry_selectable = 0;
        $btn_approve = $entry_approval_status = '';
        if(($this->session->userdata('user_role')=='admin' || ($this->session->userdata('user_role')=='accounts_manager' && $row->created_user_role_id>2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1){
          if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status_2 == 0)){
            $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="loan" data-approval-status="'.$row->entry_approval_status.'" data-id="'.$row->loan_id.'" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
            <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
            </a>';
            $entry_selectable = 1;
          }
        }
        if(($page_data_type=='approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval')==1) || $this->config->item('User_enable_data_entry_approval')==1){
          $level='';
          if($this->config->item('User_enable_data_entry_approval_2_level')==1){
            $level='1st Level ';
          }
          if($row->entry_approval_status==1){
            $entry_approval_status="<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
          }elseif($row->entry_approval_status==2){
            $entry_approval_status="<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
          }else{
            $entry_approval_status="<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
          }
          if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->entry_approval_status == 1){
            if ($row->entry_approval_status_2 == 1) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
            } elseif ($row->entry_approval_status_2 == 2) {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
            } else {
              $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
            }
          }
        }
        $bill_details = $row->loan_title;
        if($row->loan_type=='payable'){
          $bill_details .= '<br/>Provider : <a href="'.base_url().'loans/provider/profile/'.$row->provider_id.'" target="_blank">'.$row->loan_provider_name.'</a>';
          if($row->work_id==0){
            $bill_details .= '<br/>For Whole Business';
          }else{
            $bill_details .= '<br/>For Project : '.$row->work_name;
          }
        }else{
          $bill_details .= '<br/>Borrower : <a href="'.base_url().'loans/provider/profile/'.$row->provider_id.'" target="_blank">'.$row->loan_provider_name.'</a>';
        }

        $array[$j][]='loan-'.$row->loan_id;
        $array[$j][]=$sl_no++;
        $array[$j][]='<strong>'.ucwords($row->loan_type)." Loan".'</strong>';
        $array[$j][]="#".$row->loan_id;
        $array[$j][]=date('d-m-Y',strtotime($row->loan_date));
        $array[$j][]=$bill_details;
        $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->total_loan_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
        if($row->loan_type=='payable'){
          $array[$j][]='Credited To: '.$row->acc_head_name;
        }else{
          $array[$j][]='Debited From: '.$row->acc_head_name;
        }
        $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
        $array[$j][]=$row->description;
        $array[$j][]=$row->created_user.$entry_approval_status;
        if ($this->config->item('UI_hide_created_date_field')==0){
          $array[$j][]=date('d-m-Y',strtotime($row->created_date));
        }else{
          $array[$j][]='';
        }
        $array[$j][]=$btn_approve;
        $array[$j][]=$row->entry_approval_status;

        $j++;
      }
    }

    // Loan Payment
    $reference_type = 'loan';
    $loan_payment_where = $transaction_where;
    $loan_payment_where['ats.reference_type'] = 'loan';
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $loan_where['l.work_id'] = $_POST['work'];
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $this->db->where("((l.loan_type='receivable' and ats.tr_type='loan_receipt_transaction') or (l.loan_type='payable' and ats.tr_type='loan_transaction'))");
    $select_columns = "l.loan_type,l.loan_id,l.loan_title,l.description,l.provider_id,lp.loan_provider_name,wc.work_name,l.work_id";
    $loan_payments = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $loan_payment_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($loan_payments as $row){
      $reference_type_2 = $reference_type;
      $bill_details = 'Loan : #' . $row->loan_id . " (".$row->loan_title.")";
      if($row->loan_type=='payable'){
        $bill_details .= '<br/>Provider : <a href="'.base_url().'loans/provider/profile/'.$row->provider_id.'" target="_blank">'.$row->loan_provider_name.'</a>';
        if($row->work_id==0){
          $bill_details .= '<br/>For Whole Business';
        }else{
          $bill_details .= '<br/>For Project : '.$row->work_name;
        }
      }else{
        $bill_details .= '<br/>Borrower : <a href="'.base_url().'loans/provider/profile/'.$row->provider_id.'" target="_blank">'.$row->loan_provider_name.'</a>';
      }

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='loan_payment-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      if($row->loan_type=='payable'){
        $array[$j][]='<strong>Loan Payment -<br/>Towards Payable Loan</strong>';
      }else{
        $array[$j][]='<strong>Loan Receipt -<br/>Towards Receivable Loan</strong>';
      }
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      if($row->loan_type=='receivable'){
        $array[$j][]='Credit Account: '.$row->credit_account."<br/>Mode: ".$row->tr_mode;
      }else{
        $array[$j][]='Debit Account: '.$row->debit_account."<br/>Mode: ".$row->tr_mode;
      }
      $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }

    // Other Income Receipt
    $reference_type = 'income_receipt';
    $other_income_receipt_where = $transaction_where;
    if(isset($_POST['work']) && $_POST['work']!='' && $_POST['work']!='all'){
      $other_income_receipt_where['ats.tr_work_id'] = $_POST['work'];
    }
    if (isset($_POST['acc_head_id']) && $_POST['acc_head_id'] != '' && $_POST['acc_head_id'] != 'all') {
      $this->db->where('(tr_debit_acc='.$_POST['acc_head_id'].')');
    }
    $other_income_receipt_where['ats.reference_type'] = $reference_type ;
    $other_income_receipt_where['ats.tr_type'] = $reference_type . "_transaction";
    $select_columns = "wc.work_id,wc.work_name";
    $other_income_receipts = $this->Account->select_account_transaction("ats.tr_branch_id as branch_id,ats.*,ah1.acc_head_name as debit_account,ah2.acc_head_name as credit_account,u1.user_alias as created_user,u1.user_role as created_user_role_id," . $select_columns, $other_income_receipt_where, $reference_type, '', '', '', $entry_approval, 'all', $join_table_entry_approval)->result();
    foreach($other_income_receipts as $row){
      $reference_type_2 = $reference_type;
      if($row->tr_work_id!=0){
        $bill_details = 'Income Under : <a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
      }else{
        $bill_details = 'Income Under : Office';
      }
      $bill_details .= '<br/>Head : '.$row->tr_description;

      $btn_approve = $entry_approval_status = '';
      $entry_selectable = 0;
      if (($this->session->userdata('user_role') == 'admin' || ($this->session->userdata('user_role') == 'accounts_manager' && $row->created_user_role_id > 2 && (($this->config->item('User_enable_data_entry_approval_2_level')==0 && $row->created_user_role_id != 16) || $this->config->item('User_enable_data_entry_approval_2_level')==1))) && $page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) {
        if($this->config->item('User_enable_data_entry_approval_2_level')==0 || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types) && $row->tr_entry_approval_status_2 == 0) || ($this->config->item('User_enable_data_entry_approval_2_level')==1 && !in_array($row->tr_type, $data_entry_approval_2_level_tr_types))){
          $btn_approve = '<a style="margin-left: 5px;margin-right: 5px" data-type="' . $reference_type_2 . '_payment" data-approval-status="' . $row->tr_entry_approval_status . '" data-id="' . $row->transaction_id . '" id="btn_data_entry_approval" href="#data_entry_approve_modal" data-toggle="modal" class="btn btn-sm btn-warning m-btn m-btn--icon  m-btn--pill m-btn--air">
          <i class="la la-check-circle"></i> / <i class="la la-times-circle"></i>
          </a>';
          $entry_selectable = 1;
        }
      }
      if (($page_data_type == 'approval_entries' && $this->config->item('Mobile_App_enable_data_entry_approval') == 1) || $this->config->item('User_enable_data_entry_approval') == 1) {
        $level='';
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          $level='1st Level ';
        }
        if ($row->tr_entry_approval_status == 1) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> ".$level."Approved</span>";
        } elseif ($row->tr_entry_approval_status == 2) {
          $entry_approval_status = "<br/><span class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> ".$level."Rejected</span>";
        } else {
          $entry_approval_status = "<br/><span class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> ".$level."Pending</span>";
        }
        if($this->config->item('User_enable_data_entry_approval_2_level')==1 && $row->tr_entry_approval_status == 1 && in_array($row->tr_type, $data_entry_approval_2_level_tr_types)){
          if ($row->tr_entry_approval_status_2 == 1) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--success m-badge--wide'><i class='fa fa-check'></i> 2nd Level Approved</span>";
          } elseif ($row->tr_entry_approval_status_2 == 2) {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--danger m-badge--wide'><i class='fa fa-check'></i> 2nd Level Rejected</span>";
          } else {
            $entry_approval_status .= "<br/><span style='margin-top:5px' class='m-badge m-badge--warning m-badge--wide'><i class='fa fa-times-circle'></i> 2nd Level Pending</span>";
          }
        }
      }
      if($entry_selectable==1){
        $array[$j][]='other_income-'.$row->transaction_id;
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$sl_no++;
      $array[$j][]='<strong>Other Income Receipt</strong>';
      $array[$j][]="#".$row->transaction_id;
      $array[$j][]=date('d-m-Y',strtotime($row->tr_date));
      $array[$j][]=$bill_details;
      $array[$j][]="<strong>" . $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($row->tr_amount, $this->config->item('Currency_currency_shortname')). "</strong>";
      $array[$j][]="Credit Account: ".$row->credit_account."<br/>Mode: ".$row->tr_mode;
      $array[$j][]='<a href="'.base_url().'work/profile/'.$row->work_id.'">'.$row->work_name.'</a>';
      $array[$j][]=$row->tr_remarks;
      $array[$j][]=$row->created_user.$entry_approval_status;
      if ($this->config->item('UI_hide_created_date_field')==0){
        $array[$j][]=date('d-m-Y',strtotime($row->created_date));
      }else{
        $array[$j][]='';
      }
      $array[$j][]=$btn_approve;
      $array[$j][]=$row->tr_entry_approval_status;

      $j++;
    }



    $json_data['data']=$array;
    $json_data['draw']=5;
    $json_data['recordsTotal']=sizeof($array);
    $json_data['recordsFiltered']=sizeof($array);
    echo json_encode($json_data);  // send data as json format
  }
}
